/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.graph.DijkstraGraphSearch;
import org.onlab.graph.EdgeWeight;
import org.onlab.graph.Graph;
import org.onlab.graph.GraphPathSearch;
import org.onlab.graph.Path;
import org.onlab.graph.TarjanGraphSearch;
import org.onlab.graph.Vertex;
import org.onosproject.core.CoreService;
import org.onosproject.net.AbstractModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultTopologyCluster;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.store.trivial.impl.DefaultTopologyGraph;

public class DefaultTopology
extends AbstractModel
implements Topology {
    private static final DijkstraGraphSearch<TopologyVertex, TopologyEdge> DIJKSTRA = new DijkstraGraphSearch();
    private static final TarjanGraphSearch<TopologyVertex, TopologyEdge> TARJAN = new TarjanGraphSearch();
    private final long time;
    private final long creationTime;
    private final long computeCost;
    private final TopologyGraph graph;
    private final LinkWeight weight;
    private final Supplier<TarjanGraphSearch.SCCResult<TopologyVertex, TopologyEdge>> clusterResults;
    private final Supplier<ImmutableMap<ClusterId, TopologyCluster>> clusters;
    private final Supplier<ImmutableSet<ConnectPoint>> infrastructurePoints;
    private final Supplier<ImmutableSetMultimap<ClusterId, ConnectPoint>> broadcastSets;
    private final Supplier<ClusterIndexes> clusterIndexes;

    DefaultTopology(ProviderId providerId, GraphDescription description) {
        super(providerId, new Annotations[0]);
        this.time = description.timestamp();
        this.creationTime = description.creationTime();
        this.graph = new DefaultTopologyGraph((Set<TopologyVertex>)description.vertexes(), (Set<TopologyEdge>)description.edges());
        this.clusterResults = Suppliers.memoize(() -> this.searchForClusters());
        this.clusters = Suppliers.memoize(() -> this.buildTopologyClusters());
        this.clusterIndexes = Suppliers.memoize(() -> this.buildIndexes());
        this.weight = new HopCountLinkWeight(this.graph.getVertexes().size());
        this.broadcastSets = Suppliers.memoize(() -> this.buildBroadcastSets());
        this.infrastructurePoints = Suppliers.memoize(() -> this.findInfrastructurePoints());
        this.computeCost = Math.max(0L, System.nanoTime() - this.time);
    }

    public long time() {
        return this.time;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long computeCost() {
        return this.computeCost;
    }

    public int clusterCount() {
        return ((ImmutableMap)this.clusters.get()).size();
    }

    public int deviceCount() {
        return this.graph.getVertexes().size();
    }

    public int linkCount() {
        return this.graph.getEdges().size();
    }

    private ImmutableMap<DeviceId, TopologyCluster> clustersByDevice() {
        return ((ClusterIndexes)this.clusterIndexes.get()).clustersByDevice;
    }

    private ImmutableSetMultimap<TopologyCluster, DeviceId> devicesByCluster() {
        return ((ClusterIndexes)this.clusterIndexes.get()).devicesByCluster;
    }

    private ImmutableSetMultimap<TopologyCluster, Link> linksByCluster() {
        return ((ClusterIndexes)this.clusterIndexes.get()).linksByCluster;
    }

    TopologyGraph getGraph() {
        return this.graph;
    }

    Set<TopologyCluster> getClusters() {
        return ImmutableSet.copyOf((Collection)((ImmutableMap)this.clusters.get()).values());
    }

    TopologyCluster getCluster(ClusterId clusterId) {
        return (TopologyCluster)((ImmutableMap)this.clusters.get()).get((Object)clusterId);
    }

    TopologyCluster getCluster(DeviceId deviceId) {
        return (TopologyCluster)this.clustersByDevice().get((Object)deviceId);
    }

    Set<DeviceId> getClusterDevices(TopologyCluster cluster) {
        return this.devicesByCluster().get((Object)cluster);
    }

    Set<Link> getClusterLinks(TopologyCluster cluster) {
        return this.linksByCluster().get((Object)cluster);
    }

    boolean isInfrastructure(ConnectPoint connectPoint) {
        return ((ImmutableSet)this.infrastructurePoints.get()).contains((Object)connectPoint);
    }

    boolean isBroadcastPoint(ConnectPoint connectPoint) {
        if (!this.isInfrastructure(connectPoint)) {
            return true;
        }
        TopologyCluster cluster = (TopologyCluster)this.clustersByDevice().get((Object)connectPoint.deviceId());
        if (cluster == null) {
            throw new IllegalArgumentException("No cluster found for device " + connectPoint.deviceId());
        }
        ImmutableSet points = ((ImmutableSetMultimap)this.broadcastSets.get()).get((Object)cluster.id());
        return points == null || points.isEmpty() || points.contains(connectPoint);
    }

    int broadcastSetSize(ClusterId clusterId) {
        return ((ImmutableSetMultimap)this.broadcastSets.get()).get((Object)clusterId).size();
    }

    Set<org.onosproject.net.Path> getPaths(DeviceId src, DeviceId dst) {
        return this.getPaths(src, dst, null);
    }

    Set<org.onosproject.net.Path> getPaths(DeviceId src, DeviceId dst, LinkWeight weight) {
        DefaultTopologyVertex srcV = new DefaultTopologyVertex(src);
        DefaultTopologyVertex dstV = new DefaultTopologyVertex(dst);
        Set vertices = this.graph.getVertexes();
        if (!vertices.contains(srcV) || !vertices.contains(dstV)) {
            return ImmutableSet.of();
        }
        GraphPathSearch.Result result = DIJKSTRA.search((Graph)this.graph, (Vertex)srcV, (Vertex)dstV, (EdgeWeight)weight, -1);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Path path : result.paths()) {
            builder.add((Object)this.networkPath((Path<TopologyVertex, TopologyEdge>)path));
        }
        return builder.build();
    }

    private org.onosproject.net.Path networkPath(Path<TopologyVertex, TopologyEdge> path) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (TopologyEdge edge : path.edges()) {
            links.add(edge.link());
        }
        return new DefaultPath(CoreService.CORE_PROVIDER_ID, links, path.cost(), new Annotations[0]);
    }

    private TarjanGraphSearch.SCCResult<TopologyVertex, TopologyEdge> searchForClusters() {
        return TARJAN.search((Graph)this.graph, (EdgeWeight)new NoIndirectLinksWeight());
    }

    private ImmutableMap<ClusterId, TopologyCluster> buildTopologyClusters() {
        ImmutableMap.Builder clusterBuilder = ImmutableMap.builder();
        TarjanGraphSearch.SCCResult results = (TarjanGraphSearch.SCCResult)this.clusterResults.get();
        List clusterVertexes = results.clusterVertexes();
        List clusterEdges = results.clusterEdges();
        int n = results.clusterCount();
        for (int i = 0; i < n; ++i) {
            Set vertexSet = (Set)clusterVertexes.get(i);
            Set edgeSet = (Set)clusterEdges.get(i);
            ClusterId cid = ClusterId.clusterId((int)i);
            DefaultTopologyCluster cluster = new DefaultTopologyCluster(cid, vertexSet.size(), edgeSet.size(), this.findRoot(vertexSet));
            clusterBuilder.put((Object)cid, (Object)cluster);
        }
        return clusterBuilder.build();
    }

    private TopologyVertex findRoot(Set<TopologyVertex> vertexSet) {
        TopologyVertex minVertex = null;
        for (TopologyVertex vertex : vertexSet) {
            if (minVertex != null && minVertex.deviceId().toString().compareTo(minVertex.deviceId().toString()) >= 0) continue;
            minVertex = vertex;
        }
        return minVertex;
    }

    private ImmutableSetMultimap<ClusterId, ConnectPoint> buildBroadcastSets() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (TopologyCluster cluster : ((ImmutableMap)this.clusters.get()).values()) {
            this.addClusterBroadcastSet(cluster, (ImmutableSetMultimap.Builder<ClusterId, ConnectPoint>)builder);
        }
        return builder.build();
    }

    private void addClusterBroadcastSet(TopologyCluster cluster, ImmutableSetMultimap.Builder<ClusterId, ConnectPoint> builder) {
        GraphPathSearch.Result result = DIJKSTRA.search((Graph)this.graph, (Vertex)cluster.root(), null, (EdgeWeight)this.weight, 1);
        for (Map.Entry entry : result.parents().entrySet()) {
            Set parents;
            TopologyVertex vertex = (TopologyVertex)entry.getKey();
            if (this.clustersByDevice().get((Object)vertex.deviceId()) != cluster || (parents = (Set)entry.getValue()).isEmpty()) continue;
            Link link = ((TopologyEdge)parents.iterator().next()).link();
            builder.put((Object)cluster.id(), (Object)link.src());
            builder.put((Object)cluster.id(), (Object)link.dst());
        }
    }

    private ImmutableSet<ConnectPoint> findInfrastructurePoints() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TopologyEdge edge : this.graph.getEdges()) {
            builder.add((Object)edge.link().src());
            builder.add((Object)edge.link().dst());
        }
        return builder.build();
    }

    private ClusterIndexes buildIndexes() {
        ImmutableMap.Builder clusterBuilder = ImmutableMap.builder();
        ImmutableSetMultimap.Builder devicesBuilder = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder linksBuilder = ImmutableSetMultimap.builder();
        for (TopologyCluster cluster : ((ImmutableMap)this.clusters.get()).values()) {
            int i = cluster.id().index();
            for (TopologyVertex vertex : (Set)((TarjanGraphSearch.SCCResult)this.clusterResults.get()).clusterVertexes().get(i)) {
                devicesBuilder.put((Object)cluster, (Object)vertex.deviceId());
                clusterBuilder.put((Object)vertex.deviceId(), (Object)cluster);
            }
            for (TopologyEdge edge : (Set)((TarjanGraphSearch.SCCResult)this.clusterResults.get()).clusterEdges().get(i)) {
                linksBuilder.put((Object)cluster, (Object)edge.link());
            }
        }
        return new ClusterIndexes((ImmutableMap<DeviceId, TopologyCluster>)clusterBuilder.build(), (ImmutableSetMultimap<TopologyCluster, DeviceId>)devicesBuilder.build(), (ImmutableSetMultimap<TopologyCluster, Link>)linksBuilder.build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("time", this.time).add("created", this.creationTime).add("computeCost", this.computeCost).add("clusters", this.clusterCount()).add("devices", this.deviceCount()).add("links", this.linkCount()).toString();
    }

    static final class ClusterIndexes {
        final ImmutableMap<DeviceId, TopologyCluster> clustersByDevice;
        final ImmutableSetMultimap<TopologyCluster, DeviceId> devicesByCluster;
        final ImmutableSetMultimap<TopologyCluster, Link> linksByCluster;

        public ClusterIndexes(ImmutableMap<DeviceId, TopologyCluster> clustersByDevice, ImmutableSetMultimap<TopologyCluster, DeviceId> devicesByCluster, ImmutableSetMultimap<TopologyCluster, Link> linksByCluster) {
            this.clustersByDevice = clustersByDevice;
            this.devicesByCluster = devicesByCluster;
            this.linksByCluster = linksByCluster;
        }
    }

    private static class NoIndirectLinksWeight
    implements LinkWeight {
        private NoIndirectLinksWeight() {
        }

        public double weight(TopologyEdge edge) {
            return edge.link().state() == Link.State.INACTIVE || edge.link().type() == Link.Type.INDIRECT ? -1.0 : 1.0;
        }
    }

    private static class HopCountLinkWeight
    implements LinkWeight {
        private final int indirectLinkCost;

        HopCountLinkWeight(int indirectLinkCost) {
            this.indirectLinkCost = indirectLinkCost;
        }

        public double weight(TopologyEdge edge) {
            return edge.link().state() == Link.State.ACTIVE ? (double)(edge.link().type() == Link.Type.INDIRECT ? this.indirectLinkCost : 1) : -1.0;
        }
    }
}

