/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplicationId;

@Component(immediate=true)
@Service
public class SimpleApplicationIdStore
implements ApplicationIdStore {
    private static final AtomicInteger ID_DISPENSER = new AtomicInteger(1);
    private final Map<Short, DefaultApplicationId> appIds = new ConcurrentHashMap<Short, DefaultApplicationId>();
    private final Map<String, DefaultApplicationId> appIdsByName = new ConcurrentHashMap<String, DefaultApplicationId>();

    public Set<ApplicationId> getAppIds() {
        return ImmutableSet.copyOf(this.appIds.values());
    }

    public ApplicationId getAppId(Short id) {
        return (ApplicationId)this.appIds.get(id);
    }

    public ApplicationId getAppId(String name) {
        return (ApplicationId)this.appIdsByName.get(name);
    }

    public ApplicationId registerApplication(String name) {
        DefaultApplicationId appId = this.appIdsByName.get(name);
        if (appId == null) {
            short id = (short)ID_DISPENSER.getAndIncrement();
            appId = new DefaultApplicationId((int)id, name);
            this.appIds.put(id, appId);
            this.appIdsByName.put(name, appId);
        }
        return appId;
    }
}

