/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationState;
import org.onosproject.app.ApplicationStore;
import org.onosproject.app.ApplicationStoreDelegate;
import org.onosproject.common.app.ApplicationArchive;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplication;
import org.onosproject.core.Permission;
import org.onosproject.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleApplicationStore
extends ApplicationArchive
implements ApplicationStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<ApplicationId, DefaultApplication> apps = new ConcurrentHashMap<ApplicationId, DefaultApplication>();
    private final ConcurrentMap<ApplicationId, ApplicationState> states = new ConcurrentHashMap<ApplicationId, ApplicationState>();
    private final ConcurrentMap<ApplicationId, Set<Permission>> permissions = new ConcurrentHashMap<ApplicationId, Set<Permission>>();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationIdStore idStore;

    @Activate
    public void activate() {
        this.loadFromDisk();
        this.log.info("Started");
    }

    private void loadFromDisk() {
        for (String name : this.getApplicationNames()) {
            ApplicationId appId = this.idStore.registerApplication(name);
            ApplicationDescription appDesc = this.getApplicationDescription(name);
            DefaultApplication app = new DefaultApplication(appId, appDesc.version(), appDesc.description(), appDesc.origin(), appDesc.role(), appDesc.permissions(), appDesc.featuresRepo(), appDesc.features());
            this.apps.put(appId, app);
            this.states.put(appId, this.isActive(name) ? ApplicationState.INSTALLED : ApplicationState.ACTIVE);
        }
    }

    @Deactivate
    public void deactivate() {
        this.apps.clear();
        this.states.clear();
        this.permissions.clear();
        this.log.info("Stopped");
    }

    public Set<Application> getApplications() {
        return ImmutableSet.copyOf(this.apps.values());
    }

    public ApplicationId getId(String name) {
        return this.idStore.getAppId(name);
    }

    public Application getApplication(ApplicationId appId) {
        return (Application)this.apps.get(appId);
    }

    public ApplicationState getState(ApplicationId appId) {
        return (ApplicationState)this.states.get(appId);
    }

    public Application create(InputStream appDescStream) {
        ApplicationDescription appDesc = this.saveApplication(appDescStream);
        ApplicationId appId = this.idStore.registerApplication(appDesc.name());
        DefaultApplication app = new DefaultApplication(appId, appDesc.version(), appDesc.description(), appDesc.origin(), appDesc.role(), appDesc.permissions(), appDesc.featuresRepo(), appDesc.features());
        this.apps.put(appId, app);
        this.states.put(appId, ApplicationState.INSTALLED);
        ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, (Application)app));
        return app;
    }

    public void remove(ApplicationId appId) {
        Application app = (Application)this.apps.remove(appId);
        if (app != null) {
            this.states.remove(appId);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_UNINSTALLED, app));
            this.purgeApplication(app.id().name());
        }
    }

    public void activate(ApplicationId appId) {
        Application app = (Application)this.apps.get(appId);
        if (app != null) {
            this.setActive(appId.name());
            this.states.put(appId, ApplicationState.ACTIVE);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_ACTIVATED, app));
        }
    }

    public void deactivate(ApplicationId appId) {
        Application app = (Application)this.apps.get(appId);
        if (app != null) {
            this.clearActive(appId.name());
            this.states.put(appId, ApplicationState.INSTALLED);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_DEACTIVATED, app));
        }
    }

    public Set<Permission> getPermissions(ApplicationId appId) {
        return (Set)this.permissions.get(appId);
    }

    public void setPermissions(ApplicationId appId, Set<Permission> permissions) {
        Application app = this.getApplication(appId);
        if (app != null) {
            this.permissions.put(appId, permissions);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_PERMISSIONS_CHANGED, app));
        }
    }

    protected void bindIdStore(ApplicationIdStore applicationIdStore) {
        this.idStore = applicationIdStore;
    }

    protected void unbindIdStore(ApplicationIdStore applicationIdStore) {
        if (this.idStore == applicationIdStore) {
            this.idStore = null;
        }
    }
}

