/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.joda.time.DateTime;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterStore;
import org.onosproject.cluster.ClusterStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PartitionEvent;
import org.onosproject.net.intent.PartitionEventListener;
import org.onosproject.net.intent.PartitionService;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleClusterStore
extends AbstractStore<ClusterEvent, ClusterStoreDelegate>
implements ClusterStore,
PartitionService {
    public static final IpAddress LOCALHOST = IpAddress.valueOf((String)"127.0.0.1");
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ControllerNode instance;
    private final DateTime creationTime = DateTime.now();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    private ListenerRegistry<PartitionEvent, PartitionEventListener> listenerRegistry;

    @Activate
    public void activate() {
        this.instance = new DefaultControllerNode(new NodeId("local"), LOCALHOST);
        this.listenerRegistry = new ListenerRegistry();
        this.eventDispatcher.addSink(PartitionEvent.class, this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(PartitionEvent.class);
        this.log.info("Stopped");
    }

    public ControllerNode getLocalNode() {
        return this.instance;
    }

    public Set<ControllerNode> getNodes() {
        return ImmutableSet.of((Object)this.instance);
    }

    public ControllerNode getNode(NodeId nodeId) {
        return this.instance.id().equals((Object)nodeId) ? this.instance : null;
    }

    public ControllerNode.State getState(NodeId nodeId) {
        return ControllerNode.State.ACTIVE;
    }

    public DateTime getLastUpdated(NodeId nodeId) {
        return this.creationTime;
    }

    public ControllerNode addNode(NodeId nodeId, IpAddress ip, int tcpPort) {
        return null;
    }

    public void removeNode(NodeId nodeId) {
    }

    public boolean isMine(Key intentKey) {
        return true;
    }

    public NodeId getLeader(Key intentKey) {
        return this.instance.id();
    }

    public void addListener(PartitionEventListener listener) {
        this.listenerRegistry.addListener((EventListener)listener);
    }

    public void removeListener(PartitionEventListener listener) {
        this.listenerRegistry.removeListener((EventListener)listener);
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }
}

