/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ChassisId;
import org.onlab.util.NewConcurrentHashMap;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreDelegate;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleDeviceStore
extends AbstractStore<DeviceEvent, DeviceStoreDelegate>
implements DeviceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String DEVICE_NOT_FOUND = "Device with ID %s not found";
    private final ConcurrentMap<DeviceId, Map<ProviderId, DeviceDescriptions>> deviceDescs = Maps.newConcurrentMap();
    private final ConcurrentMap<DeviceId, Device> devices = Maps.newConcurrentMap();
    private final ConcurrentMap<DeviceId, ConcurrentMap<PortNumber, Port>> devicePorts = Maps.newConcurrentMap();
    private final ConcurrentMap<DeviceId, ConcurrentMap<PortNumber, PortStatistics>> devicePortStats = Maps.newConcurrentMap();
    private final Set<DeviceId> availableDevices = Sets.newConcurrentHashSet();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceDescs.clear();
        this.devices.clear();
        this.devicePorts.clear();
        this.availableDevices.clear();
        this.log.info("Stopped");
    }

    public int getDeviceCount() {
        return this.devices.size();
    }

    public Iterable<Device> getDevices() {
        return Collections.unmodifiableCollection(this.devices.values());
    }

    public Iterable<Device> getAvailableDevices() {
        return FluentIterable.from(this.getDevices()).filter((Predicate)new Predicate<Device>(){

            public boolean apply(Device input) {
                return SimpleDeviceStore.this.isAvailable(input.id());
            }
        });
    }

    public Device getDevice(DeviceId deviceId) {
        return (Device)this.devices.get(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceEvent createOrUpdateDevice(ProviderId providerId, DeviceId deviceId, DeviceDescription deviceDescription) {
        Map<ProviderId, DeviceDescriptions> providerDescs;
        Map<ProviderId, DeviceDescriptions> map = providerDescs = this.getOrCreateDeviceDescriptions(deviceId);
        synchronized (map) {
            DeviceDescriptions descs = this.getOrCreateProviderDeviceDescriptions(providerDescs, providerId, deviceDescription);
            Device oldDevice = (Device)this.devices.get(deviceId);
            descs.putDeviceDesc(deviceDescription);
            Device newDevice = this.composeDevice(deviceId, providerDescs);
            if (oldDevice == null) {
                return this.createDevice(providerId, newDevice);
            }
            return this.updateDevice(providerId, oldDevice, newDevice);
        }
    }

    private DeviceEvent createDevice(ProviderId providerId, Device newDevice) {
        Device oldDevice = this.devices.putIfAbsent(newDevice.id(), newDevice);
        Verify.verify((oldDevice == null ? 1 : 0) != 0, (String)"Unexpected Device in cache. PID:%s [old=%s, new=%s]", (Object[])new Object[]{providerId, oldDevice, newDevice});
        if (!providerId.isAncillary()) {
            this.availableDevices.add(newDevice.id());
        }
        return new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, newDevice, null);
    }

    private DeviceEvent updateDevice(ProviderId providerId, Device oldDevice, Device newDevice) {
        boolean annotationsChanged;
        boolean propertiesChanged = !Objects.equals(oldDevice.hwVersion(), newDevice.hwVersion()) || !Objects.equals(oldDevice.swVersion(), newDevice.swVersion());
        boolean bl = annotationsChanged = !AnnotationsUtil.isEqual((Annotations)oldDevice.annotations(), (Annotations)newDevice.annotations());
        if (providerId.isAncillary() && annotationsChanged || !providerId.isAncillary() && (propertiesChanged || annotationsChanged)) {
            boolean replaced = this.devices.replace(newDevice.id(), oldDevice, newDevice);
            if (!replaced) {
                Verify.verify((boolean)replaced, (String)"Replacing devices cache failed. PID:%s [expected:%s, found:%s, new=%s]", (Object[])new Object[]{providerId, oldDevice, this.devices.get(newDevice.id()), newDevice});
            }
            if (!providerId.isAncillary()) {
                this.availableDevices.add(newDevice.id());
            }
            return new DeviceEvent(DeviceEvent.Type.DEVICE_UPDATED, newDevice, null);
        }
        if (!providerId.isAncillary()) {
            boolean added = this.availableDevices.add(newDevice.id());
            return !added ? null : new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, newDevice, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceEvent markOffline(DeviceId deviceId) {
        Map<ProviderId, DeviceDescriptions> providerDescs;
        Map<ProviderId, DeviceDescriptions> map = providerDescs = this.getOrCreateDeviceDescriptions(deviceId);
        synchronized (map) {
            Device device = (Device)this.devices.get(deviceId);
            if (device == null) {
                return null;
            }
            boolean removed = this.availableDevices.remove(deviceId);
            if (removed) {
                return new DeviceEvent(DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, device, null);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceEvent> updatePorts(ProviderId providerId, DeviceId deviceId, List<PortDescription> portDescriptions) {
        Device device = (Device)this.devices.get(deviceId);
        if (device == null) {
            this.log.debug("Device {} doesn't exist or hasn't been initialized yet", (Object)deviceId);
            return Collections.emptyList();
        }
        Map descsMap = (Map)this.deviceDescs.get(deviceId);
        Preconditions.checkArgument((descsMap != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        ArrayList<DeviceEvent> events = new ArrayList<DeviceEvent>();
        Map map = descsMap;
        synchronized (map) {
            DeviceDescriptions descs = (DeviceDescriptions)descsMap.get(providerId);
            Preconditions.checkArgument((descs != null ? 1 : 0) != 0, (String)"Device description for Device ID %s from Provider %s was not found", (Object[])new Object[]{deviceId, providerId});
            ConcurrentMap<PortNumber, Port> ports = this.getPortMap(deviceId);
            HashSet<PortNumber> processed = new HashSet<PortNumber>();
            for (PortDescription portDescription : portDescriptions) {
                PortNumber number = portDescription.portNumber();
                processed.add(portDescription.portNumber());
                Port oldPort = (Port)ports.get(number);
                descs.putPortDesc(portDescription);
                Port newPort = this.composePort(device, number, descsMap);
                events.add(oldPort == null ? this.createPort(device, newPort, ports) : this.updatePort(device, oldPort, newPort, ports));
            }
            events.addAll(this.pruneOldPorts(device, ports, processed));
        }
        return FluentIterable.from(events).filter(Predicates.notNull()).toList();
    }

    private DeviceEvent createPort(Device device, Port newPort, Map<PortNumber, Port> ports) {
        ports.put(newPort.number(), newPort);
        return new DeviceEvent(DeviceEvent.Type.PORT_ADDED, device, newPort);
    }

    private DeviceEvent updatePort(Device device, Port oldPort, Port newPort, Map<PortNumber, Port> ports) {
        if (oldPort.isEnabled() != newPort.isEnabled() || oldPort.type() != newPort.type() || oldPort.portSpeed() != newPort.portSpeed() || !AnnotationsUtil.isEqual((Annotations)oldPort.annotations(), (Annotations)newPort.annotations())) {
            ports.put(oldPort.number(), newPort);
            return new DeviceEvent(DeviceEvent.Type.PORT_UPDATED, device, newPort);
        }
        return null;
    }

    private List<DeviceEvent> pruneOldPorts(Device device, Map<PortNumber, Port> ports, Set<PortNumber> processed) {
        ArrayList<DeviceEvent> events = new ArrayList<DeviceEvent>();
        Iterator<Map.Entry<PortNumber, Port>> iterator = ports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PortNumber, Port> e = iterator.next();
            PortNumber portNumber = e.getKey();
            if (processed.contains(portNumber)) continue;
            events.add(new DeviceEvent(DeviceEvent.Type.PORT_REMOVED, device, e.getValue()));
            iterator.remove();
        }
        return events;
    }

    private ConcurrentMap<PortNumber, Port> getPortMap(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.devicePorts, (Object)deviceId, (ConcurrentInitializer)NewConcurrentHashMap.ifNeeded());
    }

    private Map<ProviderId, DeviceDescriptions> getOrCreateDeviceDescriptions(DeviceId deviceId) {
        HashMap<ProviderId, DeviceDescriptions> r = (HashMap<ProviderId, DeviceDescriptions>)this.deviceDescs.get(deviceId);
        if (r != null) {
            return r;
        }
        r = new HashMap<ProviderId, DeviceDescriptions>();
        Map concurrentlyAdded = this.deviceDescs.putIfAbsent(deviceId, r);
        if (concurrentlyAdded != null) {
            return concurrentlyAdded;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceDescriptions getOrCreateProviderDeviceDescriptions(Map<ProviderId, DeviceDescriptions> device, ProviderId providerId, DeviceDescription deltaDesc) {
        Map<ProviderId, DeviceDescriptions> map = device;
        synchronized (map) {
            DeviceDescriptions r = device.get(providerId);
            if (r == null) {
                r = new DeviceDescriptions(deltaDesc);
                device.put(providerId, r);
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceEvent updatePortStatus(ProviderId providerId, DeviceId deviceId, PortDescription portDescription) {
        Device device = (Device)this.devices.get(deviceId);
        Preconditions.checkArgument((device != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        Map descsMap = (Map)this.deviceDescs.get(deviceId);
        Preconditions.checkArgument((descsMap != null ? 1 : 0) != 0, (String)DEVICE_NOT_FOUND, (Object[])new Object[]{deviceId});
        Map map = descsMap;
        synchronized (map) {
            DeviceDescriptions descs = (DeviceDescriptions)descsMap.get(providerId);
            Preconditions.checkArgument((descs != null ? 1 : 0) != 0, (String)"Device description for Device ID %s from Provider %s was not found", (Object[])new Object[]{deviceId, providerId});
            ConcurrentMap<PortNumber, Port> ports = this.getPortMap(deviceId);
            PortNumber number = portDescription.portNumber();
            Port oldPort = (Port)ports.get(number);
            descs.putPortDesc(portDescription);
            Port newPort = this.composePort(device, number, descsMap);
            if (oldPort == null) {
                return this.createPort(device, newPort, ports);
            }
            return this.updatePort(device, oldPort, newPort, ports);
        }
    }

    public List<Port> getPorts(DeviceId deviceId) {
        Map ports = (Map)this.devicePorts.get(deviceId);
        if (ports == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(ports.values());
    }

    public DeviceEvent updatePortStatistics(ProviderId providerId, DeviceId deviceId, Collection<PortStatistics> portStats) {
        ConcurrentMap statsMap = (ConcurrentMap)this.devicePortStats.get(deviceId);
        if (statsMap == null) {
            statsMap = Maps.newConcurrentMap();
            this.devicePortStats.put(deviceId, statsMap);
        }
        for (PortStatistics stat : portStats) {
            PortNumber portNumber = PortNumber.portNumber((long)stat.port());
            statsMap.put(portNumber, stat);
        }
        return new DeviceEvent(DeviceEvent.Type.PORT_STATS_UPDATED, (Device)this.devices.get(deviceId), null);
    }

    public Port getPort(DeviceId deviceId, PortNumber portNumber) {
        Map ports = (Map)this.devicePorts.get(deviceId);
        return ports == null ? null : (Port)ports.get(portNumber);
    }

    public List<PortStatistics> getPortStatistics(DeviceId deviceId) {
        Map portStats = (Map)this.devicePortStats.get(deviceId);
        if (portStats == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(portStats.values());
    }

    public boolean isAvailable(DeviceId deviceId) {
        return this.availableDevices.contains(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceEvent removeDevice(DeviceId deviceId) {
        Map<ProviderId, DeviceDescriptions> descs;
        Map<ProviderId, DeviceDescriptions> map = descs = this.getOrCreateDeviceDescriptions(deviceId);
        synchronized (map) {
            Device device = (Device)this.devices.remove(deviceId);
            Map ports = (Map)this.devicePorts.get(deviceId);
            if (ports != null) {
                ports.clear();
            }
            this.availableDevices.remove(deviceId);
            descs.clear();
            return device == null ? null : new DeviceEvent(DeviceEvent.Type.DEVICE_REMOVED, device, null);
        }
    }

    private Device composeDevice(DeviceId deviceId, Map<ProviderId, DeviceDescriptions> providerDescs) {
        Preconditions.checkArgument((!providerDescs.isEmpty() ? 1 : 0) != 0, (Object)"No Device descriptions supplied");
        ProviderId primary = this.pickPrimaryPID(providerDescs);
        DeviceDescriptions desc = providerDescs.get(primary);
        DeviceDescription base = desc.getDeviceDesc();
        Device.Type type = base.type();
        String manufacturer = base.manufacturer();
        String hwVersion = base.hwVersion();
        String swVersion = base.swVersion();
        String serialNumber = base.serialNumber();
        ChassisId chassisId = base.chassisId();
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)base.annotations());
        for (Map.Entry<ProviderId, DeviceDescriptions> e : providerDescs.entrySet()) {
            if (e.getKey().equals((Object)primary)) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)e.getValue().getDeviceDesc().annotations());
        }
        return new DefaultDevice(primary, deviceId, type, manufacturer, hwVersion, swVersion, serialNumber, chassisId, new Annotations[]{annotations});
    }

    private Port composePort(Device device, PortNumber number, Map<ProviderId, DeviceDescriptions> descsMap) {
        ProviderId primary = this.pickPrimaryPID(descsMap);
        DeviceDescriptions primDescs = descsMap.get(primary);
        boolean isEnabled = false;
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        PortDescription portDesc = primDescs.getPortDesc(number);
        if (portDesc != null) {
            isEnabled = portDesc.isEnabled();
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)portDesc.annotations());
        }
        for (Map.Entry<ProviderId, DeviceDescriptions> e : descsMap.entrySet()) {
            PortDescription otherPortDesc;
            if (e.getKey().equals((Object)primary) || (otherPortDesc = e.getValue().getPortDesc(number)) == null) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)otherPortDesc.annotations());
        }
        return portDesc == null ? new DefaultPort((Element)device, number, false, new Annotations[]{annotations}) : new DefaultPort((Element)device, number, isEnabled, portDesc.type(), portDesc.portSpeed(), new Annotations[]{annotations});
    }

    private ProviderId pickPrimaryPID(Map<ProviderId, DeviceDescriptions> descsMap) {
        ProviderId fallBackPrimary = null;
        for (Map.Entry<ProviderId, DeviceDescriptions> e : descsMap.entrySet()) {
            if (!e.getKey().isAncillary()) {
                return e.getKey();
            }
            if (fallBackPrimary != null) continue;
            fallBackPrimary = e.getKey();
        }
        return fallBackPrimary;
    }

    private static class DeviceDescriptions {
        private final AtomicReference<DeviceDescription> deviceDesc;
        private final ConcurrentMap<PortNumber, PortDescription> portDescs;

        public DeviceDescriptions(DeviceDescription desc) {
            this.deviceDesc = new AtomicReference<Object>(Preconditions.checkNotNull((Object)desc));
            this.portDescs = new ConcurrentHashMap<PortNumber, PortDescription>();
        }

        public DeviceDescription getDeviceDesc() {
            return this.deviceDesc.get();
        }

        public PortDescription getPortDesc(PortNumber number) {
            return (PortDescription)this.portDescs.get(number);
        }

        public synchronized DeviceDescription putDeviceDesc(DeviceDescription newDesc) {
            DeviceDescription oldOne = this.deviceDesc.get();
            DeviceDescription newOne = newDesc;
            if (oldOne != null) {
                SparseAnnotations merged = DefaultAnnotations.union((SparseAnnotations)oldOne.annotations(), (SparseAnnotations)newDesc.annotations());
                newOne = new DefaultDeviceDescription(newOne, new SparseAnnotations[]{merged});
            }
            return this.deviceDesc.getAndSet(newOne);
        }

        public synchronized PortDescription putPortDesc(PortDescription newDesc) {
            PortDescription oldOne = (PortDescription)this.portDescs.get(newDesc.portNumber());
            PortDescription newOne = newDesc;
            if (oldOne != null) {
                SparseAnnotations merged = DefaultAnnotations.union((SparseAnnotations)oldOne.annotations(), (SparseAnnotations)newDesc.annotations());
                newOne = new DefaultPortDescription(newOne, merged);
            }
            return this.portDescs.put(newOne.portNumber(), newOne);
        }
    }
}

