/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.NewConcurrentHashMap;
import org.onosproject.event.Event;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.CompletedBatchOperation;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchEvent;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleStore;
import org.onosproject.net.flow.FlowRuleStoreDelegate;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleFlowRuleStore
extends AbstractStore<FlowRuleBatchEvent, FlowRuleStoreDelegate>
implements FlowRuleStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<DeviceId, ConcurrentMap<FlowId, List<StoredFlowEntry>>> flowEntries = new ConcurrentHashMap<DeviceId, ConcurrentMap<FlowId, List<StoredFlowEntry>>>();
    private final AtomicInteger localBatchIdGen = new AtomicInteger();
    private int pendingFutureTimeoutMinutes = 5;
    private Cache<Integer, SettableFuture<CompletedBatchOperation>> pendingFutures = CacheBuilder.newBuilder().expireAfterWrite((long)this.pendingFutureTimeoutMinutes, TimeUnit.MINUTES).removalListener((RemovalListener)new TimeoutFuture()).build();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.flowEntries.clear();
        this.log.info("Stopped");
    }

    public int getFlowRuleCount() {
        int sum = 0;
        for (ConcurrentMap ft : this.flowEntries.values()) {
            for (List fes : ft.values()) {
                sum += fes.size();
            }
        }
        return sum;
    }

    private static NewConcurrentHashMap<FlowId, List<StoredFlowEntry>> lazyEmptyFlowTable() {
        return NewConcurrentHashMap.ifNeeded();
    }

    private ConcurrentMap<FlowId, List<StoredFlowEntry>> getFlowTable(DeviceId deviceId) {
        return (ConcurrentMap)ConcurrentUtils.createIfAbsentUnchecked(this.flowEntries, (Object)deviceId, SimpleFlowRuleStore.lazyEmptyFlowTable());
    }

    private List<StoredFlowEntry> getFlowEntries(DeviceId deviceId, FlowId flowId) {
        List concurrentlyAdded;
        ConcurrentMap<FlowId, List<StoredFlowEntry>> flowTable = this.getFlowTable(deviceId);
        CopyOnWriteArrayList r = (CopyOnWriteArrayList)flowTable.get(flowId);
        if (r == null && (concurrentlyAdded = (List)flowTable.putIfAbsent(flowId, r = new CopyOnWriteArrayList())) != null) {
            return concurrentlyAdded;
        }
        return r;
    }

    private FlowEntry getFlowEntryInternal(DeviceId deviceId, FlowRule rule) {
        List<StoredFlowEntry> fes = this.getFlowEntries(deviceId, rule.id());
        for (StoredFlowEntry fe : fes) {
            if (!fe.equals(rule)) continue;
            return fe;
        }
        return null;
    }

    public FlowEntry getFlowEntry(FlowRule rule) {
        return this.getFlowEntryInternal(rule.deviceId(), rule);
    }

    public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
        return FluentIterable.from(this.getFlowTable(deviceId).values()).transformAndConcat((Function)new Function<List<StoredFlowEntry>, Iterable<? extends FlowEntry>>(){

            public Iterable<? extends FlowEntry> apply(List<StoredFlowEntry> input) {
                return Collections.unmodifiableList(input);
            }
        });
    }

    public void storeFlowRule(FlowRule rule) {
        this.storeFlowRuleInternal(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeFlowRuleInternal(FlowRule rule) {
        List<StoredFlowEntry> existing;
        DefaultFlowEntry f = new DefaultFlowEntry(rule);
        DeviceId did = f.deviceId();
        FlowId fid = f.id();
        List<StoredFlowEntry> list = existing = this.getFlowEntries(did, fid);
        synchronized (list) {
            for (StoredFlowEntry fe : existing) {
                if (!fe.equals(rule)) continue;
                return;
            }
            existing.add((StoredFlowEntry)f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFlowRule(FlowRule rule) {
        List<StoredFlowEntry> entries;
        List<StoredFlowEntry> list = entries = this.getFlowEntries(rule.deviceId(), rule.id());
        synchronized (list) {
            for (StoredFlowEntry entry : entries) {
                if (!entry.equals(rule)) continue;
                StoredFlowEntry storedFlowEntry = entry;
                synchronized (storedFlowEntry) {
                    entry.setState(FlowEntry.FlowEntryState.PENDING_REMOVE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowRuleEvent addOrUpdateFlowRule(FlowEntry rule) {
        List<StoredFlowEntry> entries;
        List<StoredFlowEntry> list = entries = this.getFlowEntries(rule.deviceId(), rule.id());
        synchronized (list) {
            StoredFlowEntry stored;
            Iterator<StoredFlowEntry> iterator = entries.iterator();
            do {
                if (iterator.hasNext()) continue;
                // MONITOREXIT @DISABLED, blocks:[3, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                this.log.error("FlowRule was not found in store {} to update", (Object)rule);
                return null;
            } while (!(stored = iterator.next()).equals(rule));
            StoredFlowEntry storedFlowEntry = stored;
            synchronized (storedFlowEntry) {
                stored.setBytes(rule.bytes());
                stored.setLife(rule.life());
                stored.setPackets(rule.packets());
                if (stored.state() == FlowEntry.FlowEntryState.PENDING_ADD) {
                    stored.setState(FlowEntry.FlowEntryState.ADDED);
                    return new FlowRuleEvent(FlowRuleEvent.Type.RULE_ADDED, (FlowRule)rule);
                }
                return new FlowRuleEvent(FlowRuleEvent.Type.RULE_UPDATED, (FlowRule)rule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowRuleEvent removeFlowRule(FlowEntry rule) {
        List<StoredFlowEntry> entries;
        DeviceId did = rule.deviceId();
        List<StoredFlowEntry> list = entries = this.getFlowEntries(did, rule.id());
        synchronized (list) {
            if (entries.remove(rule)) {
                return new FlowRuleEvent(FlowRuleEvent.Type.RULE_REMOVED, (FlowRule)rule);
            }
        }
        return null;
    }

    public void storeBatch(FlowRuleBatchOperation operation) {
        ArrayList<Object> toAdd = new ArrayList<Object>();
        ArrayList<FlowRuleBatchEntry> toRemove = new ArrayList<FlowRuleBatchEntry>();
        for (FlowRuleBatchEntry entry : operation.getOperations()) {
            FlowRule flowRule = (FlowRule)entry.target();
            if (((FlowRuleBatchEntry.FlowRuleOperation)entry.operator()).equals((Object)FlowRuleBatchEntry.FlowRuleOperation.ADD)) {
                if (this.getFlowEntries(flowRule.deviceId(), flowRule.id()).contains(flowRule)) continue;
                this.storeFlowRule(flowRule);
                toAdd.add(entry);
                continue;
            }
            if (((FlowRuleBatchEntry.FlowRuleOperation)entry.operator()).equals((Object)FlowRuleBatchEntry.FlowRuleOperation.REMOVE)) {
                if (!this.getFlowEntries(flowRule.deviceId(), flowRule.id()).contains(flowRule)) continue;
                this.deleteFlowRule(flowRule);
                toRemove.add(entry);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported operation type");
        }
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            this.notifyDelegate((Event)FlowRuleBatchEvent.completed((FlowRuleBatchRequest)new FlowRuleBatchRequest(operation.id(), Collections.emptySet()), (CompletedBatchOperation)new CompletedBatchOperation(true, Collections.emptySet(), operation.deviceId())));
            return;
        }
        SettableFuture r = SettableFuture.create();
        int batchId = this.localBatchIdGen.incrementAndGet();
        this.pendingFutures.put((Object)batchId, (Object)r);
        toAdd.addAll(toRemove);
        this.notifyDelegate((Event)FlowRuleBatchEvent.requested((FlowRuleBatchRequest)new FlowRuleBatchRequest((long)batchId, (Set)Sets.newHashSet(toAdd)), (DeviceId)operation.deviceId()));
    }

    public void batchOperationComplete(FlowRuleBatchEvent event) {
        Long batchId = ((FlowRuleBatchRequest)event.subject()).batchId();
        SettableFuture future = (SettableFuture)this.pendingFutures.getIfPresent((Object)batchId);
        if (future != null) {
            future.set((Object)event.result());
            this.pendingFutures.invalidate((Object)batchId);
        }
        this.notifyDelegate((Event)event);
    }

    private static final class TimeoutFuture
    implements RemovalListener<Integer, SettableFuture<CompletedBatchOperation>> {
        private TimeoutFuture() {
        }

        public void onRemoval(RemovalNotification<Integer, SettableFuture<CompletedBatchOperation>> notification) {
            if (notification.wasEvicted()) {
                ((SettableFuture)notification.getValue()).setException((Throwable)new ExecutionException("Timed out", new TimeoutException()));
            }
        }
    }
}

