/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostStore;
import org.onosproject.net.host.HostStoreDelegate;
import org.onosproject.net.host.PortAddresses;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleHostStore
extends AbstractStore<HostEvent, HostStoreDelegate>
implements HostStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<HostId, StoredHost> hosts = new ConcurrentHashMap<HostId, StoredHost>(2000000, 0.75f, 16);
    private final Multimap<ConnectPoint, Host> locations = HashMultimap.create();
    private final SetMultimap<ConnectPoint, PortAddresses> portAddresses = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public HostEvent createOrUpdateHost(ProviderId providerId, HostId hostId, HostDescription hostDescription) {
        StoredHost host = this.hosts.get(hostId);
        if (host == null) {
            return this.createHost(providerId, hostId, hostDescription);
        }
        return this.updateHost(providerId, host, hostDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostEvent createHost(ProviderId providerId, HostId hostId, HostDescription descr) {
        StoredHost newhost = new StoredHost(providerId, hostId, descr.hwAddress(), descr.vlan(), descr.location(), (Set<IpAddress>)ImmutableSet.copyOf((Collection)descr.ipAddress()), new Annotations[]{descr.annotations()});
        SimpleHostStore simpleHostStore = this;
        synchronized (simpleHostStore) {
            this.hosts.put(hostId, newhost);
            this.locations.put((Object)descr.location(), (Object)newhost);
        }
        return new HostEvent(HostEvent.Type.HOST_ADDED, (Host)newhost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostEvent updateHost(ProviderId providerId, StoredHost host, HostDescription descr) {
        if (!host.location().equals((Object)descr.location())) {
            host.setLocation(descr.location());
            return new HostEvent(HostEvent.Type.HOST_MOVED, (Host)host);
        }
        if (host.ipAddresses().containsAll(descr.ipAddress()) && descr.annotations().keys().isEmpty()) {
            return null;
        }
        HashSet<IpAddress> addresses = new HashSet<IpAddress>(host.ipAddresses());
        addresses.addAll(descr.ipAddress());
        DefaultAnnotations annotations = DefaultAnnotations.merge((DefaultAnnotations)((DefaultAnnotations)host.annotations()), (SparseAnnotations)descr.annotations());
        StoredHost updated = new StoredHost(providerId, host.id(), host.mac(), host.vlan(), descr.location(), addresses, new Annotations[]{annotations});
        HostEvent event = new HostEvent(HostEvent.Type.HOST_UPDATED, (Host)updated);
        SimpleHostStore simpleHostStore = this;
        synchronized (simpleHostStore) {
            this.hosts.put(host.id(), updated);
            this.locations.remove((Object)host.location(), (Object)host);
            this.locations.put((Object)updated.location(), (Object)updated);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostEvent removeHost(HostId hostId) {
        SimpleHostStore simpleHostStore = this;
        synchronized (simpleHostStore) {
            Host host = (Host)this.hosts.remove(hostId);
            if (host != null) {
                this.locations.remove((Object)host.location(), (Object)host);
                return new HostEvent(HostEvent.Type.HOST_REMOVED, host);
            }
            return null;
        }
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public Iterable<Host> getHosts() {
        return ImmutableSet.copyOf(this.hosts.values());
    }

    public Host getHost(HostId hostId) {
        return (Host)this.hosts.get(hostId);
    }

    public Set<Host> getHosts(VlanId vlanId) {
        HashSet<Host> vlanset = new HashSet<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.vlan().equals((Object)vlanId)) continue;
            vlanset.add(host);
        }
        return vlanset;
    }

    public Set<Host> getHosts(MacAddress mac) {
        HashSet<Host> macset = new HashSet<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.mac().equals((Object)mac)) continue;
            macset.add(host);
        }
        return macset;
    }

    public Set<Host> getHosts(IpAddress ip) {
        HashSet<Host> ipset = new HashSet<Host>();
        for (Host host : this.hosts.values()) {
            if (!host.ipAddresses().contains(ip)) continue;
            ipset.add(host);
        }
        return ipset;
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        return ImmutableSet.copyOf((Collection)this.locations.get((Object)connectPoint));
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        HashSet<Host> hostset = new HashSet<Host>();
        for (ConnectPoint p : this.locations.keySet()) {
            if (!p.deviceId().equals((Object)deviceId)) continue;
            hostset.addAll(this.locations.get((Object)p));
        }
        return hostset;
    }

    public void updateAddressBindings(PortAddresses addresses) {
        this.portAddresses.put((Object)addresses.connectPoint(), (Object)addresses);
    }

    public void removeAddressBindings(PortAddresses addresses) {
        this.portAddresses.remove((Object)addresses.connectPoint(), (Object)addresses);
    }

    public void clearAddressBindings(ConnectPoint connectPoint) {
        this.portAddresses.removeAll((Object)connectPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PortAddresses> getAddressBindings() {
        SetMultimap<ConnectPoint, PortAddresses> setMultimap = this.portAddresses;
        synchronized (setMultimap) {
            return ImmutableSet.copyOf((Collection)this.portAddresses.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PortAddresses> getAddressBindingsForPort(ConnectPoint connectPoint) {
        SetMultimap<ConnectPoint, PortAddresses> setMultimap = this.portAddresses;
        synchronized (setMultimap) {
            Set addresses = this.portAddresses.get((Object)connectPoint);
            if (addresses == null) {
                return Collections.emptySet();
            }
            return ImmutableSet.copyOf((Collection)addresses);
        }
    }

    private static final class StoredHost
    extends DefaultHost {
        private HostLocation location;

        public StoredHost(ProviderId providerId, HostId id, MacAddress mac, VlanId vlan, HostLocation location, Set<IpAddress> ips, Annotations ... annotations) {
            super(providerId, id, mac, vlan, location, ips, annotations);
            this.location = location;
        }

        void setLocation(HostLocation location) {
            this.location = location;
        }

        public HostLocation location() {
            return this.location;
        }
    }
}

