/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.IdBlock;
import org.onosproject.core.IdBlockStore;

@Component(immediate=true)
@Service
public class SimpleIdBlockStore
implements IdBlockStore {
    private static final long DEFAULT_BLOCK_SIZE = 4096L;
    private final Map<String, AtomicLong> topicBlocks = new ConcurrentHashMap<String, AtomicLong>();

    public synchronized IdBlock getIdBlock(String topic) {
        AtomicLong blockGenerator = this.topicBlocks.get(topic);
        if (blockGenerator == null) {
            blockGenerator = new AtomicLong(0L);
            this.topicBlocks.put(topic, blockGenerator);
        }
        Long blockBase = blockGenerator.getAndAdd(4096L);
        return new IdBlock(blockBase.longValue(), 4096L);
    }
}

