/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.net.intent.Key;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.trivial.impl.SystemClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleIntentStore
extends AbstractStore<IntentEvent, IntentStoreDelegate>
implements IntentStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<Key, IntentData> current = Maps.newConcurrentMap();
    private final Map<Key, IntentData> pending = Maps.newConcurrentMap();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public long getIntentCount() {
        return this.current.size();
    }

    public Iterable<Intent> getIntents() {
        return this.current.values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public Iterable<IntentData> getIntentData(boolean localOnly, long olderThan) {
        if (localOnly || olderThan > 0L) {
            long older = System.nanoTime() - olderThan * 1000000L;
            SystemClockTimestamp time = new SystemClockTimestamp(older);
            return this.current.values().stream().filter(data -> data.version().isOlderThan((Timestamp)time) && (!localOnly || this.isMaster(data.key()))).collect(Collectors.toList());
        }
        return Lists.newArrayList(this.current.values());
    }

    public IntentState getIntentState(Key intentKey) {
        IntentData data = this.current.get(intentKey);
        return data != null ? data.state() : null;
    }

    public List<Intent> getInstallableIntents(Key intentKey) {
        IntentData data = this.current.get(intentKey);
        if (data != null) {
            return data.installables();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IntentData newData) {
        Preconditions.checkNotNull((Object)newData);
        SimpleIntentStore simpleIntentStore = this;
        synchronized (simpleIntentStore) {
            IntentData currentData = this.current.get(newData.key());
            IntentData pendingData = this.pending.get(newData.key());
            if (IntentData.isUpdateAcceptable((IntentData)currentData, (IntentData)newData)) {
                if (pendingData != null) {
                    if (pendingData.state() == IntentState.PURGE_REQ) {
                        this.current.remove(newData.key(), newData);
                    } else {
                        this.current.put(newData.key(), new IntentData(newData));
                    }
                    if (pendingData.version().compareTo((Object)newData.version()) <= 0) {
                        this.pending.remove(newData.key());
                    }
                }
                this.notifyDelegateIfNotNull(IntentEvent.getEvent((IntentData)newData));
            }
        }
    }

    private void notifyDelegateIfNotNull(IntentEvent event) {
        if (event != null) {
            this.notifyDelegate((Event)event);
        }
    }

    public void batchWrite(Iterable<IntentData> updates) {
        for (IntentData data : updates) {
            this.write(data);
        }
    }

    public Intent getIntent(Key key) {
        IntentData data = this.current.get(key);
        return data != null ? data.intent() : null;
    }

    public IntentData getIntentData(Key key) {
        IntentData currentData = this.current.get(key);
        if (currentData == null) {
            return null;
        }
        return new IntentData(currentData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(IntentData data) {
        if (data.version() == null) {
            data.setVersion((Timestamp)new SystemClockTimestamp());
        }
        SimpleIntentStore simpleIntentStore = this;
        synchronized (simpleIntentStore) {
            IntentData existingData = this.pending.get(data.key());
            if (existingData == null || existingData.version().compareTo((Object)data.version()) < 0) {
                this.pending.put(data.key(), data);
                ((IntentStoreDelegate)Preconditions.checkNotNull((Object)this.delegate, (Object)"Store delegate is not set")).process(new IntentData(data));
                this.notifyDelegateIfNotNull(IntentEvent.getEvent((IntentData)data));
            } else {
                this.log.debug("IntentData {} is older than existing: {}", (Object)data, (Object)existingData);
            }
        }
    }

    public boolean isMaster(Key intentKey) {
        return true;
    }

    public Iterable<Intent> getPending() {
        return this.pending.values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public Iterable<IntentData> getPendingData() {
        return Lists.newArrayList(this.pending.values());
    }

    public Iterable<IntentData> getPendingData(boolean localOnly, long olderThan) {
        long older = System.nanoTime() - olderThan * 1000000L;
        SystemClockTimestamp time = new SystemClockTimestamp(older);
        return this.pending.values().stream().filter(data -> data.version().isOlderThan((Timestamp)time) && (!localOnly || this.isMaster(data.key()))).collect(Collectors.toList());
    }
}

