/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipEventListener;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;

@Component(immediate=true)
@Service
public class SimpleLeadershipManager
implements LeadershipService {
    private Set<LeadershipEventListener> listeners = new CopyOnWriteArraySet<LeadershipEventListener>();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private ClusterService clusterService;
    private Map<String, Boolean> elections = new ConcurrentHashMap<String, Boolean>();

    public NodeId getLeader(String path) {
        return this.elections.get(path) != false ? this.clusterService.getLocalNode().id() : null;
    }

    public Leadership getLeadership(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0);
        return this.elections.get(path) != false ? new Leadership(path, this.clusterService.getLocalNode().id(), 0L, 0L) : null;
    }

    public Set<String> ownedTopics(NodeId nodeId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0);
        return this.elections.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public CompletableFuture<Leadership> runForLeadership(String path) {
        this.elections.put(path, true);
        for (LeadershipEventListener listener : this.listeners) {
            listener.event((Event)new LeadershipEvent(LeadershipEvent.Type.LEADER_ELECTED, new Leadership(path, this.clusterService.getLocalNode().id(), 0L, 0L)));
        }
        return CompletableFuture.completedFuture(new Leadership(path, this.clusterService.getLocalNode().id(), 0L, 0L));
    }

    public CompletableFuture<Void> withdraw(String path) {
        this.elections.remove(path);
        for (LeadershipEventListener listener : this.listeners) {
            listener.event((Event)new LeadershipEvent(LeadershipEvent.Type.LEADER_BOOTED, new Leadership(path, this.clusterService.getLocalNode().id(), 0L, 0L)));
        }
        return CompletableFuture.completedFuture(null);
    }

    public Map<String, Leadership> getLeaderBoard() {
        throw new UnsupportedOperationException("I don't know what to do. I wish you luck.");
    }

    public void addListener(LeadershipEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LeadershipEventListener listener) {
        this.listeners.remove(listener);
    }

    public Map<String, List<NodeId>> getCandidates() {
        return null;
    }

    public List<NodeId> getCandidates(String path) {
        return null;
    }

    public boolean stepdown(String path) {
        throw new UnsupportedOperationException();
    }

    public boolean makeTopCandidate(String path, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

