/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Bandwidth;
import org.onlab.util.PositionalParameterStringFormatter;
import org.onosproject.net.Annotations;
import org.onosproject.net.Link;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceAllocationException;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceAllocation;
import org.onosproject.net.resource.link.LambdaResource;
import org.onosproject.net.resource.link.LambdaResourceAllocation;
import org.onosproject.net.resource.link.LinkResourceAllocations;
import org.onosproject.net.resource.link.LinkResourceEvent;
import org.onosproject.net.resource.link.LinkResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleLinkResourceStore
implements LinkResourceStore {
    private static final BandwidthResource DEFAULT_BANDWIDTH = new BandwidthResource(Bandwidth.mbps((double)1000.0));
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<IntentId, LinkResourceAllocations> linkResourceAllocationsMap;
    private Map<Link, Set<LinkResourceAllocations>> allocatedResources;
    private Map<Link, Set<ResourceAllocation>> freeResources;

    @Activate
    public void activate() {
        this.linkResourceAllocationsMap = new HashMap<IntentId, LinkResourceAllocations>();
        this.allocatedResources = new HashMap<Link, Set<LinkResourceAllocations>>();
        this.freeResources = new HashMap<Link, Set<ResourceAllocation>>();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private synchronized Set<ResourceAllocation> readOriginalFreeResources(Link link) {
        Annotations annotations = link.annotations();
        HashSet<ResourceAllocation> allocations = new HashSet<ResourceAllocation>();
        try {
            int waves = Integer.parseInt(annotations.value("optical.waves"));
            for (int i = 1; i <= waves; ++i) {
                allocations.add((ResourceAllocation)new LambdaResourceAllocation(LambdaResource.valueOf((int)i)));
            }
        }
        catch (NumberFormatException e) {
            this.log.debug("No optical.wave annotation on link %s", (Object)link);
        }
        BandwidthResource bandwidth = DEFAULT_BANDWIDTH;
        try {
            bandwidth = new BandwidthResource(Bandwidth.mbps((double)Double.parseDouble(annotations.value("bandwidth"))));
        }
        catch (NumberFormatException e) {
            this.log.debug("No bandwidth annotation on link %s", (Object)link);
        }
        allocations.add((ResourceAllocation)new BandwidthResourceAllocation(bandwidth));
        return allocations;
    }

    private synchronized BandwidthResourceAllocation getBandwidth(Set<ResourceAllocation> freeRes) {
        for (ResourceAllocation res : freeRes) {
            if (res.type() != ResourceType.BANDWIDTH) continue;
            return (BandwidthResourceAllocation)res;
        }
        return new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)0.0)));
    }

    private synchronized void subtractFreeResources(Link link, LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)link);
        HashSet<ResourceAllocation> freeRes = new HashSet<ResourceAllocation>(this.getFreeResources(link));
        Set subRes = allocations.getResourceAllocation(link);
        for (ResourceAllocation res : subRes) {
            switch (res.type()) {
                case BANDWIDTH: {
                    BandwidthResourceAllocation ba = this.getBandwidth(freeRes);
                    double requestedBandwidth = ((BandwidthResourceAllocation)res).bandwidth().toDouble();
                    double newBandwidth = ba.bandwidth().toDouble() - requestedBandwidth;
                    if (newBandwidth < 0.0) {
                        throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate bandwidth for link {} requested amount is {} current allocation is {}", (Object[])new Object[]{link, requestedBandwidth, ba}));
                    }
                    freeRes.remove(ba);
                    freeRes.add((ResourceAllocation)new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)newBandwidth))));
                    break;
                }
                case LAMBDA: {
                    boolean lambdaAvailable = freeRes.remove(res);
                    if (lambdaAvailable) break;
                    int requestedLambda = ((LambdaResourceAllocation)res).lambda().toInt();
                    throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate lambda for link {} lambda is {}", (Object[])new Object[]{link, requestedLambda}));
                }
            }
        }
        this.freeResources.put(link, freeRes);
    }

    private synchronized void addFreeResources(Link link, LinkResourceAllocations allocations) {
        HashSet<ResourceAllocation> freeRes = new HashSet<ResourceAllocation>(this.getFreeResources(link));
        Set addRes = allocations.getResourceAllocation(link);
        for (ResourceAllocation res : addRes) {
            switch (res.type()) {
                case BANDWIDTH: {
                    BandwidthResourceAllocation ba = this.getBandwidth(freeRes);
                    double requestedBandwidth = ((BandwidthResourceAllocation)res).bandwidth().toDouble();
                    double newBandwidth = ba.bandwidth().toDouble() + requestedBandwidth;
                    freeRes.remove(ba);
                    freeRes.add((ResourceAllocation)new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)newBandwidth))));
                    break;
                }
                case LAMBDA: {
                    Preconditions.checkState((boolean)freeRes.add(res));
                    break;
                }
            }
        }
        this.freeResources.put(link, freeRes);
    }

    public synchronized Set<ResourceAllocation> getFreeResources(Link link) {
        Preconditions.checkNotNull((Object)link);
        Set<ResourceAllocation> freeRes = this.freeResources.get(link);
        if (freeRes == null) {
            freeRes = this.readOriginalFreeResources(link);
        }
        return freeRes;
    }

    public synchronized void allocateResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        this.linkResourceAllocationsMap.put(allocations.intentId(), allocations);
        for (Link link : allocations.links()) {
            this.subtractFreeResources(link, allocations);
            Set<LinkResourceAllocations> linkAllocs = this.allocatedResources.get(link);
            if (linkAllocs == null) {
                linkAllocs = new HashSet<LinkResourceAllocations>();
            }
            linkAllocs.add(allocations);
            this.allocatedResources.put(link, linkAllocs);
        }
    }

    public synchronized LinkResourceEvent releaseResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        this.linkResourceAllocationsMap.remove(allocations.intentId());
        for (Link link : allocations.links()) {
            this.addFreeResources(link, allocations);
            Set<LinkResourceAllocations> linkAllocs = this.allocatedResources.get(link);
            if (linkAllocs == null) {
                this.log.error("Missing resource allocation.");
            } else {
                linkAllocs.remove(allocations);
            }
            this.allocatedResources.put(link, linkAllocs);
        }
        ImmutableList releasedResources = ImmutableList.of((Object)allocations);
        return new LinkResourceEvent(LinkResourceEvent.Type.ADDITIONAL_RESOURCES_AVAILABLE, (Collection)releasedResources);
    }

    public synchronized LinkResourceAllocations getAllocations(IntentId intentId) {
        Preconditions.checkNotNull((Object)intentId);
        return this.linkResourceAllocationsMap.get(intentId);
    }

    public synchronized Iterable<LinkResourceAllocations> getAllocations(Link link) {
        Preconditions.checkNotNull((Object)link);
        Set<Object> result = this.allocatedResources.get(link);
        if (result == null) {
            result = Collections.emptySet();
        }
        return Collections.unmodifiableSet(result);
    }

    public synchronized Iterable<LinkResourceAllocations> getAllocations() {
        return Collections.unmodifiableCollection(this.linkResourceAllocationsMap.values());
    }
}

