/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.Annotations;
import org.onosproject.net.AnnotationsUtil;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkStore;
import org.onosproject.net.link.LinkStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleLinkStore
extends AbstractStore<LinkEvent, LinkStoreDelegate>
implements LinkStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ConcurrentMap<LinkKey, Map<ProviderId, LinkDescription>> linkDescs = new ConcurrentHashMap<LinkKey, Map<ProviderId, LinkDescription>>();
    private final ConcurrentMap<LinkKey, Link> links = new ConcurrentHashMap<LinkKey, Link>();
    private final SetMultimap<DeviceId, LinkKey> srcLinks = SimpleLinkStore.createSynchronizedHashMultiMap();
    private final SetMultimap<DeviceId, LinkKey> dstLinks = SimpleLinkStore.createSynchronizedHashMultiMap();
    private final Function<LinkKey, Link> lookupLink = new LookupLink();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.linkDescs.clear();
        this.links.clear();
        this.srcLinks.clear();
        this.dstLinks.clear();
        this.log.info("Stopped");
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Iterable<Link> getLinks() {
        return Collections.unmodifiableCollection(this.links.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getDeviceEgressLinks(DeviceId deviceId) {
        SetMultimap<DeviceId, LinkKey> setMultimap = this.srcLinks;
        synchronized (setMultimap) {
            return FluentIterable.from((Iterable)this.srcLinks.get((Object)deviceId)).transform(this.lookupLink()).filter(Predicates.notNull()).toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getDeviceIngressLinks(DeviceId deviceId) {
        SetMultimap<DeviceId, LinkKey> setMultimap = this.dstLinks;
        synchronized (setMultimap) {
            return FluentIterable.from((Iterable)this.dstLinks.get((Object)deviceId)).transform(this.lookupLink()).filter(Predicates.notNull()).toSet();
        }
    }

    public Link getLink(ConnectPoint src, ConnectPoint dst) {
        return (Link)this.links.get(LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getEgressLinks(ConnectPoint src) {
        HashSet<Link> egress = new HashSet<Link>();
        SetMultimap<DeviceId, LinkKey> setMultimap = this.srcLinks;
        synchronized (setMultimap) {
            for (LinkKey linkKey : this.srcLinks.get((Object)src.deviceId())) {
                if (!linkKey.src().equals((Object)src)) continue;
                egress.add((Link)this.links.get(linkKey));
            }
        }
        return egress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Link> getIngressLinks(ConnectPoint dst) {
        HashSet<Link> ingress = new HashSet<Link>();
        SetMultimap<DeviceId, LinkKey> setMultimap = this.dstLinks;
        synchronized (setMultimap) {
            for (LinkKey linkKey : this.dstLinks.get((Object)dst.deviceId())) {
                if (!linkKey.dst().equals((Object)dst)) continue;
                ingress.add((Link)this.links.get(linkKey));
            }
        }
        return ingress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkEvent createOrUpdateLink(ProviderId providerId, LinkDescription linkDescription) {
        Map<ProviderId, LinkDescription> descs;
        LinkKey key = LinkKey.linkKey((ConnectPoint)linkDescription.src(), (ConnectPoint)linkDescription.dst());
        Map<ProviderId, LinkDescription> map = descs = this.getOrCreateLinkDescriptions(key);
        synchronized (map) {
            Link oldLink = (Link)this.links.get(key);
            this.createOrUpdateLinkDescription(descs, providerId, linkDescription);
            Link newLink = this.composeLink(descs);
            if (oldLink == null) {
                return this.createLink(key, newLink);
            }
            return this.updateLink(key, oldLink, newLink);
        }
    }

    public LinkEvent removeOrDownLink(ConnectPoint src, ConnectPoint dst) {
        Link link = this.getLink(src, dst);
        if (link == null) {
            return null;
        }
        if (link.isDurable()) {
            return link.state() == Link.State.INACTIVE ? null : this.updateLink(LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()), link, (Link)new DefaultLink(link.providerId(), link.src(), link.dst(), link.type(), Link.State.INACTIVE, link.isDurable(), new Annotations[]{link.annotations()}));
        }
        return this.removeLink(src, dst);
    }

    private LinkDescription createOrUpdateLinkDescription(Map<ProviderId, LinkDescription> descs, ProviderId providerId, LinkDescription linkDescription) {
        LinkDescription oldDesc = descs.get(providerId);
        LinkDescription newDesc = linkDescription;
        if (oldDesc != null) {
            Link.Type newType = oldDesc.type() == Link.Type.DIRECT ? Link.Type.DIRECT : linkDescription.type();
            SparseAnnotations merged = DefaultAnnotations.union((SparseAnnotations)oldDesc.annotations(), (SparseAnnotations)linkDescription.annotations());
            newDesc = new DefaultLinkDescription(linkDescription.src(), linkDescription.dst(), newType, new SparseAnnotations[]{merged});
        }
        return descs.put(providerId, newDesc);
    }

    private LinkEvent createLink(LinkKey key, Link newLink) {
        this.links.put(key, newLink);
        this.srcLinks.put((Object)newLink.src().deviceId(), (Object)key);
        this.dstLinks.put((Object)newLink.dst().deviceId(), (Object)key);
        return new LinkEvent(LinkEvent.Type.LINK_ADDED, newLink);
    }

    private LinkEvent updateLink(LinkKey key, Link oldLink, Link newLink) {
        if (oldLink.state() != newLink.state() || oldLink.type() == Link.Type.INDIRECT && newLink.type() == Link.Type.DIRECT || !AnnotationsUtil.isEqual((Annotations)oldLink.annotations(), (Annotations)newLink.annotations())) {
            this.links.put(key, newLink);
            this.srcLinks.put((Object)oldLink.src().deviceId(), (Object)key);
            this.dstLinks.put((Object)oldLink.dst().deviceId(), (Object)key);
            return new LinkEvent(LinkEvent.Type.LINK_UPDATED, newLink);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkEvent removeLink(ConnectPoint src, ConnectPoint dst) {
        Map<ProviderId, LinkDescription> descs;
        LinkKey key = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        Map<ProviderId, LinkDescription> map = descs = this.getOrCreateLinkDescriptions(key);
        synchronized (map) {
            Link link = (Link)this.links.remove(key);
            descs.clear();
            if (link != null) {
                this.srcLinks.remove((Object)link.src().deviceId(), (Object)key);
                this.dstLinks.remove((Object)link.dst().deviceId(), (Object)key);
                return new LinkEvent(LinkEvent.Type.LINK_REMOVED, link);
            }
            return null;
        }
    }

    private static <K, V> SetMultimap<K, V> createSynchronizedHashMultiMap() {
        return Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap(new ConcurrentHashMap(), () -> Sets.newConcurrentHashSet()));
    }

    private ProviderId getBaseProviderId(Map<ProviderId, LinkDescription> providerDescs) {
        ProviderId fallBackPrimary = null;
        for (Map.Entry<ProviderId, LinkDescription> e : providerDescs.entrySet()) {
            if (!e.getKey().isAncillary()) {
                return e.getKey();
            }
            if (fallBackPrimary != null) continue;
            fallBackPrimary = e.getKey();
        }
        return fallBackPrimary;
    }

    private Link composeLink(Map<ProviderId, LinkDescription> descs) {
        ProviderId primary = this.getBaseProviderId(descs);
        LinkDescription base = descs.get(Verify.verifyNotNull((Object)primary));
        ConnectPoint src = base.src();
        ConnectPoint dst = base.dst();
        Link.Type type = base.type();
        DefaultAnnotations annotations = DefaultAnnotations.builder().build();
        annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)base.annotations());
        for (Map.Entry<ProviderId, LinkDescription> e : descs.entrySet()) {
            if (primary.equals((Object)e.getKey())) continue;
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)e.getValue().annotations());
        }
        boolean isDurable = Objects.equals(annotations.value("durable"), "true");
        return new DefaultLink(primary, src, dst, type, Link.State.ACTIVE, isDurable, new Annotations[]{annotations});
    }

    private Map<ProviderId, LinkDescription> getOrCreateLinkDescriptions(LinkKey key) {
        HashMap<ProviderId, LinkDescription> r = (HashMap<ProviderId, LinkDescription>)this.linkDescs.get(key);
        if (r != null) {
            return r;
        }
        r = new HashMap<ProviderId, LinkDescription>();
        Map concurrentlyAdded = this.linkDescs.putIfAbsent(key, r);
        if (concurrentlyAdded == null) {
            return r;
        }
        return concurrentlyAdded;
    }

    private Function<LinkKey, Link> lookupLink() {
        return this.lookupLink;
    }

    private final class LookupLink
    implements Function<LinkKey, Link> {
        private LookupLink() {
        }

        public Link apply(LinkKey input) {
            if (input == null) {
                return null;
            }
            return (Link)SimpleLinkStore.this.links.get(input);
        }
    }
}

