/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.joda.time.DateTime;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipStore;
import org.onosproject.mastership.MastershipStoreDelegate;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.AbstractStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleMastershipStore
extends AbstractStore<MastershipEvent, MastershipStoreDelegate>
implements MastershipStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int NOTHING = 0;
    private static final int INIT = 1;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    protected final Map<DeviceId, NodeId> masterMap = new HashMap<DeviceId, NodeId>();
    protected final Map<DeviceId, List<NodeId>> backups = new HashMap<DeviceId, List<NodeId>>();
    protected final Map<DeviceId, AtomicInteger> termMap = new HashMap<DeviceId, AtomicInteger>();

    @Activate
    public void activate() {
        if (this.clusterService == null) {
            DefaultControllerNode instance = new DefaultControllerNode(new NodeId("local"), IpAddress.valueOf((String)"127.0.0.1"));
            this.clusterService = new ClusterService((ControllerNode)instance){
                private final DateTime creationTime = DateTime.now();
                final /* synthetic */ ControllerNode val$instance;
                {
                    this.val$instance = controllerNode;
                }

                public ControllerNode getLocalNode() {
                    return this.val$instance;
                }

                public Set<ControllerNode> getNodes() {
                    return ImmutableSet.of((Object)this.val$instance);
                }

                public ControllerNode getNode(NodeId nodeId) {
                    if (this.val$instance.id().equals((Object)nodeId)) {
                        return this.val$instance;
                    }
                    return null;
                }

                public ControllerNode.State getState(NodeId nodeId) {
                    if (this.val$instance.id().equals((Object)nodeId)) {
                        return ControllerNode.State.ACTIVE;
                    }
                    return ControllerNode.State.INACTIVE;
                }

                public DateTime getLastUpdated(NodeId nodeId) {
                    return this.creationTime;
                }

                public void addListener(ClusterEventListener listener) {
                }

                public void removeListener(ClusterEventListener listener) {
                }
            };
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public synchronized CompletableFuture<MastershipEvent> setMaster(NodeId nodeId, DeviceId deviceId) {
        MastershipRole role = this.getRole(nodeId, deviceId);
        switch (role) {
            case MASTER: {
                return CompletableFuture.completedFuture(null);
            }
            case STANDBY: 
            case NONE: {
                NodeId prevMaster = this.masterMap.put(deviceId, nodeId);
                this.incrementTerm(deviceId);
                this.removeFromBackups(deviceId, nodeId);
                this.addToBackup(deviceId, prevMaster);
                break;
            }
            default: {
                this.log.warn("unknown Mastership Role {}", (Object)role);
                return null;
            }
        }
        return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)));
    }

    public NodeId getMaster(DeviceId deviceId) {
        return this.masterMap.get(deviceId);
    }

    public synchronized RoleInfo getNodes(DeviceId deviceId) {
        return new RoleInfo(this.masterMap.get(deviceId), this.backups.getOrDefault(deviceId, (List<NodeId>)ImmutableList.of()));
    }

    public Set<DeviceId> getDevices(NodeId nodeId) {
        HashSet<DeviceId> ids = new HashSet<DeviceId>();
        for (Map.Entry<DeviceId, NodeId> d : this.masterMap.entrySet()) {
            if (!Objects.equals(d.getValue(), nodeId)) continue;
            ids.add(d.getKey());
        }
        return ids;
    }

    public synchronized CompletableFuture<MastershipRole> requestRole(DeviceId deviceId) {
        NodeId node = this.clusterService.getLocalNode().id();
        MastershipRole role = this.getRole(node, deviceId);
        switch (role) {
            case MASTER: {
                return CompletableFuture.completedFuture(MastershipRole.MASTER);
            }
            case STANDBY: {
                if (this.getMaster(deviceId) == null) {
                    this.masterMap.put(deviceId, node);
                    this.incrementTerm(deviceId);
                    this.removeFromBackups(deviceId, node);
                    this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)));
                    return CompletableFuture.completedFuture(MastershipRole.MASTER);
                }
                return CompletableFuture.completedFuture(MastershipRole.STANDBY);
            }
            case NONE: {
                if (this.getMaster(deviceId) == null) {
                    this.masterMap.put(deviceId, node);
                    this.incrementTerm(deviceId);
                    this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)));
                    return CompletableFuture.completedFuture(MastershipRole.MASTER);
                }
                if (this.addToBackup(deviceId, node)) {
                    this.notifyDelegate((Event)new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, this.getNodes(deviceId)));
                }
                return CompletableFuture.completedFuture(MastershipRole.STANDBY);
            }
        }
        this.log.warn("unknown Mastership Role {}", (Object)role);
        return CompletableFuture.completedFuture(role);
    }

    private synchronized boolean addToBackup(DeviceId deviceId, NodeId nodeId) {
        boolean modified = false;
        List stbys = this.backups.getOrDefault(deviceId, new ArrayList());
        if (nodeId != null && !stbys.contains(nodeId)) {
            stbys.add(nodeId);
            modified = true;
        }
        this.backups.put(deviceId, stbys);
        return modified;
    }

    private synchronized boolean removeFromBackups(DeviceId deviceId, NodeId node) {
        List stbys = this.backups.getOrDefault(deviceId, new ArrayList());
        boolean modified = stbys.remove(node);
        this.backups.put(deviceId, stbys);
        return modified;
    }

    private synchronized void incrementTerm(DeviceId deviceId) {
        AtomicInteger term = this.termMap.getOrDefault(deviceId, new AtomicInteger(0));
        term.incrementAndGet();
        this.termMap.put(deviceId, term);
    }

    public MastershipRole getRole(NodeId nodeId, DeviceId deviceId) {
        NodeId current = this.masterMap.get(deviceId);
        if (current != null && current.equals((Object)nodeId)) {
            return MastershipRole.MASTER;
        }
        MastershipRole role = this.backups.getOrDefault(deviceId, Collections.emptyList()).contains(nodeId) ? MastershipRole.STANDBY : MastershipRole.NONE;
        return role;
    }

    public synchronized MastershipTerm getTermFor(DeviceId deviceId) {
        if (this.termMap.get(deviceId) == null) {
            return MastershipTerm.of((NodeId)this.masterMap.get(deviceId), (long)0L);
        }
        return MastershipTerm.of((NodeId)this.masterMap.get(deviceId), (long)this.termMap.get(deviceId).get());
    }

    public synchronized CompletableFuture<MastershipEvent> setStandby(NodeId nodeId, DeviceId deviceId) {
        MastershipRole role = this.getRole(nodeId, deviceId);
        switch (role) {
            case MASTER: {
                NodeId backup = this.reelect(deviceId, nodeId);
                if (backup == null) {
                    this.masterMap.remove(deviceId);
                    return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)));
                }
                NodeId prevMaster = this.masterMap.put(deviceId, backup);
                this.incrementTerm(deviceId);
                this.addToBackup(deviceId, prevMaster);
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)));
            }
            case STANDBY: 
            case NONE: {
                boolean modified = this.addToBackup(deviceId, nodeId);
                if (!modified) break;
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, this.getNodes(deviceId)));
            }
            default: {
                this.log.warn("unknown Mastership Role {}", (Object)role);
            }
        }
        return null;
    }

    private synchronized NodeId reelect(DeviceId did, NodeId nodeId) {
        List stbys = this.backups.getOrDefault(did, Collections.emptyList());
        NodeId backup = null;
        for (NodeId n : stbys) {
            if (n.equals((Object)nodeId)) continue;
            backup = n;
            break;
        }
        stbys.remove(backup);
        return backup;
    }

    public synchronized CompletableFuture<MastershipEvent> relinquishRole(NodeId nodeId, DeviceId deviceId) {
        MastershipRole role = this.getRole(nodeId, deviceId);
        switch (role) {
            case MASTER: {
                NodeId backup = this.reelect(deviceId, nodeId);
                this.masterMap.put(deviceId, backup);
                this.incrementTerm(deviceId);
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.MASTER_CHANGED, deviceId, this.getNodes(deviceId)));
            }
            case STANDBY: {
                if (!this.removeFromBackups(deviceId, nodeId)) break;
                return CompletableFuture.completedFuture(new MastershipEvent(MastershipEvent.Type.BACKUPS_CHANGED, deviceId, this.getNodes(deviceId)));
            }
            case NONE: {
                break;
            }
            default: {
                this.log.warn("unknown Mastership Role {}", (Object)role);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public synchronized void relinquishAllRole(NodeId nodeId) {
        ArrayList eventFutures = new ArrayList();
        HashSet toRelinquish = new HashSet();
        this.masterMap.entrySet().stream().filter(entry -> nodeId.equals(entry.getValue())).forEach(entry -> toRelinquish.add(entry.getKey()));
        this.backups.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(nodeId)).forEach(entry -> toRelinquish.add(entry.getKey()));
        toRelinquish.forEach(deviceId -> eventFutures.add(this.relinquishRole(nodeId, (DeviceId)deviceId)));
        eventFutures.forEach(future -> future.whenComplete((event, error) -> this.notifyDelegate((Event)event)));
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }
}

