/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.statistic.StatisticStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleStatisticStore
implements StatisticStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<ConnectPoint, InternalStatisticRepresentation> representations = new ConcurrentHashMap<ConnectPoint, InternalStatisticRepresentation>();
    private Map<ConnectPoint, Set<FlowEntry>> previous = new ConcurrentHashMap<ConnectPoint, Set<FlowEntry>>();
    private Map<ConnectPoint, Set<FlowEntry>> current = new ConcurrentHashMap<ConnectPoint, Set<FlowEntry>>();

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForStatistics(FlowRule rule) {
        InternalStatisticRepresentation rep;
        ConnectPoint cp = this.buildConnectPoint(rule);
        if (cp == null) {
            return;
        }
        Map<ConnectPoint, InternalStatisticRepresentation> map = this.representations;
        synchronized (map) {
            rep = this.getOrCreateRepresentation(cp);
        }
        rep.prepare();
    }

    public synchronized void removeFromStatistics(FlowRule rule) {
        Set<FlowEntry> values;
        ConnectPoint cp = this.buildConnectPoint(rule);
        if (cp == null) {
            return;
        }
        InternalStatisticRepresentation rep = this.representations.get(cp);
        if (rep != null && rep.remove(rule)) {
            this.updatePublishedStats(cp, Collections.emptySet());
        }
        if ((values = this.current.get(cp)) != null) {
            values.remove(rule);
        }
        if ((values = this.previous.get(cp)) != null) {
            values.remove(rule);
        }
    }

    public void addOrUpdateStatistic(FlowEntry rule) {
        ConnectPoint cp = this.buildConnectPoint((FlowRule)rule);
        if (cp == null) {
            return;
        }
        InternalStatisticRepresentation rep = this.representations.get(cp);
        if (rep != null && rep.submit(rule)) {
            this.updatePublishedStats(cp, rep.get());
        }
    }

    private synchronized void updatePublishedStats(ConnectPoint cp, Set<FlowEntry> flowEntries) {
        Set<FlowEntry> curr = this.current.get(cp);
        if (curr == null) {
            curr = new HashSet<FlowEntry>();
        }
        this.previous.put(cp, curr);
        this.current.put(cp, flowEntries);
    }

    public Set<FlowEntry> getCurrentStatistic(ConnectPoint connectPoint) {
        return this.getCurrentStatisticInternal(connectPoint);
    }

    private synchronized Set<FlowEntry> getCurrentStatisticInternal(ConnectPoint connectPoint) {
        return this.current.get(connectPoint);
    }

    public Set<FlowEntry> getPreviousStatistic(ConnectPoint connectPoint) {
        return this.getPreviousStatisticInternal(connectPoint);
    }

    private synchronized Set<FlowEntry> getPreviousStatisticInternal(ConnectPoint connectPoint) {
        return this.previous.get(connectPoint);
    }

    private InternalStatisticRepresentation getOrCreateRepresentation(ConnectPoint cp) {
        if (this.representations.containsKey(cp)) {
            return this.representations.get(cp);
        }
        InternalStatisticRepresentation rep = new InternalStatisticRepresentation();
        this.representations.put(cp, rep);
        return rep;
    }

    private ConnectPoint buildConnectPoint(FlowRule rule) {
        PortNumber port = this.getOutput(rule);
        if (port == null) {
            return null;
        }
        ConnectPoint cp = new ConnectPoint((ElementId)rule.deviceId(), port);
        return cp;
    }

    private PortNumber getOutput(FlowRule rule) {
        for (Instruction i : rule.treatment().immediate()) {
            if (i.type() == Instruction.Type.OUTPUT) {
                Instructions.OutputInstruction out = (Instructions.OutputInstruction)i;
                return out.port();
            }
            if (i.type() != Instruction.Type.DROP) continue;
            return PortNumber.P0;
        }
        return null;
    }

    private class InternalStatisticRepresentation {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final Set<FlowEntry> rules = new HashSet<FlowEntry>();

        private InternalStatisticRepresentation() {
        }

        public void prepare() {
            this.counter.incrementAndGet();
        }

        public synchronized boolean remove(FlowRule rule) {
            this.rules.remove(rule);
            return this.counter.decrementAndGet() == 0;
        }

        public synchronized boolean submit(FlowEntry rule) {
            if (this.rules.contains(rule)) {
                this.rules.remove(rule);
            }
            this.rules.add(rule);
            if (this.counter.get() == 0) {
                return true;
            }
            return this.counter.decrementAndGet() == 0;
        }

        public synchronized Set<FlowEntry> get() {
            this.counter.set(this.rules.size());
            return Sets.newHashSet(this.rules);
        }
    }
}

