/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.Event;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyStore;
import org.onosproject.net.topology.TopologyStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.trivial.impl.DefaultTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SimpleTopologyStore
extends AbstractStore<TopologyEvent, TopologyStoreDelegate>
implements TopologyStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile DefaultTopology current;

    @Activate
    public void activate() {
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Topology currentTopology() {
        return this.current;
    }

    public boolean isLatest(Topology topology) {
        return topology == this.current;
    }

    public TopologyGraph getGraph(Topology topology) {
        return this.defaultTopology(topology).getGraph();
    }

    public Set<TopologyCluster> getClusters(Topology topology) {
        return this.defaultTopology(topology).getClusters();
    }

    public TopologyCluster getCluster(Topology topology, ClusterId clusterId) {
        return this.defaultTopology(topology).getCluster(clusterId);
    }

    public Set<DeviceId> getClusterDevices(Topology topology, TopologyCluster cluster) {
        return this.defaultTopology(topology).getClusterDevices(cluster);
    }

    public Set<Link> getClusterLinks(Topology topology, TopologyCluster cluster) {
        return this.defaultTopology(topology).getClusterLinks(cluster);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst) {
        return this.defaultTopology(topology).getPaths(src, dst);
    }

    public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
        return this.defaultTopology(topology).getPaths(src, dst, weight);
    }

    public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
        return this.defaultTopology(topology).isInfrastructure(connectPoint);
    }

    public boolean isBroadcastPoint(Topology topology, ConnectPoint connectPoint) {
        return this.defaultTopology(topology).isBroadcastPoint(connectPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyEvent updateTopology(ProviderId providerId, GraphDescription graphDescription, List<Event> reasons) {
        if (this.current != null && graphDescription.timestamp() < this.current.time()) {
            return null;
        }
        DefaultTopology newTopology = new DefaultTopology(providerId, graphDescription);
        SimpleTopologyStore simpleTopologyStore = this;
        synchronized (simpleTopologyStore) {
            this.current = newTopology;
            return new TopologyEvent(TopologyEvent.Type.TOPOLOGY_CHANGED, (Topology)this.current, reasons);
        }
    }

    private DefaultTopology defaultTopology(Topology topology) {
        if (topology instanceof DefaultTopology) {
            return (DefaultTopology)topology;
        }
        throw new IllegalArgumentException("Topology class " + topology.getClass() + " not supported");
    }
}

