/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import org.onosproject.store.Timestamp;

public class SystemClockTimestamp
implements Timestamp {
    private final long nanoTimestamp;

    public SystemClockTimestamp() {
        this.nanoTimestamp = System.nanoTime();
    }

    public SystemClockTimestamp(long timestamp) {
        this.nanoTimestamp = timestamp;
    }

    public int compareTo(Timestamp o) {
        Preconditions.checkArgument((boolean)(o instanceof SystemClockTimestamp), (String)"Must be SystemClockTimestamp", (Object[])new Object[]{o});
        SystemClockTimestamp that = (SystemClockTimestamp)o;
        return ComparisonChain.start().compare(this.nanoTimestamp, that.nanoTimestamp).result();
    }

    public int hashCode() {
        return Objects.hash(this.nanoTimestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SystemClockTimestamp)) {
            return false;
        }
        SystemClockTimestamp that = (SystemClockTimestamp)obj;
        return Objects.equals(this.nanoTimestamp, that.nanoTimestamp);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("nanoTimestamp", this.nanoTimestamp).toString();
    }

    public long nanoTimestamp() {
        return this.nanoTimestamp;
    }

    public long systemTimestamp() {
        return this.nanoTimestamp / 1000000L;
    }
}

