/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.bti;

import com.btisystems.mibbler.mibs.bti7000.bti7000_13_2_0.I_Device;
import com.btisystems.mibbler.mibs.bti7000.bti7000_13_2_0._OidRegistry;
import com.btisystems.mibbler.mibs.bti7000.bti7000_13_2_0.btisystems.btiproducts.bti7000.objects.conditions.ActAlarmTable;
import com.btisystems.mibbler.mibs.bti7000.interfaces.btisystems.btiproducts.bti7000.objects.conditions.IActAlarmTable;
import com.btisystems.pronx.ems.core.model.ClassRegistry;
import com.btisystems.pronx.ems.core.model.IClassRegistry;
import com.btisystems.pronx.ems.core.model.NetworkDevice;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmConsumer;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.snmp.SnmpController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public class Bti7000SnmpAlarmConsumer
extends AbstractHandlerBehaviour
implements AlarmConsumer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final IClassRegistry CLASS_REGISTRY = new ClassRegistry(_OidRegistry.oidRegistry, I_Device.class);
    static final int ALARM_SEVERITY_MINOR = 2;
    static final int ALARM_SEVERITY_MAJOR = 3;
    static final int ALARM_SEVERITY_CRITICAL = 4;

    private Alarm.SeverityLevel mapAlarmSeverity(int intAlarmSeverity) {
        Alarm.SeverityLevel mappedSeverity;
        switch (intAlarmSeverity) {
            case 2: {
                mappedSeverity = Alarm.SeverityLevel.MINOR;
                break;
            }
            case 3: {
                mappedSeverity = Alarm.SeverityLevel.MAJOR;
                break;
            }
            case 4: {
                mappedSeverity = Alarm.SeverityLevel.CRITICAL;
                break;
            }
            default: {
                mappedSeverity = Alarm.SeverityLevel.MINOR;
                this.log.warn("Unexpected alarm severity: {}", (Object)intAlarmSeverity);
            }
        }
        return mappedSeverity;
    }

    public static Date getLocalDateAndTime(String actAlarmDateAndTime, String sysInfoTimeZone, String swVersion) {
        if (StringUtils.isBlank((String)actAlarmDateAndTime)) {
            return null;
        }
        GregorianCalendar decodedDateAndTimeCal = Bti7000SnmpAlarmConsumer.btiMakeCalendar(OctetString.fromHexString((String)actAlarmDateAndTime));
        if (sysInfoTimeZone == null || swVersion == null) {
            return decodedDateAndTimeCal.getTime();
        }
        TimeZone javaTimeZone = Bti7000SnmpAlarmConsumer.getTimeZone();
        decodedDateAndTimeCal.setTimeZone(javaTimeZone);
        GregorianCalendar localTime = new GregorianCalendar();
        localTime.setTimeInMillis(decodedDateAndTimeCal.getTimeInMillis());
        return localTime.getTime();
    }

    public static GregorianCalendar btiMakeCalendar(OctetString dateAndTimeValue) {
        int year = (dateAndTimeValue.get(0) & 0xFF) * 256 + (dateAndTimeValue.get(1) & 0xFF);
        int month = dateAndTimeValue.get(2) & 0xFF;
        int date = dateAndTimeValue.get(3) & 0xFF;
        int hour = dateAndTimeValue.get(4) & 0xFF;
        int minute = dateAndTimeValue.get(5) & 0xFF;
        int second = dateAndTimeValue.get(6) & 0xFF;
        int deci = dateAndTimeValue.get(7) & 0xFF;
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, date, hour, minute, second);
        gc.set(14, deci * 100);
        if (dateAndTimeValue.length() == 11) {
            char directionOfOffset = (char)dateAndTimeValue.get(8);
            byte hoursOffset = directionOfOffset == '+' ? dateAndTimeValue.get(9) : -dateAndTimeValue.get(9);
            DateTimeZone offset = DateTimeZone.forOffsetHoursMinutes((int)hoursOffset, (int)dateAndTimeValue.get(10));
            DateTime dt = new DateTime(year, month, date, hour, minute, second, offset);
            return dt.toGregorianCalendar();
        }
        return gc;
    }

    private static TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public List<Alarm> consumeAlarms() {
        SnmpController controller = (SnmpController)Preconditions.checkNotNull((Object)this.handler().get(SnmpController.class));
        ArrayList<DefaultAlarm> alarms = new ArrayList<DefaultAlarm>();
        DeviceId deviceId = this.handler().data().deviceId();
        try {
            ISnmpSession session = controller.getSession(deviceId);
            this.log.debug("Getting alarms for BTI 7000 device at {}", (Object)deviceId);
            NetworkDevice networkDevice = new NetworkDevice(CLASS_REGISTRY, session.getAddress().getHostAddress());
            session.walkDevice((IVariableBindingHandler)networkDevice, Collections.singletonList(CLASS_REGISTRY.getClassToOidMap().get(ActAlarmTable.class)));
            IActAlarmTable deviceAlarms = (IActAlarmTable)networkDevice.getRootObject().getEntity((OID)CLASS_REGISTRY.getClassToOidMap().get(ActAlarmTable.class));
            if (deviceAlarms != null && deviceAlarms.getActAlarmEntry() != null && !deviceAlarms.getActAlarmEntry().isEmpty()) {
                deviceAlarms.getActAlarmEntry().values().stream().forEach(alarm -> {
                    DefaultAlarm.Builder alarmBuilder = new DefaultAlarm.Builder(deviceId, alarm.getActAlarmDescription(), this.mapAlarmSeverity(alarm.getActAlarmSeverity()), Bti7000SnmpAlarmConsumer.getLocalDateAndTime(alarm.getActAlarmDateAndTime(), null, null).getTime()).forSource(AlarmEntityId.alarmEntityId((String)("other:" + alarm.getActAlarmInstanceIdx())));
                    alarms.add(alarmBuilder.build());
                });
            }
            this.log.debug("Conditions retrieved: {}", (Object)deviceAlarms);
        }
        catch (IOException ex) {
            this.log.error("Error reading alarms for device {}.", (Object)deviceId, (Object)ex);
            alarms.add(controller.buildWalkFailedAlarm(deviceId));
        }
        return ImmutableList.copyOf(alarms);
    }
}

