/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.bti;

import com.btisystems.mibbler.mibs.netsnmp.netsnmp.I_Device;
import com.btisystems.mibbler.mibs.netsnmp.netsnmp._OidRegistry;
import com.btisystems.mibbler.mibs.netsnmp.netsnmp.mib_2.interfaces.IfTable;
import com.btisystems.pronx.ems.core.model.ClassRegistry;
import com.btisystems.pronx.ems.core.model.IClassRegistry;
import com.btisystems.pronx.ems.core.model.NetworkDevice;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmConsumer;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.snmp.SnmpController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;

public class NetSnmpAlarmConsumer
extends AbstractHandlerBehaviour
implements AlarmConsumer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final IClassRegistry CLASS_REGISTRY = new ClassRegistry(_OidRegistry.oidRegistry, I_Device.class);

    public List<Alarm> consumeAlarms() {
        SnmpController controller = (SnmpController)Preconditions.checkNotNull((Object)this.handler().get(SnmpController.class));
        ArrayList<DefaultAlarm> alarms = new ArrayList<DefaultAlarm>();
        DeviceId deviceId = this.handler().data().deviceId();
        try {
            ISnmpSession session = controller.getSession(deviceId);
            NetworkDevice networkDevice = new NetworkDevice(CLASS_REGISTRY, session.getAddress().getHostAddress());
            session.walkDevice((IVariableBindingHandler)networkDevice, Collections.singletonList(CLASS_REGISTRY.getClassToOidMap().get(IfTable.class)));
            IfTable interfaceTable = (IfTable)networkDevice.getRootObject().getEntity((OID)CLASS_REGISTRY.getClassToOidMap().get(IfTable.class));
            if (interfaceTable != null) {
                interfaceTable.getEntries().values().stream().forEach(ifEntry -> {
                    if (ifEntry.getIfAdminStatus() == 1 && ifEntry.getIfOperStatus() == 2) {
                        alarms.add(new DefaultAlarm.Builder(deviceId, "Link Down.", Alarm.SeverityLevel.CRITICAL, System.currentTimeMillis()).forSource(AlarmEntityId.alarmEntityId((String)("port:" + ifEntry.getIfDescr()))).build());
                    }
                    this.log.debug("Interface: " + ifEntry);
                });
            }
        }
        catch (IOException ex) {
            this.log.error("Error reading alarms for device {}.", (Object)deviceId, (Object)ex);
            alarms.add(controller.buildWalkFailedAlarm(deviceId));
        }
        return ImmutableList.copyOf(alarms);
    }
}

