/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.bti;

import com.btisystems.mibbler.mibs.netsnmp.netsnmp.I_Device;
import com.btisystems.mibbler.mibs.netsnmp.netsnmp._OidRegistry;
import com.btisystems.mibbler.mibs.netsnmp.netsnmp.mib_2.System;
import com.btisystems.pronx.ems.core.model.ClassRegistry;
import com.btisystems.pronx.ems.core.model.IClassRegistry;
import com.btisystems.pronx.ems.core.model.NetworkDevice;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import com.btisystems.pronx.ems.core.snmp.V2cSnmpConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.snmp.SnmpController;
import org.onosproject.snmp.SnmpDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.smi.OID;

public class NetSnmpDeviceDescriptor
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final IClassRegistry CLASS_REGISTRY = new ClassRegistry(_OidRegistry.oidRegistry, I_Device.class);
    private static final String UNKNOWN = "unknown";

    public DeviceDescription discoverDeviceDetails() {
        SnmpController controller = (SnmpController)Preconditions.checkNotNull((Object)this.handler().get(SnmpController.class));
        DeviceId deviceId = this.handler().data().deviceId();
        SnmpDevice snmpDevice = controller.getDevice(deviceId);
        DeviceService deviceService = (DeviceService)Preconditions.checkNotNull((Object)this.handler().get(DeviceService.class));
        Device device = deviceService.getDevice(deviceId);
        DeviceDescription desc = null;
        String ipAddress = snmpDevice.getSnmpHost();
        int port = snmpDevice.getSnmpPort();
        V2cSnmpConfiguration config = new V2cSnmpConfiguration();
        config.setPort(port);
        try (ISnmpSession session = controller.getSession(deviceId);){
            String deviceOid = session.identifyDevice();
            desc = this.populateDescription(session, device);
        }
        catch (IOException | RuntimeException ex) {
            this.log.error("Failed to walk device.", (Object)ex.getMessage());
            this.log.debug("Detailed problem was ", (Throwable)ex);
        }
        return desc;
    }

    public List<PortDescription> discoverPortDetails() {
        return ImmutableList.of();
    }

    private DeviceDescription populateDescription(ISnmpSession session, Device device) {
        NetworkDevice networkDevice = new NetworkDevice(CLASS_REGISTRY, session.getAddress().getHostAddress());
        try {
            session.walkDevice((IVariableBindingHandler)networkDevice, Collections.singletonList(CLASS_REGISTRY.getClassToOidMap().get(System.class)));
            System systemTree = (System)networkDevice.getRootObject().getEntity((OID)CLASS_REGISTRY.getClassToOidMap().get(System.class));
            if (systemTree != null) {
                String manufacturer = StringUtils.abbreviate((String)systemTree.getSysContact(), (int)20);
                return new DefaultDeviceDescription(device.id().uri(), device.type(), manufacturer, UNKNOWN, UNKNOWN, UNKNOWN, device.chassisId(), new SparseAnnotations[]{(SparseAnnotations)device.annotations()});
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error reading details for device." + session.getAddress(), ex);
        }
        return null;
    }
}

