/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.cisco;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.drivers.cisco.TextBlockParserCisco;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.provider.ProviderId;

public class TextBlockParserCiscoTest {
    private static final PortNumber INTF1_PORT = PortNumber.portNumber((long)0L);
    private static final String INTF1_NAME = "FastEthernet0/0";
    private static final PortNumber INTF2_PORT = PortNumber.portNumber((long)0L);
    private static final String INTF2_NAME = "Ethernet1/0";
    private static final PortNumber INTF3_PORT = PortNumber.portNumber((long)0L);
    private static final String INTF3_NAME = "GigabitEthernet2/0";
    private static final PortNumber INTF4_PORT = PortNumber.portNumber((long)0L);
    private static final String INTF4_NAME = "Serial3/0";
    private static final PortNumber INTF5_PORT = PortNumber.portNumber((long)0L);
    private static final String INTF5_NAME = "POS4/0";
    private static final PortNumber INTF6_PORT = PortNumber.portNumber((long)0L);
    private static final String INTF6_NAME = "Fddi5/0";
    private static final Port.Type COPPER = Port.Type.COPPER;
    private static final Port.Type FIBER = Port.Type.FIBER;
    private static final long CONNECTION_SPEED_ETHERNET = 100000L;
    private static final long CONNECTION_SPEED_SERIAL = 1544L;
    private static final long CONNECTION_SPEED_POS = 9952000L;
    private static final long CONNECTION_SPEED_FDDI = 100000L;
    private static final boolean IS_ENABLED = true;
    private static final boolean IS_NOT_ENABLED = false;
    private static final String SHOW_VERSION = "/testShowVersion.xml";
    private static final String SHOW_INTFS = "/testShowInterfaces.xml";
    private static final String SW = "IOS C3560E 15.0(2)EJ";
    private static final String HW = "SM-X-ES3-24-P";
    private static final String MFR = "Cisco";
    private static final String SN = "FOC18401Z3R";
    private static final ProviderId PROVIDERID = new ProviderId("of", "foo");
    private static final DeviceId DEVICE = DeviceId.deviceId((String)"of:foo");
    private static final ChassisId CID = new ChassisId();

    @Test
    public void controllersVersion() {
        InputStream streamOrig = this.getClass().getResourceAsStream(SHOW_VERSION);
        String version = new Scanner(streamOrig, "UTF-8").useDelimiter("\\Z").next();
        version = version.substring(version.indexOf(10) + 1);
        String[] actualDetails = TextBlockParserCisco.parseCiscoIosDeviceDetails((String)version);
        Assert.assertEquals((String)"Information could not be retrieved", (Object)this.getExpectedInfo(), (Object)this.actualInfo(actualDetails));
    }

    @Test
    public void controllersIntfs() {
        InputStream streamOrig = this.getClass().getResourceAsStream(SHOW_INTFS);
        String rpcReply = new Scanner(streamOrig, "UTF-8").useDelimiter("\\Z").next();
        List actualIntfs = TextBlockParserCisco.parseCiscoIosPorts((String)rpcReply);
        Assert.assertEquals((String)"Information could not be retrieved", this.getExpectedIntfs(), (Object)actualIntfs);
    }

    private DefaultDevice getExpectedInfo() {
        return new DefaultDevice(PROVIDERID, DEVICE, Device.Type.SWITCH, MFR, HW, SW, SN, CID, new Annotations[0]);
    }

    private DefaultDevice actualInfo(String[] actualDetails) {
        return new DefaultDevice(PROVIDERID, DEVICE, Device.Type.SWITCH, actualDetails[0], actualDetails[1], actualDetails[2], actualDetails[3], CID, new Annotations[0]);
    }

    private List<PortDescription> getExpectedIntfs() {
        DefaultAnnotations.Builder int1Annotations = DefaultAnnotations.builder().set("portName", INTF1_NAME);
        DefaultAnnotations.Builder int2Annotations = DefaultAnnotations.builder().set("portName", INTF2_NAME);
        DefaultAnnotations.Builder int3Annotations = DefaultAnnotations.builder().set("portName", INTF3_NAME);
        DefaultAnnotations.Builder int4Annotations = DefaultAnnotations.builder().set("portName", INTF4_NAME);
        DefaultAnnotations.Builder int5Annotations = DefaultAnnotations.builder().set("portName", INTF5_NAME);
        DefaultAnnotations.Builder int6Annotations = DefaultAnnotations.builder().set("portName", INTF6_NAME);
        ArrayList<PortDescription> intfs = new ArrayList<PortDescription>();
        intfs.add((PortDescription)new DefaultPortDescription(INTF1_PORT, true, COPPER, 100000L, new SparseAnnotations[]{int1Annotations.build()}));
        intfs.add((PortDescription)new DefaultPortDescription(INTF2_PORT, false, COPPER, 100000L, new SparseAnnotations[]{int2Annotations.build()}));
        intfs.add((PortDescription)new DefaultPortDescription(INTF3_PORT, false, COPPER, 100000L, new SparseAnnotations[]{int3Annotations.build()}));
        intfs.add((PortDescription)new DefaultPortDescription(INTF4_PORT, true, COPPER, 1544L, new SparseAnnotations[]{int4Annotations.build()}));
        intfs.add((PortDescription)new DefaultPortDescription(INTF5_PORT, true, FIBER, 9952000L, new SparseAnnotations[]{int5Annotations.build()}));
        intfs.add((PortDescription)new DefaultPortDescription(INTF6_PORT, true, FIBER, 100000L, new SparseAnnotations[]{int6Annotations.build()}));
        return intfs;
    }
}

