/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.cisco;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.onosproject.drivers.cisco.TextBlockParserCisco;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiscoIosDeviceDescription
extends AbstractHandlerBehaviour
implements DeviceDescriptionDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String version;
    private String interfaces;

    public DeviceDescription discoverDeviceDetails() {
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            this.version = session.get(this.showVersionRequestBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new NetconfException("Failed to retrieve version info.", (Throwable)e));
        }
        String[] details = TextBlockParserCisco.parseCiscoIosDeviceDetails(this.version);
        DeviceService deviceService = (DeviceService)Preconditions.checkNotNull((Object)this.handler().get(DeviceService.class));
        DeviceId deviceId = this.handler().data().deviceId();
        Device device = deviceService.getDevice(deviceId);
        return new DefaultDeviceDescription(device.id().uri(), Device.Type.SWITCH, details[0], details[1], details[2], details[3], device.chassisId(), new SparseAnnotations[0]);
    }

    public List<PortDescription> discoverPortDetails() {
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            this.interfaces = session.get(this.showInterfacesRequestBuilder());
        }
        catch (IOException e) {
            this.log.error("Failed to retrieve Interfaces");
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(TextBlockParserCisco.parseCiscoIosPorts(this.interfaces));
    }

    private String showVersionRequestBuilder() {
        StringBuilder rpc = new StringBuilder("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        rpc.append("<get>");
        rpc.append("<filter>");
        rpc.append("<config-format-text-block>");
        rpc.append("<text-filter-spec> | include exp_to_match_run_conf </text-filter-spec>");
        rpc.append("</config-format-text-block>");
        rpc.append("<oper-data-format-text-block>");
        rpc.append("<show>version</show>");
        rpc.append("</oper-data-format-text-block>");
        rpc.append("</filter>");
        rpc.append("</get>");
        rpc.append("</rpc>]]>]]>");
        return rpc.toString();
    }

    private String showInterfacesRequestBuilder() {
        StringBuilder rpc = new StringBuilder("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        rpc.append("<get>");
        rpc.append("<filter>");
        rpc.append("<config-format-text-block>");
        rpc.append("<text-filter-spec> | include exp_to_match_run_conf </text-filter-spec>");
        rpc.append("</config-format-text-block>");
        rpc.append("<oper-data-format-text-block>");
        rpc.append("<show>interfaces</show>");
        rpc.append("</oper-data-format-text-block>");
        rpc.append("</filter>");
        rpc.append("</get>");
        rpc.append("</rpc>]]>]]>");
        return rpc.toString();
    }
}

