/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.cisco;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;

final class TextBlockParserCisco {
    private static final String PHRASE = "bytes of memory.";
    private static final String VERSION = "Version ";
    private static final String EOF_VERSION1 = "Software";
    private static final String EOF_VERSION2 = "Software,";
    private static final String EOF_VERSION3 = "RELEASE";
    private static final String PROCESSOR_BOARD = "Processor board ID ";
    private static final String BANDWIDTH = "BW ";
    private static final String SPEED = " Kbit/sec";
    private static final String ETHERNET = "Eth";
    private static final String FASTETHERNET = "Fas";
    private static final String GIGABITETHERNET = "Gig";
    private static final String FDDI = "Fdd";
    private static final String POS = "POS";
    private static final String SERIAL = "Ser";
    private static final String NEWLINE_SPLITTER = "\n";
    private static final String PORT_DELIMITER = "/";
    private static final String SPACE = " ";
    private static final String IS_UP = "is up, line protocol is up";
    private static final List INTERFACES = Arrays.asList("Eth", "Fas", "Gig", "Ser", "Fdd", "POS");
    private static final List FIBERINTERFACES = Arrays.asList("Fdd", "POS");

    private TextBlockParserCisco() {
    }

    static String[] parseCiscoIosDeviceDetails(String version) {
        String[] details = new String[]{TextBlockParserCisco.getManufacturer(version), TextBlockParserCisco.getHwVersion(version), TextBlockParserCisco.getSwVersion(version), TextBlockParserCisco.serialNumber(version)};
        return details;
    }

    private static String getManufacturer(String version) {
        String[] textStr = version.split(NEWLINE_SPLITTER);
        String[] lineStr = textStr[0].trim().split(SPACE);
        return lineStr[0];
    }

    private static String getHwVersion(String version) {
        String[] textStr = version.split(NEWLINE_SPLITTER);
        String processor = SPACE;
        for (int i = 0; i < textStr.length; ++i) {
            if (textStr[i].indexOf(PHRASE) > 0) {
                String[] lineStr = textStr[i].trim().split(SPACE);
                processor = lineStr[1];
                break;
            }
            processor = SPACE;
        }
        return processor;
    }

    private static String getSwVersion(String version) {
        int i;
        String[] textStr = version.split(NEWLINE_SPLITTER);
        for (i = 0; i < textStr.length && textStr[i].indexOf(VERSION) <= 0; ++i) {
        }
        String[] lineStr = textStr[i].trim().split(SPACE);
        StringBuilder sw = new StringBuilder();
        for (int j = 0; j < lineStr.length; ++j) {
            if (lineStr[j].equals(EOF_VERSION1) || lineStr[j].equals(EOF_VERSION2)) {
                sw.append(lineStr[j - 1]).append(SPACE);
                continue;
            }
            if (!lineStr[j].equals(EOF_VERSION3)) continue;
            sw.append(lineStr[j - 1]);
            sw.setLength(sw.length() - 1);
        }
        return sw.toString();
    }

    private static String serialNumber(String version) {
        int i;
        String[] textStr = version.split(NEWLINE_SPLITTER);
        for (i = 0; i < textStr.length && textStr[i].indexOf(PROCESSOR_BOARD) <= 0; ++i) {
        }
        return textStr[i].substring(textStr[i].indexOf(PROCESSOR_BOARD) + PROCESSOR_BOARD.length(), textStr[i].length());
    }

    public static List<PortDescription> parseCiscoIosPorts(String interfacesReply) {
        ArrayList portDesc = Lists.newArrayList();
        int interfacesCounter = TextBlockParserCisco.interfacesCounterMethod(interfacesReply);
        for (int i = 0; i < interfacesCounter; ++i) {
            String parentInterface = TextBlockParserCisco.parentInterfaceMethod(interfacesReply);
            portDesc.add(TextBlockParserCisco.findPortInfo(parentInterface));
            String[] parentArray = parentInterface.split(SPACE);
            String tempString = parentArray[0] + SPACE;
            interfacesReply = interfacesReply.replace(tempString, SPACE + tempString);
        }
        return portDesc;
    }

    private static DefaultPortDescription findPortInfo(String interfaceTree) {
        String[] textStr = interfaceTree.split(NEWLINE_SPLITTER);
        String[] firstLine = textStr[0].split(SPACE);
        String firstWord = firstLine[0];
        Port.Type type = TextBlockParserCisco.getPortType(textStr);
        boolean isEnabled = TextBlockParserCisco.getIsEnabled(textStr);
        String port = TextBlockParserCisco.getPort(textStr);
        long portSpeed = TextBlockParserCisco.getPortSpeed(textStr);
        DefaultAnnotations.Builder annotations = DefaultAnnotations.builder().set("portName", firstWord);
        return port.equals("-1") ? null : new DefaultPortDescription(PortNumber.portNumber((String)port), isEnabled, type, portSpeed, new SparseAnnotations[]{annotations.build()});
    }

    private static int interfacesCounterMethod(String interfacesReply) {
        String[] textStr = interfacesReply.split(NEWLINE_SPLITTER);
        int lastLine = textStr.length - 1;
        int counter = 0;
        for (int i = 1; i < lastLine; ++i) {
            String first3Characters = textStr[i].substring(0, 3);
            if (!INTERFACES.contains(first3Characters)) continue;
            ++counter;
        }
        return counter;
    }

    private static String parentInterfaceMethod(String interfacesReply) {
        boolean isChild = false;
        StringBuilder anInterface = new StringBuilder("");
        String[] textStr = interfacesReply.split("\\n");
        int lastLine = textStr.length - 1;
        for (int i = 1; i < lastLine; ++i) {
            String firstCharacter = textStr[i].substring(0, 1);
            String first3Characters = textStr[i].substring(0, 3);
            if (!firstCharacter.equals(SPACE) && isChild) break;
            if (firstCharacter.equals(SPACE) && isChild) {
                anInterface.append(textStr[i]).append(NEWLINE_SPLITTER);
                continue;
            }
            if (!INTERFACES.contains(first3Characters)) continue;
            isChild = true;
            anInterface.append(textStr[i]).append(NEWLINE_SPLITTER);
        }
        return anInterface.toString();
    }

    private static Port.Type getPortType(String[] textStr) {
        String first3Characters = textStr[0].substring(0, 3);
        return FIBERINTERFACES.contains(first3Characters) ? Port.Type.FIBER : Port.Type.COPPER;
    }

    private static boolean getIsEnabled(String[] textStr) {
        return textStr[0].contains(IS_UP);
    }

    private static String getPort(String[] textStr) {
        String port;
        try {
            port = textStr[0].indexOf(PORT_DELIMITER) > 0 ? textStr[0].substring(textStr[0].lastIndexOf(PORT_DELIMITER) + 1, textStr[0].indexOf(SPACE)) : "-1";
        }
        catch (RuntimeException e) {
            port = "-1";
        }
        return port;
    }

    private static long getPortSpeed(String[] textStr) {
        long portSpeed = 0L;
        int lastLine = textStr.length - 1;
        for (int i = 0; i < lastLine; ++i) {
            if (textStr[i].indexOf(BANDWIDTH) <= 0 || textStr[i].indexOf(SPEED) <= 0) continue;
            String result = textStr[i].substring(textStr[i].indexOf(BANDWIDTH) + 3, textStr[i].indexOf(SPEED));
            portSpeed = Long.valueOf(result);
            break;
        }
        return portSpeed;
    }
}

