/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.cisco;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onlab.packet.VlanId;
import org.onosproject.net.device.DefaultDeviceInterfaceDescription;
import org.onosproject.net.device.DeviceInterfaceDescription;

public final class XmlParserCisco {
    private static final String TRUNK_MODE_KEY = "ConfigIf-Configuration.switchport.mode.trunk";
    private static final String ACCESS_KEY = "ConfigIf-Configuration.switchport.access.vlan.VLANIDVLANPortAccessMode";
    private static final String TRUNK_VLAN_KEY = "ConfigIf-Configuration.switchport.trunk.allowed.vlan.VLANIDsAllowedVLANsPortTrunkingMode";
    private static final String RATE_LIMIT_KEY = "ConfigIf-Configuration.srr-queue.bandwidth.limit.EnterBandwidthLimitInterfaceAsPercentage";
    private static final short NO_LIMIT = -1;

    private XmlParserCisco() {
    }

    public static List<DeviceInterfaceDescription> getInterfacesFromConfig(HierarchicalConfiguration cfg) {
        ArrayList intfs = Lists.newArrayList();
        List subtrees = cfg.configurationsAt("data.xml-config-data.Device-Configuration.interface");
        for (HierarchicalConfiguration intfConfig : subtrees) {
            String intfName = XmlParserCisco.getInterfaceName(intfConfig);
            DeviceInterfaceDescription.Mode intfMode = XmlParserCisco.getInterfaceMode(intfConfig);
            List<VlanId> intfVlans = XmlParserCisco.getInterfaceVlans(intfConfig, intfMode);
            short intfLimit = XmlParserCisco.getInterfaceLimit(intfConfig);
            boolean intfLimited = intfLimit != -1;
            DefaultDeviceInterfaceDescription intf = new DefaultDeviceInterfaceDescription(intfName, intfMode, intfVlans, intfLimited, intfLimit);
            intfs.add(intf);
        }
        return intfs;
    }

    private static String getInterfaceName(HierarchicalConfiguration intfConfig) {
        return intfConfig.getString("Param");
    }

    private static DeviceInterfaceDescription.Mode getInterfaceMode(HierarchicalConfiguration intfConfig) {
        if (intfConfig.containsKey(TRUNK_MODE_KEY)) {
            return DeviceInterfaceDescription.Mode.TRUNK;
        }
        if (intfConfig.containsKey(ACCESS_KEY)) {
            return DeviceInterfaceDescription.Mode.ACCESS;
        }
        return DeviceInterfaceDescription.Mode.NORMAL;
    }

    private static List<VlanId> getInterfaceVlans(HierarchicalConfiguration intfConfig, DeviceInterfaceDescription.Mode mode) {
        ArrayList vlans = Lists.newArrayList();
        if (mode == DeviceInterfaceDescription.Mode.ACCESS) {
            vlans.add(XmlParserCisco.getVlanForAccess(intfConfig));
        } else if (mode == DeviceInterfaceDescription.Mode.TRUNK) {
            vlans.addAll(XmlParserCisco.getVlansForTrunk(intfConfig));
        }
        return vlans;
    }

    private static VlanId getVlanForAccess(HierarchicalConfiguration intfConfig) {
        if (intfConfig.containsKey(ACCESS_KEY)) {
            return VlanId.vlanId((String)intfConfig.getString(ACCESS_KEY));
        }
        return null;
    }

    private static List<VlanId> getVlansForTrunk(HierarchicalConfiguration intfConfig) {
        if (intfConfig.containsKey(TRUNK_VLAN_KEY)) {
            return XmlParserCisco.parseVlans(intfConfig.getStringArray(TRUNK_VLAN_KEY));
        }
        return null;
    }

    private static List<VlanId> parseVlans(String[] vlansString) {
        ArrayList vlans = Lists.newArrayList();
        List<String> items = Arrays.asList(vlansString);
        for (String item : items) {
            int index = item.indexOf("-");
            if (index == -1) {
                vlans.add(VlanId.vlanId((String)item));
                continue;
            }
            short lowerVlan = Short.parseShort(item.substring(0, index));
            short higherVlan = Short.parseShort(item.substring(index + 1));
            for (short i = lowerVlan; i <= higherVlan; i = (short)(i + 1)) {
                vlans.add(VlanId.vlanId((short)i));
            }
        }
        return vlans;
    }

    private static short getInterfaceLimit(HierarchicalConfiguration intfConfig) {
        if (intfConfig.containsKey(RATE_LIMIT_KEY)) {
            return intfConfig.getShort(RATE_LIMIT_KEY);
        }
        return -1;
    }
}

