/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.cisco;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.onlab.packet.VlanId;
import org.onosproject.drivers.cisco.XmlParserCisco;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.InterfaceConfig;
import org.onosproject.net.behaviour.PatchDescription;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.device.DeviceInterfaceDescription;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterfaceConfigCiscoIosImpl
extends AbstractHandlerBehaviour
implements InterfaceConfig {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public boolean addAccessInterface(DeviceId deviceId, String intf, VlanId vlanId) {
        return this.addAccessMode(intf, vlanId);
    }

    public boolean addAccessMode(String intf, VlanId vlanId) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.addAccessModeBuilder(intf, vlanId));
        }
        catch (NetconfException e) {
            this.log.error("Failed to configure VLAN ID {} on device {} interface {}.", new Object[]{vlanId, this.handler().data().deviceId(), intf, e});
            return false;
        }
        return XmlConfigParser.configSuccess((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String addAccessModeBuilder(String intf, VlanId vlanId) {
        StringBuilder rpc = new StringBuilder(this.getOpeningString(intf));
        rpc.append("<switchport><access><vlan><VLANIDVLANPortAccessMode>");
        rpc.append(vlanId);
        rpc.append("</VLANIDVLANPortAccessMode></vlan></access></switchport>");
        rpc.append("<switchport><mode><access/></mode></switchport>");
        rpc.append(this.getClosingString());
        return rpc.toString();
    }

    public boolean removeAccessInterface(DeviceId deviceId, String intf) {
        return this.removeAccessMode(intf);
    }

    public boolean removeAccessMode(String intf) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.removeAccessModeBuilder(intf));
        }
        catch (NetconfException e) {
            this.log.error("Failed to remove access mode from device {} interface {}.", new Object[]{this.handler().data().deviceId(), intf, e});
            return false;
        }
        return XmlConfigParser.configSuccess((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String removeAccessModeBuilder(String intf) {
        StringBuilder rpc = new StringBuilder(this.getOpeningString(intf));
        rpc.append("<switchport operation=\"delete\"><access><vlan><VLANIDVLANPortAccessMode>");
        rpc.append("</VLANIDVLANPortAccessMode></vlan></access></switchport>");
        rpc.append("<switchport operation=\"delete\"><mode><access/></mode></switchport>");
        rpc.append(this.getClosingString());
        return rpc.toString();
    }

    public boolean addTrunkInterface(DeviceId deviceId, String intf, List<VlanId> vlanIds) {
        return this.addTrunkMode(intf, vlanIds);
    }

    public boolean addTrunkMode(String intf, List<VlanId> vlanIds) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.addTrunkModeBuilder(intf, vlanIds));
        }
        catch (NetconfException e) {
            this.log.error("Failed to configure trunk mode for VLAN ID {} on device {} interface {}.", new Object[]{vlanIds, this.handler().data().deviceId(), intf, e});
            return false;
        }
        return XmlConfigParser.configSuccess((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String addTrunkModeBuilder(String intf, List<VlanId> vlanIds) {
        StringBuilder rpc = new StringBuilder(this.getOpeningString(intf));
        rpc.append("<switchport><trunk><encapsulation><dot1q/></encapsulation>");
        rpc.append("</trunk></switchport><switchport><trunk><allowed><vlan>");
        rpc.append("<VLANIDsAllowedVLANsPortTrunkingMode>");
        rpc.append(this.getVlansString(vlanIds));
        rpc.append("</VLANIDsAllowedVLANsPortTrunkingMode></vlan></allowed></trunk>");
        rpc.append("</switchport><switchport><mode><trunk/></mode></switchport>");
        rpc.append(this.getClosingString());
        return rpc.toString();
    }

    public boolean removeTrunkInterface(DeviceId deviceId, String intf) {
        return this.removeTrunkMode(intf);
    }

    public boolean removeTrunkMode(String intf) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.removeTrunkModeBuilder(intf));
        }
        catch (NetconfException e) {
            this.log.error("Failed to remove trunk mode from device {} interface {}.", new Object[]{this.handler().data().deviceId(), intf, e});
            return false;
        }
        return XmlConfigParser.configSuccess((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String removeTrunkModeBuilder(String intf) {
        StringBuilder rpc = new StringBuilder(this.getOpeningString(intf));
        rpc.append("<switchport><mode operation=\"delete\"><trunk/></mode></switchport>");
        rpc.append("<switchport><trunk operation=\"delete\"><encapsulation>");
        rpc.append("<dot1q/></encapsulation></trunk></switchport>");
        rpc.append("<switchport><trunk operation=\"delete\"><allowed><vlan>");
        rpc.append("<VLANIDsAllowedVLANsPortTrunkingMode>");
        rpc.append("</VLANIDsAllowedVLANsPortTrunkingMode></vlan></allowed>");
        rpc.append("</trunk></switchport>");
        rpc.append(this.getClosingString());
        return rpc.toString();
    }

    public boolean addRateLimit(String intf, short limit) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.addRateLimitBuilder(intf, limit));
        }
        catch (NetconfException e) {
            this.log.error("Failed to configure rate limit {}%% on device {} interface {}.", new Object[]{limit, this.handler().data().deviceId(), intf, e});
            return false;
        }
        return XmlConfigParser.configSuccess((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String addRateLimitBuilder(String intf, short limit) {
        StringBuilder rpc = new StringBuilder(this.getOpeningString(intf));
        rpc.append("<srr-queue><bandwidth><limit>");
        rpc.append("<EnterBandwidthLimitInterfaceAsPercentage>");
        rpc.append(limit);
        rpc.append("</EnterBandwidthLimitInterfaceAsPercentage>");
        rpc.append("</limit></bandwidth></srr-queue>");
        rpc.append(this.getClosingString());
        return rpc.toString();
    }

    public boolean removeRateLimit(String intf) {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.removeRateLimitBuilder(intf));
        }
        catch (NetconfException e) {
            this.log.error("Failed to remove rate limit from device {} interface {}.", new Object[]{this.handler().data().deviceId(), intf, e});
            return false;
        }
        return XmlConfigParser.configSuccess((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String removeRateLimitBuilder(String intf) {
        StringBuilder rpc = new StringBuilder(this.getOpeningString(intf));
        rpc.append("<srr-queue operation=\"delete\"><bandwidth><limit>");
        rpc.append("</limit></bandwidth></srr-queue>");
        rpc.append(this.getClosingString());
        return rpc.toString();
    }

    private String getOpeningString(String intf) {
        StringBuilder rpc = new StringBuilder("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\" ");
        rpc.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        rpc.append("<edit-config>");
        rpc.append("<target>");
        rpc.append("<running/>");
        rpc.append("</target>");
        rpc.append("<config>");
        rpc.append("<xml-config-data>");
        rpc.append("<Device-Configuration><interface><Param>");
        rpc.append(intf);
        rpc.append("</Param>");
        rpc.append("<ConfigIf-Configuration>");
        return rpc.toString();
    }

    private String getClosingString() {
        StringBuilder rpc = new StringBuilder("</ConfigIf-Configuration>");
        rpc.append("</interface>");
        rpc.append("</Device-Configuration>");
        rpc.append("</xml-config-data>");
        rpc.append("</config>");
        rpc.append("</edit-config>");
        rpc.append("</rpc>");
        return rpc.toString();
    }

    private String getVlansString(List<VlanId> vlanIds) {
        StringBuilder vlansStringBuilder = new StringBuilder();
        for (int i = 0; i < vlanIds.size(); ++i) {
            vlansStringBuilder.append(vlanIds.get(i));
            if (i == vlanIds.size() - 1) continue;
            vlansStringBuilder.append(",");
        }
        return vlansStringBuilder.toString();
    }

    public List<DeviceInterfaceDescription> getInterfaces(DeviceId deviceId) {
        return this.getInterfaces();
    }

    public List<DeviceInterfaceDescription> getInterfaces() {
        String reply;
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        NetconfSession session = ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
        try {
            reply = session.requestSync(this.getConfigBuilder());
        }
        catch (NetconfException e) {
            this.log.error("Failed to retrieve configuration from device {}.", (Object)this.handler().data().deviceId(), (Object)e);
            return null;
        }
        return XmlParserCisco.getInterfacesFromConfig(XmlConfigParser.loadXml((InputStream)new ByteArrayInputStream(reply.getBytes(StandardCharsets.UTF_8))));
    }

    private String getConfigBuilder() {
        StringBuilder rpc = new StringBuilder("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\" ");
        rpc.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        rpc.append("<get-config>");
        rpc.append("<source>");
        rpc.append("<running/>");
        rpc.append("</source>");
        rpc.append("<filter>");
        rpc.append("<config-format-xml>");
        rpc.append("</config-format-xml>");
        rpc.append("</filter>");
        rpc.append("</get-config>");
        rpc.append("</rpc>");
        return rpc.toString();
    }

    public boolean addTunnelMode(String ifaceName, TunnelDescription tunnelDesc) {
        throw new UnsupportedOperationException("Add tunnel mode is not supported");
    }

    public boolean removeTunnelMode(String ifaceName) {
        throw new UnsupportedOperationException("Remove tunnel mode is not supported");
    }

    public boolean addPatchMode(String ifaceName, PatchDescription patchDesc) {
        throw new UnsupportedOperationException("Add patch interface is not supported");
    }

    public boolean removePatchMode(String ifaceName) {
        throw new UnsupportedOperationException("Remove patch interface is not supported");
    }
}

