/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.pipeline.Ofdpa2Pipeline;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa2GroupHandler {
    protected static final int L2_INTERFACE_TYPE = 0;
    protected static final int L3_INTERFACE_TYPE = 0x50000000;
    protected static final int L3_UNICAST_TYPE = 0x20000000;
    protected static final int L3_MULTICAST_TYPE = 0x60000000;
    protected static final int MPLS_INTERFACE_TYPE = -1879048192;
    protected static final int MPLS_L3VPN_SUBTYPE = -1845493760;
    protected static final int L3_ECMP_TYPE = 0x70000000;
    protected static final int L2_FLOOD_TYPE = 0x40000000;
    protected static final int TYPE_MASK = 0xFFFFFFF;
    protected static final int SUBTYPE_MASK = 0xFFFFFF;
    protected static final int TYPE_VLAN_MASK = 65535;
    protected static final int PORT_LOWER_BITS_MASK = 63;
    protected static final long PORT_HIGHER_BITS_MASK = -64L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceDirectory serviceDirectory;
    protected GroupService groupService;
    protected StorageService storageService;
    protected DeviceId deviceId;
    private FlowObjectiveStore flowObjectiveStore;
    private Cache<GroupKey, List<OfdpaNextGroup>> pendingAddNextObjectives;
    private Cache<NextObjective, List<GroupKey>> pendingRemoveNextObjectives;
    private ConcurrentHashMap<GroupKey, Set<GroupChainElem>> pendingGroups;
    private ScheduledExecutorService groupChecker = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/pipeliner", (String)"ofdpa2-%d", (Logger)this.log));
    private AtomicCounter nextIndex;
    protected ConcurrentHashMap<Integer, NextObjective> pendingBuckets = new ConcurrentHashMap();

    protected void init(DeviceId deviceId, PipelinerContext context) {
        this.deviceId = deviceId;
        this.flowObjectiveStore = context.store();
        this.serviceDirectory = context.directory();
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.storageService = (StorageService)this.serviceDirectory.get(StorageService.class);
        this.nextIndex = this.storageService.getAtomicCounter("group-id-index-counter");
        this.pendingAddNextObjectives = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                ((List)notification.getValue()).forEach(ofdpaNextGrp -> Ofdpa2Pipeline.fail((Objective)((OfdpaNextGroup)ofdpaNextGrp).nextObj, ObjectiveError.GROUPINSTALLATIONFAILED));
            }
        }).build();
        this.pendingRemoveNextObjectives = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                Ofdpa2Pipeline.fail((Objective)notification.getKey(), ObjectiveError.GROUPREMOVALFAILED);
            }
        }).build();
        this.pendingGroups = new ConcurrentHashMap();
        this.groupChecker.scheduleAtFixedRate(new GroupChecker(), 0L, 500L, TimeUnit.MILLISECONDS);
        this.groupService.addListener((EventListener)new InnerGroupListener());
    }

    protected void addGroup(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type Simple should only have a single Traffic Treatment. Next Objective Id:{}", (Object)nextObjective.id());
                    Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                this.processSimpleNextObjective(nextObjective);
                break;
            }
            case BROADCAST: {
                this.processBroadcastNextObjective(nextObjective);
                break;
            }
            case HASHED: {
                this.processHashedNextObjective(nextObjective);
                break;
            }
            case FAILOVER: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    private void processSimpleNextObjective(NextObjective nextObj) {
        TrafficTreatment treatment = (TrafficTreatment)nextObj.next().iterator().next();
        boolean plainL2 = true;
        for (Instruction ins : treatment.allInstructions()) {
            L2ModificationInstruction l2ins;
            if (ins.type() != Instruction.Type.L2MODIFICATION || (l2ins = (L2ModificationInstruction)ins).subtype() != L2ModificationInstruction.L2SubType.ETH_DST && l2ins.subtype() != L2ModificationInstruction.L2SubType.ETH_SRC) continue;
            plainL2 = false;
            break;
        }
        if (plainL2) {
            this.createL2InterfaceGroup(nextObj);
            return;
        }
        GroupInfo groupInfo = this.createL2L3Chain(treatment, nextObj.id(), nextObj.appId(), false, nextObj.meta());
        if (groupInfo == null) {
            this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
            return;
        }
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(groupInfo.innerMostGroupDesc.appCookie());
        gkeyChain.addFirst(groupInfo.nextGroupDesc.appCookie());
        OfdpaNextGroup ofdpaGrp = new OfdpaNextGroup(Collections.singletonList(gkeyChain), nextObj);
        this.updatePendingNextObjective(groupInfo.nextGroupDesc.appCookie(), ofdpaGrp);
        this.groupService.addGroup(groupInfo.innerMostGroupDesc);
    }

    private void createL2InterfaceGroup(NextObjective nextObj) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by simple next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        GroupDescription l2InterfaceGroupDesc = groupInfos.get(0).innerMostGroupDesc;
        ArrayList allGroupKeys = Lists.newArrayList();
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(l2InterfaceGroupDesc.appCookie());
        allGroupKeys.add(gkeyChain);
        OfdpaNextGroup ofdpaGrp = new OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective(l2InterfaceGroupDesc.appCookie(), ofdpaGrp);
        this.groupService.addGroup(l2InterfaceGroupDesc);
    }

    protected GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        return this.createL2L3ChainInternal(treatment, nextId, appId, mpls, meta, true);
    }

    protected GroupInfo createL2L3ChainInternal(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta, boolean useSetVlanExtension) {
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        VlanId vlanid = null;
        long portNum = 0L;
        boolean setVlan = false;
        boolean popVlan = false;
        MacAddress srcMac = MacAddress.ZERO;
        MacAddress dstMac = MacAddress.ZERO;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        vlanid = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        if (useSetVlanExtension) {
                            OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanid);
                            outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                        } else {
                            outerTtb.setVlanId(vlanid);
                        }
                        setVlan = true;
                        break;
                    }
                    case VLAN_POP: {
                        innerTtb.popVlan();
                        popVlan = true;
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                portNum = ((Instructions.OutputInstruction)ins).port().toLong();
                innerTtb.add(ins);
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives:  {}", (Object)ins.type());
        }
        if (vlanid == null && meta != null) {
            Criterion vidCriterion = meta.getCriterion(Criterion.Type.VLAN_VID);
            if (vidCriterion != null) {
                vlanid = ((VlanIdCriterion)vidCriterion).vlanId();
            }
            if (vlanid != null && !setVlan) {
                if (useSetVlanExtension) {
                    OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanid);
                    outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                } else {
                    outerTtb.setVlanId(vlanid);
                }
            }
        }
        if (vlanid == null) {
            this.log.error("Driver cannot process an L2/L3 group chain without egress vlan information for dev: {} port:{}", (Object)this.deviceId, (Object)portNum);
            return null;
        }
        if (!setVlan && !popVlan) {
            TrafficTreatment.Builder temp = DefaultTrafficTreatment.builder();
            temp.popVlan();
            innerTtb.build().allInstructions().forEach(i -> temp.add(i));
            innerTtb = temp;
        }
        int l2groupId = 0 | vlanid.toShort() << 16 | (int)portNum;
        int l2gk = this.l2InterfaceGroupKey(this.deviceId, vlanid, portNum);
        DefaultGroupKey l2groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
        DefaultGroupDescription outerGrpDesc = null;
        if (mpls) {
            int mplsInterfaceIndex = this.getNextAvailableIndex();
            int mplsgroupId = 0x90000000 | 0xFFFFFF & mplsInterfaceIndex;
            DefaultGroupKey mplsgroupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)mplsInterfaceIndex));
            outerTtb.group((GroupId)new DefaultGroupId(l2groupId));
            GroupBucket mplsinterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(mplsinterfaceGroupBucket)), (GroupKey)mplsgroupkey, Integer.valueOf(mplsgroupId), appId);
            this.log.debug("Trying MPLS-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(mplsgroupId), mplsgroupkey, nextId});
        } else {
            int l3unicastIndex = this.getNextAvailableIndex();
            int l3groupId = 0x20000000 | 0xFFFFFFF & l3unicastIndex;
            DefaultGroupKey l3groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3unicastIndex));
            outerTtb.group((GroupId)new DefaultGroupId(l2groupId));
            GroupBucket l3unicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3unicastGroupBucket)), (GroupKey)l3groupkey, Integer.valueOf(l3groupId), appId);
            this.log.debug("Trying L3Unicast: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextId});
        }
        GroupChainElem gce = new GroupChainElem((GroupDescription)outerGrpDesc, 1, false);
        this.updatePendingGroups((GroupKey)l2groupkey, gce);
        GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)innerTtb.build());
        DefaultGroupDescription l2groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2groupkey, Integer.valueOf(l2groupId), appId);
        this.log.debug("Trying L2Interface: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2groupId), l2groupkey, nextId});
        return new GroupInfo((GroupDescription)l2groupDescription, (GroupDescription)outerGrpDesc);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processBroadcastNextObjective(NextObjective nextObj) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by broadcast next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        IpPrefix ipDst = Ofdpa2Pipeline.readIpDstFromSelector(nextObj.meta());
        if (ipDst == null) {
            this.createL2FloodGroup(nextObj, assignedVlan, groupInfos);
            return;
        }
        if (ipDst.isMulticast()) {
            this.createL3MulticastGroup(nextObj, assignedVlan, groupInfos);
            return;
        }
        this.log.warn("Broadcast NextObj with non-multicast IP address {}", (Object)nextObj);
        Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
    }

    private List<GroupInfo> prepareL2InterfaceGroup(NextObjective nextObj, VlanId assignedVlan) {
        ImmutableList.Builder groupInfoBuilder = ImmutableList.builder();
        Collection buckets = nextObj.next();
        for (TrafficTreatment treatment : buckets) {
            TrafficTreatment.Builder newTreatment = DefaultTrafficTreatment.builder();
            PortNumber portNum = null;
            VlanId egressVlan = null;
            for (Instruction ins : treatment.allInstructions()) {
                if (ins.type() == Instruction.Type.L2MODIFICATION) {
                    L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                    switch (l2ins.subtype()) {
                        case VLAN_POP: {
                            newTreatment.add((Instruction)l2ins);
                            break;
                        }
                        case VLAN_ID: {
                            egressVlan = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                            break;
                        }
                        default: {
                            this.log.debug("action {} not permitted for broadcast nextObj", (Object)l2ins.subtype());
                            break;
                        }
                    }
                    continue;
                }
                if (ins.type() == Instruction.Type.OUTPUT) {
                    portNum = ((Instructions.OutputInstruction)ins).port();
                    newTreatment.add(ins);
                    continue;
                }
                this.log.debug("TrafficTreatment of type {} not permitted in  broadcast nextObjective", (Object)ins.type());
            }
            VlanId l2InterfaceGroupVlan = egressVlan != null && !assignedVlan.equals(egressVlan) ? egressVlan : assignedVlan;
            int l2gk = this.l2InterfaceGroupKey(this.deviceId, l2InterfaceGroupVlan, portNum.toLong());
            DefaultGroupKey l2InterfaceGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
            int l2InterfaceGroupId = 0 | l2InterfaceGroupVlan.toShort() << 16 | (int)portNum.toLong();
            GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)newTreatment.build());
            DefaultGroupDescription l2InterfaceGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2InterfaceGroupKey, Integer.valueOf(l2InterfaceGroupId), nextObj.appId());
            this.log.debug("Trying L2-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2InterfaceGroupId), l2InterfaceGroupKey, nextObj.id()});
            groupInfoBuilder.add((Object)new GroupInfo((GroupDescription)l2InterfaceGroupDescription, (GroupDescription)l2InterfaceGroupDescription));
        }
        return groupInfoBuilder.build();
    }

    private void createL2FloodGroup(NextObjective nextObj, VlanId vlanId, List<GroupInfo> groupInfos) {
        Integer l2floodgroupId = 0x40000000 | vlanId.toShort() << 16;
        int l2floodgk = this.getNextAvailableIndex();
        DefaultGroupKey l2floodgroupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2floodgk));
        ArrayList l2floodBuckets = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            GroupDescription l2intGrpDesc = ((GroupInfo)groupInfo).nextGroupDesc;
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group((GroupId)new DefaultGroupId(l2intGrpDesc.givenGroupId().intValue()));
            GroupBucket abucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)ttb.build());
            l2floodBuckets.add(abucket);
        });
        DefaultGroupDescription l2floodGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets((List)l2floodBuckets), (GroupKey)l2floodgroupkey, l2floodgroupId, nextObj.appId());
        this.log.debug("Trying L2-Flood: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2floodgroupId), l2floodgroupkey, nextObj.id()});
        ArrayList allGroupKeys = Lists.newArrayList();
        groupInfos.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$createL2FloodGroup$5((GroupKey)l2floodgroupkey, allGroupKeys, arg_0));
        OfdpaNextGroup ofdpaGrp = new OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l2floodgroupkey, ofdpaGrp);
        GroupChainElem gce = new GroupChainElem((GroupDescription)l2floodGroupDescription, groupInfos.size(), false);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(((GroupInfo)groupInfo).nextGroupDesc.appCookie(), gce);
            this.groupService.addGroup(((GroupInfo)groupInfo).innerMostGroupDesc);
        });
    }

    private void createL3MulticastGroup(NextObjective nextObj, VlanId vlanId, List<GroupInfo> groupInfos) {
        ArrayList l3McastBuckets = new ArrayList();
        groupInfos.forEach(groupInfo -> {
            GroupDescription nextGroupDesc = ((GroupInfo)groupInfo).nextGroupDesc != null ? ((GroupInfo)groupInfo).nextGroupDesc : ((GroupInfo)groupInfo).innerMostGroupDesc;
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group((GroupId)new DefaultGroupId(nextGroupDesc.givenGroupId().intValue()));
            GroupBucket abucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)ttb.build());
            l3McastBuckets.add(abucket);
        });
        int l3MulticastIndex = this.getNextAvailableIndex();
        int l3MulticastGroupId = 0x60000000 | vlanId.toShort() << 16 | 0xFFFF & l3MulticastIndex;
        DefaultGroupKey l3MulticastGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3MulticastIndex));
        DefaultGroupDescription l3MulticastGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(l3McastBuckets), (GroupKey)l3MulticastGroupKey, Integer.valueOf(l3MulticastGroupId), nextObj.appId());
        ArrayList allGroupKeys = Lists.newArrayList();
        groupInfos.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$createL3MulticastGroup$8((GroupKey)l3MulticastGroupKey, allGroupKeys, arg_0));
        OfdpaNextGroup ofdpaGrp = new OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l3MulticastGroupKey, ofdpaGrp);
        GroupChainElem outerGce = new GroupChainElem((GroupDescription)l3MulticastGroupDesc, groupInfos.size(), false);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(((GroupInfo)groupInfo).nextGroupDesc.appCookie(), outerGce);
            if (!((GroupInfo)groupInfo).nextGroupDesc.equals(((GroupInfo)groupInfo).innerMostGroupDesc)) {
                GroupChainElem innerGce = new GroupChainElem(((GroupInfo)groupInfo).nextGroupDesc, 1, false);
                this.updatePendingGroups(((GroupInfo)groupInfo).innerMostGroupDesc.appCookie(), innerGce);
            }
            this.groupService.addGroup(((GroupInfo)groupInfo).innerMostGroupDesc);
        });
    }

    private void processHashedNextObjective(NextObjective nextObj) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<GroupInfo> unsentGroups = new ArrayList<GroupInfo>();
        this.createHashBucketChains(nextObj, allGroupKeys, unsentGroups);
        ArrayList<GroupBucket> l3ecmpGroupBuckets = new ArrayList<GroupBucket>();
        for (GroupInfo gi : unsentGroups) {
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group((GroupId)new DefaultGroupId(gi.nextGroupDesc.givenGroupId().intValue()));
            GroupBucket sbucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)ttb.build());
            l3ecmpGroupBuckets.add(sbucket);
        }
        int l3ecmpIndex = this.getNextAvailableIndex();
        int l3ecmpGroupId = 0x70000000 | 0xFFFFFFF & l3ecmpIndex;
        DefaultGroupKey l3ecmpGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3ecmpIndex));
        DefaultGroupDescription l3ecmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(l3ecmpGroupBuckets), (GroupKey)l3ecmpGroupKey, Integer.valueOf(l3ecmpGroupId), nextObj.appId());
        GroupChainElem l3ecmpGce = new GroupChainElem((GroupDescription)l3ecmpGroupDesc, l3ecmpGroupBuckets.size(), false);
        allGroupKeys.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$processHashedNextObjective$10((GroupKey)l3ecmpGroupKey, arg_0));
        OfdpaNextGroup ofdpaGrp = new OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l3ecmpGroupKey, ofdpaGrp);
        this.log.debug("Trying L3ECMP: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3ecmpGroupId), l3ecmpGroupKey, nextObj.id()});
        for (GroupInfo gi : unsentGroups) {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(gi.innerMostGroupDesc.givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(gi.nextGroupDesc.appCookie(), l3ecmpGce);
            this.groupService.addGroup(gi.innerMostGroupDesc);
        }
    }

    private void createHashBucketChains(NextObjective nextObj, List<Deque<GroupKey>> allGroupKeys, List<GroupInfo> unsentGroups) {
        Collection buckets = nextObj.next();
        for (TrafficTreatment bucket : buckets) {
            int labelsPushed = 0;
            MplsLabel innermostLabel = null;
            for (Instruction ins : bucket.allInstructions()) {
                if (ins.type() != Instruction.Type.L2MODIFICATION) continue;
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                if (l2ins.subtype() == L2ModificationInstruction.L2SubType.MPLS_PUSH) {
                    ++labelsPushed;
                }
                if (l2ins.subtype() != L2ModificationInstruction.L2SubType.MPLS_LABEL || innermostLabel != null) continue;
                innermostLabel = ((L2ModificationInstruction.ModMplsLabelInstruction)l2ins).label();
            }
            ArrayDeque<Object> gkeyChain = new ArrayDeque<Object>();
            if (labelsPushed == 0) {
                GroupInfo nolabelGroupInfo = this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), false, nextObj.meta());
                if (nolabelGroupInfo == null) {
                    this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                    return;
                }
                gkeyChain.addFirst(nolabelGroupInfo.innerMostGroupDesc.appCookie());
                gkeyChain.addFirst(nolabelGroupInfo.nextGroupDesc.appCookie());
                unsentGroups.add(nolabelGroupInfo);
            } else if (labelsPushed == 1) {
                GroupInfo onelabelGroupInfo = this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), true, nextObj.meta());
                if (onelabelGroupInfo == null) {
                    this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                    return;
                }
                TrafficTreatment.Builder l3vpnTtb = DefaultTrafficTreatment.builder();
                l3vpnTtb.pushMpls().setMpls(innermostLabel).setMplsBos(true).copyTtlOut().group((GroupId)new DefaultGroupId(onelabelGroupInfo.nextGroupDesc.givenGroupId().intValue()));
                GroupBucket l3vpnGrpBkt = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)l3vpnTtb.build());
                int l3vpnIndex = this.getNextAvailableIndex();
                int l3vpngroupId = 0x92000000 | 0xFFFFFF & l3vpnIndex;
                DefaultGroupKey l3vpngroupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3vpnIndex));
                DefaultGroupDescription l3vpnGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3vpnGrpBkt)), (GroupKey)l3vpngroupkey, Integer.valueOf(l3vpngroupId), nextObj.appId());
                GroupChainElem l3vpnGce = new GroupChainElem((GroupDescription)l3vpnGroupDesc, 1, false);
                this.updatePendingGroups(onelabelGroupInfo.nextGroupDesc.appCookie(), l3vpnGce);
                gkeyChain.addFirst(onelabelGroupInfo.innerMostGroupDesc.appCookie());
                gkeyChain.addFirst(onelabelGroupInfo.nextGroupDesc.appCookie());
                gkeyChain.addFirst(l3vpngroupkey);
                onelabelGroupInfo.nextGroupDesc = (GroupDescription)l3vpnGroupDesc;
                unsentGroups.add(onelabelGroupInfo);
                this.log.debug("Trying L3VPN: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3vpngroupId), l3vpngroupkey, nextObj.id()});
            } else {
                this.log.warn("Driver currently does not handle more than 1 MPLS labels. Not processing nextObjective {}", (Object)nextObj.id());
                return;
            }
            allGroupKeys.add(gkeyChain);
        }
    }

    protected void addBucketToGroup(NextObjective nextObjective, NextGroup next) {
        if (nextObjective.type() != NextObjective.Type.HASHED && nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.warn("AddBuckets not applied to nextType:{} in dev:{} for next:{}", new Object[]{nextObjective.type(), this.deviceId, nextObjective.id()});
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        if (nextObjective.next().size() > 1) {
            this.log.warn("Only one bucket can be added at a time");
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        HashSet<PortNumber> existingOutPorts = new HashSet<PortNumber>();
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        for (Deque gkeys : allActiveKeys) {
            PortNumber op;
            Group glast = this.groupService.getGroup(this.deviceId, (GroupKey)gkeys.peekLast());
            if (glast == null || glast.buckets().buckets().isEmpty() || (op = Ofdpa2GroupHandler.readOutPortFromTreatment(((GroupBucket)glast.buckets().buckets().get(0)).treatment())) == null) continue;
            existingOutPorts.add(op);
        }
        TrafficTreatment tt = (TrafficTreatment)nextObjective.next().iterator().next();
        PortNumber newport = Ofdpa2GroupHandler.readOutPortFromTreatment(tt);
        if (existingOutPorts.contains(newport)) {
            this.log.info("Attempt to add bucket for existing outport:{} in dev:{} for next:{}", new Object[]{newport, this.deviceId, nextObjective.id()});
            return;
        }
        if (nextObjective.type() == NextObjective.Type.HASHED) {
            this.addBucketToHashGroup(nextObjective, allActiveKeys, newport);
        } else if (nextObjective.type() == NextObjective.Type.BROADCAST) {
            this.addBucketToBroadcastGroup(nextObjective, allActiveKeys, newport);
        }
    }

    private void addBucketToHashGroup(NextObjective nextObjective, List<Deque<GroupKey>> allActiveKeys, PortNumber newport) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<GroupInfo> unsentGroups = new ArrayList<GroupInfo>();
        this.createHashBucketChains(nextObjective, allGroupKeys, unsentGroups);
        GroupInfo gi = (GroupInfo)unsentGroups.get(0);
        TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
        ttb.group((GroupId)new DefaultGroupId(gi.nextGroupDesc.givenGroupId().intValue()));
        GroupBucket sbucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)ttb.build());
        Group l3ecmpGroup = this.retrieveTopLevelGroup(allActiveKeys, nextObjective.id());
        if (l3ecmpGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l3ecmpGroupKey = l3ecmpGroup.appCookie();
        int l3ecmpGroupId = (Integer)l3ecmpGroup.id().id();
        DefaultGroupDescription l3ecmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(Collections.singletonList(sbucket)), l3ecmpGroupKey, Integer.valueOf(l3ecmpGroupId), nextObjective.appId());
        GroupChainElem l3ecmpGce = new GroupChainElem((GroupDescription)l3ecmpGroupDesc, 1, true);
        Deque newBucketChain = (Deque)allGroupKeys.get(0);
        newBucketChain.addFirst(l3ecmpGroupKey);
        if (allActiveKeys.size() == 1 && allActiveKeys.get(0).size() == 1) {
            allActiveKeys.clear();
        }
        allActiveKeys.add(newBucketChain);
        this.updatePendingNextObjective(l3ecmpGroupKey, new OfdpaNextGroup(allActiveKeys, nextObjective));
        this.log.debug("Adding to L3ECMP: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3ecmpGroupId), l3ecmpGroupKey, nextObjective.id()});
        this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(gi.innerMostGroupDesc.givenGroupId()), (Object)this.deviceId);
        this.updatePendingGroups(gi.nextGroupDesc.appCookie(), l3ecmpGce);
        this.groupService.addGroup(gi.innerMostGroupDesc);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addBucketToBroadcastGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, PortNumber newport) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by broadcast next obj is missing. Aborting add bucket to broadcast group for next:{} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        IpPrefix ipDst = Ofdpa2Pipeline.readIpDstFromSelector(nextObj.meta());
        if (ipDst == null) {
            this.addBucketToL2FloodGroup(nextObj, allActiveKeys, groupInfos, assignedVlan, newport);
            return;
        }
        if (ipDst.isMulticast()) {
            this.addBucketToL3MulticastGroup(nextObj, allActiveKeys, groupInfos, assignedVlan, newport);
            return;
        }
        this.log.warn("Broadcast NextObj with non-multicast IP address {}", (Object)nextObj);
        Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
    }

    private void addBucketToL2FloodGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, List<GroupInfo> groupInfos, VlanId assignedVlan, PortNumber newport) {
        GroupInfo groupInfo = groupInfos.get(0);
        GroupDescription l2intGrpDesc = groupInfo.nextGroupDesc;
        TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
        ttb.group((GroupId)new DefaultGroupId(l2intGrpDesc.givenGroupId().intValue()));
        GroupBucket abucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)ttb.build());
        Group l2floodGroup = this.retrieveTopLevelGroup(allActiveKeys, nextObj.id());
        if (l2floodGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l2floodGroupKey = l2floodGroup.appCookie();
        int l2floodGroupId = (Integer)l2floodGroup.id().id();
        VlanId expectedVlan = VlanId.vlanId((short)((short)((l2floodGroupId & 0xFFF0000) >> 16)));
        if (!expectedVlan.equals((Object)assignedVlan)) {
            this.log.warn("VLAN ID {} does not match Flood group {} to which bucket is being added, for next:{} in dev:{}. Abort.", new Object[]{assignedVlan, Integer.toHexString(l2floodGroupId), nextObj.id(), this.deviceId});
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
        }
        DefaultGroupDescription l2floodGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(Collections.singletonList(abucket)), l2floodGroupKey, Integer.valueOf(l2floodGroupId), nextObj.appId());
        GroupChainElem l2floodGce = new GroupChainElem((GroupDescription)l2floodGroupDescription, 1, true);
        ArrayDeque<GroupKey> newBucketChain = new ArrayDeque<GroupKey>();
        newBucketChain.addFirst(groupInfo.nextGroupDesc.appCookie());
        newBucketChain.addFirst(l2floodGroupKey);
        if (allActiveKeys.size() == 1 && allActiveKeys.get(0).size() == 1) {
            allActiveKeys.clear();
        }
        allActiveKeys.add(newBucketChain);
        this.updatePendingNextObjective(l2floodGroupKey, new OfdpaNextGroup(allActiveKeys, nextObj));
        this.log.debug("Adding to L2FLOOD: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2floodGroupId), l2floodGroupKey, nextObj.id()});
        this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc.givenGroupId()), (Object)this.deviceId);
        this.updatePendingGroups(groupInfo.nextGroupDesc.appCookie(), l2floodGce);
        this.groupService.addGroup(groupInfo.innerMostGroupDesc);
    }

    private void addBucketToL3MulticastGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, List<GroupInfo> groupInfos, VlanId assignedVlan, PortNumber newport) {
        GroupInfo groupInfo = groupInfos.get(0);
        GroupDescription nextGroupDesc = groupInfo.nextGroupDesc != null ? groupInfo.nextGroupDesc : groupInfo.innerMostGroupDesc;
        TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
        ttb.group((GroupId)new DefaultGroupId(nextGroupDesc.givenGroupId().intValue()));
        GroupBucket abucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)ttb.build());
        Group l3mcastGroup = this.retrieveTopLevelGroup(allActiveKeys, nextObj.id());
        if (l3mcastGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l3mcastGroupKey = l3mcastGroup.appCookie();
        int l3mcastGroupId = (Integer)l3mcastGroup.id().id();
        VlanId expectedVlan = VlanId.vlanId((short)((short)((l3mcastGroupId & 0xFFF0000) >> 16)));
        if (!expectedVlan.equals((Object)assignedVlan)) {
            this.log.warn("VLAN ID {} does not match L3 Mcast group {} to which bucket is being added, for next:{} in dev:{}. Abort.", new Object[]{assignedVlan, Integer.toHexString(l3mcastGroupId), nextObj.id(), this.deviceId});
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
        }
        DefaultGroupDescription l3mcastGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(Collections.singletonList(abucket)), l3mcastGroupKey, Integer.valueOf(l3mcastGroupId), nextObj.appId());
        GroupChainElem l3mcastGce = new GroupChainElem((GroupDescription)l3mcastGroupDescription, 1, true);
        ArrayDeque<GroupKey> newBucketChain = new ArrayDeque<GroupKey>();
        newBucketChain.addFirst(groupInfo.innerMostGroupDesc.appCookie());
        if (!groupInfo.nextGroupDesc.equals(groupInfo.innerMostGroupDesc)) {
            newBucketChain.addFirst(groupInfo.nextGroupDesc.appCookie());
        }
        newBucketChain.addFirst(l3mcastGroupKey);
        if (allActiveKeys.size() == 1 && allActiveKeys.get(0).size() == 1) {
            allActiveKeys.clear();
        }
        allActiveKeys.add(newBucketChain);
        this.updatePendingNextObjective(l3mcastGroupKey, new OfdpaNextGroup(allActiveKeys, nextObj));
        this.updatePendingGroups(groupInfo.nextGroupDesc.appCookie(), l3mcastGce);
        if (!groupInfo.nextGroupDesc.equals(groupInfo.innerMostGroupDesc)) {
            GroupChainElem innerGce = new GroupChainElem(groupInfo.nextGroupDesc, 1, false);
            this.updatePendingGroups(groupInfo.innerMostGroupDesc.appCookie(), innerGce);
        }
        this.log.debug("Adding to L3MCAST: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3mcastGroupId), l3mcastGroupKey, nextObj.id()});
        this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc.givenGroupId()), (Object)this.deviceId);
        this.groupService.addGroup(groupInfo.innerMostGroupDesc);
    }

    protected void removeBucketFromGroup(NextObjective nextObjective, NextGroup next) {
        if (nextObjective.type() != NextObjective.Type.HASHED && nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.warn("RemoveBuckets not applied to nextType:{} in dev:{} for next:{}", new Object[]{nextObjective.type(), this.deviceId, nextObjective.id()});
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        Collection treatments = nextObjective.next();
        TrafficTreatment treatment = (TrafficTreatment)treatments.iterator().next();
        PortNumber portToRemove = Ofdpa2GroupHandler.readOutPortFromTreatment(treatment);
        if (portToRemove == null) {
            this.log.warn("next objective {} has no outport.. cannot remove bucketfrom group in dev: {}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        Deque foundChain = null;
        int index = 0;
        for (Deque gkeys : allActiveKeys) {
            GroupKey groupWithPort = (GroupKey)gkeys.peekLast();
            Group group = this.groupService.getGroup(this.deviceId, groupWithPort);
            if (group == null) {
                this.log.warn("Inconsistent group chain found when removing bucketfor next:{} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
                continue;
            }
            PortNumber pout = Ofdpa2GroupHandler.readOutPortFromTreatment(((GroupBucket)group.buckets().buckets().get(0)).treatment());
            if (pout.equals((Object)portToRemove)) {
                foundChain = gkeys;
                break;
            }
            ++index;
        }
        if (foundChain == null) {
            this.log.warn("Could not find appropriate group-chain for removing bucket for next id {} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        GroupKey modGroupKey = (GroupKey)foundChain.peekFirst();
        Group modGroup = this.groupService.getGroup(this.deviceId, modGroupKey);
        GroupKey pointedGroupKey = null;
        int i = 0;
        for (GroupKey gk : foundChain) {
            if (i++ != 1) continue;
            pointedGroupKey = gk;
            break;
        }
        Group pointedGroup = this.groupService.getGroup(this.deviceId, pointedGroupKey);
        GroupBucket bucket = null;
        bucket = nextObjective.type() == NextObjective.Type.HASHED ? DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)DefaultTrafficTreatment.builder().group(pointedGroup.id()).build()) : DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)DefaultTrafficTreatment.builder().group(pointedGroup.id()).build());
        GroupBuckets removeBuckets = new GroupBuckets(Collections.singletonList(bucket));
        this.log.debug("Removing buckets from group id 0x{} pointing to group id 0x{} for next id {} in device {}", new Object[]{Integer.toHexString((Integer)modGroup.id().id()), Integer.toHexString((Integer)pointedGroup.id().id()), nextObjective.id(), this.deviceId});
        this.groupService.removeBucketsFromGroup(this.deviceId, modGroupKey, removeBuckets, modGroupKey, nextObjective.appId());
        if (allActiveKeys.size() == 1) {
            ArrayDeque<GroupKey> top = new ArrayDeque<GroupKey>();
            top.add(modGroupKey);
            allActiveKeys.add(top);
        }
        allActiveKeys.remove(index);
        this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new OfdpaNextGroup(allActiveKeys, nextObjective));
    }

    protected void removeGroup(NextObjective nextObjective, NextGroup next) {
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        List groupKeys = allActiveKeys.stream().map(Deque::getFirst).collect(Collectors.toList());
        this.pendingRemoveNextObjectives.put((Object)nextObjective, groupKeys);
        allActiveKeys.forEach(groupChain -> groupChain.forEach(groupKey -> this.groupService.removeGroup(this.deviceId, groupKey, nextObjective.appId())));
        this.flowObjectiveStore.removeNextGroup(Integer.valueOf(nextObjective.id()));
    }

    private void updatePendingNextObjective(GroupKey key, OfdpaNextGroup value) {
        CopyOnWriteArrayList<OfdpaNextGroup> nextList = new CopyOnWriteArrayList<OfdpaNextGroup>();
        nextList.add(value);
        List ret = this.pendingAddNextObjectives.asMap().putIfAbsent(key, nextList);
        if (ret != null) {
            ret.add(value);
        }
    }

    protected void updatePendingGroups(GroupKey gkey, GroupChainElem gce) {
        Set gceSet = Collections.newSetFromMap(new ConcurrentHashMap());
        gceSet.add(gce);
        Set retval = this.pendingGroups.putIfAbsent(gkey, gceSet);
        if (retval != null) {
            retval.add(gce);
        }
    }

    private void processGroupChain(GroupChainElem gce) {
        int waitOnGroups = gce.decrementAndGetGroupsWaitedOn();
        if (waitOnGroups != 0) {
            this.log.debug("GCE: {} not ready to be processed", (Object)gce);
            return;
        }
        this.log.debug("GCE: {} ready to be processed", (Object)gce);
        if (gce.addBucketToGroup) {
            this.groupService.addBucketsToGroup(gce.groupDescription.deviceId(), gce.groupDescription.appCookie(), gce.groupDescription.buckets(), gce.groupDescription.appCookie(), gce.groupDescription.appId());
        } else {
            this.groupService.addGroup(gce.groupDescription);
        }
    }

    private void processPendingAddGroupsOrNextObjs(GroupKey key, boolean added) {
        Set<GroupChainElem> gceSet = this.pendingGroups.remove(key);
        if (gceSet != null) {
            for (GroupChainElem gce : gceSet) {
                this.log.debug("Group service {} group key {} in device {}. Processing next group in group chain with group id 0x{}", new Object[]{added ? "ADDED" : "processed", key, this.deviceId, Integer.toHexString(gce.groupDescription.givenGroupId())});
                this.processGroupChain(gce);
            }
        } else {
            List nextGrpList = (List)this.pendingAddNextObjectives.getIfPresent((Object)key);
            if (nextGrpList != null) {
                this.pendingAddNextObjectives.invalidate((Object)key);
                nextGrpList.forEach(nextGrp -> {
                    this.log.debug("Group service {} group key {} in device:{}. Done implementing next objective: {} <<-->> gid:0x{}", new Object[]{added ? "ADDED" : "processed", key, this.deviceId, nextGrp.nextObjective().id(), Integer.toHexString(this.groupService.getGroup(this.deviceId, key).givenGroupId())});
                    Ofdpa2Pipeline.pass((Objective)nextGrp.nextObjective());
                    this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextGrp.nextObjective().id()), (NextGroup)nextGrp);
                    NextObjective pendBkt = this.pendingBuckets.remove(nextGrp.nextObjective().id());
                    if (pendBkt != null) {
                        this.addBucketToGroup(pendBkt, (NextGroup)nextGrp);
                    }
                });
            }
        }
    }

    private void processPendingRemoveNextObjs(GroupKey key) {
        this.pendingRemoveNextObjectives.asMap().forEach((nextObjective, groupKeys) -> {
            if (groupKeys.isEmpty()) {
                this.pendingRemoveNextObjectives.invalidate(nextObjective);
                Ofdpa2Pipeline.pass((Objective)nextObjective);
            } else {
                groupKeys.remove(key);
            }
        });
    }

    protected int getNextAvailableIndex() {
        return (int)this.nextIndex.incrementAndGet();
    }

    protected static PortNumber readOutPortFromTreatment(TrafficTreatment tt) {
        for (Instruction ins : tt.allInstructions()) {
            if (ins.type() != Instruction.Type.OUTPUT) continue;
            return ((Instructions.OutputInstruction)ins).port();
        }
        return null;
    }

    protected int l2InterfaceGroupKey(DeviceId deviceId, VlanId vlanId, long portNumber) {
        int portLowerBits = (int)portNumber & 0x3F;
        long portHigherBits = portNumber & 0xFFFFFFFFFFFFFFC0L;
        int hash = Objects.hash(deviceId, vlanId, portHigherBits);
        return 0 | 0xFFFFFFF & hash << 6 | portLowerBits;
    }

    private Group retrieveTopLevelGroup(List<Deque<GroupKey>> allActiveKeys, int nextid) {
        GroupKey topLevelGroupKey = null;
        if (allActiveKeys.isEmpty()) {
            this.log.warn("Could not determine top level group while processingnext:{} in dev:{}", (Object)nextid, (Object)this.deviceId);
            return null;
        }
        topLevelGroupKey = allActiveKeys.get(0).peekFirst();
        Group topGroup = this.groupService.getGroup(this.deviceId, topLevelGroupKey);
        if (topGroup == null) {
            this.log.warn("Could not find top level group while processing next:{} in dev:{}", (Object)nextid, (Object)this.deviceId);
        }
        return topGroup;
    }

    private static /* synthetic */ void lambda$processHashedNextObjective$10(GroupKey l3ecmpGroupKey, Deque gkeyChain) {
        gkeyChain.addFirst(l3ecmpGroupKey);
    }

    private static /* synthetic */ void lambda$createL3MulticastGroup$8(GroupKey l3MulticastGroupKey, List allGroupKeys, GroupInfo groupInfo) {
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(groupInfo.innerMostGroupDesc.appCookie());
        if (!groupInfo.nextGroupDesc.equals(groupInfo.innerMostGroupDesc)) {
            gkeyChain.addFirst(groupInfo.nextGroupDesc.appCookie());
        }
        gkeyChain.addFirst(l3MulticastGroupKey);
        allGroupKeys.add(gkeyChain);
    }

    private static /* synthetic */ void lambda$createL2FloodGroup$5(GroupKey l2floodgroupkey, List allGroupKeys, GroupInfo groupInfo) {
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(groupInfo.nextGroupDesc.appCookie());
        gkeyChain.addFirst(l2floodgroupkey);
        allGroupKeys.add(gkeyChain);
    }

    protected class GroupChainElem {
        private GroupDescription groupDescription;
        private AtomicInteger waitOnGroups;
        private boolean addBucketToGroup;

        GroupChainElem(GroupDescription groupDescription, int waitOnGroups, boolean addBucketToGroup) {
            this.groupDescription = groupDescription;
            this.waitOnGroups = new AtomicInteger(waitOnGroups);
            this.addBucketToGroup = addBucketToGroup;
        }

        int decrementAndGetGroupsWaitedOn() {
            return this.waitOnGroups.decrementAndGet();
        }

        public String toString() {
            return Integer.toHexString(this.groupDescription.givenGroupId()) + " groupKey: " + this.groupDescription.appCookie() + " waiting-on-groups: " + this.waitOnGroups.get() + " addBucketToGroup: " + this.addBucketToGroup + " device: " + Ofdpa2GroupHandler.this.deviceId;
        }
    }

    protected class OfdpaNextGroup
    implements NextGroup {
        private final NextObjective nextObj;
        private final List<Deque<GroupKey>> gkeys;

        public OfdpaNextGroup(List<Deque<GroupKey>> gkeys, NextObjective nextObj) {
            this.nextObj = nextObj;
            this.gkeys = gkeys;
        }

        public NextObjective nextObjective() {
            return this.nextObj;
        }

        public List<Deque<GroupKey>> groupKeys() {
            return this.gkeys;
        }

        public byte[] data() {
            return Ofdpa2Pipeline.appKryo.serialize(this.gkeys);
        }
    }

    protected class GroupInfo {
        private GroupDescription innerMostGroupDesc;
        private GroupDescription nextGroupDesc;

        GroupInfo(GroupDescription innerMostGroupDesc, GroupDescription nextGroupDesc) {
            this.innerMostGroupDesc = innerMostGroupDesc;
            this.nextGroupDesc = nextGroupDesc;
        }
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            Ofdpa2GroupHandler.this.log.trace("received group event of type {}", (Object)event.type());
            switch ((GroupEvent.Type)event.type()) {
                case GROUP_ADDED: {
                    Ofdpa2GroupHandler.this.processPendingAddGroupsOrNextObjs(((Group)event.subject()).appCookie(), true);
                    break;
                }
                case GROUP_REMOVED: {
                    Ofdpa2GroupHandler.this.processPendingRemoveNextObjs(((Group)event.subject()).appCookie());
                    break;
                }
            }
        }
    }

    private class GroupChecker
    implements Runnable {
        private GroupChecker() {
        }

        @Override
        public void run() {
            Set<GroupKey> keys = Ofdpa2GroupHandler.this.pendingGroups.keySet().stream().filter(key -> Ofdpa2GroupHandler.this.groupService.getGroup(Ofdpa2GroupHandler.this.deviceId, key) != null).collect(Collectors.toSet());
            Set otherkeys = Ofdpa2GroupHandler.this.pendingAddNextObjectives.asMap().keySet().stream().filter(otherkey -> Ofdpa2GroupHandler.this.groupService.getGroup(Ofdpa2GroupHandler.this.deviceId, otherkey) != null).collect(Collectors.toSet());
            keys.addAll(otherkeys);
            keys.forEach(key -> Ofdpa2GroupHandler.this.processPendingAddGroupsOrNextObjs(key, false));
        }
    }
}

