/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Collections;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.pipeline.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.Ofdpa2Pipeline;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpqdOfdpa2GroupHandler
extends Ofdpa2GroupHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected Ofdpa2GroupHandler.GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        VlanId vlanid = null;
        long portNum = 0L;
        boolean setVlan = false;
        boolean popVlan = false;
        MacAddress srcMac = MacAddress.ZERO;
        MacAddress dstMac = MacAddress.ZERO;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        vlanid = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        outerTtb.setVlanId(vlanid);
                        setVlan = true;
                        break;
                    }
                    case VLAN_POP: {
                        innerTtb.popVlan();
                        popVlan = true;
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                portNum = ((Instructions.OutputInstruction)ins).port().toLong();
                innerTtb.add(ins);
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives:  {}", (Object)ins.type());
        }
        if (vlanid == null && meta != null) {
            Criterion vidCriterion = meta.getCriterion(Criterion.Type.VLAN_VID);
            if (vidCriterion != null) {
                vlanid = ((VlanIdCriterion)vidCriterion).vlanId();
            }
            if (vlanid != null && !setVlan) {
                outerTtb.setVlanId(vlanid);
            }
        }
        if (vlanid == null) {
            this.log.error("Driver cannot process an L2/L3 group chain without egress vlan information for dev: {} port:{}", (Object)this.deviceId, (Object)portNum);
            return null;
        }
        if (!setVlan && !popVlan) {
            TrafficTreatment.Builder temp = DefaultTrafficTreatment.builder();
            temp.popVlan();
            innerTtb.build().allInstructions().forEach(i -> temp.add(i));
            innerTtb = temp;
        }
        int l2groupId = 0 | vlanid.toShort() << 16 | (int)portNum;
        int l2gk = this.l2InterfaceGroupKey(this.deviceId, vlanid, portNum);
        DefaultGroupKey l2groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
        DefaultGroupDescription outerGrpDesc = null;
        if (mpls) {
            int mplsInterfaceIndex = this.getNextAvailableIndex();
            int mplsgroupId = 0x90000000 | 0xFFFFFF & mplsInterfaceIndex;
            DefaultGroupKey mplsgroupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)mplsInterfaceIndex));
            outerTtb.group((GroupId)new DefaultGroupId(l2groupId));
            GroupBucket mplsinterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(mplsinterfaceGroupBucket)), (GroupKey)mplsgroupkey, Integer.valueOf(mplsgroupId), appId);
            this.log.debug("Trying MPLS-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(mplsgroupId), mplsgroupkey, nextId});
        } else {
            int l3unicastIndex = this.getNextAvailableIndex();
            int l3groupId = 0x20000000 | 0xFFFFFFF & l3unicastIndex;
            DefaultGroupKey l3groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3unicastIndex));
            outerTtb.group((GroupId)new DefaultGroupId(l2groupId));
            GroupBucket l3unicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3unicastGroupBucket)), (GroupKey)l3groupkey, Integer.valueOf(l3groupId), appId);
            this.log.debug("Trying L3Unicast: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextId});
        }
        Ofdpa2GroupHandler.GroupChainElem gce = new Ofdpa2GroupHandler.GroupChainElem(this, (GroupDescription)outerGrpDesc, 1, false);
        this.updatePendingGroups((GroupKey)l2groupkey, gce);
        GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)innerTtb.build());
        DefaultGroupDescription l2groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2groupkey, Integer.valueOf(l2groupId), appId);
        this.log.debug("Trying L2Interface: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2groupId), l2groupkey, nextId});
        return new Ofdpa2GroupHandler.GroupInfo(this, (GroupDescription)l2groupDescription, (GroupDescription)outerGrpDesc);
    }
}

