/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSingleTablePipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private FlowObjectiveStore flowObjectiveStore;
    private DeviceId deviceId;
    private Cache<Integer, NextObjective> pendingNext;
    private KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{SingleGroup.class}).register(new Class[]{byte[].class}).build("DefaultSingleTablePipeline");

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = (FlowObjectiveStore)this.serviceDirectory.get(FlowObjectiveStore.class);
        this.pendingNext = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                ((NextObjective)notification.getValue()).context().ifPresent(c -> c.onError((Objective)notification.getValue(), ObjectiveError.FLOWINSTALLATIONFAILED));
            }
        }).build();
    }

    public void filter(FilteringObjective filter) {
        TrafficTreatment.Builder actions;
        switch (filter.type()) {
            case PERMIT: {
                actions = filter.meta() == null ? DefaultTrafficTreatment.builder().punt() : DefaultTrafficTreatment.builder((TrafficTreatment)filter.meta());
                break;
            }
            case DENY: {
                actions = filter.meta() == null ? DefaultTrafficTreatment.builder() : DefaultTrafficTreatment.builder((TrafficTreatment)filter.meta());
                actions.drop();
                break;
            }
            default: {
                this.log.warn("Unknown filter type: {}", (Object)filter.type());
                actions = DefaultTrafficTreatment.builder().drop();
            }
        }
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        filter.conditions().forEach(arg_0 -> ((TrafficSelector.Builder)selector).add(arg_0));
        if (filter.key() != null) {
            selector.add(filter.key());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(actions.build()).fromApp(filter.appId()).withPriority(filter.priority());
        if (filter.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(filter.timeout());
        }
        this.installObjective(ruleBuilder, (Objective)filter);
    }

    public void forward(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        if (fwd.treatment() != null) {
            FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(fwd.treatment());
            if (fwd.permanent()) {
                ruleBuilder.makePermanent();
            } else {
                ruleBuilder.makeTemporary(fwd.timeout());
            }
            this.installObjective(ruleBuilder, (Objective)fwd);
        } else {
            NextObjective nextObjective = (NextObjective)this.pendingNext.getIfPresent((Object)fwd.nextId());
            if (nextObjective != null) {
                this.pendingNext.invalidate((Object)fwd.nextId());
                nextObjective.next().forEach(treat -> {
                    FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(treat);
                    if (fwd.permanent()) {
                        ruleBuilder.makePermanent();
                    } else {
                        ruleBuilder.makeTemporary(fwd.timeout());
                    }
                    this.installObjective(ruleBuilder, (Objective)fwd);
                });
            } else {
                fwd.context().ifPresent(c -> c.onError((Objective)fwd, ObjectiveError.GROUPMISSING));
            }
        }
    }

    private void installObjective(FlowRule.Builder ruleBuilder, final Objective objective) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        switch (objective.op()) {
            case ADD: {
                flowBuilder.add(ruleBuilder.build());
                break;
            }
            case REMOVE: {
                flowBuilder.remove(ruleBuilder.build());
                break;
            }
            default: {
                this.log.warn("Unknown operation {}", (Object)objective.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onSuccess(objective));
            }

            public void onError(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onError(objective, ObjectiveError.FLOWINSTALLATIONFAILED));
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        this.pendingNext.put((Object)nextObjective.id(), (Object)nextObjective);
        this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new SingleGroup((GroupKey)new DefaultGroupKey(this.appKryo.serialize((Object)nextObjective.id()))));
        nextObjective.context().ifPresent(context -> context.onSuccess((Objective)nextObjective));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    private class SingleGroup
    implements NextGroup {
        private final GroupKey key;

        public SingleGroup(GroupKey key) {
            this.key = key;
        }

        public GroupKey key() {
            return this.key;
        }

        public byte[] data() {
            return DefaultSingleTablePipeline.this.appKryo.serialize((Object)this.key);
        }
    }
}

