/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.extensions.Ofdpa3MplsType;
import org.onosproject.driver.extensions.Ofdpa3SetMplsType;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.pipeline.Ofdpa2GroupHandler;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.ExtensionCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa2Pipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    protected static final int PORT_TABLE = 0;
    protected static final int VLAN_TABLE = 10;
    protected static final int VLAN_1_TABLE = 11;
    protected static final int MPLS_L2_PORT_FLOW_TABLE = 13;
    protected static final int MPLS_L2_PORT_PCP_TRUST_FLOW_TABLE = 16;
    protected static final int TMAC_TABLE = 20;
    protected static final int UNICAST_ROUTING_TABLE = 30;
    protected static final int MULTICAST_ROUTING_TABLE = 40;
    protected static final int MPLS_TABLE_0 = 23;
    protected static final int MPLS_TABLE_1 = 24;
    protected static final int MPLS_L3_TYPE_TABLE = 27;
    protected static final int MPLS_TYPE_TABLE = 29;
    protected static final int BRIDGING_TABLE = 50;
    protected static final int ACL_TABLE = 60;
    protected static final int MAC_LEARNING_TABLE = 254;
    protected static final long OFPP_MAX = 0xFFFFFF00L;
    protected static final int HIGHEST_PRIORITY = 65535;
    protected static final int DEFAULT_PRIORITY = 32768;
    protected static final int LOWEST_PRIORITY = 0;
    protected static final int MPLS_L2_PORT_PRIORITY = 2;
    protected static final int MPLS_TUNNEL_ID_BASE = 65536;
    protected static final int MPLS_TUNNEL_ID_MAX = 131071;
    protected static final int MPLS_UNI_PORT_MAX = 65535;
    protected static final int MPLS_NNI_PORT_BASE = 131072;
    protected static final int MPLS_NNI_PORT_MAX = 196607;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ServiceDirectory serviceDirectory;
    protected FlowRuleService flowRuleService;
    protected CoreService coreService;
    protected GroupService groupService;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId driverId;
    protected DeviceService deviceService;
    protected static KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{Ofdpa2GroupHandler.OfdpaNextGroup.class}).register(new Class[]{ArrayDeque.class}).build("Ofdpa2Pipeline");
    protected Ofdpa2GroupHandler groupHandler;
    protected Set<IPCriterion> sentIpFilters = Collections.newSetFromMap(new ConcurrentHashMap());
    protected ScheduledExecutorService executorService = Executors.newScheduledThreadPool(5, Tools.groupedThreads((String)"OfdpaPipeliner", (String)"retry-%d", (Logger)this.log));
    protected static final int MAX_RETRY_ATTEMPTS = 10;
    protected static final int RETRY_MS = 1000;

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.deviceId = deviceId;
        this.groupHandler = new Ofdpa2GroupHandler();
        this.groupHandler.init(deviceId, context);
        this.serviceDirectory = context.directory();
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.Ofdpa2Pipeline");
        this.initializePipeline();
    }

    protected void initializePipeline() {
    }

    public void filter(FilteringObjective filteringObjective) {
        if (filteringObjective.type() == FilteringObjective.Type.PERMIT) {
            this.processFilter(filteringObjective, filteringObjective.op() == Objective.Operation.ADD, filteringObjective.appId());
        } else {
            this.log.debug("filter objective other than PERMIT currently not supported");
            Ofdpa2Pipeline.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
        }
    }

    public void forward(ForwardingObjective fwd) {
        Collection<FlowRule> rules = this.processForward(fwd);
        if (rules == null || rules.isEmpty()) {
            return;
        }
        this.sendForward(fwd, rules);
    }

    protected void sendForward(final ForwardingObjective fwd, Collection<FlowRule> rules) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).add(arg_0));
                this.log.debug("Applying a add fwd-obj {} to sw:{}", (Object)fwd.id(), (Object)this.deviceId);
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).remove(arg_0));
                this.log.debug("Deleting a flow rule to sw:{}", (Object)this.deviceId);
                break;
            }
            default: {
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                Ofdpa2Pipeline.pass((Objective)fwd);
            }

            public void onError(FlowRuleOperations ops) {
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    public void next(NextObjective nextObjective) {
        NextGroup nextGroup = this.flowObjectiveStore.getNextGroup(Integer.valueOf(nextObjective.id()));
        switch (nextObjective.op()) {
            case ADD: {
                if (nextGroup != null) {
                    this.log.warn("Cannot add next {} that already exists in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id{} in dev{} - add group", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.addGroup(nextObjective);
                break;
            }
            case ADD_TO_EXISTING: {
                if (nextGroup != null) {
                    this.log.debug("Processing NextObjective id{} in dev{} - add bucket", (Object)nextObjective.id(), (Object)this.deviceId);
                    this.groupHandler.addBucketToGroup(nextObjective, nextGroup);
                    break;
                }
                this.log.debug("Waiting to add bucket to group for next-id:{} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.pendingBuckets.put(nextObjective.id(), nextObjective);
                break;
            }
            case REMOVE: {
                if (nextGroup == null) {
                    this.log.warn("Cannot remove next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id{}  in dev{} - remove group", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.removeGroup(nextObjective, nextGroup);
                break;
            }
            case REMOVE_FROM_EXISTING: {
                if (nextGroup == null) {
                    this.log.warn("Cannot remove from next {} that does not exist in device {}", (Object)nextObjective.id(), (Object)this.deviceId);
                    return;
                }
                this.log.debug("Processing NextObjective id{} in dev{} - remove bucket", (Object)nextObjective.id(), (Object)this.deviceId);
                this.groupHandler.removeBucketFromGroup(nextObjective, nextGroup);
                break;
            }
            default: {
                this.log.warn("Unsupported operation {}", (Object)nextObjective.op());
            }
        }
    }

    protected void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        PortCriterion portCriterion = null;
        EthCriterion ethCriterion = null;
        VlanIdCriterion vidCriterion = null;
        ArrayList<IPCriterion> ips = new ArrayList<IPCriterion>();
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            Ofdpa2Pipeline.fail((Objective)filt, ObjectiveError.BADPARAMS);
            return;
        }
        portCriterion = (PortCriterion)filt.key();
        this.log.debug("Received filtering objective for dev/port: {}/{}", (Object)this.deviceId, (Object)portCriterion.port());
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Object criterion : filt.conditions()) {
            if (criterion.type() == Criterion.Type.ETH_DST || criterion.type() == Criterion.Type.ETH_DST_MASKED) {
                ethCriterion = (EthCriterion)criterion;
                continue;
            }
            if (criterion.type() == Criterion.Type.VLAN_VID) {
                vidCriterion = (VlanIdCriterion)criterion;
                continue;
            }
            if (criterion.type() == Criterion.Type.IPV4_DST) {
                ips.add((IPCriterion)criterion);
                continue;
            }
            this.log.error("Unsupported filter {}", criterion);
            Ofdpa2Pipeline.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
            return;
        }
        VlanId assignedVlan = null;
        if (vidCriterion != null) {
            if (filt.meta() != null) {
                assignedVlan = Ofdpa2Pipeline.readVlanFromTreatment(filt.meta());
            } else if (!vidCriterion.vlanId().equals((Object)VlanId.NONE)) {
                assignedVlan = vidCriterion.vlanId();
            }
            if (assignedVlan == null) {
                this.log.error("Driver fails to extract VLAN information. Not proccessing VLAN filters on device {}.", (Object)this.deviceId);
                this.log.debug("VLAN ID in criterion={}, metadata={}", (Object)Ofdpa2Pipeline.readVlanFromTreatment(filt.meta()), (Object)vidCriterion.vlanId());
                Ofdpa2Pipeline.fail((Objective)filt, ObjectiveError.BADPARAMS);
                return;
            }
        }
        if (ethCriterion == null || ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            this.log.debug("filtering objective missing dstMac, cannot program TMAC table");
        } else {
            for (FlowRule tmacRule : this.processEthDstFilter(portCriterion, ethCriterion, vidCriterion, assignedVlan, applicationId)) {
                this.log.debug("adding MAC filtering rules in TMAC table: {} for dev: {}", (Object)tmacRule, (Object)this.deviceId);
                ops = install ? ops.add(tmacRule) : ops.remove(tmacRule);
            }
        }
        if (vidCriterion == null) {
            this.log.debug("filtering objective missing dstMac or VLAN, cannot program VLAN Table");
        } else {
            List<FlowRule> allRules = this.processVlanIdFilter(portCriterion, vidCriterion, assignedVlan, applicationId);
            ArrayList filteringRules = new ArrayList();
            ArrayList assignmentRules = new ArrayList();
            allRules.forEach(flowRule -> {
                ExtensionCriterion extCriterion = (ExtensionCriterion)flowRule.selector().getCriterion(Criterion.Type.EXTENSION);
                VlanId vlanId = ((OfdpaMatchVlanVid)extCriterion.extensionSelector()).vlanId();
                if (!vlanId.equals((Object)VlanId.NONE)) {
                    filteringRules.add(flowRule);
                } else {
                    assignmentRules.add(flowRule);
                }
            });
            for (FlowRule filteringRule : filteringRules) {
                this.log.debug("adding VLAN filtering rule in VLAN table: {} for dev: {}", (Object)filteringRule, (Object)this.deviceId);
                ops = install ? ops.add(filteringRule) : ops.remove(filteringRule);
            }
            ops.newStage();
            for (FlowRule assignmentRule : assignmentRules) {
                this.log.debug("adding VLAN assignment rule in VLAN table: {} for dev: {}", (Object)assignmentRule, (Object)this.deviceId);
                ops = install ? ops.add(assignmentRule) : ops.remove(assignmentRule);
            }
        }
        for (IPCriterion ipaddr : ips) {
            if (this.sentIpFilters.contains(ipaddr)) continue;
            this.sentIpFilters.add(ipaddr);
            this.log.debug("adding IP filtering rules in ACL table {} for dev: {}", (Object)ipaddr, (Object)this.deviceId);
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPDst(ipaddr.ip());
            treatment.setOutput(PortNumber.CONTROLLER);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).fromApp(applicationId).makePermanent().forTable(60).build();
            ops = install ? ops.add(rule) : ops.remove(rule);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                Ofdpa2Pipeline.this.log.info("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)Ofdpa2Pipeline.this.deviceId);
                Ofdpa2Pipeline.pass((Objective)filt);
            }

            public void onError(FlowRuleOperations ops) {
                Ofdpa2Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)Ofdpa2Pipeline.this.deviceId);
                Ofdpa2Pipeline.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    protected List<FlowRule> processVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        return this.processVlanIdFilterInternal(portCriterion, vidCriterion, assignedVlan, applicationId, true);
    }

    protected List<FlowRule> processVlanIdFilterInternal(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId, boolean useSetVlanExtension) {
        OfdpaSetVlanVid ofdpaSetVlanVid;
        OfdpaMatchVlanVid ofdpaMatchVlanVid;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder preSelector = null;
        TrafficTreatment.Builder preTreatment = null;
        treatment.transition(Integer.valueOf(20));
        if (vidCriterion.vlanId() == VlanId.NONE) {
            ofdpaMatchVlanVid = new OfdpaMatchVlanVid(VlanId.NONE);
            selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            if (useSetVlanExtension) {
                ofdpaSetVlanVid = new OfdpaSetVlanVid(assignedVlan);
                treatment.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
            } else {
                treatment.setVlanId(assignedVlan);
            }
            preSelector = DefaultTrafficSelector.builder();
            OfdpaMatchVlanVid preOfdpaMatchVlanVid = new OfdpaMatchVlanVid(assignedVlan);
            preSelector.extension((ExtensionSelector)preOfdpaMatchVlanVid, this.deviceId);
            preTreatment = DefaultTrafficTreatment.builder().transition(Integer.valueOf(20));
        } else {
            ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vidCriterion.vlanId());
            selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            if (!assignedVlan.equals((Object)vidCriterion.vlanId())) {
                if (useSetVlanExtension) {
                    ofdpaSetVlanVid = new OfdpaSetVlanVid(assignedVlan);
                    treatment.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                } else {
                    treatment.setVlanId(assignedVlan);
                }
            }
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        for (PortNumber pnum : portnums) {
            selector.matchInPort(pnum);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            if (preSelector != null) {
                preSelector.matchInPort(pnum);
                FlowRule preRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(preSelector.build()).withTreatment(preTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
                rules.add(preRule);
            }
            rules.add(rule);
        }
        return rules;
    }

    protected List<FlowRule> processEthDstFilter(PortCriterion portCriterion, EthCriterion ethCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        if (portCriterion != null && portCriterion.port() == PortNumber.ANY) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId);
        }
        if (ethCriterion.mask() != null) {
            return this.processMcastEthDstFilter(ethCriterion, applicationId);
        }
        if (vidCriterion.vlanId() == VlanId.NONE) {
            vidCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (PortNumber pnum : portnums) {
            OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vidCriterion.vlanId());
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchEthDst(ethCriterion.mac());
            treatment.transition(Integer.valueOf(30));
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            selector.matchEthType(Ethernet.MPLS_UNICAST);
            selector.matchEthDst(ethCriterion.mac());
            treatment.transition(Integer.valueOf(23));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
        }
        return rules;
    }

    protected List<FlowRule> processEthDstOnlyFilter(EthCriterion ethCriterion, ApplicationId applicationId) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        treatment.transition(Integer.valueOf(30));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        return ImmutableList.builder().add((Object)rule).build();
    }

    protected List<FlowRule> processMcastEthDstFilter(EthCriterion ethCriterion, ApplicationId applicationId) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDstMasked(ethCriterion.mac(), ethCriterion.mask());
        treatment.transition(Integer.valueOf(40));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        return ImmutableList.builder().add((Object)rule).build();
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
        }
        Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.info("Processing versatile forwarding objective:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
        EthTypeCriterion ethType = (EthTypeCriterion)fwd.selector().getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.error("Versatile forwarding objective:{} must include ethType", (Object)fwd.id());
            Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        fwd.selector().criteria().forEach(criterion -> {
            if (criterion instanceof VlanIdCriterion) {
                VlanId vlanId = ((VlanIdCriterion)criterion).vlanId();
                if (vlanId.equals((Object)VlanId.NONE)) {
                    return;
                }
                OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vlanId);
                sbuilder.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            } else {
                sbuilder.add(criterion);
            }
        });
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction ins : fwd.treatment().allInstructions()) {
                if (ins instanceof Instructions.OutputInstruction) {
                    Instructions.OutputInstruction o = (Instructions.OutputInstruction)ins;
                    if (o.port() == PortNumber.CONTROLLER) {
                        ttBuilder.add((Instruction)o);
                        continue;
                    }
                    this.log.warn("Only allowed treatments in versatile forwarding objectives are punts to the controller");
                    continue;
                }
                this.log.warn("Cannot process instruction in versatile fwd {}", (Object)ins);
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            ttBuilder.deferred().group(group.id());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
        return Collections.singletonList(ruleBuilder.build());
    }

    protected Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific fwd objective:{} in dev:{} with next:{}", new Object[]{fwd.id(), this.deviceId, fwd.nextId()});
        boolean isEthTypeObj = this.isSupportedEthTypeObjective(fwd);
        boolean isEthDstObj = this.isSupportedEthDstObjective(fwd);
        if (isEthTypeObj) {
            return this.processEthTypeSpecific(fwd);
        }
        if (isEthDstObj) {
            return this.processEthDstSpecific(fwd);
        }
        this.log.warn("processSpecific: Unsupported forwarding objective criteria fwd:{} in dev:{}", (Object)fwd.nextId(), (Object)this.deviceId);
        Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
        return Collections.emptySet();
    }

    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        return this.processEthTypeSpecificInternal(fwd, false, 60);
    }

    protected Collection<FlowRule> processEthTypeSpecificInternal(ForwardingObjective fwd, boolean allowDefaultRoute, int mplsNextTable) {
        int forTableId;
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        boolean popMpls = false;
        boolean emptyGroup = false;
        TrafficSelector.Builder filteredSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder complementarySelector = DefaultTrafficSelector.builder();
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            if (this.buildIpv4Selector(filteredSelector, complementarySelector, fwd, allowDefaultRoute) < 0) {
                return Collections.emptyList();
            }
            IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            forTableId = ipv4Dst.isMulticast() ? 40 : 30;
            if (fwd.treatment() != null) {
                for (Instruction instr : fwd.treatment().allInstructions()) {
                    if (instr instanceof L3ModificationInstruction && ((L3ModificationInstruction)instr).subtype() != L3ModificationInstruction.L3SubType.DEC_TTL) continue;
                }
            }
        } else {
            filteredSelector.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            MplsBosCriterion bos = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
            if (bos != null) {
                filteredSelector.matchMplsBos(bos.mplsBos());
            }
            forTableId = 24;
            this.log.debug("processing MPLS specific forwarding objective {} -> next:{} in dev {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            if (fwd.treatment() != null) {
                for (Instruction instr : fwd.treatment().allInstructions()) {
                    if (instr instanceof L2ModificationInstruction && ((L2ModificationInstruction)instr).subtype() == L2ModificationInstruction.L2SubType.MPLS_POP) {
                        popMpls = true;
                        if (mplsNextTable == 29 && bos != null && !bos.mplsBos()) {
                            tb.immediate().popMpls();
                        }
                    }
                    if (instr instanceof L3ModificationInstruction && ((L3ModificationInstruction)instr).subtype() == L3ModificationInstruction.L3SubType.DEC_TTL) {
                        tb.immediate().decMplsTtl();
                    }
                    if (!(instr instanceof L3ModificationInstruction) || ((L3ModificationInstruction)instr).subtype() != L3ModificationInstruction.L3SubType.TTL_IN) continue;
                    tb.immediate().add(instr);
                }
            }
        }
        if (fwd.nextId() != null) {
            if (forTableId == 24 && !popMpls) {
                this.log.warn("SR CONTINUE case cannot be handled as MPLS ECMP is not implemented in OF-DPA yet. Aborting this flow {} -> next:{}in this device {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                return Collections.emptySet();
            }
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            if (next != null) {
                List gkeys = (List)appKryo.deserialize(next.data());
                Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
                if (Ofdpa2Pipeline.isNotMplsBos(selector) && group.type().equals((Object)NextObjective.Type.HASHED)) {
                    this.log.warn("SR CONTINUE case cannot be handled as MPLS ECMP is not implemented in OF-DPA yet. Aborting this flow {} -> next:{}in this device {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
                    Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                    return Collections.emptySet();
                }
                if (group == null) {
                    this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                    Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                    return Collections.emptySet();
                }
                tb.deferred().group(group.id());
                if (gkeys.size() == 1 && ((Deque)gkeys.get(0)).size() == 1) {
                    this.log.warn("Found empty group 0x{} in dev:{} .. will retry fwd:{}", new Object[]{Integer.toHexString((Integer)group.id().id()), this.deviceId, fwd.id()});
                    emptyGroup = true;
                }
            } else {
                this.log.warn("Cannot find group for nextId:{} in dev:{}. Aborting fwd:{}", new Object[]{fwd.nextId(), this.deviceId, fwd.id()});
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                return Collections.emptySet();
            }
        }
        if (forTableId == 24) {
            if (mplsNextTable == 27) {
                Ofdpa3SetMplsType setMplsType = new Ofdpa3SetMplsType(Ofdpa3MplsType.L3_PHP);
                tb.immediate().extension((ExtensionTreatment)setMplsType, this.deviceId);
            }
            tb.transition(Integer.valueOf(mplsNextTable));
        } else {
            tb.transition(Integer.valueOf(60));
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ArrayList<FlowRule> flowRuleCollection = new ArrayList<FlowRule>();
        flowRuleCollection.add(ruleBuilder.build());
        if (!allowDefaultRoute) {
            flowRuleCollection.add(this.defaultRoute(fwd, complementarySelector, forTableId, tb));
            this.log.debug("Default rule 0.0.0.0/0 is being installed two rules");
        }
        if (emptyGroup) {
            this.executorService.schedule(new RetryFlows(fwd, flowRuleCollection), 1000L, TimeUnit.MILLISECONDS);
        }
        return flowRuleCollection;
    }

    protected int buildIpv4Selector(TrafficSelector.Builder builderToUpdate, TrafficSelector.Builder extBuilder, ForwardingObjective fwd, boolean allowDefaultRoute) {
        TrafficSelector selector = fwd.selector();
        IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
        if (ipv4Dst.isMulticast()) {
            if (ipv4Dst.prefixLength() != 32) {
                this.log.warn("Multicast specific forwarding objective can only be /32");
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return -1;
            }
            VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(fwd.meta());
            if (assignedVlan == null) {
                this.log.warn("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                return -1;
            }
            OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(assignedVlan);
            builderToUpdate.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
            builderToUpdate.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
            this.log.debug("processing IPv4 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            if (ipv4Dst.prefixLength() == 0) {
                if (allowDefaultRoute) {
                    builderToUpdate.matchEthType(Ethernet.TYPE_IPV4);
                } else {
                    builderToUpdate.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(IpPrefix.valueOf((String)"0.0.0.0/1"));
                    extBuilder.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(IpPrefix.valueOf((String)"128.0.0.0/1"));
                }
            } else {
                builderToUpdate.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
            }
            this.log.debug("processing IPv4 unicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        }
        return 0;
    }

    protected FlowRule defaultRoute(ForwardingObjective fwd, TrafficSelector.Builder complementarySelector, int forTableId, TrafficTreatment.Builder tb) {
        FlowRule.Builder rule = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(complementarySelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            rule.makePermanent();
        } else {
            rule.makeTemporary(fwd.timeout());
        }
        return rule.build();
    }

    protected Collection<FlowRule> processEthDstSpecific(ForwardingObjective fwd) {
        NextGroup next;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector selector = fwd.selector();
        EthCriterion ethCriterion = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.warn("Forwarding objective for bridging requires vlan. Not installing fwd:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        if (!ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            filteredSelectorBuilder.matchEthDst(ethCriterion.mac());
            this.log.debug("processing L2 forwarding objective:{} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            this.log.debug("processing L2 Broadcast forwarding objective:{} -> next:{} in dev:{} for vlan:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId, vlanIdCriterion.vlanId()});
        }
        OfdpaMatchVlanVid ofdpaMatchVlanVid = new OfdpaMatchVlanVid(vlanIdCriterion.vlanId());
        filteredSelectorBuilder.extension((ExtensionSelector)ofdpaMatchVlanVid, this.deviceId);
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        if (fwd.treatment() != null) {
            this.log.warn("Ignoring traffic treatment in fwd rule {} meant for L2 tablefor dev:{}. Expecting only nextId", (Object)fwd.id(), (Object)this.deviceId);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group != null) {
                treatmentBuilder.deferred().group(group.id());
            } else {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                Ofdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        treatmentBuilder.immediate().transition(Integer.valueOf(60));
        TrafficTreatment filteredTreatment = treatmentBuilder.build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRuleBuilder.fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(filteredTreatment).forTable(50);
        if (fwd.permanent()) {
            flowRuleBuilder.makePermanent();
        } else {
            flowRuleBuilder.makeTemporary(fwd.timeout());
        }
        rules.add(flowRuleBuilder.build());
        return rules;
    }

    private boolean isSupportedEthTypeObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        return ethType != null && (ethType.ethType().toShort() == Ethernet.TYPE_IPV4 || ethType.ethType().toShort() == Ethernet.MPLS_UNICAST);
    }

    private boolean isSupportedEthDstObjective(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        EthCriterion ethDst = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanId = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        return ethDst != null || vlanId != null;
    }

    protected NextGroup getGroupForNextObjective(Integer nextId) {
        NextGroup next = this.flowObjectiveStore.getNextGroup(nextId);
        if (next != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            if (gkeys != null && !gkeys.isEmpty()) {
                return next;
            }
            this.log.warn("Empty next group found in FlowObjective store for next-id:{} in dev:{}", (Object)nextId, (Object)this.deviceId);
        } else {
            this.log.warn("next-id {} not found in Flow objective store for dev:{}", (Object)nextId, (Object)this.deviceId);
        }
        return null;
    }

    protected static void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    protected static void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        ArrayList<String> mappings = new ArrayList<String>();
        List gkeys = (List)appKryo.deserialize(nextGroup.data());
        for (Deque gkd : gkeys) {
            Group lastGroup = null;
            StringBuffer gchain = new StringBuffer();
            for (GroupKey gk : gkd) {
                Group g = this.groupService.getGroup(this.deviceId, gk);
                if (g == null) {
                    gchain.append("  NoGrp").append(" -->");
                    continue;
                }
                gchain.append("  0x").append(Integer.toHexString((Integer)g.id().id())).append(" -->");
                lastGroup = g;
            }
            List lastGroupIns = new ArrayList();
            if (lastGroup != null && !lastGroup.buckets().buckets().isEmpty()) {
                lastGroupIns = ((GroupBucket)lastGroup.buckets().buckets().get(0)).treatment().allInstructions();
            }
            for (Instruction i : lastGroupIns) {
                if (!(i instanceof Instructions.OutputInstruction)) continue;
                gchain.append(" port:").append(((Instructions.OutputInstruction)i).port());
            }
            mappings.add(gchain.toString());
        }
        return mappings;
    }

    protected static VlanId readVlanFromSelector(TrafficSelector selector) {
        if (selector == null) {
            return null;
        }
        Criterion criterion = selector.getCriterion(Criterion.Type.VLAN_VID);
        return criterion == null ? null : ((VlanIdCriterion)criterion).vlanId();
    }

    protected static IpPrefix readIpDstFromSelector(TrafficSelector selector) {
        if (selector == null) {
            return null;
        }
        Criterion criterion = selector.getCriterion(Criterion.Type.IPV4_DST);
        return criterion == null ? null : ((IPCriterion)criterion).ip();
    }

    private static VlanId readVlanFromTreatment(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction i : treatment.allInstructions()) {
            if (!(i instanceof L2ModificationInstruction.ModVlanIdInstruction)) continue;
            return ((L2ModificationInstruction.ModVlanIdInstruction)i).vlanId();
        }
        return null;
    }

    static boolean isMplsBos(TrafficSelector selector) {
        MplsBosCriterion bosCriterion = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
        return bosCriterion != null && bosCriterion.mplsBos();
    }

    static boolean isNotMplsBos(TrafficSelector selector) {
        MplsBosCriterion bosCriterion = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
        return bosCriterion != null && !bosCriterion.mplsBos();
    }

    protected final class RetryFlows
    implements Runnable {
        int attempts = 10;
        private Collection<FlowRule> retryFlows;
        private ForwardingObjective fwd;

        RetryFlows(ForwardingObjective fwd, Collection<FlowRule> retryFlows) {
            this.fwd = fwd;
            this.retryFlows = retryFlows;
        }

        @Override
        public void run() {
            Ofdpa2Pipeline.this.log.info("RETRY FLOWS ATTEMPT# {} for fwd:{} rules:{}", new Object[]{10 - this.attempts, this.fwd.id(), this.retryFlows.size()});
            Ofdpa2Pipeline.this.sendForward(this.fwd, this.retryFlows);
            if (--this.attempts > 0) {
                Ofdpa2Pipeline.this.executorService.schedule(this, 1000L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

