/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.driver.extensions.MoveExtensionTreatment;
import org.onosproject.driver.extensions.NiciraEncapEthDst;
import org.onosproject.driver.extensions.NiciraEncapEthSrc;
import org.onosproject.driver.extensions.NiciraEncapEthType;
import org.onosproject.driver.extensions.NiciraMoveTreatmentFactory;
import org.onosproject.driver.extensions.NiciraNshMdType;
import org.onosproject.driver.extensions.NiciraNshNp;
import org.onosproject.driver.extensions.NiciraPopNsh;
import org.onosproject.driver.extensions.NiciraPushNsh;
import org.onosproject.driver.extensions.NiciraResubmit;
import org.onosproject.driver.extensions.NiciraResubmitTable;
import org.onosproject.driver.extensions.NiciraSetNshContextHeader;
import org.onosproject.driver.extensions.NiciraSetNshSi;
import org.onosproject.driver.extensions.NiciraSetNshSpi;
import org.onosproject.driver.extensions.NiciraSetTunnelDst;
import org.onosproject.driver.extensions.NiciraTunGpeNp;
import org.onosproject.net.NshContextHeader;
import org.onosproject.net.NshServiceIndex;
import org.onosproject.net.NshServicePathId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.openflow.controller.ExtensionTreatmentInterpreter;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionExperimenter;
import org.projectfloodlight.openflow.protocol.action.OFActionNicira;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraMove;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraResubmit;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraResubmitTable;
import org.projectfloodlight.openflow.protocol.action.OFActionSetField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthDst;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthSrc;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthType;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshC1;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshC2;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshC3;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshC4;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshMdtype;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNshNp;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNsi;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNsp;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunGpeNp;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunnelIpv4Dst;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;

public class NiciraExtensionTreatmentInterpreter
extends AbstractHandlerBehaviour
implements ExtensionTreatmentInterpreter,
ExtensionTreatmentResolver {
    private static final int TYPE_NICIRA = 8992;
    private static final int SRC_ARP_SHA = 74246;
    private static final int SRC_ARP_SPA = 8196;
    private static final int SRC_ETH = 1030;
    private static final int SRC_IP = 3588;
    private static final int NSH_C1 = 124420;
    private static final int NSH_C2 = 124932;
    private static final int NSH_C3 = 125444;
    private static final int NSH_C4 = 125956;
    private static final int TUN_IPV4_DST = 81924;
    private static final int TUN_ID = 73736;
    private static final int SUB_TYPE_RESUBMIT = 1;
    private static final int SUB_TYPE_RESUBMIT_TABLE = 14;
    private static final int SUB_TYPE_MOVE = 6;
    private static final int SUB_TYPE_PUSH_NSH = 38;
    private static final int SUB_TYPE_POP_NSH = 39;
    private static final String TUNNEL_DST = "tunnelDst";
    private static final String RESUBMIT = "resubmit";
    private static final String RESUBMIT_TABLE = "resubmitTable";
    private static final String NICIRA_NSH_SPI = "niciraNshSpi";
    private static final String NICIRA_NSH_SI = "niciraNshSi";
    private static final String NICIRA_NSH_CH = "niciraNshCh";
    private static final String NICIRA_MOVE = "niciraMove";
    private static final String TYPE = "type";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraExtensionTreatmentInterpreter";

    public boolean supported(ExtensionTreatmentType extensionTreatmentType) {
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SPI.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SI.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SHA_TO_THA.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SPA_TO_TPA.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ETH_SRC_TO_DST.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_IP_SRC_TO_DST.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_MDTYPE.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_NP.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_SRC.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_DST.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_TYPE.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_PUSH_NSH.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_POP_NSH.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_TUN_GPE_NP.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C1_TO_C1.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_C2.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C3_TO_C3.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C4_TO_C4.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_IPV4_DST_TO_TUN_IPV4_DST.type())) {
            return true;
        }
        if (extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_ID_TO_TUN_ID.type())) {
            return true;
        }
        return extensionTreatmentType.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_TUN_ID.type());
    }

    public OFAction mapInstruction(OFFactory factory, ExtensionTreatment extensionTreatment) {
        ExtensionTreatmentType type = extensionTreatment.type();
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type())) {
            NiciraSetTunnelDst tunnelDst = (NiciraSetTunnelDst)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().tunnelIpv4Dst(IPv4Address.of((int)tunnelDst.tunnelDst().toInt())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT.type())) {
            NiciraResubmit resubmit = (NiciraResubmit)extensionTreatment;
            return factory.actions().niciraResubmit((int)resubmit.inPort().toLong(), resubmit.table());
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type())) {
            NiciraResubmitTable resubmitTable = (NiciraResubmitTable)extensionTreatment;
            return factory.actions().niciraResubmitTable((int)resubmitTable.inPort().toLong(), resubmitTable.table());
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SPI.type())) {
            NiciraSetNshSpi niciraNshSpi = (NiciraSetNshSpi)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nsp(U32.of((long)niciraNshSpi.nshSpi().servicePathId())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SI.type())) {
            NiciraSetNshSi niciraNshSi = (NiciraSetNshSi)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nsi(U8.of((short)niciraNshSi.nshSi().serviceIndex())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type())) {
            NiciraSetNshContextHeader niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nshC1(U32.of((long)niciraNshch.nshCh().nshContextHeader())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type())) {
            NiciraSetNshContextHeader niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nshC2(U32.of((long)niciraNshch.nshCh().nshContextHeader())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type())) {
            NiciraSetNshContextHeader niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nshC3(U32.of((long)niciraNshch.nshCh().nshContextHeader())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type())) {
            NiciraSetNshContextHeader niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nshC4(U32.of((long)niciraNshch.nshCh().nshContextHeader())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_MDTYPE.type())) {
            NiciraNshMdType niciraNshMdType = (NiciraNshMdType)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nshMdtype(U8.of((short)niciraNshMdType.nshMdType())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_NP.type())) {
            NiciraNshNp niciraNshNp = (NiciraNshNp)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().nshNp(U8.of((short)niciraNshNp.nshNp())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_SRC.type())) {
            NiciraEncapEthSrc niciraEncapEthSrc = (NiciraEncapEthSrc)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().encapEthSrc(org.projectfloodlight.openflow.types.MacAddress.of((byte[])niciraEncapEthSrc.encapEthSrc().toBytes())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_DST.type())) {
            NiciraEncapEthDst niciraEncapEthDst = (NiciraEncapEthDst)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().encapEthDst(org.projectfloodlight.openflow.types.MacAddress.of((byte[])niciraEncapEthDst.encapEthDst().toBytes())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_TYPE.type())) {
            NiciraEncapEthType niciraEncapEthType = (NiciraEncapEthType)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().encapEthType(U16.of((int)niciraEncapEthType.encapEthType())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_PUSH_NSH.type())) {
            return factory.actions().niciraPushNsh();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_POP_NSH.type())) {
            return factory.actions().niciraPopNsh();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_TUN_GPE_NP.type())) {
            NiciraTunGpeNp niciraTunGpeNp = (NiciraTunGpeNp)extensionTreatment;
            return factory.actions().setField((OFOxm)factory.oxms().tunGpeNp(U8.of((short)niciraTunGpeNp.tunGpeNp())));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SHA_TO_THA.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SPA_TO_TPA.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ETH_SRC_TO_DST.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_IP_SRC_TO_DST.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C1_TO_C1.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_C2.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C3_TO_C3.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C4_TO_C4.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_IPV4_DST_TO_TUN_IPV4_DST.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_ID_TO_TUN_ID.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_TUN_ID.type())) {
            MoveExtensionTreatment mov = (MoveExtensionTreatment)extensionTreatment;
            OFActionNiciraMove.Builder action = factory.actions().buildNiciraMove();
            action.setDstOfs(mov.dstOffset());
            action.setSrcOfs(mov.srcOffset());
            action.setNBits(mov.nBits());
            action.setSrc((long)mov.src());
            action.setDst((long)mov.dst());
            return action.build();
        }
        return null;
    }

    public ExtensionTreatment mapAction(OFAction action) throws UnsupportedOperationException {
        OFActionExperimenter experimenter;
        if (action.getType().equals((Object)OFActionType.SET_FIELD)) {
            OFActionSetField setFieldAction = (OFActionSetField)action;
            OFOxm oxm = setFieldAction.getField();
            switch (oxm.getMatchField().id) {
                case TUNNEL_IPV4_DST: {
                    OFOxmTunnelIpv4Dst tunnelIpv4Dst = (OFOxmTunnelIpv4Dst)oxm;
                    return new NiciraSetTunnelDst(Ip4Address.valueOf((int)tunnelIpv4Dst.getValue().getInt()));
                }
                case NSP: {
                    OFOxmNsp nsp = (OFOxmNsp)oxm;
                    return new NiciraSetNshSpi(NshServicePathId.of((int)nsp.getValue().getRaw()));
                }
                case NSI: {
                    OFOxmNsi nsi = (OFOxmNsi)oxm;
                    return new NiciraSetNshSi(NshServiceIndex.of((short)nsi.getValue().getRaw()));
                }
                case NSH_C1: {
                    OFOxmNshC1 nshC1 = (OFOxmNshC1)oxm;
                    return new NiciraSetNshContextHeader(NshContextHeader.of((int)nshC1.getValue().getRaw()), ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type());
                }
                case NSH_C2: {
                    OFOxmNshC2 nshC2 = (OFOxmNshC2)oxm;
                    return new NiciraSetNshContextHeader(NshContextHeader.of((int)nshC2.getValue().getRaw()), ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type());
                }
                case NSH_C3: {
                    OFOxmNshC3 nshC3 = (OFOxmNshC3)oxm;
                    return new NiciraSetNshContextHeader(NshContextHeader.of((int)nshC3.getValue().getRaw()), ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type());
                }
                case NSH_C4: {
                    OFOxmNshC4 nshC4 = (OFOxmNshC4)oxm;
                    return new NiciraSetNshContextHeader(NshContextHeader.of((int)nshC4.getValue().getRaw()), ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type());
                }
                case NSH_MDTYPE: {
                    OFOxmNshMdtype nshMdType = (OFOxmNshMdtype)oxm;
                    return new NiciraNshMdType(nshMdType.getValue().getRaw());
                }
                case NSH_NP: {
                    OFOxmNshNp nshNp = (OFOxmNshNp)oxm;
                    return new NiciraNshNp(nshNp.getValue().getRaw());
                }
                case ENCAP_ETH_SRC: {
                    OFOxmEncapEthSrc encapEthSrc = (OFOxmEncapEthSrc)oxm;
                    return new NiciraEncapEthSrc(MacAddress.valueOf((byte[])encapEthSrc.getValue().getBytes()));
                }
                case ENCAP_ETH_DST: {
                    OFOxmEncapEthDst encapEthDst = (OFOxmEncapEthDst)oxm;
                    return new NiciraEncapEthDst(MacAddress.valueOf((byte[])encapEthDst.getValue().getBytes()));
                }
                case ENCAP_ETH_TYPE: {
                    OFOxmEncapEthType encapEthType = (OFOxmEncapEthType)oxm;
                    return new NiciraEncapEthType(encapEthType.getValue().getRaw());
                }
                case TUN_GPE_NP: {
                    OFOxmTunGpeNp tunGpeNp = (OFOxmTunGpeNp)oxm;
                    return new NiciraTunGpeNp(tunGpeNp.getValue().getRaw());
                }
            }
            throw new UnsupportedOperationException("Driver does not support extension type " + oxm.getMatchField().id);
        }
        if (action.getType().equals((Object)OFActionType.EXPERIMENTER) && Long.valueOf((experimenter = (OFActionExperimenter)action).getExperimenter()).intValue() == 8992) {
            OFActionNicira nicira = (OFActionNicira)experimenter;
            switch (nicira.getSubtype()) {
                case 6: {
                    OFActionNiciraMove moveAction = (OFActionNiciraMove)nicira;
                    switch (Long.valueOf(moveAction.getSrc()).intValue()) {
                        case 74246: {
                            return NiciraMoveTreatmentFactory.createNiciraMovArpShaToTha();
                        }
                        case 1030: {
                            return NiciraMoveTreatmentFactory.createNiciraMovEthSrcToDst();
                        }
                        case 3588: {
                            return NiciraMoveTreatmentFactory.createNiciraMovIpSrcToDst();
                        }
                        case 8196: {
                            return NiciraMoveTreatmentFactory.createNiciraMovArpSpaToTpa();
                        }
                        case 124420: {
                            return NiciraMoveTreatmentFactory.createNiciraMovNshC1ToC1();
                        }
                        case 124932: {
                            if (Long.valueOf(moveAction.getDst()).intValue() == 73736) {
                                return NiciraMoveTreatmentFactory.createNiciraMovNshC2ToTunId();
                            }
                            return NiciraMoveTreatmentFactory.createNiciraMovNshC2ToC2();
                        }
                        case 125444: {
                            return NiciraMoveTreatmentFactory.createNiciraMovNshC3ToC3();
                        }
                        case 125956: {
                            return NiciraMoveTreatmentFactory.createNiciraMovNshC4ToC4();
                        }
                        case 81924: {
                            return NiciraMoveTreatmentFactory.createNiciraMovTunDstToTunDst();
                        }
                        case 73736: {
                            return NiciraMoveTreatmentFactory.createNiciraMovTunIdToTunId();
                        }
                    }
                    throw new UnsupportedOperationException("Driver does not support move from " + moveAction.getSrc() + " to " + moveAction.getDst() + "of length " + moveAction.getNBits());
                }
                case 1: {
                    OFActionNiciraResubmit resubmitAction = (OFActionNiciraResubmit)nicira;
                    return new NiciraResubmit(PortNumber.portNumber((long)resubmitAction.getInPort()));
                }
                case 38: {
                    return new NiciraPushNsh();
                }
                case 39: {
                    return new NiciraPopNsh();
                }
                case 14: {
                    OFActionNiciraResubmitTable resubmitTable = (OFActionNiciraResubmitTable)nicira;
                    return new NiciraResubmitTable(PortNumber.portNumber((long)resubmitTable.getInPort()), resubmitTable.getTable());
                }
            }
            throw new UnsupportedOperationException("Driver does not support extension subtype " + nicira.getSubtype());
        }
        return null;
    }

    public ExtensionTreatment getExtensionInstruction(ExtensionTreatmentType type) {
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type())) {
            return new NiciraSetTunnelDst();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT.type())) {
            return new NiciraResubmit();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type())) {
            return new NiciraResubmitTable();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SPI.type())) {
            return new NiciraSetNshSpi();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SI.type())) {
            return new NiciraSetNshSi();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type())) {
            return new NiciraSetNshContextHeader(type);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_PUSH_NSH.type())) {
            return new NiciraPushNsh();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_POP_NSH.type())) {
            return new NiciraPopNsh();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_MDTYPE.type())) {
            return new NiciraNshMdType();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_NSH_NP.type())) {
            return new NiciraNshNp();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_SRC.type())) {
            return new NiciraEncapEthSrc();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_DST.type())) {
            return new NiciraEncapEthDst();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_ENCAP_ETH_TYPE.type())) {
            return new NiciraEncapEthType();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SHA_TO_THA.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovArpShaToTha();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SPA_TO_TPA.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovArpSpaToTpa();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ETH_SRC_TO_DST.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovEthSrcToDst();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_IP_SRC_TO_DST.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovIpSrcToDst();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_TUN_GPE_NP.type())) {
            return new NiciraTunGpeNp();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C1_TO_C1.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovNshC1ToC1();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_C2.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovNshC2ToC2();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C3_TO_C3.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovNshC3ToC3();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C4_TO_C4.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovNshC4ToC4();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_IPV4_DST_TO_TUN_IPV4_DST.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovTunDstToTunDst();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_TUN_ID_TO_TUN_ID.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovTunIdToTunId();
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_NSH_C2_TO_TUN_ID.type())) {
            return NiciraMoveTreatmentFactory.createNiciraMovNshC2ToTunId();
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }

    public ObjectNode encode(ExtensionTreatment extensionTreatment, CodecContext context) {
        NiciraSetNshContextHeader niciraNshch;
        Preconditions.checkNotNull((Object)extensionTreatment, (Object)"Extension treatment cannot be null");
        ExtensionTreatmentType type = extensionTreatment.type();
        ObjectNode root = context.mapper().createObjectNode();
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type())) {
            NiciraSetTunnelDst tunnelDst = (NiciraSetTunnelDst)extensionTreatment;
            root.set(TUNNEL_DST, (JsonNode)context.codec(NiciraSetTunnelDst.class).encode((Object)tunnelDst, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT.type())) {
            NiciraResubmit resubmit = (NiciraResubmit)extensionTreatment;
            root.set(RESUBMIT, (JsonNode)context.codec(NiciraResubmit.class).encode((Object)resubmit, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type())) {
            NiciraResubmitTable resubmitTable = (NiciraResubmitTable)extensionTreatment;
            root.set(RESUBMIT_TABLE, (JsonNode)context.codec(NiciraResubmitTable.class).encode((Object)resubmitTable, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SPI.type())) {
            NiciraSetNshSpi niciraNshSpi = (NiciraSetNshSpi)extensionTreatment;
            root.set(NICIRA_NSH_SPI, (JsonNode)context.codec(NiciraSetNshSpi.class).encode((Object)niciraNshSpi, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SI.type())) {
            NiciraSetNshSi niciraNshSi = (NiciraSetNshSi)extensionTreatment;
            root.set(NICIRA_NSH_SI, (JsonNode)context.codec(NiciraSetNshSi.class).encode((Object)niciraNshSi, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type())) {
            niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            root.set(NICIRA_NSH_CH, (JsonNode)context.codec(NiciraSetNshContextHeader.class).encode((Object)niciraNshch, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type())) {
            niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            root.set(NICIRA_NSH_CH, (JsonNode)context.codec(NiciraSetNshContextHeader.class).encode((Object)niciraNshch, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type())) {
            niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            root.set(NICIRA_NSH_CH, (JsonNode)context.codec(NiciraSetNshContextHeader.class).encode((Object)niciraNshch, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type())) {
            niciraNshch = (NiciraSetNshContextHeader)extensionTreatment;
            root.set(NICIRA_NSH_CH, (JsonNode)context.codec(NiciraSetNshContextHeader.class).encode((Object)niciraNshch, context));
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SHA_TO_THA.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SPA_TO_TPA.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ETH_SRC_TO_DST.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_IP_SRC_TO_DST.type())) {
            MoveExtensionTreatment mov = (MoveExtensionTreatment)extensionTreatment;
            root.set(NICIRA_MOVE, (JsonNode)context.codec(MoveExtensionTreatment.class).encode((Object)mov, context));
        }
        return root;
    }

    public ExtensionTreatment decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int typeInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in NiciraExtensionTreatmentInterpreter")).asInt();
        ExtensionTreatmentType type = new ExtensionTreatmentType(typeInt);
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetTunnelDst.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT.type())) {
            return (ExtensionTreatment)context.codec(NiciraResubmit.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type())) {
            return (ExtensionTreatment)context.codec(NiciraResubmitTable.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SPI.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetNshSpi.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_SI.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetNshSi.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH1.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetNshContextHeader.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH2.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetNshContextHeader.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH3.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetNshContextHeader.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_NSH_CH4.type())) {
            return (ExtensionTreatment)context.codec(NiciraSetNshContextHeader.class).decode(json, context);
        }
        if (type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SHA_TO_THA.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SPA_TO_TPA.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ETH_SRC_TO_DST.type()) || type.equals((Object)ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_IP_SRC_TO_DST.type())) {
            return (ExtensionTreatment)context.codec(MoveExtensionTreatment.class).decode(json, context);
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }
}

