/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraResubmitTable;
import org.onosproject.net.PortNumber;

public final class NiciraResubmitTableCodec
extends JsonCodec<NiciraResubmitTable> {
    private static final String RESUBMIT_PORT = "inPort";
    private static final String RESUBMIT_TABLE = "table";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraResubmitTable";

    public ObjectNode encode(NiciraResubmitTable niciraResubmitTable, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraResubmitTable), (Object)"Nicira Resubmit Table cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(RESUBMIT_PORT, niciraResubmitTable.inPort().toLong()).put(RESUBMIT_TABLE, niciraResubmitTable.table());
        return root;
    }

    public NiciraResubmitTable decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        long portNumberLong = ((JsonNode)Tools.nullIsIllegal((Object)json.get(RESUBMIT_PORT), (String)"inPort member is required in NiciraResubmitTable")).asLong();
        PortNumber portNumber = PortNumber.portNumber((long)portNumberLong);
        short tableId = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(RESUBMIT_TABLE), (String)"table member is required in NiciraResubmitTable")).asInt();
        return new NiciraResubmitTable(portNumber, tableId);
    }
}

