/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.pipeline.CpqdOfdpa2GroupHandler;
import org.onosproject.driver.pipeline.Ofdpa2Pipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.packet.PacketPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpqdOfdpa2Pipeline
extends Ofdpa2Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        this.deviceId = deviceId;
        this.groupHandler = new CpqdOfdpa2GroupHandler();
        this.groupHandler.init(deviceId, context);
        this.serviceDirectory = context.directory();
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.CpqdOfdpa2Pipeline");
        this.initializePipeline();
    }

    @Override
    protected void processFilter(final FilteringObjective filt, boolean install, ApplicationId applicationId) {
        PortCriterion portCriterion = null;
        EthCriterion ethCriterion = null;
        VlanIdCriterion vidCriterion = null;
        ArrayList<IPCriterion> ips = new ArrayList<IPCriterion>();
        if (filt.key().equals(Criteria.dummy()) || filt.key().type() != Criterion.Type.IN_PORT) {
            this.log.warn("No key defined in filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
            CpqdOfdpa2Pipeline.fail((Objective)filt, ObjectiveError.UNKNOWN);
            return;
        }
        portCriterion = (PortCriterion)filt.key();
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        for (Object criterion : filt.conditions()) {
            if (criterion.type() == Criterion.Type.ETH_DST || criterion.type() == Criterion.Type.ETH_DST_MASKED) {
                ethCriterion = (EthCriterion)criterion;
                continue;
            }
            if (criterion.type() == Criterion.Type.VLAN_VID) {
                vidCriterion = (VlanIdCriterion)criterion;
                continue;
            }
            if (criterion.type() == Criterion.Type.IPV4_DST) {
                ips.add((IPCriterion)criterion);
                continue;
            }
            this.log.error("Unsupported filter {}", criterion);
            CpqdOfdpa2Pipeline.fail((Objective)filt, ObjectiveError.UNSUPPORTED);
            return;
        }
        VlanId assignedVlan = null;
        if (vidCriterion != null) {
            if (vidCriterion.vlanId() != VlanId.NONE) {
                assignedVlan = vidCriterion.vlanId();
            } else {
                if (filt.meta() == null) {
                    this.log.error("Missing metadata in filtering objective required for vlan assignment in dev {}", (Object)this.deviceId);
                    CpqdOfdpa2Pipeline.fail((Objective)filt, ObjectiveError.BADPARAMS);
                    return;
                }
                for (Instruction i : filt.meta().allInstructions()) {
                    if (!(i instanceof L2ModificationInstruction.ModVlanIdInstruction)) continue;
                    assignedVlan = ((L2ModificationInstruction.ModVlanIdInstruction)i).vlanId();
                }
                if (assignedVlan == null) {
                    this.log.error("Driver requires an assigned vlan-id to tag incoming untagged packets. Not processing vlan filters on device {}", (Object)this.deviceId);
                    CpqdOfdpa2Pipeline.fail((Objective)filt, ObjectiveError.BADPARAMS);
                    return;
                }
            }
        }
        if (ethCriterion == null || ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            this.log.debug("filtering objective missing dstMac, cannot program TMAC table");
        } else {
            for (FlowRule tmacRule : this.processEthDstFilter(portCriterion, ethCriterion, vidCriterion, assignedVlan, applicationId)) {
                this.log.debug("adding MAC filtering rules in TMAC table: {} for dev: {}", (Object)tmacRule, (Object)this.deviceId);
                ops = install ? ops.add(tmacRule) : ops.remove(tmacRule);
            }
        }
        if (ethCriterion == null || vidCriterion == null) {
            this.log.debug("filtering objective missing dstMac or VLAN, cannot program VLAN Table");
        } else {
            List<FlowRule> allRules = this.processVlanIdFilter(portCriterion, vidCriterion, assignedVlan, applicationId);
            for (FlowRule rule : allRules) {
                this.log.debug("adding VLAN filtering rule in VLAN table: {} for dev: {}", (Object)rule, (Object)this.deviceId);
                ops = install ? ops.add(rule) : ops.remove(rule);
            }
        }
        for (IPCriterion ipaddr : ips) {
            if (this.sentIpFilters.contains(ipaddr)) continue;
            this.sentIpFilters.add(ipaddr);
            this.log.debug("adding IP filtering rules in ACL table {} for dev: {}", (Object)ipaddr, (Object)this.deviceId);
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchIPDst(ipaddr.ip());
            treatment.setOutput(PortNumber.CONTROLLER);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(65535).fromApp(applicationId).makePermanent().forTable(60).build();
            ops = install ? ops.add(rule) : ops.remove(rule);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)CpqdOfdpa2Pipeline.this.deviceId);
                Ofdpa2Pipeline.pass((Objective)filt);
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)CpqdOfdpa2Pipeline.this.deviceId);
                Ofdpa2Pipeline.fail((Objective)filt, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    @Override
    protected List<FlowRule> processVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchVlanId(vidCriterion.vlanId());
        treatment.transition(Integer.valueOf(20));
        if (vidCriterion.vlanId() == VlanId.NONE) {
            treatment.pushVlan().setVlanId(assignedVlan);
            TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP).matchVlanId(assignedVlan);
            TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().popVlan().punt();
            FlowRule internalVlan = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue() + 1).fromApp(applicationId).makePermanent().forTable(60).build();
            rules.add(internalVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        for (PortNumber pnum : portnums) {
            selector.matchInPort(pnum);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            rules.add(rule);
        }
        return rules;
    }

    @Override
    protected List<FlowRule> processEthDstFilter(PortCriterion portCriterion, EthCriterion ethCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        if (portCriterion != null && portCriterion.port() == PortNumber.ANY) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId);
        }
        if (ethCriterion.mask() != null) {
            return this.processMcastEthDstFilter(ethCriterion, applicationId);
        }
        if (vidCriterion.vlanId() == VlanId.NONE) {
            vidCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (PortNumber pnum : portnums) {
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchEthDst(ethCriterion.mac());
            treatment.popVlan();
            treatment.transition(Integer.valueOf(30));
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.MPLS_UNICAST);
            selector.matchEthDst(ethCriterion.mac());
            treatment.popVlan();
            treatment.transition(Integer.valueOf(23));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
        }
        return rules;
    }

    @Override
    protected List<FlowRule> processEthDstOnlyFilter(EthCriterion ethCriterion, ApplicationId applicationId) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        treatment.popVlan();
        treatment.transition(Integer.valueOf(30));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        return ImmutableList.builder().add((Object)rule).build();
    }

    @Override
    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        NextGroup next;
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4 && ethType.ethType().toShort() != Ethernet.MPLS_UNICAST) {
            this.log.warn("processSpecific: Unsupported forwarding objective criteriaethType:{} in dev:{}", (Object)ethType, (Object)this.deviceId);
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        boolean defaultRule = false;
        int forTableId = -1;
        TrafficSelector.Builder filteredSelector = DefaultTrafficSelector.builder();
        TrafficSelector.Builder complementarySelector = DefaultTrafficSelector.builder();
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            if (ipv4Dst.isMulticast()) {
                if (ipv4Dst.prefixLength() != 32) {
                    this.log.warn("Multicast specific forwarding objective can only be /32");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                VlanId assignedVlan = CpqdOfdpa2Pipeline.readVlanFromSelector(fwd.meta());
                if (assignedVlan == null) {
                    this.log.warn("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                filteredSelector.matchVlanId(assignedVlan);
                filteredSelector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
                forTableId = 40;
                this.log.debug("processing IPv4 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            } else {
                if (ipv4Dst.prefixLength() == 0) {
                    filteredSelector.matchEthType(Ethernet.TYPE_IPV4);
                } else {
                    filteredSelector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
                }
                forTableId = 30;
                this.log.debug("processing IPv4 unicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            }
        } else {
            filteredSelector.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            MplsBosCriterion bos = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
            if (bos != null) {
                filteredSelector.matchMplsBos(bos.mplsBos());
            }
            forTableId = 24;
            this.log.debug("processing MPLS specific forwarding objective {} -> next:{} in dev {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        }
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction i : fwd.treatment().allInstructions()) {
                tb.deferred().add(i);
            }
        }
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            tb.deferred().group(group.id());
        }
        tb.transition(Integer.valueOf(60));
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ArrayList<FlowRule> flowRuleCollection = new ArrayList<FlowRule>();
        flowRuleCollection.add(ruleBuilder.build());
        if (defaultRule) {
            FlowRule.Builder rule = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(complementarySelector.build()).withTreatment(tb.build()).forTable(forTableId);
            if (fwd.permanent()) {
                rule.makePermanent();
            } else {
                rule.makeTemporary(fwd.timeout());
            }
            flowRuleCollection.add(rule.build());
            this.log.debug("Default rule 0.0.0.0/0 is being installed two rules");
        }
        return flowRuleCollection;
    }

    @Override
    protected Collection<FlowRule> processEthDstSpecific(ForwardingObjective fwd) {
        NextGroup next;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector selector = fwd.selector();
        EthCriterion ethCriterion = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.warn("Forwarding objective for bridging requires vlan. Not installing fwd:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        if (!ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            filteredSelectorBuilder.matchEthDst(ethCriterion.mac());
            this.log.debug("processing L2 forwarding objective:{} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            this.log.debug("processing L2 Broadcast forwarding objective:{} -> next:{} in dev:{} for vlan:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId, vlanIdCriterion.vlanId()});
        }
        filteredSelectorBuilder.matchVlanId(vlanIdCriterion.vlanId());
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        if (fwd.treatment() != null) {
            this.log.warn("Ignoring traffic treatment in fwd rule {} meant for L2 tablefor dev:{}. Expecting only nextId", (Object)fwd.id(), (Object)this.deviceId);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group != null) {
                treatmentBuilder.deferred().group(group.id());
            } else {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        treatmentBuilder.immediate().transition(Integer.valueOf(60));
        TrafficTreatment filteredTreatment = treatmentBuilder.build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRuleBuilder.fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(filteredTreatment).forTable(50);
        if (fwd.permanent()) {
            flowRuleBuilder.makePermanent();
        } else {
            flowRuleBuilder.makeTemporary(fwd.timeout());
        }
        rules.add(flowRuleBuilder.build());
        return rules;
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.info("Processing versatile forwarding objective");
        EthTypeCriterion ethType = (EthTypeCriterion)fwd.selector().getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.error("Versatile forwarding objective must include ethType");
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            return Collections.emptySet();
        }
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        fwd.selector().criteria().forEach(criterion -> {
            if (criterion instanceof VlanIdCriterion) {
                return;
            }
            sbuilder.add(criterion);
        });
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction ins : fwd.treatment().allInstructions()) {
                if (ins instanceof Instructions.OutputInstruction) {
                    Instructions.OutputInstruction o = (Instructions.OutputInstruction)ins;
                    if (o.port() == PortNumber.CONTROLLER) {
                        ttBuilder.add((Instruction)o);
                        continue;
                    }
                    this.log.warn("Only allowed treatments in versatile forwarding objectives are punts to the controller");
                    continue;
                }
                this.log.warn("Cannot process instruction in versatile fwd {}", (Object)ins);
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            ttBuilder.deferred().group(group.id());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
        return Collections.singletonList(ruleBuilder.build());
    }

    @Override
    protected void initializePipeline() {
        this.processPortTable();
        this.processTmacTable();
        this.processIpTable();
        this.processMulticastIpTable();
        this.processMplsTable();
        this.processBridgingTable();
        this.processAclTable();
    }

    protected void processPortTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(10));
        FlowRule tmisse = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(0).build();
        ops = ops.add(tmisse);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized port table");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize port table");
            }
        }));
    }

    protected void processTmacTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(50));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(20).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized tmac table");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize tmac table");
            }
        }));
    }

    protected void processIpTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(60));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(30).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized IP table");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize unicast IP table");
            }
        }));
    }

    protected void processMulticastIpTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(60));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(40).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized multicast IP table");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize multicast IP table");
            }
        }));
    }

    protected void processMplsTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector = DefaultTrafficSelector.builder();
        treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(24));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(23).build();
        ops = ops.add(rule);
        treatment.transition(Integer.valueOf(60));
        rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(24).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized MPLS tables");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize MPLS tables");
            }
        }));
    }

    private void processBridgingTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(60));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(50).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized Bridging table");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize Bridging table");
            }
        }));
    }

    protected void processAclTable() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.driverId).makePermanent().forTable(60).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized Acl table");
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to initialize Acl table");
            }
        }));
    }
}

