/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.onlab.packet.Ethernet;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.pipeline.CpqdOfdpa2GroupHandler;
import org.onosproject.driver.pipeline.CpqdOfdpa2Pipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpqdOfdpa2VlanPipeline
extends CpqdOfdpa2Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        this.deviceId = deviceId;
        this.groupHandler = new CpqdOfdpa2GroupHandler();
        this.groupHandler.init(deviceId, context);
        this.serviceDirectory = context.directory();
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.CpqdOfdpa2VlanPipeline");
        this.initializePipeline();
    }

    @Override
    protected List<FlowRule> processEthDstFilter(PortCriterion portCriterion, EthCriterion ethCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        if (portCriterion != null && portCriterion.port() == PortNumber.ANY) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId);
        }
        if (ethCriterion.mask() != null) {
            return this.processMcastEthDstFilter(ethCriterion, applicationId);
        }
        if (vidCriterion.vlanId() == VlanId.NONE) {
            vidCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion.port() == PortNumber.ALL) {
            for (Port port : this.deviceService.getPorts(this.deviceId)) {
                if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                portnums.add(port.number());
            }
        } else {
            portnums.add(portCriterion.port());
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (PortNumber pnum : portnums) {
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchEthDst(ethCriterion.mac());
            treatment.transition(Integer.valueOf(30));
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
        }
        return rules;
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.info("Processing versatile forwarding objective");
        EthTypeCriterion ethType = (EthTypeCriterion)fwd.selector().getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.log.error("Versatile forwarding objective must include ethType");
            CpqdOfdpa2VlanPipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            return Collections.emptySet();
        }
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        fwd.selector().criteria().forEach(criterion -> {
            VlanId vlanId;
            if (criterion instanceof VlanIdCriterion && (vlanId = ((VlanIdCriterion)criterion).vlanId()).equals((Object)VlanId.NONE)) {
                return;
            }
            sbuilder.add(criterion);
        });
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction ins : fwd.treatment().allInstructions()) {
                if (ins instanceof Instructions.OutputInstruction) {
                    Instructions.OutputInstruction o = (Instructions.OutputInstruction)ins;
                    if (o.port() == PortNumber.CONTROLLER) {
                        ttBuilder.add((Instruction)o);
                        continue;
                    }
                    this.log.warn("Only allowed treatments in versatile forwarding objectives are punts to the controller");
                    continue;
                }
                this.log.warn("Cannot process instruction in versatile fwd {}", (Object)ins);
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2VlanPipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            ttBuilder.deferred().group(group.id());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
        return Collections.singletonList(ruleBuilder.build());
    }
}

