/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.GroupId;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NokiaOltPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private static final Integer QQ_TABLE = 1;
    private static final short MCAST_VLAN = 4000;
    private static final String OLTCOOKIES = "olt-cookies-must-be-unique";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private GroupService groupService;
    private CoreService coreService;
    private StorageService storageService;
    private DeviceId deviceId;
    private ApplicationId appId;
    protected FlowObjectiveStore flowObjectiveStore;
    private Cache<GroupKey, NextObjective> pendingGroups;
    protected static KryoNamespace appKryo = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{GroupKey.class}).register(new Class[]{DefaultGroupKey.class}).register(new Class[]{OLTPipelineGroup.class}).build("OltPipeline");

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.log.debug("Initiate OLT pipeline");
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.storageService = (StorageService)this.serviceDirectory.get(StorageService.class);
        this.appId = this.coreService.registerApplication("org.onosproject.driver.OLTPipeline");
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.fail((Objective)notification.getValue(), ObjectiveError.GROUPINSTALLATIONFAILED);
            }
        }).build();
        this.groupService.addListener((EventListener)new InnerGroupListener());
    }

    public void filter(FilteringObjective filter) {
        Instructions.OutputInstruction output;
        if (filter.meta() != null && !filter.meta().immediate().isEmpty()) {
            output = (Instructions.OutputInstruction)filter.meta().immediate().stream().filter((? super T t) -> t.type().equals((Object)Instruction.Type.OUTPUT)).limit(1L).findFirst().get();
            if (output == null || !output.port().equals((Object)PortNumber.CONTROLLER)) {
                this.log.error("OLT can only filter packet to controller");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
                return;
            }
        } else {
            this.fail((Objective)filter, ObjectiveError.BADPARAMS);
            return;
        }
        if (filter.key().type() != Criterion.Type.IN_PORT) {
            this.fail((Objective)filter, ObjectiveError.BADPARAMS);
            return;
        }
        EthTypeCriterion ethType = (EthTypeCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.ETH_TYPE);
        if (ethType == null) {
            this.fail((Objective)filter, ObjectiveError.BADPARAMS);
            return;
        }
        if (ethType.ethType().equals((Object)EthType.EtherType.EAPOL.ethType())) {
            this.provisionEapol(filter, ethType, output);
        } else if (ethType.ethType().equals((Object)EthType.EtherType.IPV4.ethType())) {
            IPProtocolCriterion ipProto = (IPProtocolCriterion)this.filterForCriterion(filter.conditions(), Criterion.Type.IP_PROTO);
            if (ipProto.protocol() == 2) {
                this.provisionIgmp(filter, ethType, ipProto, output);
            } else {
                this.log.error("OLT can only filter igmp");
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
            }
        } else {
            this.log.error("OLT can only filter eapol and igmp");
            this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
        }
    }

    private void installObjective(FlowRule.Builder ruleBuilder, final Objective objective) {
        FlowRuleOperations.Builder flowBuilder = FlowRuleOperations.builder();
        switch (objective.op()) {
            case ADD: {
                flowBuilder.add(ruleBuilder.build());
                break;
            }
            case REMOVE: {
                flowBuilder.remove(ruleBuilder.build());
                break;
            }
            default: {
                this.log.warn("Unknown operation {}", (Object)objective.op());
            }
        }
        this.flowRuleService.apply(flowBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onSuccess(objective));
            }

            public void onError(FlowRuleOperations ops) {
                objective.context().ifPresent(context -> context.onError(objective, ObjectiveError.FLOWINSTALLATIONFAILED));
            }
        }));
    }

    public void forward(ForwardingObjective fwd) {
        if (this.checkForMulticast(fwd)) {
            this.processMulticastRule(fwd);
            return;
        }
        TrafficTreatment treatment = fwd.treatment();
        List instructions = treatment.allInstructions();
        Optional<Instruction> vlanIntruction = instructions.stream().filter((? super T i) -> i.type() == Instruction.Type.L2MODIFICATION).filter((? super T i) -> ((L2ModificationInstruction)i).subtype() == L2ModificationInstruction.L2SubType.VLAN_PUSH || ((L2ModificationInstruction)i).subtype() == L2ModificationInstruction.L2SubType.VLAN_POP).findAny();
        if (vlanIntruction.isPresent()) {
            L2ModificationInstruction vlanIns = (L2ModificationInstruction)vlanIntruction.get();
            if (vlanIns.subtype() == L2ModificationInstruction.L2SubType.VLAN_PUSH) {
                this.installUpstreamRules(fwd);
            } else if (vlanIns.subtype() == L2ModificationInstruction.L2SubType.VLAN_POP) {
                this.installDownstreamRules(fwd);
            } else {
                this.log.error("Unknown OLT operation: {}", (Object)fwd);
                this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
                return;
            }
            this.pass((Objective)fwd);
        } else {
            TrafficSelector selector = fwd.selector();
            if (fwd.treatment() != null) {
                FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).fromApp(fwd.appId()).withPriority(fwd.priority()).withTreatment(fwd.treatment());
                if (fwd.permanent()) {
                    ruleBuilder.makePermanent();
                } else {
                    ruleBuilder.makeTemporary(fwd.timeout());
                }
                this.installObjective(ruleBuilder, (Objective)fwd);
            } else {
                this.log.error("No treatment error: {}", (Object)fwd);
                this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            }
        }
    }

    public void next(NextObjective nextObjective) {
        if (nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.error("OLT only supports broadcast groups.");
            this.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
        }
        if (nextObjective.next().size() != 1) {
            this.log.error("OLT only supports singleton broadcast groups.");
            this.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
        }
        TrafficTreatment treatment = (TrafficTreatment)nextObjective.next().stream().findFirst().get();
        GroupBucket bucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)treatment);
        DefaultGroupKey key = new DefaultGroupKey(appKryo.serialize((Object)nextObjective.id()));
        this.pendingGroups.put((Object)key, (Object)nextObjective);
        switch (nextObjective.op()) {
            case ADD: {
                DefaultGroupDescription groupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, null, nextObjective.appId());
                this.groupService.addGroup((GroupDescription)groupDesc);
                break;
            }
            case REMOVE: {
                this.groupService.removeGroup(this.deviceId, (GroupKey)key, nextObjective.appId());
                break;
            }
            case ADD_TO_EXISTING: {
                this.groupService.addBucketsToGroup(this.deviceId, (GroupKey)key, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, nextObjective.appId());
                break;
            }
            case REMOVE_FROM_EXISTING: {
                this.groupService.removeBucketsFromGroup(this.deviceId, (GroupKey)key, new GroupBuckets(Collections.singletonList(bucket)), (GroupKey)key, nextObjective.appId());
                break;
            }
            default: {
                this.log.warn("Unknown next objective operation: {}", (Object)nextObjective.op());
            }
        }
    }

    private void processMulticastRule(ForwardingObjective fwd) {
        GroupKey key;
        if (fwd.nextId() == null) {
            this.log.error("Multicast objective does not have a next id");
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
        }
        if ((key = this.getGroupForNextObjective(fwd.nextId())) == null) {
            this.log.error("Group for forwarding objective missing: {}", (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
        }
        Group group = this.groupService.getGroup(this.deviceId, key);
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{Instructions.createGroup((GroupId)group.id())});
        FlowRule rule = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(0).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(treatment).build();
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        switch (fwd.op()) {
            case ADD: {
                builder.add(rule);
                break;
            }
            case REMOVE: {
                builder.remove(rule);
                break;
            }
            case ADD_TO_EXISTING: 
            case REMOVE_FROM_EXISTING: {
                break;
            }
            default: {
                this.log.warn("Unknown forwarding operation: {}", (Object)fwd.op());
            }
        }
        this.applyFlowRules(builder, (Objective)fwd);
    }

    private boolean checkForMulticast(ForwardingObjective fwd) {
        IPCriterion ip = (IPCriterion)this.filterForCriterion(fwd.selector().criteria(), Criterion.Type.IPV4_DST);
        if (ip == null) {
            return false;
        }
        return ip.ip().isMulticast();
    }

    private GroupKey getGroupForNextObjective(Integer nextId) {
        NextGroup next = this.flowObjectiveStore.getNextGroup(nextId);
        return (GroupKey)appKryo.deserialize(next.data());
    }

    private void installDownstreamRules(ForwardingObjective fwd) {
        List<Pair<Instruction, Instruction>> vlanOps = this.vlanOps(fwd, L2ModificationInstruction.L2SubType.VLAN_POP);
        if (vlanOps == null) {
            return;
        }
        Instructions.OutputInstruction output = (Instructions.OutputInstruction)this.fetchOutput(fwd, "downstream");
        if (output == null) {
            return;
        }
        Pair<Instruction, Instruction> popAndRewrite = vlanOps.remove(0);
        TrafficSelector selector = fwd.selector();
        Criterion outerVlan = selector.getCriterion(Criterion.Type.VLAN_VID);
        Criterion innerVlan = selector.getCriterion(Criterion.Type.INNER_VLAN_VID);
        Criterion inport = selector.getCriterion(Criterion.Type.IN_PORT);
        Criterion bullshit = Criteria.matchMetadata((long)output.port().toLong());
        if (outerVlan == null || innerVlan == null || inport == null) {
            this.log.error("Forwarding objective is underspecified: {}", (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return;
        }
        Criterion innerVid = Criteria.matchVlanId((VlanId)((VlanIdCriterion)innerVlan).vlanId());
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(this.buildSelector(inport, outerVlan, bullshit)).withTreatment(this.buildTreatment((Instruction)popAndRewrite.getLeft(), Instructions.transition((Integer)QQ_TABLE)));
        FlowRule.Builder inner = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(QQ_TABLE.intValue()).makePermanent().withPriority(fwd.priority()).withSelector(this.buildSelector(inport, innerVid)).withTreatment(this.buildTreatment(new Instruction[]{(Instruction)popAndRewrite.getLeft(), output}));
        this.applyRules(fwd, inner, outer);
    }

    private boolean hasUntaggedVlanTag(TrafficSelector selector) {
        for (Criterion criterion : selector.criteria()) {
            if (criterion.type() != Criterion.Type.VLAN_VID || ((VlanIdCriterion)criterion).vlanId().toShort() != -1) continue;
            return true;
        }
        return false;
    }

    private void installUpstreamRules(ForwardingObjective fwd) {
        List<Pair<Instruction, Instruction>> vlanOps = this.vlanOps(fwd, L2ModificationInstruction.L2SubType.VLAN_PUSH);
        if (vlanOps == null) {
            return;
        }
        Instruction output = this.fetchOutput(fwd, "upstream");
        if (output == null) {
            return;
        }
        Pair<Instruction, Instruction> innerPair = vlanOps.remove(0);
        Pair<Instruction, Instruction> outerPair = vlanOps.remove(0);
        FlowRule.Builder inner = this.hasUntaggedVlanTag(fwd.selector()) ? DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(this.buildTreatment((Instruction)innerPair.getLeft(), (Instruction)innerPair.getRight(), Instructions.transition((Integer)QQ_TABLE))) : DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).makePermanent().withPriority(fwd.priority()).withSelector(fwd.selector()).withTreatment(this.buildTreatment((Instruction)innerPair.getRight(), Instructions.transition((Integer)QQ_TABLE)));
        PortCriterion inPort = (PortCriterion)fwd.selector().getCriterion(Criterion.Type.IN_PORT);
        VlanId cVlanId = ((L2ModificationInstruction.ModVlanIdInstruction)innerPair.getRight()).vlanId();
        FlowRule.Builder outer = DefaultFlowRule.builder().fromApp(fwd.appId()).forDevice(this.deviceId).forTable(QQ_TABLE.intValue()).makePermanent().withPriority(fwd.priority()).withSelector(this.buildSelector(new Criterion[]{inPort, Criteria.matchVlanId((VlanId)cVlanId)})).withTreatment(this.buildTreatment((Instruction)outerPair.getLeft(), (Instruction)outerPair.getRight(), output));
        this.applyRules(fwd, inner, outer);
    }

    private Instruction fetchOutput(ForwardingObjective fwd, String direction) {
        Instruction output = fwd.treatment().allInstructions().stream().filter((? super T i) -> i.type() == Instruction.Type.OUTPUT).findFirst().orElse(null);
        if (output == null) {
            this.log.error("OLT {} rule has no output", (Object)direction);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return null;
        }
        return output;
    }

    private List<Pair<Instruction, Instruction>> vlanOps(ForwardingObjective fwd, L2ModificationInstruction.L2SubType type) {
        List<Pair<Instruction, Instruction>> vlanOps = this.findVlanOps(fwd.treatment().allInstructions(), type);
        if (vlanOps == null) {
            String direction = type == L2ModificationInstruction.L2SubType.VLAN_POP ? "downstream" : "upstream";
            this.log.error("Missing vlan operations in {} forwarding: {}", (Object)direction, (Object)fwd);
            this.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return null;
        }
        return vlanOps;
    }

    private List<Pair<Instruction, Instruction>> findVlanOps(List<Instruction> instructions, L2ModificationInstruction.L2SubType type) {
        List<Instruction> vlanPushs = this.findL2Instructions(type, instructions);
        List<Instruction> vlanSets = this.findL2Instructions(L2ModificationInstruction.L2SubType.VLAN_ID, instructions);
        if (vlanPushs.size() != vlanSets.size()) {
            return null;
        }
        ArrayList pairs = Lists.newArrayList();
        for (int i = 0; i < vlanPushs.size(); ++i) {
            pairs.add(new ImmutablePair((Object)vlanPushs.get(i), (Object)vlanSets.get(i)));
        }
        return pairs;
    }

    private List<Instruction> findL2Instructions(L2ModificationInstruction.L2SubType subType, List<Instruction> actions) {
        return actions.stream().filter((? super T i) -> i.type() == Instruction.Type.L2MODIFICATION).filter((? super T i) -> ((L2ModificationInstruction)i).subtype() == subType).collect(Collectors.toList());
    }

    private void provisionEapol(FilteringObjective filter, EthTypeCriterion ethType, Instructions.OutputInstruction output) {
        TrafficSelector selector = this.buildSelector(new Criterion[]{filter.key(), ethType});
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{output});
        this.buildAndApplyRule(filter, selector, treatment);
    }

    private void provisionIgmp(FilteringObjective filter, EthTypeCriterion ethType, IPProtocolCriterion ipProto, Instructions.OutputInstruction output) {
        TrafficSelector selector = this.buildSelector(new Criterion[]{filter.key(), ethType, ipProto});
        TrafficTreatment treatment = this.buildTreatment(new Instruction[]{output});
        this.buildAndApplyRule(filter, selector, treatment);
    }

    private void buildAndApplyRule(FilteringObjective filter, TrafficSelector selector, TrafficTreatment treatment) {
        FlowRule rule = DefaultFlowRule.builder().fromApp(filter.appId()).forDevice(this.deviceId).forTable(0).makePermanent().withSelector(selector).withTreatment(treatment).withPriority(filter.priority()).build();
        FlowRuleOperations.Builder opsBuilder = FlowRuleOperations.builder();
        switch (filter.type()) {
            case PERMIT: {
                opsBuilder.add(rule);
                break;
            }
            case DENY: {
                opsBuilder.remove(rule);
                break;
            }
            default: {
                this.log.warn("Unknown filter type : {}", (Object)filter.type());
                this.fail((Objective)filter, ObjectiveError.UNSUPPORTED);
            }
        }
        this.applyFlowRules(opsBuilder, (Objective)filter);
    }

    private void applyRules(ForwardingObjective fwd, FlowRule.Builder inner, FlowRule.Builder outer) {
        FlowRuleOperations.Builder builder = FlowRuleOperations.builder();
        switch (fwd.op()) {
            case ADD: {
                builder.add(inner.build()).add(outer.build());
                break;
            }
            case REMOVE: {
                builder.remove(inner.build()).remove(outer.build());
                break;
            }
            case ADD_TO_EXISTING: {
                break;
            }
            case REMOVE_FROM_EXISTING: {
                break;
            }
            default: {
                this.log.warn("Unknown forwarding operation: {}", (Object)fwd.op());
            }
        }
        this.applyFlowRules(builder, (Objective)fwd);
    }

    private void applyFlowRules(FlowRuleOperations.Builder builder, final Objective objective) {
        this.flowRuleService.apply(builder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                NokiaOltPipeline.this.pass(objective);
            }

            public void onError(FlowRuleOperations ops) {
                NokiaOltPipeline.this.fail(objective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private Criterion filterForCriterion(Collection<Criterion> criteria, Criterion.Type type) {
        return criteria.stream().filter((? super T c) -> c.type().equals((Object)type)).limit(1L).findFirst().orElse(null);
    }

    private TrafficSelector buildSelector(Criterion ... criteria) {
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder();
        for (Criterion c : criteria) {
            sBuilder.add(c);
        }
        return sBuilder.build();
    }

    private TrafficTreatment buildTreatment(Instruction ... instructions) {
        TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
        for (Instruction i : instructions) {
            tBuilder.add(i);
        }
        return tBuilder.build();
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    private static class OLTPipelineGroup
    implements NextGroup {
        private final GroupKey key;

        public OLTPipelineGroup(GroupKey key) {
            this.key = key;
        }

        public GroupKey key() {
            return this.key;
        }

        public byte[] data() {
            return appKryo.serialize((Object)this.key);
        }
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            if (event.type() == GroupEvent.Type.GROUP_ADDED || event.type() == GroupEvent.Type.GROUP_UPDATED) {
                GroupKey key = ((Group)event.subject()).appCookie();
                NextObjective obj = (NextObjective)NokiaOltPipeline.this.pendingGroups.getIfPresent((Object)key);
                if (obj != null) {
                    NokiaOltPipeline.this.flowObjectiveStore.putNextGroup(Integer.valueOf(obj.id()), (NextGroup)new OLTPipelineGroup(key));
                    NokiaOltPipeline.this.pass((Objective)obj);
                    NokiaOltPipeline.this.pendingGroups.invalidate((Object)key);
                }
            }
        }
    }
}

