/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.extensions.Ofdpa3MatchMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3MatchOvid;
import org.onosproject.driver.extensions.Ofdpa3MplsType;
import org.onosproject.driver.extensions.Ofdpa3PopCw;
import org.onosproject.driver.extensions.Ofdpa3PopL2Header;
import org.onosproject.driver.extensions.Ofdpa3SetMplsL2Port;
import org.onosproject.driver.extensions.Ofdpa3SetMplsType;
import org.onosproject.driver.extensions.Ofdpa3SetOvid;
import org.onosproject.driver.extensions.Ofdpa3SetQosIndex;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.driver.pipeline.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.Ofdpa3GroupHandler;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3Pipeline
extends Ofdpa2Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        this.deviceId = deviceId;
        this.groupHandler = new Ofdpa3GroupHandler();
        this.groupHandler.init(deviceId, context);
        this.serviceDirectory = context.directory();
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.groupService = (GroupService)this.serviceDirectory.get(GroupService.class);
        this.flowObjectiveStore = context.store();
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.Ofdpa3Pipeline");
        this.initializePipeline();
    }

    @Override
    protected void processFilter(final FilteringObjective filteringObjective, boolean install, ApplicationId applicationId) {
        VlanIdCriterion innerVlanIdCriterion = null;
        for (Criterion criterion : filteringObjective.conditions()) {
            if (criterion.type() != Criterion.Type.INNER_VLAN_VID) continue;
            innerVlanIdCriterion = (VlanIdCriterion)criterion;
            break;
        }
        if (innerVlanIdCriterion != null) {
            L2ModificationInstruction l2instruction;
            FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
            VlanIdCriterion outerVlanIdCriterion = null;
            PortCriterion portCriterion = (PortCriterion)filteringObjective.key();
            for (Criterion criterion : filteringObjective.conditions()) {
                if (criterion.type() != Criterion.Type.VLAN_VID) continue;
                outerVlanIdCriterion = (VlanIdCriterion)criterion;
                break;
            }
            if (filteringObjective.meta() != null && filteringObjective.meta().allInstructions().size() != 1) {
                this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                Ofdpa3Pipeline.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            if (filteringObjective.meta() != null && filteringObjective.meta().allInstructions().size() == 1 && ((Instruction)filteringObjective.meta().allInstructions().get(0)).type() == Instruction.Type.L2MODIFICATION) {
                l2instruction = (L2ModificationInstruction)filteringObjective.meta().allInstructions().get(0);
                if (l2instruction.subtype() != L2ModificationInstruction.L2SubType.TUNNEL_ID) {
                    this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                    Ofdpa3Pipeline.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                    return;
                }
            } else {
                this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                Ofdpa3Pipeline.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            long tunnelId = ((L2ModificationInstruction.ModTunnelIdInstruction)l2instruction).tunnelId();
            tunnelId = 0x10000L | tunnelId;
            if (portCriterion == null || outerVlanIdCriterion == null || tunnelId > 131071L) {
                this.log.warn("Bad filtering objective from app: {}. Notprocessing filtering objective", (Object)applicationId);
                Ofdpa3Pipeline.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            if (portCriterion.port().toLong() > 65535L) {
                this.log.error("Filering Objective invalid logical port {}", (Object)portCriterion.port().toLong());
                Ofdpa3Pipeline.fail((Objective)filteringObjective, ObjectiveError.BADPARAMS);
                return;
            }
            List<FlowRule> pwRules = this.processPwFilter(portCriterion, innerVlanIdCriterion, outerVlanIdCriterion, tunnelId, applicationId);
            for (FlowRule pwRule : pwRules) {
                this.log.debug("adding filtering rule in VLAN tables: {} for dev: {}", (Object)pwRule, (Object)this.deviceId);
                ops = install ? ops.add(pwRule) : ops.remove(pwRule);
            }
            this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

                public void onSuccess(FlowRuleOperations ops) {
                    Ofdpa3Pipeline.this.log.info("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)Ofdpa3Pipeline.this.deviceId);
                    Ofdpa2Pipeline.pass((Objective)filteringObjective);
                }

                public void onError(FlowRuleOperations ops) {
                    Ofdpa3Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)Ofdpa3Pipeline.this.deviceId);
                    Ofdpa2Pipeline.fail((Objective)filteringObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
                }
            }));
            return;
        }
        super.processFilter(filteringObjective, install, applicationId);
    }

    private List<FlowRule> processPwFilter(PortCriterion portCriterion, VlanIdCriterion innerVlanIdCriterion, VlanIdCriterion outerVlanIdCriterion, long tunnelId, ApplicationId applicationId) {
        int mplsLogicalPort = (int)portCriterion.port().toLong();
        TrafficSelector.Builder vlan1Selector = DefaultTrafficSelector.builder().matchInPort(portCriterion.port()).extension((ExtensionSelector)new OfdpaMatchVlanVid(innerVlanIdCriterion.vlanId()), this.deviceId).extension((ExtensionSelector)new Ofdpa3MatchOvid(outerVlanIdCriterion.vlanId()), this.deviceId);
        TrafficTreatment.Builder vlan1Treatment = DefaultTrafficTreatment.builder().pushVlan().setVlanId(outerVlanIdCriterion.vlanId()).extension((ExtensionTreatment)new Ofdpa3SetMplsType(Ofdpa3MplsType.VPWS), this.deviceId).extension((ExtensionTreatment)new Ofdpa3SetMplsL2Port(mplsLogicalPort), this.deviceId).setTunnelId(tunnelId).transition(Integer.valueOf(13));
        FlowRule vlan1FlowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(vlan1Selector.build()).withTreatment(vlan1Treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(11).build();
        TrafficSelector.Builder vlanSelector = DefaultTrafficSelector.builder().matchInPort(portCriterion.port()).extension((ExtensionSelector)new OfdpaMatchVlanVid(outerVlanIdCriterion.vlanId()), this.deviceId);
        TrafficTreatment.Builder vlanTreatment = DefaultTrafficTreatment.builder().popVlan().extension((ExtensionTreatment)new Ofdpa3SetOvid(outerVlanIdCriterion.vlanId()), this.deviceId).transition(Integer.valueOf(11));
        FlowRule vlanFlowRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(vlanSelector.build()).withTreatment(vlanTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
        return ImmutableList.of((Object)vlan1FlowRule, (Object)vlanFlowRule);
    }

    @Override
    protected List<FlowRule> processVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        return this.processVlanIdFilterInternal(portCriterion, vidCriterion, assignedVlan, applicationId, false);
    }

    @Override
    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        if (Ofdpa3Pipeline.isNotMplsBos(fwd.selector())) {
            return this.processEthTypeSpecificInternal(fwd, true, 29);
        }
        return this.processEthTypeSpecificInternal(fwd, true, 27);
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)fwd.selector().getCriterion(Criterion.Type.TUNNEL_ID);
        if (tunnelIdCriterion != null) {
            return this.processInitPwVersatile(fwd);
        }
        L2ModificationInstruction.ModTunnelIdInstruction modTunnelIdInstruction = this.getModTunnelIdInstruction(fwd.treatment());
        Instructions.OutputInstruction outputInstruction = this.getOutputInstruction(fwd.treatment());
        if (modTunnelIdInstruction != null && outputInstruction != null) {
            return this.processTermPwVersatile(fwd, modTunnelIdInstruction, outputInstruction);
        }
        return super.processVersatile(fwd);
    }

    private Collection<FlowRule> processTermPwVersatile(ForwardingObjective forwardingObjective, L2ModificationInstruction.ModTunnelIdInstruction modTunnelIdInstruction, Instructions.OutputInstruction outputInstruction) {
        TrafficTreatment.Builder mplsTreatment = DefaultTrafficTreatment.builder();
        this.createMplsTreatment(forwardingObjective.treatment(), mplsTreatment);
        TrafficSelector.Builder flowSelector = DefaultTrafficSelector.builder((TrafficSelector)forwardingObjective.selector());
        long tunnelId = 0x10000L | modTunnelIdInstruction.tunnelId();
        if (tunnelId > 131071L) {
            this.log.error("Pw Versatile Forwarding Objective must include tunnel id < {}", (Object)131071);
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        int mplsLogicalPort = (int)outputInstruction.port().toLong() | 0x20000;
        if (mplsLogicalPort > 196607) {
            this.log.error("Pw Versatile Forwarding Objective invalid logical port {}", (Object)mplsLogicalPort);
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (forwardingObjective.nextId() == null) {
            this.log.error("Pw Versatile Forwarding Objective must contain nextId ", (Object)forwardingObjective.nextId());
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        NextGroup next = this.getGroupForNextObjective(forwardingObjective.nextId());
        if (next == null) {
            this.log.warn("next-id:{} not found in dev:{}", (Object)forwardingObjective.nextId(), (Object)this.deviceId);
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        List gkeys = (List)appKryo.deserialize(next.data());
        Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
        if (group == null) {
            this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), forwardingObjective.nextId(), this.deviceId});
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        TrafficTreatment.Builder flowTreatment = DefaultTrafficTreatment.builder((TrafficTreatment)mplsTreatment.build());
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3PopCw(), this.deviceId);
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3PopL2Header(), this.deviceId);
        flowTreatment.setTunnelId(tunnelId);
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3SetMplsL2Port(mplsLogicalPort), this.deviceId);
        flowTreatment.extension((ExtensionTreatment)new Ofdpa3SetMplsType(Ofdpa3MplsType.VPWS), this.deviceId);
        flowTreatment.transition(Integer.valueOf(29));
        flowTreatment.deferred().group(group.id());
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(forwardingObjective.appId()).withPriority(forwardingObjective.priority()).forDevice(this.deviceId).withSelector(flowSelector.build()).withTreatment(flowTreatment.build()).makePermanent().forTable(24);
        return Collections.singletonList(ruleBuilder.build());
    }

    private Collection<FlowRule> processInitPwVersatile(ForwardingObjective forwardingObjective) {
        TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)forwardingObjective.selector().getCriterion(Criterion.Type.TUNNEL_ID);
        PortCriterion portCriterion = (PortCriterion)forwardingObjective.selector().getCriterion(Criterion.Type.IN_PORT);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        long tunnelId = 0x10000L | tunnelIdCriterion.tunnelId();
        if (tunnelId > 131071L) {
            this.log.error("Pw Versatile Forwarding Objective must include tunnel id < {}", (Object)131071);
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (portCriterion == null) {
            this.log.error("Pw Versatile Forwarding Objective must include port");
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (portCriterion.port().toLong() > 65535L) {
            this.log.error("Pw Versatile Forwarding Objective invalid logical port {}", (Object)portCriterion.port().toLong());
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        int mplsLogicalPort = (int)portCriterion.port().toLong();
        if (forwardingObjective.nextId() == null) {
            this.log.error("Pw Versatile Forwarding Objective must contain nextId ", (Object)forwardingObjective.nextId());
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        if (forwardingObjective.treatment() != null && !forwardingObjective.treatment().equals(DefaultTrafficTreatment.emptyTreatment())) {
            this.log.error("Pw Versatile Forwarding Objective cannot contain a treatment ", (Object)forwardingObjective.nextId());
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        NextGroup next = this.getGroupForNextObjective(forwardingObjective.nextId());
        if (next == null) {
            this.log.warn("next-id:{} not found in dev:{}", (Object)forwardingObjective.nextId(), (Object)this.deviceId);
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        List gkeys = (List)appKryo.deserialize(next.data());
        Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
        if (group == null) {
            this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), forwardingObjective.nextId(), this.deviceId});
            Ofdpa3Pipeline.fail((Objective)forwardingObjective, ObjectiveError.GROUPMISSING);
            return Collections.emptySet();
        }
        selector.matchTunnelId(tunnelId);
        selector.extension((ExtensionSelector)new Ofdpa3MatchMplsL2Port(mplsLogicalPort), this.deviceId);
        treatment.extension((ExtensionTreatment)new Ofdpa3SetQosIndex(0), this.deviceId);
        treatment.transition(Integer.valueOf(16));
        treatment.deferred().group(group.id());
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(forwardingObjective.appId()).withPriority(2).forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).makePermanent().forTable(13);
        return Collections.singletonList(ruleBuilder.build());
    }

    private L2ModificationInstruction.ModTunnelIdInstruction getModTunnelIdInstruction(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction instruction : treatment.allInstructions()) {
            L2ModificationInstruction l2ModificationInstruction;
            if (instruction.type() != Instruction.Type.L2MODIFICATION || (l2ModificationInstruction = (L2ModificationInstruction)instruction).subtype() != L2ModificationInstruction.L2SubType.TUNNEL_ID) continue;
            return (L2ModificationInstruction.ModTunnelIdInstruction)l2ModificationInstruction;
        }
        return null;
    }

    private Instructions.OutputInstruction getOutputInstruction(TrafficTreatment treatment) {
        if (treatment == null) {
            return null;
        }
        for (Instruction instruction : treatment.allInstructions()) {
            if (instruction.type() != Instruction.Type.OUTPUT) continue;
            return (Instructions.OutputInstruction)instruction;
        }
        return null;
    }

    private void createMplsTreatment(TrafficTreatment treatment, TrafficTreatment.Builder mplsTreatment) {
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case TUNNEL_ID: {
                        break;
                    }
                    case DEC_MPLS_TTL: 
                    case MPLS_POP: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) break;
            if (ins.type() == Instruction.Type.L3MODIFICATION) {
                L3ModificationInstruction l3ins = (L3ModificationInstruction)ins;
                switch (l3ins.subtype()) {
                    case TTL_IN: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
                        break;
                    }
                }
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
        }
    }
}

