/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.store.serializers.PortNumberSerializer;

public class NiciraResubmitTable
extends AbstractExtension
implements ExtensionTreatment {
    private static final PortNumber DEFAULT_IN_PORT = PortNumber.portNumber((long)65528L);
    private PortNumber inPort;
    private short table;
    private final KryoNamespace appKryo = new KryoNamespace.Builder().register((Serializer)new PortNumberSerializer(), new Class[]{PortNumber.class}).register(new Class[]{Map.class}).register(new Class[]{HashMap.class}).register(new Class[]{byte[].class}).build("NiciraResubmitTable");

    NiciraResubmitTable() {
        this.inPort = DEFAULT_IN_PORT;
        this.table = (short)-1;
    }

    public NiciraResubmitTable(PortNumber inPort, short table) {
        Preconditions.checkNotNull((Object)inPort);
        Preconditions.checkNotNull((Object)table);
        this.inPort = inPort;
        this.table = table;
    }

    public NiciraResubmitTable(short table) {
        Preconditions.checkNotNull((Object)table);
        this.inPort = DEFAULT_IN_PORT;
        this.table = table;
    }

    public PortNumber inPort() {
        return this.inPort;
    }

    public short table() {
        return this.table;
    }

    public ExtensionTreatmentType type() {
        return ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_RESUBMIT_TABLE.type();
    }

    public void deserialize(byte[] data) {
        Map values = (Map)this.appKryo.deserialize(data);
        this.inPort = (PortNumber)values.get("inPort");
        this.table = (Short)values.get("table");
    }

    public byte[] serialize() {
        HashMap values = Maps.newHashMap();
        values.put("inPort", this.inPort);
        values.put("table", this.table);
        return this.appKryo.serialize((Object)values);
    }

    public int hashCode() {
        return Objects.hash(this.inPort, this.table);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NiciraResubmitTable) {
            NiciraResubmitTable that = (NiciraResubmitTable)((Object)obj);
            return Objects.equals(this.inPort, that.inPort) && this.table == that.table;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("inPort", (Object)this.inPort).add("table", (int)this.table).toString();
    }
}

