/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import org.onlab.packet.VlanId;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVid;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVidMasked;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.VlanVid;

public class OfdpaExtensionSelectorInterpreter
extends AbstractHandlerBehaviour
implements ExtensionSelectorInterpreter,
ExtensionSelectorResolver {
    public boolean supported(ExtensionSelectorType extensionSelectorType) {
        return extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type());
    }

    public OFOxm<?> mapSelector(OFFactory factory, ExtensionSelector extensionSelector) {
        ExtensionSelectorType type = extensionSelector.type();
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type())) {
            VlanId vlanId = ((OfdpaMatchVlanVid)extensionSelector).vlanId();
            if (vlanId.equals((Object)VlanId.NONE)) {
                OFVlanVidMatch vid = OFVlanVidMatch.ofRawVid((short)0);
                OFVlanVidMatch mask = OFVlanVidMatch.ofRawVid((short)8191);
                return factory.oxms().vlanVidMasked(vid, mask);
            }
            if (vlanId.equals((Object)VlanId.ANY)) {
                return factory.oxms().vlanVidMasked(OFVlanVidMatch.PRESENT, OFVlanVidMatch.PRESENT);
            }
            return factory.oxms().vlanVid(OFVlanVidMatch.ofVlanVid((VlanVid)VlanVid.ofVlan((int)vlanId.toShort())));
        }
        throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
    }

    public ExtensionSelector mapOxm(OFOxm<?> oxm) {
        if (oxm.getMatchField().equals(MatchField.VLAN_VID)) {
            VlanId vlanId;
            if (oxm.isMasked()) {
                OFVlanVidMatch vid = ((OFOxmVlanVidMasked)oxm).getValue();
                OFVlanVidMatch mask = ((OFOxmVlanVidMasked)oxm).getMask();
                vlanId = vid.equals((Object)OFVlanVidMatch.ofRawVid((short)0)) ? VlanId.NONE : (vid.equals((Object)OFVlanVidMatch.PRESENT) && mask.equals((Object)OFVlanVidMatch.PRESENT) ? VlanId.ANY : VlanId.vlanId((short)vid.getVlan()));
            } else {
                OFVlanVidMatch vid = ((OFOxmVlanVid)oxm).getValue();
                vlanId = !vid.isPresentBitSet() ? VlanId.NONE : VlanId.vlanId((short)vid.getVlan());
            }
            return new OfdpaMatchVlanVid(vlanId);
        }
        throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
    }

    public ExtensionSelector getExtensionSelector(ExtensionSelectorType type) {
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type())) {
            return new OfdpaMatchVlanVid();
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }
}

