/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpPipeline
extends AbstractHandlerBehaviour
implements Pipeliner {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private FlowRuleService flowRuleService;
    private CoreService coreService;
    private DeviceId deviceId;
    private ApplicationId appId;
    protected FlowObjectiveStore flowObjectiveStore;
    private static final int SOFTWARE_TABLE_START = 200;
    private static final int TIME_OUT = 30;

    public void init(DeviceId deviceId, PipelinerContext context) {
        this.log.debug("Initiate HP pipeline");
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowObjectiveStore = context.store();
        this.appId = this.coreService.registerApplication("org.onosproject.driver.HpPipeline");
    }

    public void filter(FilteringObjective filter) {
    }

    public void forward(final ForwardingObjective forwardObjective) {
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(forwardObjective);
        switch (forwardObjective.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)forwardObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}");
            }
        }
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                HpPipeline.this.pass((Objective)forwardObjective);
            }

            public void onError(FlowRuleOperations ops) {
                HpPipeline.this.fail((Objective)forwardObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        this.log.debug("Processing forwarding object");
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(fwd.selector()).withTreatment(fwd.treatment()).withPriority(fwd.priority()).fromApp(fwd.appId()).forTable(200);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(30);
        }
        return Collections.singletonList(ruleBuilder.build());
    }

    public void next(NextObjective nextObjective) {
    }

    public List<String> getNextMappings(NextGroup nextGroup) {
        return null;
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }
}

