/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.extensions.Ofdpa3PushCw;
import org.onosproject.driver.extensions.Ofdpa3PushL2Header;
import org.onosproject.driver.pipeline.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.Ofdpa2Pipeline;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3GroupHandler
extends Ofdpa2GroupHandler {
    private static final int PW_INTERNAL_VLAN = 4094;
    private static final int MAX_DEPTH_UNPROTECTED_PW = 3;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected Ofdpa2GroupHandler.GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        return this.createL2L3ChainInternal(treatment, nextId, appId, mpls, meta, false);
    }

    @Override
    protected void processPwNextObjective(NextObjective nextObjective) {
        Ofdpa2GroupHandler.GroupChainElem groupChainElem;
        DefaultGroupKey groupKey;
        GroupDescription groupDescription;
        TrafficTreatment treatment = (TrafficTreatment)nextObjective.next().iterator().next();
        ArrayDeque<Object> gkeyChain = new ArrayDeque<Object>();
        TrafficTreatment.Builder l2L3Treatment = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder mplsTreatment = DefaultTrafficTreatment.builder();
        this.createL2L3AndMplsTreatments(treatment, l2L3Treatment, mplsTreatment);
        Ofdpa2GroupHandler.GroupInfo groupInfo = this.createL2L3ChainInternal(l2L3Treatment.build(), nextObjective.id(), nextObjective.appId(), true, nextObjective.meta(), false);
        if (groupInfo == null) {
            this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.GROUPINSTALLATIONFAILED);
            return;
        }
        gkeyChain.addFirst(groupInfo.getInnerMostGroupDesc().appCookie());
        gkeyChain.addFirst(groupInfo.getNextGroupDesc().appCookie());
        ArrayList mplsInstructionSets = Lists.newArrayList();
        ArrayList mplsInstructionSet = Lists.newArrayList();
        for (Instruction ins : treatment.allInstructions()) {
            L3ModificationInstruction l3Ins;
            mplsInstructionSet.add(ins);
            if (ins.type() != Instruction.Type.L3MODIFICATION || (l3Ins = (L3ModificationInstruction)ins).subtype() != L3ModificationInstruction.L3SubType.TTL_OUT) continue;
            mplsInstructionSets.add(mplsInstructionSet);
            mplsInstructionSet = Lists.newArrayList();
        }
        if (mplsInstructionSets.size() > 3) {
            this.log.error("Next Objective for pseudo wire should have at most {} mpls instruction sets. Next Objective Id:{}", (Object)3, (Object)nextObjective.id());
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        int nextGid = groupInfo.getNextGroupDesc().givenGroupId();
        if (mplsInstructionSets.size() == 3) {
            int index = this.getNextAvailableIndex();
            groupDescription = this.createMplsTunnelLabelGroup(nextGid, Ofdpa2GroupHandler.OfdpaMplsGroupSubType.MPLS_TUNNEL_LABEL_2, index, (List)mplsInstructionSets.get(2), nextObjective.appId());
            groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
            groupChainElem = new Ofdpa2GroupHandler.GroupChainElem(groupDescription, 1, false);
            this.updatePendingGroups(groupInfo.getNextGroupDesc().appCookie(), groupChainElem);
            gkeyChain.addFirst(groupKey);
            nextGid = groupDescription.givenGroupId();
            groupInfo = new Ofdpa2GroupHandler.GroupInfo(groupInfo.getInnerMostGroupDesc(), groupDescription);
            this.log.debug("Trying Label 2 Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
        }
        int index = this.getNextAvailableIndex();
        groupDescription = this.createMplsTunnelLabelGroup(nextGid, Ofdpa2GroupHandler.OfdpaMplsGroupSubType.MPLS_TUNNEL_LABEL_1, index, (List)mplsInstructionSets.get(1), nextObjective.appId());
        groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        groupChainElem = new Ofdpa2GroupHandler.GroupChainElem(groupDescription, 1, false);
        this.updatePendingGroups(groupInfo.getNextGroupDesc().appCookie(), groupChainElem);
        gkeyChain.addFirst(groupKey);
        nextGid = groupDescription.givenGroupId();
        groupInfo = new Ofdpa2GroupHandler.GroupInfo(groupInfo.getInnerMostGroupDesc(), groupDescription);
        this.log.debug("Trying Label 1 Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
        index = this.getNextAvailableIndex();
        groupDescription = this.createMplsL2VpnGroup(nextGid, index, (List)mplsInstructionSets.get(0), nextObjective.appId());
        groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        groupChainElem = new Ofdpa2GroupHandler.GroupChainElem(groupDescription, 1, false);
        this.updatePendingGroups(groupInfo.getNextGroupDesc().appCookie(), groupChainElem);
        gkeyChain.addFirst(groupKey);
        Ofdpa2GroupHandler.OfdpaNextGroup ofdpaGrp = new Ofdpa2GroupHandler.OfdpaNextGroup(Collections.singletonList(gkeyChain), nextObjective);
        this.updatePendingNextObjective((GroupKey)groupKey, ofdpaGrp);
        this.log.debug("Trying L2 Vpn Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
        this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.getInnerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
        this.groupService.addGroup(groupInfo.getInnerMostGroupDesc());
    }

    private GroupDescription createMplsTunnelLabelGroup(int nextGroupId, Ofdpa2GroupHandler.OfdpaMplsGroupSubType subtype, int index, List<Instruction> instructions, ApplicationId applicationId) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        instructions.forEach(arg_0 -> ((TrafficTreatment.Builder)treatment).add(arg_0));
        treatment.group((GroupId)new DefaultGroupId(nextGroupId));
        GroupBucket groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment.build());
        int groupId = this.makeMplsLabelGroupId(subtype, index);
        DefaultGroupKey groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        return new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(groupBucket)), (GroupKey)groupKey, Integer.valueOf(groupId), applicationId);
    }

    private GroupDescription createMplsL2VpnGroup(int nextGroupId, int index, List<Instruction> instructions, ApplicationId applicationId) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.extension((ExtensionTreatment)new Ofdpa3PushL2Header(), this.deviceId);
        treatment.pushVlan();
        instructions.forEach(arg_0 -> ((TrafficTreatment.Builder)treatment).add(arg_0));
        treatment.extension((ExtensionTreatment)new Ofdpa3PushCw(), this.deviceId);
        treatment.group((GroupId)new DefaultGroupId(nextGroupId));
        GroupBucket groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment.build());
        int groupId = this.makeMplsLabelGroupId(Ofdpa2GroupHandler.OfdpaMplsGroupSubType.L2_VPN, index);
        DefaultGroupKey groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        return new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(groupBucket)), (GroupKey)groupKey, Integer.valueOf(groupId), applicationId);
    }

    private void createL2L3AndMplsTreatments(TrafficTreatment treatment, TrafficTreatment.Builder l2L3Treatment, TrafficTreatment.Builder mplsTreatment) {
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: 
                    case ETH_SRC: 
                    case VLAN_ID: 
                    case VLAN_POP: {
                        l2L3Treatment.add(ins);
                        break;
                    }
                    case MPLS_BOS: 
                    case DEC_MPLS_TTL: 
                    case MPLS_LABEL: 
                    case MPLS_PUSH: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                l2L3Treatment.add(ins);
                continue;
            }
            if (ins.type() == Instruction.Type.L3MODIFICATION) {
                L3ModificationInstruction l3ins = (L3ModificationInstruction)ins;
                switch (l3ins.subtype()) {
                    case TTL_OUT: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
                        break;
                    }
                }
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction in nextObjectives: {} - {}", (Object)ins.type(), (Object)ins);
        }
        l2L3Treatment.setVlanId(VlanId.vlanId((short)4094));
    }
}

