/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.driver.pipeline.DefaultSingleTablePipeline;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.Pipeliner;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenVSwitchPipeline
extends DefaultSingleTablePipeline
implements Pipeliner {
    private static final String VTN_APP_ID = "org.onosproject.app.vtn";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CoreService coreService;
    private ServiceDirectory serviceDirectory;
    protected FlowObjectiveStore flowObjectiveStore;
    protected DeviceId deviceId;
    protected ApplicationId appId;
    protected FlowRuleService flowRuleService;
    protected DeviceService deviceService;
    private static final int TIME_OUT = 0;
    private static final int CLASSIFIER_TABLE = 0;
    private static final int ENCAP_OUTPUT_TABLE = 4;
    private static final int TUN_SEND_TABLE = 7;
    private static final int ARP_TABLE = 10;
    private static final int DNAT_TABLE = 20;
    private static final int L3FWD_TABLE = 30;
    private static final int SNAT_TABLE = 40;
    private static final int MAC_TABLE = 50;
    private static final int TABLE_MISS_PRIORITY = 0;
    private static final String USERDATA_IP = "169.254.169.254";

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        super.init(deviceId, context);
        this.serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.coreService = (CoreService)this.serviceDirectory.get(CoreService.class);
        this.flowRuleService = (FlowRuleService)this.serviceDirectory.get(FlowRuleService.class);
        this.flowObjectiveStore = context.store();
        this.appId = this.coreService.registerApplication("org.onosproject.driver.OpenVSwitchPipeline");
        this.initializePipeline();
    }

    @Override
    public void filter(FilteringObjective filteringObjective) {
        super.filter(filteringObjective);
    }

    @Override
    public void forward(final ForwardingObjective fwd) {
        if (!VTN_APP_ID.equals(fwd.appId().name())) {
            super.forward(fwd);
            return;
        }
        FlowRuleOperations.Builder flowOpsBuilder = FlowRuleOperations.builder();
        Collection<FlowRule> rules = this.processForward(fwd);
        switch (fwd.op()) {
            case ADD: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).add(arg_0));
                break;
            }
            case REMOVE: {
                rules.stream().filter(Objects::nonNull).forEach(arg_0 -> ((FlowRuleOperations.Builder)flowOpsBuilder).remove(arg_0));
                break;
            }
            default: {
                this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown forwarding type {}", (Object)fwd.op());
            }
        }
        this.flowRuleService.apply(flowOpsBuilder.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                OpenVSwitchPipeline.this.pass((Objective)fwd);
            }

            public void onError(FlowRuleOperations ops) {
                OpenVSwitchPipeline.this.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    @Override
    public void next(NextObjective nextObjective) {
        super.next(nextObjective);
    }

    private void initializePipeline() {
        this.processClassifierTable(true);
        this.processArpTable(true);
        this.processDnatTable(true);
        this.processL3fwdTable(true);
        this.processSnatTable(true);
        this.processMacTable(true);
    }

    private void processClassifierTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(50));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(0).build();
        this.applyRules(install, rule);
    }

    private void processArpTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(50));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(10).build();
        this.applyRules(install, rule);
    }

    private void processDnatTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(50));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(20).build();
        this.applyRules(install, rule);
    }

    private void processL3fwdTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(40));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(30).build();
        this.applyRules(install, rule);
    }

    private void processSnatTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.transition(Integer.valueOf(50));
        treatment.add((Instruction)Instructions.createOutput((PortNumber)PortNumber.CONTROLLER));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(40).build();
        this.applyRules(install, rule);
    }

    private void processMacTable(boolean install) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.drop();
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(0).fromApp(this.appId).makePermanent().forTable(50).build();
        this.applyRules(install, rule);
    }

    private void applyRules(boolean install, final FlowRule rule) {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        ops = install ? ops.add(rule) : ops.remove(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                OpenVSwitchPipeline.this.log.info("ONOSW provisioned " + rule.tableId() + " table");
            }

            public void onError(FlowRuleOperations ops) {
                OpenVSwitchPipeline.this.log.info("ONOSW failed to provision " + rule.tableId() + " table");
            }
        }));
    }

    private Collection<FlowRule> processForward(ForwardingObjective fwd) {
        switch (fwd.flag()) {
            case SPECIFIC: {
                return this.processSpecific(fwd);
            }
            case VERSATILE: {
                return this.processVersatile(fwd);
            }
        }
        this.fail((Objective)fwd, ObjectiveError.UNKNOWN);
        this.log.warn("Unknown forwarding flag {}", (Object)fwd.flag());
        return Collections.emptySet();
    }

    private Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.debug("Processing versatile forwarding objective");
        TrafficSelector selector = fwd.selector();
        TrafficTreatment tb = fwd.treatment();
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(selector).withTreatment(tb).makeTemporary(0);
        ruleBuilder.withPriority(fwd.priority());
        if (fwd.priority() == 100) {
            ruleBuilder.forTable(4);
        } else if (fwd.priority() == 200) {
            ruleBuilder.forTable(7);
        } else {
            ruleBuilder.forTable(0);
        }
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        }
        return Collections.singletonList(ruleBuilder.build());
    }

    private Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific forwarding objective");
        TrafficSelector selector = fwd.selector();
        TrafficTreatment tb = fwd.treatment();
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(selector).withTreatment(tb).makeTemporary(0);
        ruleBuilder.withPriority(fwd.priority());
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        }
        Integer transition = null;
        Integer forTable = null;
        if (selector.getCriterion(Criterion.Type.TUNNEL_ID) != null && (selector.getCriterion(Criterion.Type.ETH_DST) != null || selector.getCriterion(Criterion.Type.ETH_SRC) != null)) {
            forTable = 50;
            return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
        }
        if (selector.getCriterion(Criterion.Type.IN_PORT) != null) {
            forTable = 0;
            if (selector.getCriterion(Criterion.Type.ETH_SRC) != null && selector.getCriterion(Criterion.Type.ETH_DST) != null) {
                transition = 30;
            } else if (selector.getCriterion(Criterion.Type.ETH_SRC) != null || selector.getCriterion(Criterion.Type.TUNNEL_ID) != null) {
                transition = 50;
            } else if (selector.getCriterion(Criterion.Type.IPV4_DST) != null) {
                transition = 20;
            } else if (selector.getCriterion(Criterion.Type.ETH_TYPE) != null && selector.getCriterion(Criterion.Type.ETH_TYPE).equals(Criteria.matchEthType((int)EthType.EtherType.ARP.ethType().toShort()))) {
                transition = 10;
            }
            return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
        }
        if (selector.getCriterion(Criterion.Type.ETH_TYPE) != null && selector.getCriterion(Criterion.Type.ETH_TYPE).equals(Criteria.matchEthType((int)EthType.EtherType.ARP.ethType().toShort()))) {
            if (selector.getCriterion(Criterion.Type.TUNNEL_ID) == null) {
                if (selector.getCriterion(Criterion.Type.ARP_OP) != null) {
                    forTable = 0;
                    return this.reassemblyFlowRule(ruleBuilder, tb, null, forTable);
                }
                transition = 10;
                forTable = 0;
                return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
            }
            forTable = 10;
            return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
        }
        if (selector.getCriterion(Criterion.Type.TUNNEL_ID) != null && selector.getCriterion(Criterion.Type.IPV4_SRC) != null) {
            transition = 50;
            forTable = 40;
            return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
        }
        if (selector.getCriterion(Criterion.Type.TUNNEL_ID) != null && selector.getCriterion(Criterion.Type.IPV4_DST) != null) {
            transition = 50;
            forTable = 30;
            return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
        }
        if (selector.getCriterion(Criterion.Type.IPV4_DST) != null) {
            IPCriterion ipCriterion = (IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST);
            IpPrefix ipPrefix = ipCriterion.ip();
            if (ipPrefix.address().equals((Object)IpAddress.valueOf((String)USERDATA_IP))) {
                forTable = 0;
                transition = 50;
                return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
            }
            transition = 30;
            forTable = 20;
            return this.reassemblyFlowRule(ruleBuilder, tb, transition, forTable);
        }
        return Collections.singletonList(ruleBuilder.build());
    }

    private Collection<FlowRule> reassemblyFlowRule(FlowRule.Builder ruleBuilder, TrafficTreatment tb, Integer transition, Integer forTable) {
        if (transition != null) {
            TrafficTreatment.Builder newTraffic = DefaultTrafficTreatment.builder();
            tb.allInstructions().forEach(t -> newTraffic.add(t));
            newTraffic.transition(transition);
            ruleBuilder.withTreatment(newTraffic.build());
        } else {
            ruleBuilder.withTreatment(tb);
        }
        if (forTable != null) {
            ruleBuilder.forTable(forTable.intValue());
        }
        return Collections.singletonList(ruleBuilder.build());
    }

    private void fail(Objective obj, ObjectiveError error) {
        obj.context().ifPresent(context -> context.onError(obj, error));
    }

    private void pass(Objective obj) {
        obj.context().ifPresent(context -> context.onSuccess(obj));
    }
}

