/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.flow.AbstractExtension;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;

public class NiciraMatchCtMark
extends AbstractExtension
implements ExtensionSelector {
    private long ctMark;
    private long ctMarkMask;
    private final KryoNamespace appKryo = new KryoNamespace.Builder().register(new Class[]{HashMap.class}).build();

    NiciraMatchCtMark() {
        this.ctMark = 0L;
        this.ctMarkMask = -1L;
    }

    public NiciraMatchCtMark(long ctMark) {
        this.ctMark = ctMark;
        this.ctMarkMask = -1L;
    }

    public NiciraMatchCtMark(long ctMark, long mask) {
        this.ctMark = ctMark;
        this.ctMarkMask = mask;
    }

    public long ctMark() {
        return this.ctMark;
    }

    public long ctMarkMask() {
        return this.ctMarkMask;
    }

    public ExtensionSelectorType type() {
        return ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_MARK.type();
    }

    public void deserialize(byte[] data) {
        Map values = (Map)this.appKryo.deserialize(data);
        this.ctMark = (Long)values.get("ctMark");
        this.ctMarkMask = (Long)values.get("ctMarkMask");
    }

    public byte[] serialize() {
        HashMap values = Maps.newHashMap();
        values.put("ctMark", this.ctMark);
        values.put("ctMarkMask", this.ctMarkMask);
        return this.appKryo.serialize((Object)values);
    }

    public int hashCode() {
        return Objects.hash(this.ctMark, this.ctMarkMask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NiciraMatchCtMark) {
            NiciraMatchCtMark that = (NiciraMatchCtMark)((Object)obj);
            return Objects.equals(this.ctMark, that.ctMark) && Objects.equals(this.ctMarkMask, that.ctMarkMask);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("ctMark", this.ctMark).add("ctMarkMask", this.ctMarkMask).toString();
    }
}

