/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import org.onlab.packet.VlanId;
import org.onosproject.driver.extensions.OfdpaMatchActsetOutput;
import org.onosproject.driver.extensions.OfdpaMatchAllowVlanTranslation;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaActsetOutput;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaAllowVlanTranslation;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVid;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanVidMasked;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.types.VlanVid;

public class OfdpaExtensionSelectorInterpreter
extends AbstractHandlerBehaviour
implements ExtensionSelectorInterpreter,
ExtensionSelectorResolver {
    public boolean supported(ExtensionSelectorType extensionSelectorType) {
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ACTSET_OUTPUT.type())) {
            return true;
        }
        return extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ALLOW_VLAN_TRANSLATION.type());
    }

    public OFOxm<?> mapSelector(OFFactory factory, ExtensionSelector extensionSelector) {
        ExtensionSelectorType type = extensionSelector.type();
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type())) {
            VlanId vlanId = ((OfdpaMatchVlanVid)extensionSelector).vlanId();
            if (vlanId.equals((Object)VlanId.NONE)) {
                OFVlanVidMatch vid = OFVlanVidMatch.ofRawVid((short)0);
                OFVlanVidMatch mask = OFVlanVidMatch.ofRawVid((short)8191);
                return factory.oxms().vlanVidMasked(vid, mask);
            }
            if (vlanId.equals((Object)VlanId.ANY)) {
                return factory.oxms().vlanVidMasked(OFVlanVidMatch.PRESENT, OFVlanVidMatch.PRESENT);
            }
            return factory.oxms().vlanVid(OFVlanVidMatch.ofVlanVid((VlanVid)VlanVid.ofVlan((int)vlanId.toShort())));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ACTSET_OUTPUT.type())) {
            PortNumber port = ((OfdpaMatchActsetOutput)extensionSelector).port();
            return factory.oxms().ofdpaActsetOutput(U32.of((long)port.toLong()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ALLOW_VLAN_TRANSLATION.type())) {
            Short allowVlanTranslation = ((OfdpaMatchAllowVlanTranslation)extensionSelector).allowVlanTranslation();
            return factory.oxms().ofdpaAllowVlanTranslation(U8.of((short)allowVlanTranslation));
        }
        throw new UnsupportedOperationException("Unexpected ExtensionSelector: " + extensionSelector.toString());
    }

    public ExtensionSelector mapOxm(OFOxm<?> oxm) {
        if (oxm.getMatchField().equals(MatchField.VLAN_VID)) {
            VlanId vlanId;
            if (oxm.isMasked()) {
                OFVlanVidMatch vid = ((OFOxmVlanVidMasked)oxm).getValue();
                OFVlanVidMatch mask = ((OFOxmVlanVidMasked)oxm).getMask();
                vlanId = vid.equals((Object)OFVlanVidMatch.ofRawVid((short)0)) ? VlanId.NONE : (vid.equals((Object)OFVlanVidMatch.PRESENT) && mask.equals((Object)OFVlanVidMatch.PRESENT) ? VlanId.ANY : VlanId.vlanId((short)vid.getVlan()));
            } else {
                OFVlanVidMatch vid = ((OFOxmVlanVid)oxm).getValue();
                vlanId = !vid.isPresentBitSet() ? VlanId.NONE : VlanId.vlanId((short)vid.getVlan());
            }
            return new OfdpaMatchVlanVid(vlanId);
        }
        if (oxm.getMatchField().equals(MatchField.OFDPA_ACTSET_OUTPUT)) {
            U32 portNumberU32 = ((OFOxmOfdpaActsetOutput)oxm).getValue();
            PortNumber portNumber = PortNumber.portNumber((long)portNumberU32.getValue());
            return new OfdpaMatchActsetOutput(portNumber);
        }
        if (oxm.getMatchField().equals(MatchField.OFDPA_ALLOW_VLAN_TRANSLATION)) {
            U8 value = ((OFOxmOfdpaAllowVlanTranslation)oxm).getValue();
            return new OfdpaMatchAllowVlanTranslation(value.getValue());
        }
        throw new UnsupportedOperationException("Unexpected OXM: " + oxm.toString());
    }

    public ExtensionSelector getExtensionSelector(ExtensionSelectorType type) {
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_VLAN_VID.type())) {
            return new OfdpaMatchVlanVid();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ACTSET_OUTPUT.type())) {
            return new OfdpaMatchActsetOutput();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.OFDPA_MATCH_ALLOW_VLAN_TRANSLATION.type())) {
            return new OfdpaMatchAllowVlanTranslation();
        }
        throw new UnsupportedOperationException("Driver does not support extension type " + type.toString());
    }
}

