/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.NiciraSetNshContextHeader;
import org.onosproject.net.NshContextHeader;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;

public class NiciraSetNshContextHeaderCodec
extends JsonCodec<NiciraSetNshContextHeader> {
    private static final String NSH_CONTEXT_HEADER = "nshch";
    private static final String TYPE = "type";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in NiciraSetNshContextHeader";

    public ObjectNode encode(NiciraSetNshContextHeader niciraSetNshContextHeader, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)niciraSetNshContextHeader), (Object)"Nicira Set Nsh Context Header cannot be null");
        ObjectNode root = context.mapper().createObjectNode().put(NSH_CONTEXT_HEADER, niciraSetNshContextHeader.nshCh().nshContextHeader()).put(TYPE, niciraSetNshContextHeader.type().type());
        return root;
    }

    public NiciraSetNshContextHeader decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        int contextHeaderInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(NSH_CONTEXT_HEADER), (String)"nshch member is required in NiciraSetNshContextHeader")).asInt();
        NshContextHeader contextHeader = NshContextHeader.of((int)contextHeaderInt);
        int extensionTypeInt = ((JsonNode)Tools.nullIsIllegal((Object)json.get(TYPE), (String)"type member is required in NiciraSetNshContextHeader")).asInt();
        ExtensionTreatmentType type = new ExtensionTreatmentType(extensionTypeInt);
        return new NiciraSetNshContextHeader(contextHeader, type);
    }
}

