/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.driver.extensions.OfdpaMatchVlanVid;

public class OfdpaMatchVlanVidCodec
extends JsonCodec<OfdpaMatchVlanVid> {
    private static final String VLAN_ID = "vlanId";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in OfdpaMatchVlanVid";
    private static final String MISSING_VLAN_ID_MESSAGE = "Vlan ID cannot be null";

    public ObjectNode encode(OfdpaMatchVlanVid vlanId, CodecContext context) {
        Preconditions.checkNotNull((Object)((Object)vlanId), (Object)MISSING_VLAN_ID_MESSAGE);
        return context.mapper().createObjectNode().put(VLAN_ID, (Short)vlanId.vlanId().id());
    }

    public OfdpaMatchVlanVid decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        short vlanVid = (short)((JsonNode)Tools.nullIsIllegal((Object)json.get(VLAN_ID), (String)"vlanId member is required in OfdpaMatchVlanVid")).asInt();
        return new OfdpaMatchVlanVid(VlanId.vlanId((short)vlanVid));
    }
}

