/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Optional;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.EthType;
import org.onosproject.driver.pipeline.DefaultSingleTablePipeline;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiscoN9kPipeliner
extends DefaultSingleTablePipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServiceDirectory serviceDirectory;
    private DeviceId deviceId;
    protected DeviceService deviceService;

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        super.init(deviceId, context);
        this.deviceId = deviceId;
        this.serviceDirectory = context.directory();
        this.deviceService = (DeviceService)this.serviceDirectory.get(DeviceService.class);
    }

    @Override
    public void forward(ForwardingObjective forwardObjective) {
        EthTypeCriterion ethType;
        ForwardingObjective newFwd = forwardObjective;
        Device device = this.deviceService.getDevice(this.deviceId);
        if (forwardObjective.treatment() != null && forwardObjective.treatment().clearedDeferred()) {
            this.log.warn("Using 'clear actions' instruction which is not supported by {} {} {} Switch removing the clear deferred from the forwarding objective", new Object[]{device.id(), device.manufacturer(), device.hwVersion()});
            newFwd = this.forwardingObjectiveWithoutCleardDef(forwardObjective).orElse(forwardObjective);
        }
        if ((ethType = (EthTypeCriterion)newFwd.selector().getCriterion(Criterion.Type.ETH_TYPE)) != null && ethType.ethType() == EthType.EtherType.IPV6.ethType()) {
            this.log.error("IPv6 type not supported for {} {} {} Switch, The FlowRule associated with IPv6 is dropped.", new Object[]{device.id(), device.manufacturer(), device.hwVersion()});
            return;
        }
        super.forward(newFwd);
    }

    private Optional<ForwardingObjective> forwardingObjectiveWithoutCleardDef(ForwardingObjective forwardingObjective) {
        TrafficTreatment treatment = this.trafficTreatmentWithoutClearedDeffered(forwardingObjective.treatment());
        DefaultForwardingObjective.Builder foBuilder = (DefaultForwardingObjective.Builder)forwardingObjective.copy();
        foBuilder.withTreatment(treatment);
        switch (forwardingObjective.op()) {
            case ADD: {
                return Optional.of(foBuilder.add((ObjectiveContext)forwardingObjective.context().orElse(null)));
            }
            case REMOVE: {
                return Optional.of(foBuilder.remove((ObjectiveContext)forwardingObjective.context().orElse(null)));
            }
        }
        this.log.warn("Driver does not support other operations for forwarding objective");
        return Optional.empty();
    }

    private TrafficTreatment trafficTreatmentWithoutClearedDeffered(TrafficTreatment treatment) {
        return DefaultTrafficTreatment.builder((TrafficTreatment)treatment).notWipeDeferred().build();
    }
}

