/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.driver.pipeline.SpringOpenTTP;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringOpenTTPDell
extends SpringOpenTTP {
    private static final int DELL_TABLE_VLAN = 17;
    private static final int DELL_TABLE_TMAC = 18;
    private static final int DELL_TABLE_IPV4_UNICAST = 30;
    private static final int DELL_TABLE_MPLS = 25;
    private static final int DELL_TABLE_ACL = 40;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MacAddress deviceTMac = null;

    public SpringOpenTTPDell() {
        this.vlanTableId = 17;
        this.tmacTableId = 18;
        this.ipv4UnicastTableId = 30;
        this.mplsTableId = 25;
        this.aclTableId = 40;
    }

    @Override
    protected void setTableMissEntries() {
    }

    @Override
    protected Collection<FlowRule> processSpecific(ForwardingObjective fwd) {
        this.log.debug("Processing specific");
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4 && ethType.ethType().toShort() != Ethernet.MPLS_UNICAST) {
            this.log.debug("processSpecific: Unsupported forwarding objective criteraia");
            this.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        int forTableId = -1;
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            if (this.deviceTMac == null) {
                this.log.debug("processSpecific: ETH_DST filtering objective is not set which is required before sending a IPv4 forwarding objective");
                this.fail((Objective)fwd, ObjectiveError.DEVICEMISSING);
                return Collections.emptySet();
            }
            filteredSelectorBuilder = filteredSelectorBuilder.matchEthType(Ethernet.TYPE_IPV4).matchEthDst(this.deviceTMac).matchIPDst(((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip());
            forTableId = this.ipv4UnicastTableId;
            this.log.debug("processing IPv4 specific forwarding objective");
        } else {
            filteredSelectorBuilder = filteredSelectorBuilder.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            if (selector.getCriterion(Criterion.Type.MPLS_BOS) != null) {
                filteredSelectorBuilder.matchMplsBos(((MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS)).mplsBos());
            }
            forTableId = this.mplsTableId;
            this.log.debug("processing MPLS specific forwarding objective");
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction i : fwd.treatment().allInstructions()) {
                treatmentBuilder.add(i);
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(fwd.nextId());
            if (next != null) {
                SpringOpenTTP.SpringOpenGroup soGroup = (SpringOpenTTP.SpringOpenGroup)this.appKryo.deserialize(next.data());
                if (soGroup.dummy()) {
                    this.log.debug("Adding {} flow-actions for fwd. obj. {} -> next:{} in dev: {}", new Object[]{soGroup.treatment().allInstructions().size(), fwd.id(), fwd.nextId(), this.deviceId});
                    for (Instruction ins : soGroup.treatment().allInstructions()) {
                        treatmentBuilder.add(ins);
                    }
                } else {
                    Group group = this.groupService.getGroup(this.deviceId, soGroup.key());
                    if (group == null) {
                        this.log.warn("The group left!");
                        this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                        return Collections.emptySet();
                    }
                    treatmentBuilder.group(group.id());
                    this.log.debug("Adding OUTGROUP action to group:{} for fwd. obj. {} for next:{} in dev: {}", new Object[]{group.id(), fwd.id(), fwd.nextId(), this.deviceId});
                }
            } else {
                this.log.warn("processSpecific: No associated next objective object");
                this.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        TrafficTreatment treatment = treatmentBuilder.transition(Integer.valueOf(this.aclTableId)).build();
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(treatment);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ruleBuilder.forTable(forTableId);
        return Collections.singletonList(ruleBuilder.build());
    }

    @Override
    protected List<FlowRule> processEthDstFilter(EthCriterion ethCriterion, VlanIdCriterion vlanIdCriterion, FilteringObjective filt, VlanId assignedVlan, ApplicationId applicationId) {
        this.deviceTMac = ethCriterion.mac();
        this.log.debug("For now not adding any TMAC rules into Dell switches as it is ignoring");
        return Collections.emptyList();
    }

    @Override
    protected List<FlowRule> processVlanIdFilter(VlanIdCriterion vlanIdCriterion, FilteringObjective filt, VlanId assignedVlan, VlanId modifiedVlan, VlanId pushedVlan, boolean popVlan, boolean pushVlan, ApplicationId applicationId) {
        this.log.debug("For now not adding any VLAN rules into Dell switches as it is ignoring");
        return Collections.emptyList();
    }
}

