/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.extensions.OfdpaMatchActsetOutput;
import org.onosproject.driver.pipeline.ofdpa.CpqdOfdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.FlowRuleOperationsContext;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.MplsBosCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.PacketPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpqdOfdpa2Pipeline
extends Ofdpa2Pipeline {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int EGRESS_VLAN_FLOW_TABLE_IN_INGRESS = 31;
    private static final int UNICAST_ROUTING_TABLE_1 = 32;
    private static final int PUNT_TABLE = 63;
    private static final int POP_VLAN_PUNT_GROUP_ID = -805306368;
    private ScheduledExecutorService groupChecker;
    private Queue<FlowRule> flowRuleQueue;
    private ReentrantLock groupCheckerLock;

    @Override
    protected boolean requireVlanExtensions() {
        return false;
    }

    protected boolean supportCopyTtl() {
        return true;
    }

    protected boolean supportTaggedMpls() {
        return false;
    }

    protected boolean supportPuntGroup() {
        return false;
    }

    @Override
    protected void initDriverId() {
        this.driverId = this.coreService.registerApplication("org.onosproject.driver.CpqdOfdpa2Pipeline");
    }

    @Override
    protected void initGroupHander(PipelinerContext context) {
        this.groupHandler = new CpqdOfdpa2GroupHandler();
        this.groupHandler.init(this.deviceId, context);
    }

    @Override
    public void init(DeviceId deviceId, PipelinerContext context) {
        if (this.supportPuntGroup()) {
            this.groupChecker = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/driver", (String)"cpqd-ofdpa-%d", (Logger)this.log));
            this.flowRuleQueue = new ConcurrentLinkedQueue<FlowRule>();
            this.groupCheckerLock = new ReentrantLock();
            this.groupChecker.scheduleAtFixedRate(new PopVlanPuntGroupChecker(), 20L, 50L, TimeUnit.MILLISECONDS);
            super.init(deviceId, context);
        }
    }

    @Override
    protected void processFilter(FilteringObjective filteringObjective, boolean install, ApplicationId applicationId) {
        if (this.isDoubleTagged(filteringObjective)) {
            this.processDoubleTaggedFilter(filteringObjective, install, applicationId);
        } else {
            super.processFilter(filteringObjective, install, applicationId);
        }
    }

    private boolean isDoubleTagged(FilteringObjective fob) {
        return fob.meta() != null && fob.meta().allInstructions().stream().anyMatch(inst -> inst.type() == Instruction.Type.L2MODIFICATION && ((L2ModificationInstruction)inst).subtype() == L2ModificationInstruction.L2SubType.VLAN_POP) && fob.conditions().stream().filter((? super T criterion) -> criterion.type() == Criterion.Type.VLAN_VID).count() == 2L;
    }

    private boolean isDoubleTagged(ForwardingObjective fwd) {
        int groupId;
        List gkeys;
        Group group;
        NextGroup next;
        return fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null && (group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)(gkeys = (List)appKryo.deserialize(next.data())).get(0)).peekFirst())) != null && ((groupId = ((Integer)group.id().id()).intValue()) & 0xF0000000) == 0x20000000 && (groupId & 0x8000000) == 0x8000000;
    }

    private void processDoubleTaggedFilter(final FilteringObjective filteringObjective, boolean install, ApplicationId applicationId) {
        PortCriterion portCriterion = null;
        EthCriterion ethCriterion = null;
        VlanIdCriterion innervidCriterion = null;
        VlanIdCriterion outerVidCriterion = null;
        boolean popVlan = false;
        TrafficTreatment meta = filteringObjective.meta();
        if (!filteringObjective.key().equals(Criteria.dummy()) && filteringObjective.key().type() == Criterion.Type.IN_PORT) {
            portCriterion = (PortCriterion)filteringObjective.key();
        }
        if (portCriterion == null) {
            this.log.warn("No IN_PORT defined in filtering objective from app: {}Failed to program VLAN tables.", (Object)applicationId);
            return;
        }
        this.log.debug("Received filtering objective for dev/port: {}/{}", (Object)this.deviceId, (Object)portCriterion.port());
        if (meta != null && meta.allInstructions().size() == 1) {
            L2ModificationInstruction l2Inst = (L2ModificationInstruction)meta.allInstructions().get(0);
            if (!l2Inst.subtype().equals((Object)L2ModificationInstruction.L2SubType.VLAN_POP)) {
                this.log.warn("Filtering objective can have only VLAN_POP instruction.");
                return;
            }
        } else {
            this.log.warn("Filtering objective should have one instruction.");
            return;
        }
        popVlan = true;
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        block4: for (Criterion criterion : filteringObjective.conditions()) {
            switch (criterion.type()) {
                case ETH_DST: 
                case ETH_DST_MASKED: {
                    ethCriterion = (EthCriterion)criterion;
                    continue block4;
                }
                case VLAN_VID: {
                    if (innervidCriterion == null) {
                        innervidCriterion = (VlanIdCriterion)criterion;
                        continue block4;
                    }
                    outerVidCriterion = innervidCriterion;
                    innervidCriterion = (VlanIdCriterion)criterion;
                    continue block4;
                }
            }
            this.log.warn("Unsupported filter {}", (Object)criterion);
            CpqdOfdpa2Pipeline.fail((Objective)filteringObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        if (innervidCriterion == null || outerVidCriterion == null) {
            this.log.warn("filtering objective should have two vidCriterion.");
            return;
        }
        if (ethCriterion == null || ethCriterion.mac().equals((Object)MacAddress.NONE)) {
            this.log.warn("filtering objective missing dstMac, cannot program TMAC table");
            return;
        }
        MacAddress unicastMac = CpqdOfdpa2Pipeline.readEthDstFromTreatment(filteringObjective.meta());
        List<List<FlowRule>> allStages = this.processEthDstFilter(portCriterion, ethCriterion, innervidCriterion, innervidCriterion.vlanId(), unicastMac, applicationId);
        for (List<FlowRule> flowRules : allStages) {
            this.log.trace("Starting a new flow rule stage for TMAC table flow");
            ops.newStage();
            for (FlowRule flowRule : flowRules) {
                this.log.trace("{} flow rules in TMAC table: {} for dev: {}", new Object[]{install ? "adding" : "removing", flowRules, this.deviceId});
                if (install) {
                    ops = ops.add(flowRule);
                    continue;
                }
                if (this.matchInPortTmacTable() || filteringObjective.meta() != null && filteringObjective.meta().clearedDeferred()) {
                    ops = ops.remove(flowRule);
                    continue;
                }
                this.log.debug("Abort TMAC flow removal on {}. Some other ports still share this TMAC flow");
            }
        }
        List<FlowRule> rules = this.processDoubleVlanIdFilter(portCriterion, innervidCriterion, outerVidCriterion, popVlan, applicationId);
        for (FlowRule flowRule : rules) {
            this.log.trace("{} flow rule in VLAN table: {} for dev: {}", new Object[]{install ? "adding" : "removing", flowRule, this.deviceId});
            ops = install ? ops.add(flowRule) : ops.remove(flowRule);
        }
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.debug("Applied {} filtering rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)CpqdOfdpa2Pipeline.this.deviceId);
                Ofdpa2Pipeline.pass((Objective)filteringObjective);
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Failed to apply all filtering rules in dev {}", (Object)CpqdOfdpa2Pipeline.this.deviceId);
                Ofdpa2Pipeline.fail((Objective)filteringObjective, ObjectiveError.FLOWINSTALLATIONFAILED);
            }
        }));
    }

    private List<FlowRule> processDoubleVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion innerVidCriterion, VlanIdCriterion outerVidCriterion, boolean popVlan, ApplicationId applicationId) {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder outerSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder outerTreatment = DefaultTrafficTreatment.builder();
        TrafficSelector.Builder innerSelector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder innerTreatment = DefaultTrafficTreatment.builder();
        VlanId outerVlanId = outerVidCriterion.vlanId();
        VlanId innerVlanId = innerVidCriterion.vlanId();
        PortNumber portNumber = portCriterion.port();
        if (PortNumber.ALL.equals((Object)portNumber) || outerVlanId.equals((Object)VlanId.NONE) || innerVlanId.equals((Object)VlanId.NONE)) {
            this.log.warn("Incomplete Filtering Objective. VLAN Table cannot be programmed for {}", (Object)this.deviceId);
            return ImmutableList.of();
        }
        outerSelector.matchInPort(portNumber);
        innerSelector.matchInPort(portNumber);
        outerTreatment.transition(Integer.valueOf(11));
        innerTreatment.transition(Integer.valueOf(20));
        outerTreatment.writeMetadata((long)outerVlanId.toShort(), 4095L);
        outerSelector.matchVlanId(outerVlanId);
        innerSelector.matchVlanId(innerVlanId);
        innerSelector.matchMetadata((long)outerVlanId.toShort());
        if (popVlan) {
            outerTreatment.popVlan();
        }
        if (this.supportPuntGroup()) {
            GroupKey groupKey = this.popVlanPuntGroupKey();
            Group group = this.groupService.getGroup(this.deviceId, groupKey);
            if (group != null) {
                TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchInPort(portNumber).matchVlanId(innerVlanId);
                Host host = ((HostService)this.handler().get(HostService.class)).getConnectedHosts(ConnectPoint.deviceConnectPoint((String)(this.deviceId + "/" + portNumber.toLong()))).stream().filter((? super T h) -> h.vlan().equals((Object)outerVlanId)).findFirst().orElse(null);
                EthType vlanType = EthType.EtherType.VLAN.ethType();
                if (host != null) {
                    vlanType = host.tpid();
                }
                TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().pushVlan(vlanType).setVlanId(outerVlanId).punt();
                rules.add(DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue()).fromApp(this.driverId).makePermanent().forTable(63).build());
            } else {
                this.log.info("popVlanPuntGroup not found in dev:{}", (Object)this.deviceId);
                return Collections.emptyList();
            }
        }
        FlowRule outerRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(outerSelector.build()).withTreatment(outerTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
        FlowRule innerRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(innerSelector.build()).withTreatment(innerTreatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(11).build();
        rules.add(outerRule);
        rules.add(innerRule);
        return rules;
    }

    @Override
    protected Collection<FlowRule> processEgress(ForwardingObjective fwd) {
        this.log.debug("Processing egress forwarding objective:{} in dev:{}", (Object)fwd, (Object)this.deviceId);
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder sb = DefaultTrafficSelector.builder();
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)fwd.selector().getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.error("Egress forwarding objective:{} must include vlanId", (Object)fwd.id());
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return rules;
        }
        Optional<Instruction> outInstr = fwd.treatment().allInstructions().stream().filter((? super T instruction) -> instruction instanceof Instructions.OutputInstruction).findFirst();
        if (!outInstr.isPresent()) {
            this.log.error("Egress forwarding objective:{} must include output port", (Object)fwd.id());
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return rules;
        }
        PortNumber portNumber = ((Instructions.OutputInstruction)outInstr.get()).port();
        sb.matchVlanId(vlanIdCriterion.vlanId());
        OfdpaMatchActsetOutput actsetOutput = new OfdpaMatchActsetOutput(portNumber);
        sb.extension((ExtensionSelector)actsetOutput, this.deviceId);
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        tb.transition(Integer.valueOf(32));
        if (fwd.treatment() != null) {
            for (Instruction instr : fwd.treatment().allInstructions()) {
                if (instr instanceof L2ModificationInstruction && ((L2ModificationInstruction)instr).subtype() == L2ModificationInstruction.L2SubType.VLAN_ID) {
                    tb.immediate().add(instr);
                }
                if (!(instr instanceof L2ModificationInstruction) || ((L2ModificationInstruction)instr).subtype() != L2ModificationInstruction.L2SubType.VLAN_PUSH) continue;
                EthType ethType = ((L2ModificationInstruction.ModVlanHeaderInstruction)instr).ethernetType();
                tb.immediate().pushVlan(ethType);
            }
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sb.build()).withTreatment(tb.build()).makePermanent().forTable(31);
        rules.add(ruleBuilder.build());
        return rules;
    }

    protected Collection<FlowRule> processDoubleTaggedFwd(ForwardingObjective fwd) {
        TrafficSelector selector = fwd.selector();
        TrafficSelector.Builder sBuilder = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            sBuilder.matchEthType(Ethernet.TYPE_IPV4);
            sBuilder.matchVlanId(VlanId.ANY);
            IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            if (!ipv4Dst.isMulticast() && ipv4Dst.prefixLength() == 32) {
                sBuilder.matchIPDst(ipv4Dst);
                if (fwd.nextId() != null) {
                    NextGroup next = this.getGroupForNextObjective(fwd.nextId());
                    if (next != null) {
                        List gkeys = (List)appKryo.deserialize(next.data());
                        Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
                        if (group == null) {
                            this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                            return Collections.emptySet();
                        }
                        outerTtb.immediate().setVlanId(CpqdOfdpa2Pipeline.extractDummyVlanIdFromGroupId((Integer)group.id().id()));
                        outerTtb.deferred().setOutput(CpqdOfdpa2Pipeline.extractOutputPortFromGroupId((Integer)group.id().id()));
                        outerTtb.transition(Integer.valueOf(31));
                        innerTtb.deferred().group(group.id());
                        innerTtb.transition(Integer.valueOf(60));
                        FlowRule.Builder innerRuleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sBuilder.build()).withTreatment(innerTtb.build()).forTable(32);
                        if (fwd.permanent()) {
                            innerRuleBuilder.makePermanent();
                        } else {
                            innerRuleBuilder.makeTemporary(fwd.timeout());
                        }
                        HashSet<FlowRule> flowRuleCollection = new HashSet<FlowRule>();
                        flowRuleCollection.add(innerRuleBuilder.build());
                        FlowRule.Builder outerRuleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sBuilder.build()).withTreatment(outerTtb.build()).forTable(30);
                        if (fwd.permanent()) {
                            outerRuleBuilder.makePermanent();
                        } else {
                            outerRuleBuilder.makeTemporary(fwd.timeout());
                        }
                        flowRuleCollection.add(innerRuleBuilder.build());
                        flowRuleCollection.add(outerRuleBuilder.build());
                        return flowRuleCollection;
                    }
                    this.log.warn("Cannot find group for nextId:{} in dev:{}. Aborting fwd:{}", new Object[]{fwd.nextId(), this.deviceId, fwd.id()});
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                    return Collections.emptySet();
                }
                this.log.warn("NextId is not specified in fwd:{}", (Object)fwd.id());
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.FLOWINSTALLATIONFAILED);
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }

    private static VlanId extractDummyVlanIdFromGroupId(int groupId) {
        short vlanId = (short)((groupId & 0x7FF8000) >> 15);
        return VlanId.vlanId((short)vlanId);
    }

    private static PortNumber extractOutputPortFromGroupId(int groupId) {
        return PortNumber.portNumber((long)(groupId & Short.MAX_VALUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<List<FlowRule>> processVlanIdFilter(PortCriterion portCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, ApplicationId applicationId) {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchVlanId(vidCriterion.vlanId());
        treatment.transition(Integer.valueOf(20));
        if (vidCriterion.vlanId() == VlanId.NONE) {
            treatment.pushVlan().setVlanId(assignedVlan);
        } else if (!vidCriterion.vlanId().equals((Object)assignedVlan)) {
            treatment.setVlanId(assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion != null) {
            if (portCriterion.port() == PortNumber.ALL) {
                for (Port port : this.deviceService.getPorts(this.deviceId)) {
                    if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                    portnums.add(port.number());
                }
            } else {
                portnums.add(portCriterion.port());
            }
        }
        for (PortNumber pnum : portnums) {
            if (this.supportPuntGroup() && vidCriterion.vlanId() == VlanId.NONE) {
                try {
                    this.groupCheckerLock.lock();
                    if (this.flowRuleQueue == null) {
                        this.log.debug("Installing punt table rule for untagged port {} and vlan {}.", (Object)pnum, (Object)assignedVlan);
                        rules.add(this.buildPuntTableRule(pnum, assignedVlan));
                    }
                    this.log.debug("popVlanPuntGroup not found in dev:{}, queueing this flow rule.", (Object)this.deviceId);
                    this.flowRuleQueue.add(this.buildPuntTableRule(pnum, assignedVlan));
                }
                finally {
                    this.groupCheckerLock.unlock();
                }
            } else if (vidCriterion.vlanId() != VlanId.NONE) {
                this.log.debug("Installing punt rule for tagged port {} and vlan {}.", (Object)pnum, (Object)vidCriterion.vlanId());
                rules.add(this.buildPuntTableRuleTagged(pnum, vidCriterion.vlanId()));
            }
            selector.matchInPort(pnum);
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(10).build();
            rules.add(rule);
        }
        return ImmutableList.of(rules);
    }

    private FlowRule buildPuntTableRule(PortNumber portNumber, VlanId assignedVlan) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchInPort(portNumber).matchVlanId(assignedVlan);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().group(new GroupId(-805306368));
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue()).fromApp(this.driverId).makePermanent().forTable(63).build();
    }

    private FlowRule buildPuntTableRuleTagged(PortNumber portNumber, VlanId packetVlan) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchInPort(portNumber).matchVlanId(packetVlan);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().punt();
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue()).fromApp(this.driverId).makePermanent().forTable(63).build();
    }

    private FlowRule buildArpPunt(VlanId assignedVlan, ApplicationId applicationId) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_ARP).matchVlanId(assignedVlan);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().popVlan().punt();
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue() + 1).fromApp(applicationId).makePermanent().forTable(60).build();
    }

    private FlowRule buildIcmpV6Punt(VlanId assignedVlan, ApplicationId applicationId) {
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder().matchVlanId(assignedVlan).matchEthType(Ethernet.TYPE_IPV6).matchIPProtocol((byte)58);
        TrafficTreatment.Builder tbuilder = DefaultTrafficTreatment.builder().popVlan().punt();
        return DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(tbuilder.build()).withPriority(PacketPriority.CONTROL.priorityValue() + 1).fromApp(applicationId).makePermanent().forTable(60).build();
    }

    @Override
    protected List<List<FlowRule>> processEthDstFilter(PortCriterion portCriterion, EthCriterion ethCriterion, VlanIdCriterion vidCriterion, VlanId assignedVlan, MacAddress unicastMac, ApplicationId applicationId) {
        if (portCriterion != null && portCriterion.port() == PortNumber.ANY) {
            return this.processEthDstOnlyFilter(ethCriterion, applicationId);
        }
        if (ethCriterion.mask() != null) {
            return this.processMcastEthDstFilter(ethCriterion, assignedVlan, unicastMac, applicationId);
        }
        if (vidCriterion.vlanId() == VlanId.NONE) {
            vidCriterion = (VlanIdCriterion)Criteria.matchVlanId((VlanId)assignedVlan);
        }
        ArrayList<PortNumber> portnums = new ArrayList<PortNumber>();
        if (portCriterion != null) {
            if (portCriterion.port() == PortNumber.ALL) {
                for (Port port : this.deviceService.getPorts(this.deviceId)) {
                    if (port.number().toLong() <= 0L || port.number().toLong() >= 0xFFFFFF00L) continue;
                    portnums.add(port.number());
                }
            } else {
                portnums.add(portCriterion.port());
            }
        }
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (PortNumber pnum : portnums) {
            TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
            TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.TYPE_IPV4);
            selector.matchEthDst(ethCriterion.mac());
            if (!this.supportTaggedMpls()) {
                treatment.popVlan();
            }
            treatment.transition(Integer.valueOf(30));
            FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.MPLS_UNICAST);
            selector.matchEthDst(ethCriterion.mac());
            if (!this.supportTaggedMpls()) {
                treatment.popVlan();
            }
            treatment.transition(Integer.valueOf(23));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
            selector = DefaultTrafficSelector.builder();
            treatment = DefaultTrafficTreatment.builder();
            selector.matchInPort(pnum);
            selector.matchVlanId(vidCriterion.vlanId());
            selector.matchEthType(Ethernet.TYPE_IPV6);
            selector.matchEthDst(ethCriterion.mac());
            if (!this.supportTaggedMpls()) {
                treatment.popVlan();
            }
            treatment.transition(Integer.valueOf(30));
            rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
            rules.add(rule);
        }
        return ImmutableList.of(rules);
    }

    @Override
    protected List<List<FlowRule>> processEthDstOnlyFilter(EthCriterion ethCriterion, ApplicationId applicationId) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchEthDst(ethCriterion.mac());
        if (!this.supportTaggedMpls()) {
            treatment.popVlan();
        }
        treatment.transition(Integer.valueOf(30));
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector.build()).withTreatment(treatment.build()).withPriority(32768).fromApp(applicationId).makePermanent().forTable(20).build();
        return ImmutableList.of((Object)ImmutableList.of((Object)rule));
    }

    @Override
    protected Collection<FlowRule> processEthTypeSpecific(ForwardingObjective fwd) {
        NextGroup next;
        int forTableId;
        Object assignedVlan;
        if (this.isDoubleTagged(fwd)) {
            return this.processDoubleTaggedFwd(fwd);
        }
        TrafficSelector selector = fwd.selector();
        EthTypeCriterion ethType = (EthTypeCriterion)selector.getCriterion(Criterion.Type.ETH_TYPE);
        if (ethType == null || ethType.ethType().toShort() != Ethernet.TYPE_IPV4 && ethType.ethType().toShort() != Ethernet.MPLS_UNICAST && ethType.ethType().toShort() != Ethernet.TYPE_IPV6) {
            this.log.warn("processSpecific: Unsupported forwarding objective criteriaethType:{} in dev:{}", (Object)ethType, (Object)this.deviceId);
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.UNSUPPORTED);
            return Collections.emptySet();
        }
        boolean defaultRule = false;
        TrafficSelector.Builder filteredSelector = DefaultTrafficSelector.builder();
        TrafficSelector.Builder complementarySelector = DefaultTrafficSelector.builder();
        if (ethType.ethType().toShort() == Ethernet.TYPE_IPV4) {
            IpPrefix ipv4Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV4_DST)).ip();
            if (ipv4Dst.isMulticast()) {
                if (ipv4Dst.prefixLength() != 32) {
                    this.log.warn("Multicast specific forwarding objective can only be /32");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                assignedVlan = CpqdOfdpa2Pipeline.readVlanFromSelector(fwd.meta());
                if (assignedVlan == null) {
                    this.log.warn("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                filteredSelector.matchVlanId((VlanId)assignedVlan);
                filteredSelector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
                forTableId = 40;
                this.log.debug("processing IPv4 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            } else {
                if (ipv4Dst.prefixLength() == 0) {
                    filteredSelector.matchEthType(Ethernet.TYPE_IPV4);
                } else {
                    filteredSelector.matchEthType(Ethernet.TYPE_IPV4).matchIPDst(ipv4Dst);
                }
                forTableId = 30;
                this.log.debug("processing IPv4 unicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            }
        } else if (ethType.ethType().toShort() == Ethernet.TYPE_IPV6) {
            IpPrefix ipv6Dst = ((IPCriterion)selector.getCriterion(Criterion.Type.IPV6_DST)).ip();
            if (ipv6Dst.isMulticast()) {
                if (ipv6Dst.prefixLength() != 128) {
                    this.log.debug("Multicast specific IPv6 forwarding objective can only be /128");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                assignedVlan = CpqdOfdpa2Pipeline.readVlanFromSelector(fwd.meta());
                if (assignedVlan == null) {
                    this.log.debug("VLAN ID required by multicast specific fwd obj is missing. Abort.");
                    CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
                    return ImmutableSet.of();
                }
                filteredSelector.matchVlanId((VlanId)assignedVlan);
                filteredSelector.matchEthType(Ethernet.TYPE_IPV6).matchIPv6Dst(ipv6Dst);
                forTableId = 40;
                this.log.debug("processing IPv6 multicast specific forwarding objective {} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
            } else {
                if (this.buildIpv6Selector(filteredSelector, fwd) < 0) {
                    return Collections.emptyList();
                }
                forTableId = 30;
            }
        } else {
            filteredSelector.matchEthType(Ethernet.MPLS_UNICAST).matchMplsLabel(((MplsCriterion)selector.getCriterion(Criterion.Type.MPLS_LABEL)).label());
            MplsBosCriterion bos = (MplsBosCriterion)selector.getCriterion(Criterion.Type.MPLS_BOS);
            if (bos != null) {
                filteredSelector.matchMplsBos(bos.mplsBos());
            }
            forTableId = 24;
            this.log.debug("processing MPLS specific forwarding objective {} -> next:{} in dev {}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        }
        TrafficTreatment.Builder tb = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction i : fwd.treatment().allInstructions()) {
                L3ModificationInstruction l3instr;
                if (!this.supportCopyTtl() && i instanceof L3ModificationInstruction && ((l3instr = (L3ModificationInstruction)i).subtype().equals((Object)L3ModificationInstruction.L3SubType.TTL_IN) || l3instr.subtype().equals((Object)L3ModificationInstruction.L3SubType.TTL_OUT))) continue;
                tb.deferred().add(i);
            }
        }
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            tb.deferred().group(group.id());
        }
        tb.transition(Integer.valueOf(60));
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector.build()).withTreatment(tb.build()).forTable(forTableId);
        if (fwd.permanent()) {
            ruleBuilder.makePermanent();
        } else {
            ruleBuilder.makeTemporary(fwd.timeout());
        }
        ArrayList<FlowRule> flowRuleCollection = new ArrayList<FlowRule>();
        flowRuleCollection.add(ruleBuilder.build());
        if (defaultRule) {
            flowRuleCollection.add(this.defaultRoute(fwd, complementarySelector, forTableId, tb));
            this.log.debug("Default rule 0.0.0.0/0 is being installed two rules");
        }
        return flowRuleCollection;
    }

    @Override
    protected Collection<FlowRule> processEthDstSpecific(ForwardingObjective fwd) {
        NextGroup next;
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        TrafficSelector selector = fwd.selector();
        EthCriterion ethCriterion = (EthCriterion)selector.getCriterion(Criterion.Type.ETH_DST);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)selector.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null) {
            this.log.warn("Forwarding objective for bridging requires vlan. Not installing fwd:{} in dev:{}", (Object)fwd.id(), (Object)this.deviceId);
            CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.BADPARAMS);
            return Collections.emptySet();
        }
        TrafficSelector.Builder filteredSelectorBuilder = DefaultTrafficSelector.builder();
        if (!ethCriterion.mac().equals((Object)MacAddress.NONE) && !ethCriterion.mac().equals((Object)MacAddress.BROADCAST)) {
            filteredSelectorBuilder.matchEthDst(ethCriterion.mac());
            this.log.debug("processing L2 forwarding objective:{} -> next:{} in dev:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId});
        } else {
            this.log.debug("processing L2 Broadcast forwarding objective:{} -> next:{} in dev:{} for vlan:{}", new Object[]{fwd.id(), fwd.nextId(), this.deviceId, vlanIdCriterion.vlanId()});
        }
        filteredSelectorBuilder.matchVlanId(vlanIdCriterion.vlanId());
        TrafficSelector filteredSelector = filteredSelectorBuilder.build();
        if (fwd.treatment() != null) {
            this.log.warn("Ignoring traffic treatment in fwd rule {} meant for L2 tablefor dev:{}. Expecting only nextId", (Object)fwd.id(), (Object)this.deviceId);
        }
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        if (fwd.nextId() != null && (next = this.getGroupForNextObjective(fwd.nextId())) != null) {
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group != null) {
                treatmentBuilder.deferred().group(group.id());
            } else {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
        }
        treatmentBuilder.immediate().transition(Integer.valueOf(60));
        TrafficTreatment filteredTreatment = treatmentBuilder.build();
        DefaultFlowRule.Builder flowRuleBuilder = DefaultFlowRule.builder();
        flowRuleBuilder.fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(filteredSelector).withTreatment(filteredTreatment).forTable(50);
        if (fwd.permanent()) {
            flowRuleBuilder.makePermanent();
        } else {
            flowRuleBuilder.makeTemporary(fwd.timeout());
        }
        rules.add(flowRuleBuilder.build());
        return rules;
    }

    @Override
    protected Collection<FlowRule> processVersatile(ForwardingObjective fwd) {
        this.log.info("Processing versatile forwarding objective");
        if (fwd.nextId() == null && fwd.treatment() == null) {
            this.log.error("Forwarding objective {} from {} must contain nextId or Treatment", (Object)fwd.selector(), (Object)fwd.appId());
            return Collections.emptySet();
        }
        TrafficSelector.Builder sbuilder = DefaultTrafficSelector.builder();
        fwd.selector().criteria().forEach(criterion -> {
            if (criterion instanceof VlanIdCriterion) {
                return;
            }
            if (criterion instanceof Icmpv6TypeCriterion || criterion instanceof Icmpv6CodeCriterion) {
                this.log.warn("ICMPv6 Type and ICMPv6 Code are not supported");
            } else {
                sbuilder.add(criterion);
            }
        });
        TrafficTreatment.Builder ttBuilder = DefaultTrafficTreatment.builder();
        if (fwd.treatment() != null) {
            for (Instruction ins : fwd.treatment().allInstructions()) {
                if (ins instanceof Instructions.OutputInstruction) {
                    Instructions.OutputInstruction o = (Instructions.OutputInstruction)ins;
                    if (o.port() == PortNumber.CONTROLLER) {
                        ttBuilder.transition(Integer.valueOf(63));
                        continue;
                    }
                    this.log.warn("Only allowed treatments in versatile forwarding objectives are punts to the controller");
                    continue;
                }
                if (ins instanceof Instructions.NoActionInstruction) continue;
                this.log.warn("Cannot process instruction in versatile fwd {}", (Object)ins);
            }
            if (fwd.treatment().clearedDeferred()) {
                ttBuilder.wipeDeferred();
            }
        }
        if (fwd.nextId() != null) {
            NextGroup next = this.getGroupForNextObjective(fwd.nextId());
            List gkeys = (List)appKryo.deserialize(next.data());
            Group group = this.groupService.getGroup(this.deviceId, (GroupKey)((Deque)gkeys.get(0)).peekFirst());
            if (group == null) {
                this.log.warn("Group with key:{} for next-id:{} not found in dev:{}", new Object[]{((Deque)gkeys.get(0)).peekFirst(), fwd.nextId(), this.deviceId});
                CpqdOfdpa2Pipeline.fail((Objective)fwd, ObjectiveError.GROUPMISSING);
                return Collections.emptySet();
            }
            ttBuilder.deferred().group(group.id());
        }
        FlowRule.Builder ruleBuilder = DefaultFlowRule.builder().fromApp(fwd.appId()).withPriority(fwd.priority()).forDevice(this.deviceId).withSelector(sbuilder.build()).withTreatment(ttBuilder.build()).makePermanent().forTable(60);
        return Collections.singletonList(ruleBuilder.build());
    }

    @Override
    protected void initializePipeline() {
        this.initTableMiss(0, 10, null);
        this.initTableMiss(10, 60, null);
        this.initTableMiss(11, 60, null);
        this.initTableMiss(20, 50, null);
        this.initTableMiss(30, 60, null);
        this.initTableMiss(40, 60, null);
        this.initTableMiss(31, 60, null);
        this.initTableMiss(32, 60, null);
        this.initTableMiss(23, 24, null);
        this.initTableMiss(24, 60, null);
        this.initTableMiss(50, 60, null);
        this.initTableMiss(60, -1, null);
        this.linkDiscoveryPuntTableRules();
        if (this.supportPuntGroup()) {
            this.initPopVlanPuntGroup();
        } else {
            this.initTableMiss(63, -1, DefaultTrafficTreatment.builder().popVlan().punt().build());
        }
    }

    private void initTableMiss(final int thisTable, int nextTable, TrafficTreatment treatment) {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficSelector selector = DefaultTrafficSelector.builder().build();
        if (treatment == null) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            if (nextTable > 0) {
                tBuilder.transition(Integer.valueOf(nextTable));
            }
            treatment = tBuilder.build();
        }
        FlowRule rule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(selector).withTreatment(treatment).withPriority(0).fromApp(this.driverId).makePermanent().forTable(thisTable).build();
        ops = ops.add(rule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Initialized table {} on {}", (Object)thisTable, (Object)CpqdOfdpa2Pipeline.this.deviceId);
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.warn("Failed to initialize table {} on {}", (Object)thisTable, (Object)CpqdOfdpa2Pipeline.this.deviceId);
            }
        }));
    }

    private void linkDiscoveryPuntTableRules() {
        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().punt().build();
        TrafficSelector.Builder lldpSelector = DefaultTrafficSelector.builder();
        lldpSelector.matchEthType(EthType.EtherType.LLDP.ethType().toShort());
        FlowRule lldpRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(lldpSelector.build()).withTreatment(treatment).withPriority(65535).fromApp(this.driverId).makePermanent().forTable(63).build();
        ops = ops.add(lldpRule);
        TrafficSelector.Builder bbdpSelector = DefaultTrafficSelector.builder();
        bbdpSelector.matchEthType(EthType.EtherType.BDDP.ethType().toShort());
        FlowRule bbdpRule = DefaultFlowRule.builder().forDevice(this.deviceId).withSelector(bbdpSelector.build()).withTreatment(treatment).withPriority(65535).fromApp(this.driverId).makePermanent().forTable(63).build();
        ops.add(bbdpRule);
        this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

            public void onSuccess(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.info("Added lldp/bbdp rules for table {} on {}", (Object)63, (Object)CpqdOfdpa2Pipeline.this.deviceId);
            }

            public void onError(FlowRuleOperations ops) {
                CpqdOfdpa2Pipeline.this.log.warn("Failed to initialize lldp/bbdp rules for table {} on {}", (Object)63, (Object)CpqdOfdpa2Pipeline.this.deviceId);
            }
        }));
    }

    private void initPopVlanPuntGroup() {
        GroupKey groupKey = this.popVlanPuntGroupKey();
        TrafficTreatment bucketTreatment = DefaultTrafficTreatment.builder().popVlan().punt().build();
        GroupBucket bucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)bucketTreatment);
        DefaultGroupDescription groupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(bucket)), groupKey, Integer.valueOf(-805306368), this.driverId);
        this.groupService.addGroup((GroupDescription)groupDesc);
        this.log.info("Initialized pop vlan punt group on {}", (Object)this.deviceId);
    }

    private GroupKey popVlanPuntGroupKey() {
        int hash = 0xD0000000 | Objects.hash(this.deviceId) & 0xFFFF;
        return new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)hash));
    }

    private class PopVlanPuntGroupChecker
    implements Runnable {
        private PopVlanPuntGroupChecker() {
        }

        @Override
        public void run() {
            try {
                CpqdOfdpa2Pipeline.this.groupCheckerLock.lock();
                Group group = CpqdOfdpa2Pipeline.this.groupService.getGroup(CpqdOfdpa2Pipeline.this.deviceId, CpqdOfdpa2Pipeline.this.popVlanPuntGroupKey());
                if (group != null) {
                    CpqdOfdpa2Pipeline.this.log.debug("PopVlanPuntGroupChecker: Installing {} missing rules at punt table.", (Object)CpqdOfdpa2Pipeline.this.flowRuleQueue.size());
                    if (CpqdOfdpa2Pipeline.this.flowRuleQueue.size() > 0) {
                        FlowRuleOperations.Builder ops = FlowRuleOperations.builder();
                        CpqdOfdpa2Pipeline.this.flowRuleQueue.forEach(arg_0 -> ((FlowRuleOperations.Builder)ops).add(arg_0));
                        CpqdOfdpa2Pipeline.this.flowRuleService.apply(ops.build(new FlowRuleOperationsContext(){

                            public void onSuccess(FlowRuleOperations ops) {
                                CpqdOfdpa2Pipeline.this.log.debug("Applied {} pop vlan punt rules in device {}", (Object)((Set)ops.stages().get(0)).size(), (Object)CpqdOfdpa2Pipeline.this.deviceId);
                            }

                            public void onError(FlowRuleOperations ops) {
                                CpqdOfdpa2Pipeline.this.log.error("Failed to apply all pop vlan punt rules in dev {}", (Object)CpqdOfdpa2Pipeline.this.deviceId);
                            }
                        }));
                    }
                    CpqdOfdpa2Pipeline.this.flowRuleQueue = null;
                    CpqdOfdpa2Pipeline.this.groupChecker.shutdown();
                }
            }
            finally {
                CpqdOfdpa2Pipeline.this.groupCheckerLock.unlock();
            }
        }
    }
}

