/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.trafficcontrol;

import java.net.URI;
import java.util.Collection;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.trafficcontrol.Policer;
import org.onosproject.net.behaviour.trafficcontrol.PolicerConfigurable;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFlowPolicerConfigurable
extends AbstractHandlerBehaviour
implements PolicerConfigurable {
    private final Logger log = LoggerFactory.getLogger(OpenFlowPolicerConfigurable.class);
    private static final String OF_SCHEME = "of";
    private static final int HEX = 16;

    private PolicerId getPolicerIdFromMeterId(MeterId meterId) {
        URI uri = URI.create("of:" + Long.toHexString((Long)meterId.id()));
        return PolicerId.policerId((URI)uri);
    }

    private MeterId getMeterIdFromPolicerId(PolicerId policerId) {
        Long id = Long.parseLong(policerId.uri().getSchemeSpecificPart(), 16);
        return MeterId.meterId((long)id);
    }

    public PolicerId allocatePolicerId() {
        DriverHandler handler = this.handler();
        MeterService meterService = (MeterService)handler.get(MeterService.class);
        if (meterService == null) {
            this.log.warn("MeterService is null");
            return PolicerId.NONE;
        }
        DeviceId deviceId = handler.data().deviceId();
        if (!deviceId.uri().getScheme().equals(OF_SCHEME)) {
            this.log.warn("The device {} does not seem to be managed by OpenFlow", (Object)deviceId);
            return PolicerId.NONE;
        }
        MeterId meterId = meterService.allocateMeterId(deviceId);
        if (meterId == null) {
            this.log.warn("MeterService does not provide valid ids");
            return PolicerId.NONE;
        }
        return this.getPolicerIdFromMeterId(meterId);
    }

    public void freePolicerId(PolicerId id) {
        DriverHandler handler = this.handler();
        MeterService meterService = (MeterService)handler.get(MeterService.class);
        if (meterService == null) {
            this.log.warn("MeterService is null");
            return;
        }
        DeviceId deviceId = handler.data().deviceId();
        if (!deviceId.uri().getScheme().equals(OF_SCHEME)) {
            this.log.warn("The device {} does not seem to be managed by OpenFlow", (Object)deviceId);
            return;
        }
        if (!id.uri().getScheme().equals(OF_SCHEME)) {
            this.log.warn("The id {} does not seem to be OpenFlow", (Object)id);
            return;
        }
        MeterId meterId = this.getMeterIdFromPolicerId(id);
        meterService.freeMeterId(deviceId, meterId);
    }

    public void addPolicer(Policer policer) {
        throw new UnsupportedOperationException("addPolicer not yet implemented");
    }

    public void deletePolicer(PolicerId id) {
        throw new UnsupportedOperationException("deletePolicer not yet implemented");
    }

    public Policer getPolicer(PolicerId policerId) {
        throw new UnsupportedOperationException("getPolicer not yet implemented");
    }

    public Collection<Policer> getPolicers() {
        throw new UnsupportedOperationException("getPolicers not yet implemented");
    }
}

