/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.extensions.Ofdpa3AllowVlanTranslationType;
import org.onosproject.driver.extensions.Ofdpa3PushCw;
import org.onosproject.driver.extensions.Ofdpa3PushL2Header;
import org.onosproject.driver.extensions.OfdpaSetAllowVlanTranslation;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2GroupHandler;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa3Pipeline;
import org.onosproject.driver.pipeline.ofdpa.OfdpaGroupHandlerUtility;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa3GroupHandler
extends Ofdpa2GroupHandler {
    private static final int PW_INTERNAL_VLAN = 4094;
    private static final int MAX_DEPTH_UNPROTECTED_PW = 3;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    protected OfdpaGroupHandlerUtility.GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        return this.isUnfiltered(treatment, meta) ? this.createUnfilteredL2L3Chain(treatment, nextId, appId, false) : this.createL2L3ChainInternal(treatment, nextId, appId, mpls, meta, false);
    }

    @Override
    protected void processPwNextObjective(NextObjective nextObjective) {
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp;
        OfdpaGroupHandlerUtility.GroupChainElem groupChainElem;
        DefaultGroupKey groupKey;
        GroupDescription groupDescription;
        this.log.info("Started deploying nextObjective id={} for pseudowire", (Object)nextObjective.id());
        TrafficTreatment treatment = (TrafficTreatment)nextObjective.next().iterator().next();
        ArrayDeque<Object> gkeyChain = new ArrayDeque<Object>();
        TrafficTreatment.Builder l2L3Treatment = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder mplsTreatment = DefaultTrafficTreatment.builder();
        this.createL2L3AndMplsTreatments(treatment, l2L3Treatment, mplsTreatment);
        OfdpaGroupHandlerUtility.GroupInfo groupInfo = this.createL2L3ChainInternal(l2L3Treatment.build(), nextObjective.id(), nextObjective.appId(), true, nextObjective.meta(), false);
        if (groupInfo == null) {
            this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.GROUPINSTALLATIONFAILED);
            return;
        }
        gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
        gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
        ArrayList mplsInstructionSets = Lists.newArrayList();
        ArrayList mplsInstructionSet = Lists.newArrayList();
        for (Instruction ins : treatment.allInstructions()) {
            L3ModificationInstruction l3Ins;
            mplsInstructionSet.add(ins);
            if (ins.type() != Instruction.Type.L3MODIFICATION || (l3Ins = (L3ModificationInstruction)ins).subtype() != L3ModificationInstruction.L3SubType.TTL_OUT) continue;
            mplsInstructionSets.add(mplsInstructionSet);
            mplsInstructionSet = Lists.newArrayList();
        }
        if (mplsInstructionSets.size() > 3) {
            this.log.error("Next Objective for pseudo wire should have at most {} mpls instruction sets. Next Objective Id:{}", (Object)3, (Object)nextObjective.id());
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        this.log.debug("Size of mpls instructions is {}.", (Object)mplsInstructionSets.size());
        this.log.debug("mpls instructions sets are {}.", (Object)mplsInstructionSets);
        int nextGid = groupInfo.nextGroupDesc().givenGroupId();
        if (mplsInstructionSets.size() == 3) {
            this.log.debug("Creating inter-co pw mpls chains with nextid {}", (Object)nextObjective.id());
            int index = this.getNextAvailableIndex();
            groupDescription = this.createMplsTunnelLabelGroup(nextGid, OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType.MPLS_TUNNEL_LABEL_2, index, (List)mplsInstructionSets.get(2), nextObjective.appId());
            groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
            groupChainElem = new OfdpaGroupHandlerUtility.GroupChainElem(groupDescription, 1, false, this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), groupChainElem);
            gkeyChain.addFirst(groupKey);
            nextGid = groupDescription.givenGroupId();
            groupInfo = new OfdpaGroupHandlerUtility.GroupInfo(groupInfo.innerMostGroupDesc(), groupDescription);
            this.log.debug("Trying Label 2 Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
        }
        if (mplsInstructionSets.size() == 2) {
            this.log.debug("Creating leaf-leaf pw mpls chains with nextid {}", (Object)nextObjective.id());
            int index = this.getNextAvailableIndex();
            groupDescription = this.createMplsTunnelLabelGroup(nextGid, OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType.MPLS_TUNNEL_LABEL_1, index, (List)mplsInstructionSets.get(1), nextObjective.appId());
            groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
            groupChainElem = new OfdpaGroupHandlerUtility.GroupChainElem(groupDescription, 1, false, this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), groupChainElem);
            gkeyChain.addFirst(groupKey);
            nextGid = groupDescription.givenGroupId();
            groupInfo = new OfdpaGroupHandlerUtility.GroupInfo(groupInfo.innerMostGroupDesc(), groupDescription);
            this.log.debug("Trying Label 1 Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
            index = this.getNextAvailableIndex();
            groupDescription = this.createMplsL2VpnGroup(nextGid, index, (List)mplsInstructionSets.get(0), nextObjective.appId());
            groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
            groupChainElem = new OfdpaGroupHandlerUtility.GroupChainElem(groupDescription, 1, false, this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), groupChainElem);
            gkeyChain.addFirst(groupKey);
            ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(Collections.singletonList(gkeyChain), nextObjective);
            this.updatePendingNextObjective((GroupKey)groupKey, ofdpaGrp);
            this.log.debug("Trying L2 Vpn Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        }
        if (mplsInstructionSets.size() == 1) {
            this.log.debug("Creating leaf-spine pw mpls chains with nextid {}", (Object)nextObjective.id());
            int index = this.getNextAvailableIndex();
            groupDescription = this.createMplsL2VpnGroup(nextGid, index, (List)mplsInstructionSets.get(0), nextObjective.appId());
            groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
            groupChainElem = new OfdpaGroupHandlerUtility.GroupChainElem(groupDescription, 1, false, this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), groupChainElem);
            gkeyChain.addFirst(groupKey);
            ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(Collections.singletonList(gkeyChain), nextObjective);
            this.updatePendingNextObjective((GroupKey)groupKey, ofdpaGrp);
            this.log.debug("Trying L2 Vpn Group: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(nextGid), groupKey, nextObjective.id()});
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        }
    }

    private GroupDescription createMplsTunnelLabelGroup(int nextGroupId, OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType subtype, int index, List<Instruction> instructions, ApplicationId applicationId) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        instructions.forEach(arg_0 -> ((TrafficTreatment.Builder)treatment).add(arg_0));
        treatment.group(new GroupId(nextGroupId));
        GroupBucket groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment.build());
        int groupId = OfdpaGroupHandlerUtility.makeMplsLabelGroupId(subtype, index);
        DefaultGroupKey groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        return new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(groupBucket)), (GroupKey)groupKey, Integer.valueOf(groupId), applicationId);
    }

    private GroupDescription createMplsL2VpnGroup(int nextGroupId, int index, List<Instruction> instructions, ApplicationId applicationId) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.extension((ExtensionTreatment)new Ofdpa3PushL2Header(), this.deviceId);
        treatment.pushVlan();
        instructions.forEach(arg_0 -> ((TrafficTreatment.Builder)treatment).add(arg_0));
        treatment.extension((ExtensionTreatment)new Ofdpa3PushCw(), this.deviceId);
        treatment.group(new GroupId(nextGroupId));
        GroupBucket groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment.build());
        int groupId = OfdpaGroupHandlerUtility.makeMplsLabelGroupId(OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType.L2_VPN, index);
        DefaultGroupKey groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        return new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(groupBucket)), (GroupKey)groupKey, Integer.valueOf(groupId), applicationId);
    }

    private void createL2L3AndMplsTreatments(TrafficTreatment treatment, TrafficTreatment.Builder l2L3Treatment, TrafficTreatment.Builder mplsTreatment) {
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: 
                    case ETH_SRC: 
                    case VLAN_ID: 
                    case VLAN_POP: {
                        l2L3Treatment.add(ins);
                        break;
                    }
                    case MPLS_BOS: 
                    case DEC_MPLS_TTL: 
                    case MPLS_LABEL: 
                    case MPLS_PUSH: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle TrafficTreatment L2Mod {} for pw next-obj", (Object)l2ins.subtype());
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                l2L3Treatment.add(ins);
                continue;
            }
            if (ins.type() == Instruction.Type.L3MODIFICATION) {
                L3ModificationInstruction l3ins = (L3ModificationInstruction)ins;
                switch (l3ins.subtype()) {
                    case TTL_OUT: {
                        mplsTreatment.add(ins);
                        break;
                    }
                    default: {
                        this.log.warn("Driver does not handle TrafficTreatment L3Mod for pw next-obj", (Object)l3ins.subtype());
                        break;
                    }
                }
                continue;
            }
            this.log.warn("Driver does not handle this type of TrafficTreatment instruction for pw next-obj: {} - {}", (Object)ins.type(), (Object)ins);
        }
    }

    private OfdpaGroupHandlerUtility.GroupInfo createUnfilteredL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean useSetVlanExtension) {
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        long portNum = 0L;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        MacAddress dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        MacAddress srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        VlanId vlanId = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        if (useSetVlanExtension) {
                            OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanId);
                            outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                            break;
                        }
                        outerTtb.setVlanId(vlanId);
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                portNum = ((Instructions.OutputInstruction)ins).port().toLong();
                innerTtb.add(ins);
                continue;
            }
            this.log.debug("Driver does not handle this type of TrafficTreatment instruction in l2l3chain:  {} - {}", (Object)ins.type(), (Object)ins);
        }
        innerTtb.extension((ExtensionTreatment)new OfdpaSetAllowVlanTranslation(Ofdpa3AllowVlanTranslationType.ALLOW), this.deviceId);
        int l2groupId = OfdpaGroupHandlerUtility.l2UnfilteredGroupId(portNum);
        int l2gk = OfdpaGroupHandlerUtility.l2UnfilteredGroupKey(this.deviceId, portNum);
        DefaultGroupKey l2groupkey = new DefaultGroupKey(Ofdpa3Pipeline.appKryo.serialize((Object)l2gk));
        int l3unicastIndex = this.getNextAvailableIndex();
        int l3groupId = 0x20000000 | 0xFFFFFFF & l3unicastIndex;
        DefaultGroupKey l3groupkey = new DefaultGroupKey(Ofdpa3Pipeline.appKryo.serialize((Object)l3unicastIndex));
        outerTtb.group(new GroupId(l2groupId));
        GroupBucket l3unicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
        DefaultGroupDescription outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3unicastGroupBucket)), (GroupKey)l3groupkey, Integer.valueOf(l3groupId), appId);
        this.log.debug("Trying L3Unicast: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextId});
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)outerGrpDesc, 1, false, this.deviceId);
        this.updatePendingGroups((GroupKey)l2groupkey, gce);
        GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)innerTtb.build());
        DefaultGroupDescription l2groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2groupkey, Integer.valueOf(l2groupId), appId);
        this.log.debug("Trying L2Unfiltered: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2groupId), l2groupkey, nextId});
        return new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2groupDescription, (GroupDescription)outerGrpDesc);
    }

    private boolean isUnfiltered(TrafficTreatment treatment, TrafficSelector meta) {
        if (meta == null || treatment == null) {
            return false;
        }
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)meta.getCriterion(Criterion.Type.VLAN_VID);
        if (vlanIdCriterion == null || !vlanIdCriterion.vlanId().equals((Object)VlanId.ANY)) {
            return false;
        }
        return treatment.allInstructions().stream().filter(i -> i.type() == Instruction.Type.L2MODIFICATION && ((L2ModificationInstruction)i).subtype() == L2ModificationInstruction.L2SubType.VLAN_ID).count() == 1L;
    }
}

