/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.extensions;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.onosproject.codec.CodecContext;
import org.onosproject.driver.extensions.NiciraMatchCtMark;
import org.onosproject.driver.extensions.NiciraMatchCtState;
import org.onosproject.driver.extensions.NiciraMatchCtZone;
import org.onosproject.driver.extensions.NiciraMatchEncapEthType;
import org.onosproject.driver.extensions.NiciraMatchNshContextHeader;
import org.onosproject.driver.extensions.NiciraMatchNshSi;
import org.onosproject.driver.extensions.NiciraMatchNshSpi;
import org.onosproject.net.NshServiceIndex;
import org.onosproject.net.NshServicePathId;
import org.onosproject.net.behaviour.ExtensionSelectorResolver;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.net.flow.criteria.ExtensionSelector;
import org.onosproject.net.flow.criteria.ExtensionSelectorType;
import org.onosproject.openflow.controller.ExtensionSelectorInterpreter;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConntrackMark;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConntrackStateMasked;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConntrackZone;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthType;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNsi;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmNsp;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;

public class NiciraExtensionSelectorInterpreter
extends AbstractHandlerBehaviour
implements ExtensionSelectorInterpreter,
ExtensionSelectorResolver {
    public boolean supported(ExtensionSelectorType extensionSelectorType) {
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH1.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH2.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH3.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH4.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_ENCAP_ETH_TYPE.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_STATE.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_ZONE.type())) {
            return true;
        }
        if (extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_MARK.type())) {
            return true;
        }
        return extensionSelectorType.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_LABEL.type());
    }

    public OFOxm<?> mapSelector(OFFactory factory, ExtensionSelector extensionSelector) {
        ExtensionSelectorType type = extensionSelector.type();
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type())) {
            NiciraMatchNshSpi niciraNshSpi = (NiciraMatchNshSpi)extensionSelector;
            return factory.oxms().nsp(U32.of((long)niciraNshSpi.nshSpi().servicePathId()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type())) {
            NiciraMatchNshSi niciraNshSi = (NiciraMatchNshSi)extensionSelector;
            return factory.oxms().nsi(U8.of((short)niciraNshSi.nshSi().serviceIndex()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_ENCAP_ETH_TYPE.type())) {
            NiciraMatchEncapEthType niciraEncapEthType = (NiciraMatchEncapEthType)extensionSelector;
            return factory.oxms().encapEthType(U16.of((int)niciraEncapEthType.encapEthType()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH1.type())) {
            // empty if block
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH2.type())) {
            // empty if block
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH3.type())) {
            // empty if block
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH4.type())) {
            // empty if block
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_STATE.type())) {
            NiciraMatchCtState niciraMatchCtState = (NiciraMatchCtState)extensionSelector;
            return factory.oxms().conntrackStateMasked(U32.of((long)niciraMatchCtState.ctState()), U32.of((long)niciraMatchCtState.ctStateMask()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_ZONE.type())) {
            NiciraMatchCtZone niciraMatchCtZone = (NiciraMatchCtZone)extensionSelector;
            return factory.oxms().conntrackZone(U16.of((int)niciraMatchCtZone.ctZone()));
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_MARK.type())) {
            NiciraMatchCtMark niciraMatchCtMark = (NiciraMatchCtMark)extensionSelector;
            return factory.oxms().conntrackMark(U32.of((long)niciraMatchCtMark.ctMark()));
        }
        return null;
    }

    public ExtensionSelector mapOxm(OFOxm<?> oxm) {
        if (oxm.getMatchField() == MatchField.NSP) {
            OFOxmNsp oxmField = (OFOxmNsp)oxm;
            return new NiciraMatchNshSpi(NshServicePathId.of((int)oxmField.getValue().getRaw()));
        }
        if (oxm.getMatchField() == MatchField.NSI) {
            OFOxmNsi oxmField = (OFOxmNsi)oxm;
            return new NiciraMatchNshSi(NshServiceIndex.of((short)oxmField.getValue().getRaw()));
        }
        if (oxm.getMatchField() == MatchField.ENCAP_ETH_TYPE) {
            OFOxmEncapEthType oxmField = (OFOxmEncapEthType)oxm;
            return new NiciraMatchEncapEthType(oxmField.getValue().getRaw());
        }
        if (oxm.getMatchField() == MatchField.CONNTRACK_STATE) {
            OFOxmConntrackStateMasked oxmField = (OFOxmConntrackStateMasked)oxm;
            return new NiciraMatchCtState(oxmField.getValue().getRaw(), oxmField.getMask().getRaw());
        }
        if (oxm.getMatchField() == MatchField.CONNTRACK_ZONE) {
            OFOxmConntrackZone oxmField = (OFOxmConntrackZone)oxm;
            return new NiciraMatchCtZone(oxmField.getValue().getRaw());
        }
        if (oxm.getMatchField() == MatchField.CONNTRACK_MARK) {
            OFOxmConntrackMark oxmField = (OFOxmConntrackMark)oxm;
            return new NiciraMatchCtMark(oxmField.getValue().getRaw());
        }
        return null;
    }

    public ExtensionSelector getExtensionSelector(ExtensionSelectorType type) {
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SPI.type())) {
            return new NiciraMatchNshSpi();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_SI.type())) {
            return new NiciraMatchNshSi();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_ENCAP_ETH_TYPE.type())) {
            return new NiciraMatchEncapEthType();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH1.type()) || type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH2.type()) || type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH3.type()) || type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_NSH_CH4.type())) {
            return new NiciraMatchNshContextHeader(type);
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_STATE.type())) {
            return new NiciraMatchCtState();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_ZONE.type())) {
            return new NiciraMatchCtZone();
        }
        if (type.equals((Object)ExtensionSelectorType.ExtensionSelectorTypes.NICIRA_MATCH_CONNTRACK_MARK.type())) {
            return new NiciraMatchCtMark();
        }
        return null;
    }

    public ObjectNode encode(ExtensionSelector extensionSelector, CodecContext context) {
        return null;
    }

    public ExtensionSelector decode(ObjectNode json, CodecContext context) {
        return null;
    }
}

