/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.driver.pipeline.ofdpa;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.driver.extensions.Ofdpa3AllowVlanTranslationType;
import org.onosproject.driver.extensions.OfdpaSetAllowVlanTranslation;
import org.onosproject.driver.extensions.OfdpaSetVlanVid;
import org.onosproject.driver.pipeline.ofdpa.Ofdpa2Pipeline;
import org.onosproject.driver.pipeline.ofdpa.OfdpaGroupHandlerUtility;
import org.onosproject.event.EventListener;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.behaviour.PipelinerContext;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flowobjective.DefaultNextObjective;
import org.onosproject.net.flowobjective.DefaultNextTreatment;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.IdNextTreatment;
import org.onosproject.net.flowobjective.NextObjective;
import org.onosproject.net.flowobjective.NextTreatment;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupListener;
import org.onosproject.net.group.GroupService;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ofdpa2GroupHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected GroupService groupService;
    protected StorageService storageService;
    protected FlowObjectiveStore flowObjectiveStore;
    private AtomicCounter nextIndex;
    protected DeviceId deviceId;
    Cache<GroupKey, List<OfdpaGroupHandlerUtility.OfdpaNextGroup>> pendingAddNextObjectives;
    Cache<NextObjective, List<GroupKey>> pendingRemoveNextObjectives;
    Cache<GroupKey, Set<OfdpaGroupHandlerUtility.GroupChainElem>> pendingGroups;
    ConcurrentHashMap<GroupKey, Set<NextObjective>> pendingUpdateNextObjectives;
    protected ConcurrentHashMap<Integer, Set<NextObjective>> pendingBuckets = new ConcurrentHashMap();
    private ScheduledExecutorService groupCheckerExecutor = Executors.newScheduledThreadPool(2, Tools.groupedThreads((String)"onos/pipeliner", (String)"ofdpa-%d", (Logger)this.log));

    protected boolean supportCopyTtl() {
        return true;
    }

    protected boolean supportSetMplsBos() {
        return true;
    }

    protected boolean requireVlanPopBeforeMplsPush() {
        return false;
    }

    protected boolean requireAllowVlanTransition() {
        return true;
    }

    public void init(DeviceId deviceId, PipelinerContext context) {
        ServiceDirectory serviceDirectory = context.directory();
        this.deviceId = deviceId;
        this.flowObjectiveStore = context.store();
        this.groupService = (GroupService)serviceDirectory.get(GroupService.class);
        this.storageService = (StorageService)serviceDirectory.get(StorageService.class);
        this.nextIndex = this.storageService.getAtomicCounter("group-id-index-counter");
        this.pendingAddNextObjectives = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED && Objects.nonNull(notification.getValue())) {
                ((List)notification.getValue()).forEach(ofdpaNextGrp -> Ofdpa2Pipeline.fail((Objective)ofdpaNextGrp.nextObjective(), ObjectiveError.GROUPINSTALLATIONFAILED));
            }
        }).build();
        this.pendingRemoveNextObjectives = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                Ofdpa2Pipeline.fail((Objective)notification.getKey(), ObjectiveError.GROUPREMOVALFAILED);
            }
        }).build();
        this.pendingGroups = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).removalListener(notification -> {
            if (notification.getCause() == RemovalCause.EXPIRED) {
                this.log.error("Unable to install group with key {} and pending GCEs: {}", notification.getKey(), notification.getValue());
            }
        }).build();
        this.pendingUpdateNextObjectives = new ConcurrentHashMap();
        OfdpaGroupHandlerUtility.GroupChecker groupChecker = new OfdpaGroupHandlerUtility.GroupChecker(this);
        this.groupCheckerExecutor.scheduleAtFixedRate(groupChecker, 0L, 500L, TimeUnit.MILLISECONDS);
        this.groupService.addListener((EventListener)new InnerGroupListener());
    }

    protected void addGroup(NextObjective nextObjective) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type Simple should only have a single Traffic Treatment. Next Objective Id:{}", (Object)nextObjective.id());
                    Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                this.processSimpleNextObjective(nextObjective);
                break;
            }
            case BROADCAST: {
                this.processBroadcastNextObjective(nextObjective);
                break;
            }
            case HASHED: {
                if (!OfdpaGroupHandlerUtility.verifyHashedNextObjective(nextObjective)) {
                    this.log.error("Next Objectives of type hashed not supported. Next Objective Id:{}", (Object)nextObjective.id());
                    Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                if (OfdpaGroupHandlerUtility.isL2Hash(nextObjective)) {
                    this.processL2HashedNextObjective(nextObjective);
                    return;
                }
                this.processEcmpHashedNextObjective(nextObjective);
                break;
            }
            case FAILOVER: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
                this.log.warn("Unsupported next objective type {}", (Object)nextObjective.type());
                break;
            }
            default: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    private void processL2MulticastNextObjective(NextObjective nextObj) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by L2 multicast next objective is missing. Aborting group creation.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        this.createL2MulticastGroup(nextObj, assignedVlan, groupInfos);
    }

    private void createL2MulticastGroup(NextObjective nextObj, VlanId vlanId, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos) {
        Integer l2MulticastGroupId = 0x30000000 | vlanId.toShort() << 16;
        GroupKey l2MulticastGroupKey = OfdpaGroupHandlerUtility.l2MulticastGroupKey(vlanId, this.deviceId);
        ArrayList l2MulticastAllGroup = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> groupKeyChain = new ArrayDeque<GroupKey>();
            groupKeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            groupKeyChain.addFirst(l2MulticastGroupKey);
            l2MulticastAllGroup.add(groupKeyChain);
        });
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaL2MulticastGroup = new OfdpaGroupHandlerUtility.OfdpaNextGroup(l2MulticastAllGroup, nextObj);
        this.updatePendingNextObjective(l2MulticastGroupKey, ofdpaL2MulticastGroup);
        ArrayList l2McastBuckets = new ArrayList();
        groupInfos.forEach(groupInfo -> {
            TrafficTreatment.Builder trafficTreatment = DefaultTrafficTreatment.builder();
            trafficTreatment.group(new GroupId(groupInfo.innerMostGroupDesc().givenGroupId().intValue()));
            GroupBucket bucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)trafficTreatment.build());
            l2McastBuckets.add(bucket);
        });
        DefaultGroupDescription l2MulticastGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(l2McastBuckets), l2MulticastGroupKey, l2MulticastGroupId, nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l2MulticastGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2MulticastGroupDescription, groupInfos.size(), false, this.deviceId);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(groupInfo.innerMostGroupDesc().appCookie(), l2MulticastGce);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    private void processSimpleNextObjective(NextObjective nextObj) {
        TunnelIdCriterion tunnelIdCriterion;
        TrafficTreatment treatment = (TrafficTreatment)nextObj.next().iterator().next();
        boolean plainL2 = true;
        boolean mplsSwap = false;
        MplsLabel mplsLabel = null;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() != Instruction.Type.L2MODIFICATION) continue;
            L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
            if (l2ins.subtype() == L2ModificationInstruction.L2SubType.ETH_DST || l2ins.subtype() == L2ModificationInstruction.L2SubType.ETH_SRC) {
                plainL2 = false;
            }
            if (l2ins.subtype() != L2ModificationInstruction.L2SubType.MPLS_LABEL) continue;
            mplsSwap = true;
            mplsLabel = ((L2ModificationInstruction.ModMplsLabelInstruction)l2ins).label();
        }
        if (plainL2) {
            this.createL2InterfaceGroup(nextObj);
            return;
        }
        boolean isPw = false;
        if (nextObj.meta() != null && (tunnelIdCriterion = (TunnelIdCriterion)nextObj.meta().getCriterion(Criterion.Type.TUNNEL_ID)) != null) {
            isPw = true;
        }
        if (mplsSwap && !isPw) {
            this.log.debug("Creating a MPLS Swap -> MPLS Interface -> L2 Interface group chain.");
            OfdpaGroupHandlerUtility.GroupInfo groupInfo = this.createL2L3Chain(treatment, nextObj.id(), nextObj.appId(), true, nextObj.meta());
            if (groupInfo == null) {
                this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
                return;
            }
            ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
            gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            int nextGid = groupInfo.nextGroupDesc().givenGroupId();
            int index = this.getNextAvailableIndex();
            GroupDescription swapGroupDescription = this.createMplsSwap(nextGid, OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType.MPLS_SWAP_LABEL, index, mplsLabel, nextObj.appId());
            GroupKey swapGroupKey = swapGroupDescription.appCookie();
            OfdpaGroupHandlerUtility.GroupChainElem swapChainElem = new OfdpaGroupHandlerUtility.GroupChainElem(swapGroupDescription, 1, false, this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), swapChainElem);
            gkeyChain.addFirst(swapGroupKey);
            ArrayList allGroupKeys = Lists.newArrayList();
            allGroupKeys.add(gkeyChain);
            OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
            this.updatePendingNextObjective(swapGroupKey, ofdpaGrp);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        } else if (!isPw) {
            boolean isMpls = false;
            if (nextObj.meta() != null) {
                isMpls = Ofdpa2Pipeline.isNotMplsBos(nextObj.meta());
            }
            this.log.debug("Creating a {} -> L2 Interface group chain.", (Object)(isMpls ? "MPLS Interface" : "L3 Unicast"));
            OfdpaGroupHandlerUtility.GroupInfo groupInfo = this.createL2L3Chain(treatment, nextObj.id(), nextObj.appId(), isMpls, nextObj.meta());
            if (groupInfo == null) {
                this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
                return;
            }
            ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
            gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            ArrayList allGroupKeys = Lists.newArrayList();
            allGroupKeys.add(gkeyChain);
            OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
            this.updatePendingNextObjective(groupInfo.nextGroupDesc().appCookie(), ofdpaGrp);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        } else {
            this.processPwNextObjective(nextObj);
        }
    }

    private void createL2InterfaceGroup(NextObjective nextObj) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by simple next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        GroupDescription l2InterfaceGroupDesc = groupInfos.get(0).innerMostGroupDesc();
        ArrayList allGroupKeys = Lists.newArrayList();
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(l2InterfaceGroupDesc.appCookie());
        allGroupKeys.add(gkeyChain);
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective(l2InterfaceGroupDesc.appCookie(), ofdpaGrp);
        this.groupService.addGroup(l2InterfaceGroupDesc);
    }

    protected GroupDescription createMplsSwap(int nextGroupId, OfdpaGroupHandlerUtility.OfdpaMplsGroupSubType subtype, int index, MplsLabel mplsLabel, ApplicationId applicationId) {
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setMpls(mplsLabel);
        treatment.group(new GroupId(nextGroupId));
        GroupBucket groupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)treatment.build());
        int groupId = OfdpaGroupHandlerUtility.makeMplsLabelGroupId(subtype, index);
        DefaultGroupKey groupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)index));
        return new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(groupBucket)), (GroupKey)groupKey, Integer.valueOf(groupId), applicationId);
    }

    protected OfdpaGroupHandlerUtility.GroupInfo createL2L3Chain(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta) {
        return this.createL2L3ChainInternal(treatment, nextId, appId, mpls, meta, true);
    }

    protected OfdpaGroupHandlerUtility.GroupInfo createL2L3ChainInternal(TrafficTreatment treatment, int nextId, ApplicationId appId, boolean mpls, TrafficSelector meta, boolean useSetVlanExtension) {
        DefaultGroupDescription outerGrpDesc;
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        TrafficTreatment.Builder innerTtb = DefaultTrafficTreatment.builder();
        VlanId vlanid = null;
        long portNum = 0L;
        boolean setVlan = false;
        boolean popVlan = false;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        MacAddress dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        MacAddress srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        vlanid = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        if (useSetVlanExtension) {
                            OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanid);
                            outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                        } else {
                            outerTtb.setVlanId(vlanid);
                        }
                        setVlan = true;
                        break;
                    }
                    case VLAN_POP: {
                        innerTtb.popVlan();
                        popVlan = true;
                        break;
                    }
                }
                continue;
            }
            if (ins.type() == Instruction.Type.OUTPUT) {
                portNum = ((Instructions.OutputInstruction)ins).port().toLong();
                innerTtb.add(ins);
                continue;
            }
            this.log.debug("Driver does not handle this type of TrafficTreatment instruction in l2l3chain:  {} - {}", (Object)ins.type(), (Object)ins);
        }
        if (vlanid == null && meta != null) {
            Criterion vidCriterion = meta.getCriterion(Criterion.Type.VLAN_VID);
            if (vidCriterion != null) {
                vlanid = ((VlanIdCriterion)vidCriterion).vlanId();
            }
            if (vlanid != null && !setVlan) {
                if (useSetVlanExtension) {
                    OfdpaSetVlanVid ofdpaSetVlanVid = new OfdpaSetVlanVid(vlanid);
                    outerTtb.extension((ExtensionTreatment)ofdpaSetVlanVid, this.deviceId);
                } else {
                    outerTtb.setVlanId(vlanid);
                }
            }
        }
        if (vlanid == null) {
            this.log.error("Driver cannot process an L2/L3 group chain without egress vlan information for dev: {} port:{}", (Object)this.deviceId, (Object)portNum);
            return null;
        }
        if (!setVlan && !popVlan) {
            TrafficTreatment.Builder temp = DefaultTrafficTreatment.builder();
            temp.popVlan();
            innerTtb.build().allInstructions().forEach(arg_0 -> ((TrafficTreatment.Builder)temp).add(arg_0));
            innerTtb = temp;
        }
        int l2groupId = OfdpaGroupHandlerUtility.l2GroupId(vlanid, portNum);
        int l2gk = OfdpaGroupHandlerUtility.l2InterfaceGroupKey(this.deviceId, vlanid, portNum);
        DefaultGroupKey l2groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
        if (mpls) {
            int mplsInterfaceIndex = this.getNextAvailableIndex();
            int mplsGroupId = 0x90000000 | 0xFFFFFF & mplsInterfaceIndex;
            DefaultGroupKey mplsGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)mplsInterfaceIndex));
            outerTtb.group(new GroupId(l2groupId));
            GroupBucket mplsinterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(mplsinterfaceGroupBucket)), (GroupKey)mplsGroupKey, Integer.valueOf(mplsGroupId), appId);
            this.log.debug("Trying MPLS-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(mplsGroupId), mplsGroupKey, nextId});
        } else {
            int l3unicastIndex = this.getNextAvailableIndex();
            int l3groupId = 0x20000000 | 0xFFFFFFF & l3unicastIndex;
            DefaultGroupKey l3groupkey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3unicastIndex));
            outerTtb.group(new GroupId(l2groupId));
            GroupBucket l3unicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
            outerGrpDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3unicastGroupBucket)), (GroupKey)l3groupkey, Integer.valueOf(l3groupId), appId);
            this.log.debug("Trying L3Unicast: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextId});
        }
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)outerGrpDesc, 1, false, this.deviceId);
        this.updatePendingGroups((GroupKey)l2groupkey, gce);
        GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)innerTtb.build());
        DefaultGroupDescription l2groupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2groupkey, Integer.valueOf(l2groupId), appId);
        this.log.debug("Trying L2Interface: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2groupId), l2groupkey, nextId});
        return new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2groupDescription, (GroupDescription)outerGrpDesc);
    }

    private void processBroadcastNextObjective(NextObjective nextObj) {
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos;
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by broadcast next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        MacAddress dstMac = Ofdpa2Pipeline.readEthDstFromSelector(nextObj.meta());
        if (dstMac != null && dstMac.isMulticast()) {
            this.processL2MulticastNextObjective(nextObj);
            return;
        }
        if (nextObj.nextTreatments().stream().allMatch(n -> n.type() == NextTreatment.Type.TREATMENT)) {
            groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
            this.log.debug("prepareL2InterfaceGroup");
        } else {
            groupInfos = this.prepareL2UnfilteredGroup(nextObj);
            this.log.debug("prepareL2UnfilteredGroup");
        }
        if (groupInfos == null || groupInfos.isEmpty()) {
            this.log.warn("No buckets for Broadcast NextObj {}", (Object)nextObj);
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        IpPrefix ipDst = Ofdpa2Pipeline.readIpDstFromSelector(nextObj.meta());
        if (ipDst != null) {
            if (ipDst.isMulticast()) {
                this.createL3MulticastGroup(nextObj, assignedVlan, groupInfos);
            } else {
                this.log.warn("Broadcast NextObj with non-multicast IP address {}", (Object)nextObj);
                Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            }
        } else {
            this.createL2FloodGroup(nextObj, assignedVlan, groupInfos);
        }
    }

    private List<OfdpaGroupHandlerUtility.GroupInfo> prepareL2UnfilteredGroup(NextObjective nextObj) {
        ImmutableList.Builder groupInfoBuilder = ImmutableList.builder();
        Collection treatments = nextObj.nextTreatments().stream().filter(nt -> nt.type() == NextTreatment.Type.TREATMENT).map(nt -> ((DefaultNextTreatment)nt).treatment()).collect(Collectors.toSet());
        Collection nextIds = nextObj.nextTreatments().stream().filter(nt -> nt.type() == NextTreatment.Type.ID).map(nt -> ((IdNextTreatment)nt).nextId()).collect(Collectors.toSet());
        treatments.forEach(treatment -> {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            PortNumber port = treatment.allInstructions().stream().map(instr -> (Instructions.OutputInstruction)instr).map(instr -> instr.port()).findFirst().orElse(null);
            if (port == null) {
                this.log.debug("Skip bucket without output instruction");
                return;
            }
            tBuilder.setOutput(port);
            if (this.requireAllowVlanTransition()) {
                tBuilder.extension((ExtensionTreatment)new OfdpaSetAllowVlanTranslation(Ofdpa3AllowVlanTranslationType.ALLOW), this.deviceId);
            }
            int l2ugk = OfdpaGroupHandlerUtility.l2UnfilteredGroupKey(this.deviceId, port.toLong());
            DefaultGroupKey l2UnfilterGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2ugk));
            int l2UnfilteredGroupId = 0xB0000000 | (int)port.toLong() & 0xFFFF;
            GroupBucket l2UnfilteredGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)tBuilder.build());
            DefaultGroupDescription l2UnfilteredGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2UnfilteredGroupBucket)), (GroupKey)l2UnfilterGroupKey, Integer.valueOf(l2UnfilteredGroupId), nextObj.appId());
            this.log.debug("Trying L2-Unfiltered: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2UnfilteredGroupId), l2UnfilterGroupKey, nextObj.id()});
            groupInfoBuilder.add((Object)new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2UnfilteredGroupDesc, (GroupDescription)l2UnfilteredGroupDesc));
        });
        int counts = groupInfoBuilder.build().size();
        nextIds.forEach(nextId -> {
            NextGroup nextGroup = this.flowObjectiveStore.getNextGroup(nextId);
            if (nextGroup != null) {
                List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(nextGroup.data());
                GroupKey topGroupKey = (GroupKey)((Deque)allActiveKeys.get(0)).getFirst();
                Group groupDesc = this.groupService.getGroup(this.deviceId, topGroupKey);
                if (groupDesc != null) {
                    this.log.debug("Trying L2-Hash device:{} gid:{}, gkey:{}, nextid:{}", new Object[]{this.deviceId, Integer.toHexString((Integer)groupDesc.id().id()), topGroupKey, nextId});
                    groupInfoBuilder.add((Object)new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)groupDesc, (GroupDescription)groupDesc));
                } else {
                    this.log.error("Not found L2-Hash device:{}, gkey:{}, nextid:{}", new Object[]{this.deviceId, topGroupKey, nextId});
                }
            } else {
                this.log.error("Not found NextGroup device:{}, nextid:{}", (Object)this.deviceId, nextId);
            }
        });
        ImmutableList groupInfos = groupInfoBuilder.build();
        return counts + nextIds.size() == groupInfos.size() ? groupInfos : ImmutableList.of();
    }

    private List<OfdpaGroupHandlerUtility.GroupInfo> prepareL2InterfaceGroup(NextObjective nextObj, VlanId assignedVlan) {
        ImmutableList.Builder groupInfoBuilder = ImmutableList.builder();
        Collection buckets = nextObj.nextTreatments().stream().filter(nt -> nt.type() == NextTreatment.Type.TREATMENT).map(nt -> ((DefaultNextTreatment)nt).treatment()).collect(Collectors.toSet());
        for (TrafficTreatment treatment : buckets) {
            TrafficTreatment.Builder newTreatment = DefaultTrafficTreatment.builder();
            PortNumber portNum = null;
            VlanId egressVlan = null;
            for (Instruction ins : treatment.allInstructions()) {
                if (ins.type() == Instruction.Type.L2MODIFICATION) {
                    L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                    switch (l2ins.subtype()) {
                        case VLAN_POP: {
                            newTreatment.add((Instruction)l2ins);
                            break;
                        }
                        case VLAN_ID: {
                            egressVlan = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                            break;
                        }
                        default: {
                            this.log.debug("action {} not permitted for broadcast nextObj", (Object)l2ins.subtype());
                            break;
                        }
                    }
                    continue;
                }
                if (ins.type() == Instruction.Type.OUTPUT) {
                    portNum = ((Instructions.OutputInstruction)ins).port();
                    newTreatment.add(ins);
                    continue;
                }
                this.log.debug("TrafficTreatment of type {} not permitted in  broadcast nextObjective", (Object)ins.type());
            }
            if (portNum == null) {
                this.log.debug("Can't find output port for the bucket {}.", (Object)treatment);
                continue;
            }
            VlanId l2InterfaceGroupVlan = egressVlan != null && !assignedVlan.equals(egressVlan) ? egressVlan : assignedVlan;
            int l2gk = OfdpaGroupHandlerUtility.l2InterfaceGroupKey(this.deviceId, l2InterfaceGroupVlan, portNum.toLong());
            DefaultGroupKey l2InterfaceGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2gk));
            int l2InterfaceGroupId = 0 | (l2InterfaceGroupVlan.toShort() & 0xFFF) << 16 | (int)portNum.toLong() & 0xFFFF;
            GroupBucket l2InterfaceGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)newTreatment.build());
            DefaultGroupDescription l2InterfaceGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l2InterfaceGroupBucket)), (GroupKey)l2InterfaceGroupKey, Integer.valueOf(l2InterfaceGroupId), nextObj.appId());
            this.log.debug("Trying L2-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2InterfaceGroupId), l2InterfaceGroupKey, nextObj.id()});
            groupInfoBuilder.add((Object)new OfdpaGroupHandlerUtility.GroupInfo((GroupDescription)l2InterfaceGroupDescription, (GroupDescription)l2InterfaceGroupDescription));
        }
        return groupInfoBuilder.build();
    }

    private OfdpaGroupHandlerUtility.GroupInfo prepareL3UnicastGroup(NextObjective nextObj, NextGroup next) {
        ImmutableList.Builder groupInfoBuilder = ImmutableList.builder();
        TrafficTreatment treatment = (TrafficTreatment)nextObj.next().iterator().next();
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by next obj is missing. Abort.");
            return null;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> l2GroupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        GroupDescription l2InterfaceGroupDesc = l2GroupInfos.get(0).innerMostGroupDesc();
        GroupKey l2groupkey = l2InterfaceGroupDesc.appCookie();
        TrafficTreatment.Builder outerTtb = DefaultTrafficTreatment.builder();
        VlanId vlanid = null;
        for (Instruction ins : treatment.allInstructions()) {
            if (ins.type() == Instruction.Type.L2MODIFICATION) {
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                switch (l2ins.subtype()) {
                    case ETH_DST: {
                        MacAddress dstMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthDst(dstMac);
                        break;
                    }
                    case ETH_SRC: {
                        MacAddress srcMac = ((L2ModificationInstruction.ModEtherInstruction)l2ins).mac();
                        outerTtb.setEthSrc(srcMac);
                        break;
                    }
                    case VLAN_ID: {
                        vlanid = ((L2ModificationInstruction.ModVlanIdInstruction)l2ins).vlanId();
                        outerTtb.setVlanId(vlanid);
                        break;
                    }
                }
                continue;
            }
            this.log.debug("Driver does not handle this type of TrafficTreatment instruction in l2l3chain:  {} - {}", (Object)ins.type(), (Object)ins);
        }
        GroupId l2groupId = new GroupId(l2InterfaceGroupDesc.givenGroupId().intValue());
        outerTtb.group(l2groupId);
        List gkeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        GroupKey l3groupkey = (GroupKey)((Deque)gkeys.get(0)).peekFirst();
        GroupId grpId = this.groupService.getGroup(this.deviceId, l3groupkey).id();
        int l3groupId = (Integer)grpId.id();
        GroupBucket l3UnicastGroupBucket = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)outerTtb.build());
        DefaultGroupDescription l3UnicastGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3UnicastGroupBucket)), l3groupkey, Integer.valueOf(l3groupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3UnicastGroupDescription, 1, false, this.deviceId);
        this.updatePendingGroups(l2groupkey, gce);
        this.log.debug("Trying L3-Interface: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l3groupId), l3groupkey, nextObj.id()});
        groupInfoBuilder.add((Object)new OfdpaGroupHandlerUtility.GroupInfo(l2InterfaceGroupDesc, (GroupDescription)l3UnicastGroupDescription));
        return (OfdpaGroupHandlerUtility.GroupInfo)groupInfoBuilder.build().iterator().next();
    }

    private void createL2FloodGroup(NextObjective nextObj, VlanId vlanId, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos) {
        Integer l2FloodGroupId = 0x40000000 | vlanId.toShort() << 16;
        GroupKey l2FloodGroupKey = OfdpaGroupHandlerUtility.l2FloodGroupKey(vlanId, this.deviceId);
        List<GroupBucket> l2floodBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(groupInfos, GroupDescription.Type.ALL);
        DefaultGroupDescription l2floodGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(l2floodBuckets), l2FloodGroupKey, l2FloodGroupId, nextObj.appId());
        this.log.debug("Trying L2-Flood: device:{} gid:{} gkey:{} nextid:{}", new Object[]{this.deviceId, Integer.toHexString(l2FloodGroupId), l2FloodGroupKey, nextObj.id()});
        ArrayList allGroupKeys = Lists.newArrayList();
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> groupKeyChain = new ArrayDeque<GroupKey>();
            groupKeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            groupKeyChain.addFirst(l2FloodGroupKey);
            allGroupKeys.add(groupKeyChain);
        });
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective(l2FloodGroupKey, ofdpaGrp);
        OfdpaGroupHandlerUtility.GroupChainElem gce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2floodGroupDescription, groupInfos.size(), false, this.deviceId);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), gce);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    private void createL3MulticastGroup(NextObjective nextObj, VlanId vlanId, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos) {
        List<GroupBucket> l3McastBuckets = OfdpaGroupHandlerUtility.createL3MulticastBucket(groupInfos);
        int l3MulticastIndex = this.getNextAvailableIndex();
        int l3MulticastGroupId = 0x60000000 | vlanId.toShort() << 16 | 0xFFFF & l3MulticastIndex;
        DefaultGroupKey l3MulticastGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3MulticastIndex));
        DefaultGroupDescription l3MulticastGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(l3McastBuckets), (GroupKey)l3MulticastGroupKey, Integer.valueOf(l3MulticastGroupId), nextObj.appId());
        ArrayList allGroupKeys = Lists.newArrayList();
        groupInfos.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$createL3MulticastGroup$20((GroupKey)l3MulticastGroupKey, allGroupKeys, arg_0));
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l3MulticastGroupKey, ofdpaGrp);
        OfdpaGroupHandlerUtility.GroupChainElem outerGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3MulticastGroupDesc, groupInfos.size(), false, this.deviceId);
        groupInfos.forEach(groupInfo -> {
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), outerGce);
            if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
                OfdpaGroupHandlerUtility.GroupChainElem innerGce = new OfdpaGroupHandlerUtility.GroupChainElem(groupInfo.nextGroupDesc(), 1, false, this.deviceId);
                this.updatePendingGroups(groupInfo.innerMostGroupDesc().appCookie(), innerGce);
            }
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    protected void processEcmpHashedNextObjective(NextObjective nextObj) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
        this.createEcmpHashBucketChains(nextObj, allGroupKeys, unsentGroups);
        ArrayList<GroupBucket> l3ecmpGroupBuckets = new ArrayList<GroupBucket>();
        for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group(new GroupId(gi.nextGroupDesc().givenGroupId().intValue()));
            GroupBucket sbucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)ttb.build());
            l3ecmpGroupBuckets.add(sbucket);
        }
        int l3ecmpIndex = this.getNextAvailableIndex();
        int l3ecmpGroupId = 0x70000000 | 0xFFFFFFF & l3ecmpIndex;
        DefaultGroupKey l3ecmpGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3ecmpIndex));
        DefaultGroupDescription l3ecmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(l3ecmpGroupBuckets), (GroupKey)l3ecmpGroupKey, Integer.valueOf(l3ecmpGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l3ecmpGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3ecmpGroupDesc, l3ecmpGroupBuckets.size(), false, this.deviceId);
        allGroupKeys.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$processEcmpHashedNextObjective$22((GroupKey)l3ecmpGroupKey, arg_0));
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l3ecmpGroupKey, ofdpaGrp);
        this.log.debug("Trying L3ECMP: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3ecmpGroupId), l3ecmpGroupKey, nextObj.id()});
        for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(gi.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(gi.nextGroupDesc().appCookie(), l3ecmpGce);
            this.groupService.addGroup(gi.innerMostGroupDesc());
        }
    }

    protected void createEcmpHashBucketChains(NextObjective nextObj, List<Deque<GroupKey>> allGroupKeys, List<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups) {
        Collection buckets = nextObj.next();
        for (TrafficTreatment bucket : buckets) {
            int labelsPushed = 0;
            MplsLabel innermostLabel = null;
            for (Instruction ins : bucket.allInstructions()) {
                if (ins.type() != Instruction.Type.L2MODIFICATION) continue;
                L2ModificationInstruction l2ins = (L2ModificationInstruction)ins;
                if (l2ins.subtype() == L2ModificationInstruction.L2SubType.MPLS_PUSH) {
                    ++labelsPushed;
                }
                if (l2ins.subtype() != L2ModificationInstruction.L2SubType.MPLS_LABEL || innermostLabel != null) continue;
                innermostLabel = ((L2ModificationInstruction.ModMplsLabelInstruction)l2ins).label();
            }
            ArrayDeque<Object> gKeyChain = new ArrayDeque<Object>();
            if (labelsPushed == 0) {
                TrafficSelector metaSelector = nextObj.meta();
                OfdpaGroupHandlerUtility.GroupInfo noLabelGroupInfo = metaSelector != null ? (Ofdpa2Pipeline.isNotMplsBos(metaSelector) ? this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), true, nextObj.meta()) : this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), false, nextObj.meta())) : this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), false, nextObj.meta());
                if (noLabelGroupInfo == null) {
                    this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                    return;
                }
                gKeyChain.addFirst(noLabelGroupInfo.innerMostGroupDesc().appCookie());
                gKeyChain.addFirst(noLabelGroupInfo.nextGroupDesc().appCookie());
                unsentGroups.add(noLabelGroupInfo);
            } else if (labelsPushed == 1) {
                OfdpaGroupHandlerUtility.GroupInfo onelabelGroupInfo = this.createL2L3Chain(bucket, nextObj.id(), nextObj.appId(), true, nextObj.meta());
                if (onelabelGroupInfo == null) {
                    this.log.error("Could not process nextObj={} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
                    return;
                }
                TrafficTreatment.Builder l3vpnTtb = DefaultTrafficTreatment.builder();
                if (this.requireVlanPopBeforeMplsPush()) {
                    l3vpnTtb.popVlan();
                }
                l3vpnTtb.pushMpls().setMpls(innermostLabel).group(new GroupId(onelabelGroupInfo.nextGroupDesc().givenGroupId().intValue()));
                if (this.supportCopyTtl()) {
                    l3vpnTtb.copyTtlOut();
                }
                if (this.supportSetMplsBos()) {
                    l3vpnTtb.setMplsBos(true);
                }
                if (this.requireVlanPopBeforeMplsPush()) {
                    l3vpnTtb.pushVlan().setVlanId(VlanId.vlanId((short)4095));
                }
                GroupBucket l3vpnGrpBkt = DefaultGroupBucket.createIndirectGroupBucket((TrafficTreatment)l3vpnTtb.build());
                int l3vpnIndex = this.getNextAvailableIndex();
                int l3vpnGroupId = 0x92000000 | 0xFFFFFF & l3vpnIndex;
                DefaultGroupKey l3vpnGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l3vpnIndex));
                DefaultGroupDescription l3vpnGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.INDIRECT, new GroupBuckets(Collections.singletonList(l3vpnGrpBkt)), (GroupKey)l3vpnGroupKey, Integer.valueOf(l3vpnGroupId), nextObj.appId());
                OfdpaGroupHandlerUtility.GroupChainElem l3vpnGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3vpnGroupDesc, 1, false, this.deviceId);
                this.updatePendingGroups(onelabelGroupInfo.nextGroupDesc().appCookie(), l3vpnGce);
                gKeyChain.addFirst(onelabelGroupInfo.innerMostGroupDesc().appCookie());
                gKeyChain.addFirst(onelabelGroupInfo.nextGroupDesc().appCookie());
                gKeyChain.addFirst(l3vpnGroupKey);
                onelabelGroupInfo.nextGroupDesc((GroupDescription)l3vpnGroupDesc);
                unsentGroups.add(onelabelGroupInfo);
                this.log.debug("Trying L3VPN: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3vpnGroupId), l3vpnGroupKey, nextObj.id()});
            } else {
                this.log.warn("Driver currently does not handle more than 1 MPLS labels. Not processing nextObjective {}", (Object)nextObj.id());
                return;
            }
            allGroupKeys.add(gKeyChain);
        }
    }

    private void processL2HashedNextObjective(NextObjective nextObj) {
        int l2LbIndex = Optional.ofNullable(nextObj.meta().getCriterion(Criterion.Type.IN_PORT)).map(c -> (PortCriterion)c).map(PortCriterion::port).map(PortNumber::toLong).map(Long::intValue).orElse(-1);
        if (l2LbIndex == -1) {
            this.log.warn("l2LbIndex is not found in the meta of L2 hash objective. Abort");
            return;
        }
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
        this.createL2HashBuckets(nextObj, allGroupKeys, unsentGroups);
        ArrayList<GroupBucket> l2LbGroupBuckets = new ArrayList<GroupBucket>();
        for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
            TrafficTreatment.Builder ttb = DefaultTrafficTreatment.builder();
            ttb.group(new GroupId(gi.nextGroupDesc().givenGroupId().intValue()));
            GroupBucket sbucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)ttb.build());
            l2LbGroupBuckets.add(sbucket);
        }
        int l2LbGroupId = 0xC0000000 | 0xFFFFFFF & l2LbIndex;
        int l2lbgk = OfdpaGroupHandlerUtility.l2HashGroupKey(this.deviceId, l2LbIndex);
        DefaultGroupKey l2LbGroupKey = new DefaultGroupKey(Ofdpa2Pipeline.appKryo.serialize((Object)l2lbgk));
        DefaultGroupDescription l2LbGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(l2LbGroupBuckets), (GroupKey)l2LbGroupKey, Integer.valueOf(l2LbGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l2LbGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2LbGroupDesc, l2LbGroupBuckets.size(), false, this.deviceId);
        allGroupKeys.forEach(arg_0 -> Ofdpa2GroupHandler.lambda$processL2HashedNextObjective$24((GroupKey)l2LbGroupKey, arg_0));
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObj);
        this.updatePendingNextObjective((GroupKey)l2LbGroupKey, ofdpaGrp);
        this.log.debug("Trying L2-LB: device:{} gid:{} gkey:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2LbGroupId), l2LbGroupKey, nextObj.id()});
        for (OfdpaGroupHandlerUtility.GroupInfo gi : unsentGroups) {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(gi.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(gi.nextGroupDesc().appCookie(), l2LbGce);
            this.groupService.addGroup(gi.innerMostGroupDesc());
        }
    }

    private void createL2HashBuckets(NextObjective nextObj, List<Deque<GroupKey>> allGroupKeys, List<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups) {
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2UnfilteredGroup(nextObj);
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> gKeyChain = new ArrayDeque<GroupKey>();
            gKeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            allGroupKeys.add(gKeyChain);
            unsentGroups.add((OfdpaGroupHandlerUtility.GroupInfo)groupInfo);
        });
    }

    protected void processPwNextObjective(NextObjective nextObjective) {
        this.log.warn("Pseudo wire extensions are not supported in OFDPA 2.0 {}", (Object)nextObjective.id());
    }

    protected void addBucketToGroup(NextObjective nextObjective, NextGroup next) {
        NextObjective objectiveToAdd;
        if (nextObjective.type() != NextObjective.Type.HASHED && nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.warn("AddBuckets not applied to nextType:{} in dev:{} for next:{}", new Object[]{nextObjective.type(), this.deviceId, nextObjective.id()});
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        HashSet duplicateBuckets = Sets.newHashSet();
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        Set<PortNumber> existingPorts = OfdpaGroupHandlerUtility.getExistingOutputPorts(allActiveKeys, this.groupService, this.deviceId);
        HashSet nonDuplicateBuckets = Sets.newHashSet();
        nextObjective.next().forEach(trafficTreatment -> {
            PortNumber portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(trafficTreatment);
            if (portNumber == null) {
                return;
            }
            if (existingPorts.contains(portNumber)) {
                int label = OfdpaGroupHandlerUtility.readLabelFromTreatment(trafficTreatment);
                if (label == -1) {
                    duplicateBuckets.add(trafficTreatment);
                } else {
                    List<Integer> existing = OfdpaGroupHandlerUtility.existingPortAndLabel(allActiveKeys, this.groupService, this.deviceId, portNumber, label);
                    if (!existing.isEmpty()) {
                        duplicateBuckets.add(trafficTreatment);
                    } else {
                        nonDuplicateBuckets.add(trafficTreatment);
                    }
                }
            } else {
                nonDuplicateBuckets.add(trafficTreatment);
            }
        });
        if (duplicateBuckets.isEmpty()) {
            objectiveToAdd = nextObjective;
        } else if (!nonDuplicateBuckets.isEmpty()) {
            this.log.debug("Some buckets {} already exist in next id {}, duplicate buckets will be ignored.", (Object)duplicateBuckets, (Object)nextObjective.id());
            DefaultNextObjective.Builder builder = DefaultNextObjective.builder().withType(nextObjective.type()).withId(nextObjective.id()).withMeta(nextObjective.meta()).fromApp(nextObjective.appId());
            nonDuplicateBuckets.forEach(arg_0 -> ((NextObjective.Builder)builder).addTreatment(arg_0));
            ObjectiveContext context = nextObjective.context().orElse(null);
            objectiveToAdd = builder.addToExisting(context);
        } else {
            this.log.debug("buckets already exist {} in next: {} ..ignoring bucket add", (Object)duplicateBuckets, (Object)nextObjective.id());
            Ofdpa2Pipeline.pass((Objective)nextObjective);
            return;
        }
        if (nextObjective.type() == NextObjective.Type.HASHED) {
            if (OfdpaGroupHandlerUtility.isL2Hash(nextObjective)) {
                this.addBucketToL2HashGroup(objectiveToAdd, allActiveKeys);
                return;
            }
            this.addBucketToEcmpHashGroup(objectiveToAdd, allActiveKeys);
        } else if (nextObjective.type() == NextObjective.Type.BROADCAST) {
            this.addBucketToBroadcastGroup(objectiveToAdd, allActiveKeys);
        }
    }

    private void addBucketToL2HashGroup(NextObjective nextObjective, List<Deque<GroupKey>> allActiveKeys) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
        this.createL2HashBuckets(nextObjective, allGroupKeys, unsentGroups);
        List<GroupBucket> newBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(unsentGroups, GroupDescription.Type.SELECT);
        Group l2hashGroup = OfdpaGroupHandlerUtility.retrieveTopLevelGroup(allActiveKeys, this.deviceId, this.groupService, nextObjective.id());
        if (l2hashGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l2hashGroupKey = l2hashGroup.appCookie();
        int l2hashGroupId = (Integer)l2hashGroup.id().id();
        DefaultGroupDescription l2hashGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(newBuckets), l2hashGroupKey, Integer.valueOf(l2hashGroupId), nextObjective.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l2hashGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2hashGroupDesc, unsentGroups.size(), true, this.deviceId);
        ArrayList<Deque<GroupKey>> addedKeys = new ArrayList<Deque<GroupKey>>();
        for (Deque deque : allGroupKeys) {
            deque.addFirst(l2hashGroupKey);
            addedKeys.add(deque);
        }
        this.updatePendingNextObjective(l2hashGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(addedKeys, nextObjective));
        this.log.debug("Adding to L2HASH: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2hashGroupId), l2hashGroupKey, nextObjective.id()});
        unsentGroups.forEach(groupInfo -> {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l2hashGce);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    private void addBucketToEcmpHashGroup(NextObjective nextObjective, List<Deque<GroupKey>> allActiveKeys) {
        ArrayList<Deque<GroupKey>> allGroupKeys = new ArrayList<Deque<GroupKey>>();
        ArrayList<OfdpaGroupHandlerUtility.GroupInfo> unsentGroups = new ArrayList<OfdpaGroupHandlerUtility.GroupInfo>();
        this.createEcmpHashBucketChains(nextObjective, allGroupKeys, unsentGroups);
        List<GroupBucket> newBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(unsentGroups, GroupDescription.Type.SELECT);
        Group l3ecmpGroup = OfdpaGroupHandlerUtility.retrieveTopLevelGroup(allActiveKeys, this.deviceId, this.groupService, nextObjective.id());
        if (l3ecmpGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l3ecmpGroupKey = l3ecmpGroup.appCookie();
        int l3ecmpGroupId = (Integer)l3ecmpGroup.id().id();
        DefaultGroupDescription l3ecmpGroupDesc = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.SELECT, new GroupBuckets(newBuckets), l3ecmpGroupKey, Integer.valueOf(l3ecmpGroupId), nextObjective.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l3ecmpGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3ecmpGroupDesc, unsentGroups.size(), true, this.deviceId);
        ArrayList<Deque<GroupKey>> addedKeys = new ArrayList<Deque<GroupKey>>();
        for (Deque deque : allGroupKeys) {
            deque.addFirst(l3ecmpGroupKey);
            addedKeys.add(deque);
        }
        this.updatePendingNextObjective(l3ecmpGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(addedKeys, nextObjective));
        this.log.debug("Adding to L3ECMP: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3ecmpGroupId), l3ecmpGroupKey, nextObjective.id()});
        unsentGroups.forEach(groupInfo -> {
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l3ecmpGce);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
    }

    private void addBucketToBroadcastGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObj.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by broadcast next obj is missing. Aborting add bucket to broadcast group for next:{} in dev:{}", (Object)nextObj.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObj, assignedVlan);
        IpPrefix ipDst = Ofdpa2Pipeline.readIpDstFromSelector(nextObj.meta());
        if (ipDst != null) {
            if (ipDst.isMulticast()) {
                this.addBucketToL3MulticastGroup(nextObj, allActiveKeys, groupInfos, assignedVlan);
            } else {
                this.log.warn("Broadcast NextObj with non-multicast IP address {}", (Object)nextObj);
                Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            }
        } else {
            this.addBucketToL2FloodGroup(nextObj, allActiveKeys, groupInfos, assignedVlan);
        }
    }

    private void addBucketToL2FloodGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos, VlanId assignedVlan) {
        Group l2FloodGroup = OfdpaGroupHandlerUtility.retrieveTopLevelGroup(allActiveKeys, this.deviceId, this.groupService, nextObj.id());
        if (l2FloodGroup == null) {
            this.log.warn("Can't find L2 flood group while adding bucket to it. NextObj = {}", (Object)nextObj);
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l2floodGroupKey = l2FloodGroup.appCookie();
        int l2floodGroupId = (Integer)l2FloodGroup.id().id();
        List<GroupBucket> newBuckets = OfdpaGroupHandlerUtility.generateNextGroupBuckets(groupInfos, GroupDescription.Type.ALL);
        DefaultGroupDescription l2FloodGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(newBuckets), l2floodGroupKey, Integer.valueOf(l2floodGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l2FloodGroupChainElement = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l2FloodGroupDescription, groupInfos.size(), true, this.deviceId);
        VlanId floodGroupVlan = OfdpaGroupHandlerUtility.extractVlanIdFromGroupId(l2floodGroupId);
        if (!floodGroupVlan.equals((Object)assignedVlan)) {
            this.log.warn("VLAN ID {} does not match Flood group {} to which bucket is being added, for next:{} in dev:{}. Abort.", new Object[]{assignedVlan, Integer.toHexString(l2floodGroupId), nextObj.id(), this.deviceId});
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
            return;
        }
        ArrayList<Deque<GroupKey>> addedKeys = new ArrayList<Deque<GroupKey>>();
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> newBucketChain = new ArrayDeque<GroupKey>();
            newBucketChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            newBucketChain.addFirst(l2floodGroupKey);
            addedKeys.add(newBucketChain);
            this.log.debug("Adding to L2FLOOD: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l2floodGroupId), l2floodGroupKey, nextObj.id()});
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l2FloodGroupChainElement);
            DeviceId innerMostGroupDevice = groupInfo.innerMostGroupDesc().deviceId();
            GroupKey innerMostGroupKey = groupInfo.innerMostGroupDesc().appCookie();
            Group existsL2IGroup = this.groupService.getGroup(innerMostGroupDevice, innerMostGroupKey);
            if (existsL2IGroup != null) {
                this.processPendingAddGroupsOrNextObjs(innerMostGroupKey, true);
            } else {
                this.groupService.addGroup(groupInfo.innerMostGroupDesc());
            }
        });
        this.updatePendingNextObjective(l2floodGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(addedKeys, nextObj));
    }

    private void addBucketToL3MulticastGroup(NextObjective nextObj, List<Deque<GroupKey>> allActiveKeys, List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos, VlanId assignedVlan) {
        List<GroupBucket> newBuckets = OfdpaGroupHandlerUtility.createL3MulticastBucket(groupInfos);
        Group l3mcastGroup = OfdpaGroupHandlerUtility.retrieveTopLevelGroup(allActiveKeys, this.deviceId, this.groupService, nextObj.id());
        if (l3mcastGroup == null) {
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.GROUPMISSING);
            return;
        }
        GroupKey l3mcastGroupKey = l3mcastGroup.appCookie();
        int l3mcastGroupId = (Integer)l3mcastGroup.id().id();
        VlanId expectedVlan = OfdpaGroupHandlerUtility.extractVlanIdFromGroupId(l3mcastGroupId);
        if (!expectedVlan.equals((Object)assignedVlan)) {
            this.log.warn("VLAN ID {} does not match L3 Mcast group {} to which bucket is being added, for next:{} in dev:{}. Abort.", new Object[]{assignedVlan, Integer.toHexString(l3mcastGroupId), nextObj.id(), this.deviceId});
            Ofdpa2Pipeline.fail((Objective)nextObj, ObjectiveError.BADPARAMS);
        }
        DefaultGroupDescription l3mcastGroupDescription = new DefaultGroupDescription(this.deviceId, GroupDescription.Type.ALL, new GroupBuckets(newBuckets), l3mcastGroupKey, Integer.valueOf(l3mcastGroupId), nextObj.appId());
        OfdpaGroupHandlerUtility.GroupChainElem l3mcastGce = new OfdpaGroupHandlerUtility.GroupChainElem((GroupDescription)l3mcastGroupDescription, groupInfos.size(), true, this.deviceId);
        ArrayList<Deque<GroupKey>> addedKeys = new ArrayList<Deque<GroupKey>>();
        groupInfos.forEach(groupInfo -> {
            ArrayDeque<GroupKey> newBucketChain = new ArrayDeque<GroupKey>();
            newBucketChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
            if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
                newBucketChain.addFirst(groupInfo.nextGroupDesc().appCookie());
            }
            newBucketChain.addFirst(l3mcastGroupKey);
            addedKeys.add(newBucketChain);
            this.updatePendingGroups(groupInfo.nextGroupDesc().appCookie(), l3mcastGce);
            if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
                OfdpaGroupHandlerUtility.GroupChainElem innerGce = new OfdpaGroupHandlerUtility.GroupChainElem(groupInfo.nextGroupDesc(), 1, false, this.deviceId);
                this.updatePendingGroups(groupInfo.innerMostGroupDesc().appCookie(), innerGce);
            }
            this.log.debug("Adding to L3MCAST: device:{} gid:{} group key:{} nextId:{}", new Object[]{this.deviceId, Integer.toHexString(l3mcastGroupId), l3mcastGroupKey, nextObj.id()});
            this.log.debug("Sending innermost group {} in group chain on device {} ", (Object)Integer.toHexString(groupInfo.innerMostGroupDesc().givenGroupId()), (Object)this.deviceId);
            this.groupService.addGroup(groupInfo.innerMostGroupDesc());
        });
        this.updatePendingNextObjective(l3mcastGroupKey, new OfdpaGroupHandlerUtility.OfdpaNextGroup(addedKeys, nextObj));
    }

    protected void removeBucketFromGroup(NextObjective nextObjective, NextGroup next) {
        if (nextObjective.type() != NextObjective.Type.HASHED && nextObjective.type() != NextObjective.Type.BROADCAST) {
            this.log.warn("RemoveBuckets not applied to nextType:{} in dev:{} for next:{}", new Object[]{nextObjective.type(), this.deviceId, nextObjective.id()});
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        ArrayList indicesToRemove = Lists.newArrayList();
        for (TrafficTreatment treatment : nextObjective.next()) {
            PortNumber portToRemove = OfdpaGroupHandlerUtility.readOutPortFromTreatment(treatment);
            int labelToRemove = OfdpaGroupHandlerUtility.readLabelFromTreatment(treatment);
            if (portToRemove == null) {
                this.log.warn("treatment {} of next objective {} has no outport.. cannot remove bucket from group in dev: {}", new Object[]{treatment, nextObjective.id(), this.deviceId});
                continue;
            }
            List<Integer> existing = OfdpaGroupHandlerUtility.existingPortAndLabel(allActiveKeys, this.groupService, this.deviceId, portToRemove, labelToRemove);
            indicesToRemove.addAll(existing);
        }
        ArrayList chainsToRemove = Lists.newArrayList();
        indicesToRemove.forEach(index -> chainsToRemove.add((Deque)allActiveKeys.get((int)index)));
        if (chainsToRemove.isEmpty()) {
            this.log.warn("Could not find appropriate group-chain for removing bucket for next id {} in dev:{}", (Object)nextObjective.id(), (Object)this.deviceId);
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        this.removeBucket(chainsToRemove, nextObjective);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBucket(List<Deque<GroupKey>> chainsToRemove, NextObjective nextObjective) {
        ArrayList bucketsToRemove = Lists.newArrayList();
        GroupKey modGroupKey = chainsToRemove.get(0).peekFirst();
        Group modGroup = this.groupService.getGroup(this.deviceId, modGroupKey);
        if (modGroup == null) {
            this.log.warn("removeBucket(): Attempt to modify non-existent group {} for device {}", (Object)modGroupKey, (Object)this.deviceId);
            return;
        }
        for (Deque<GroupKey> foundChain : chainsToRemove) {
            if (foundChain.size() < 2) {
                this.log.warn("Can't find second group key from chain {}", foundChain);
                continue;
            }
            GroupKey pointedGroupKey = (GroupKey)foundChain.stream().collect(Collectors.toList()).get(1);
            Group pointedGroup = this.groupService.getGroup(this.deviceId, pointedGroupKey);
            if (pointedGroup == null) continue;
            GroupBucket bucket = nextObjective.type() == NextObjective.Type.HASHED ? DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)DefaultTrafficTreatment.builder().group(pointedGroup.id()).build()) : DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)DefaultTrafficTreatment.builder().group(pointedGroup.id()).build());
            bucketsToRemove.add(bucket);
        }
        GroupBuckets removeBuckets = new GroupBuckets((List)bucketsToRemove);
        List pointedGroupIds = bucketsToRemove.stream().map(GroupBucket::treatment).map(TrafficTreatment::allInstructions).flatMap(Collection::stream).filter(inst -> inst instanceof Instructions.GroupInstruction).map(inst -> (Instructions.GroupInstruction)inst).map(Instructions.GroupInstruction::groupId).map(Identifier::id).map(Integer::toHexString).map(id -> "0x" + id).collect(Collectors.toList());
        this.log.debug("Removing buckets from group id 0x{} pointing to group id(s) {} for next id {} in device {}", new Object[]{Integer.toHexString((Integer)modGroup.id().id()), pointedGroupIds, nextObjective.id(), this.deviceId});
        this.addPendingUpdateNextObjective(modGroupKey, nextObjective);
        this.groupService.removeBucketsFromGroup(this.deviceId, modGroupKey, removeBuckets, modGroupKey, nextObjective.appId());
        FlowObjectiveStore flowObjectiveStore = this.flowObjectiveStore;
        synchronized (flowObjectiveStore) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(Integer.valueOf(nextObjective.id()));
            List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
            allActiveKeys = Lists.newArrayList((Iterable)allActiveKeys);
            allActiveKeys.removeIf(active -> chainsToRemove.stream().anyMatch(remove -> Arrays.equals(remove.toArray(new GroupKey[0]), active.toArray(new GroupKey[0]))));
            if (allActiveKeys.isEmpty()) {
                ArrayDeque<GroupKey> top = new ArrayDeque<GroupKey>();
                top.add(modGroupKey);
                allActiveKeys.add(top);
            }
            this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new OfdpaGroupHandlerUtility.OfdpaNextGroup(allActiveKeys, nextObjective));
        }
    }

    protected void removeGroup(NextObjective nextObjective, NextGroup next) {
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        List<GroupKey> groupKeys = allActiveKeys.stream().map(Deque::getFirst).collect(Collectors.toList());
        this.addPendingRemoveNextObjective(nextObjective, groupKeys);
        allActiveKeys.forEach(groupChain -> groupChain.forEach(groupKey -> this.groupService.removeGroup(this.deviceId, groupKey, nextObjective.appId())));
        this.flowObjectiveStore.removeNextGroup(Integer.valueOf(nextObjective.id()));
    }

    protected void modifyBucketFromGroup(NextObjective nextObjective, NextGroup nextGroup) {
        switch (nextObjective.type()) {
            case SIMPLE: {
                Collection treatments = nextObjective.next();
                if (treatments.size() != 1) {
                    this.log.error("Next Objectives of type Simple should only have a single Traffic Treatment. Next Objective Id:{}", (Object)nextObjective.id());
                    Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                    return;
                }
                this.modifySimpleNextObjective(nextObjective, nextGroup);
                break;
            }
            default: {
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNKNOWN);
                this.log.warn("Unknown next objective type {}", (Object)nextObjective.type());
            }
        }
    }

    private void modifySimpleNextObjective(NextObjective nextObj, NextGroup nextGroup) {
        TrafficTreatment treatment = (TrafficTreatment)nextObj.next().iterator().next();
        boolean plainL2 = true;
        for (Instruction ins : treatment.allInstructions()) {
            L2ModificationInstruction l2ins;
            if (ins.type() != Instruction.Type.L2MODIFICATION || (l2ins = (L2ModificationInstruction)ins).subtype() != L2ModificationInstruction.L2SubType.ETH_DST && l2ins.subtype() != L2ModificationInstruction.L2SubType.ETH_SRC && l2ins.subtype() != L2ModificationInstruction.L2SubType.VLAN_ID) continue;
            plainL2 = false;
        }
        if (plainL2) {
            this.modifyBucketInL2Group(nextObj, nextGroup);
        } else {
            this.modifyBucketInL3Group(nextObj, nextGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyBucketInL2Group(NextObjective nextObjective, NextGroup next) {
        VlanId assignedVlan = Ofdpa2Pipeline.readVlanFromSelector(nextObjective.meta());
        if (assignedVlan == null) {
            this.log.warn("VLAN ID required by simple next obj is missing. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        List<OfdpaGroupHandlerUtility.GroupInfo> groupInfos = this.prepareL2InterfaceGroup(nextObjective, assignedVlan);
        GroupDescription l2InterfaceGroupDesc = groupInfos.get(0).innerMostGroupDesc();
        this.groupService.setBucketsForGroup(this.deviceId, l2InterfaceGroupDesc.appCookie(), l2InterfaceGroupDesc.buckets(), l2InterfaceGroupDesc.appCookie(), l2InterfaceGroupDesc.appId());
        FlowObjectiveStore flowObjectiveStore = this.flowObjectiveStore;
        synchronized (flowObjectiveStore) {
            ArrayList modifiedGroupKeys = Lists.newArrayList();
            ArrayDeque<GroupKey> top = new ArrayDeque<GroupKey>();
            top.add(l2InterfaceGroupDesc.appCookie());
            modifiedGroupKeys.add(top);
            this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new OfdpaGroupHandlerUtility.OfdpaNextGroup(modifiedGroupKeys, nextObjective));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modifyBucketInL3Group(NextObjective nextObjective, NextGroup next) {
        OfdpaGroupHandlerUtility.GroupInfo groupInfo = this.prepareL3UnicastGroup(nextObjective, next);
        if (groupInfo == null) {
            this.log.warn("Null groupInfo retrieved for next obj. Abort.");
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
            return;
        }
        GroupDescription l3UnicastGroupDesc = groupInfo.nextGroupDesc();
        this.groupService.setBucketsForGroup(this.deviceId, l3UnicastGroupDesc.appCookie(), l3UnicastGroupDesc.buckets(), l3UnicastGroupDesc.appCookie(), l3UnicastGroupDesc.appId());
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
        gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
        ArrayList allGroupKeys = Lists.newArrayList();
        allGroupKeys.add(gkeyChain);
        OfdpaGroupHandlerUtility.OfdpaNextGroup ofdpaGrp = new OfdpaGroupHandlerUtility.OfdpaNextGroup(allGroupKeys, nextObjective);
        this.updatePendingNextObjective(groupInfo.nextGroupDesc().appCookie(), ofdpaGrp);
        FlowObjectiveStore flowObjectiveStore = this.flowObjectiveStore;
        synchronized (flowObjectiveStore) {
            ArrayList modifiedGroupKeys = Lists.newArrayList();
            ArrayDeque<GroupKey> top = new ArrayDeque<GroupKey>();
            top.add(l3UnicastGroupDesc.appCookie());
            top.add(groupInfo.innerMostGroupDesc().appCookie());
            modifiedGroupKeys.add(top);
            this.flowObjectiveStore.putNextGroup(Integer.valueOf(nextObjective.id()), (NextGroup)new OfdpaGroupHandlerUtility.OfdpaNextGroup(modifiedGroupKeys, nextObjective));
        }
    }

    protected void verifyGroup(NextObjective nextObjective, NextGroup next) {
        if (nextObjective.type() == NextObjective.Type.SIMPLE) {
            this.log.warn("verification not supported for indirect group");
            Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.UNSUPPORTED);
            return;
        }
        this.log.trace("Call to verify device:{} nextId:{}", (Object)this.deviceId, (Object)nextObjective.id());
        List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
        ArrayList bucketsToCreate = Lists.newArrayList();
        ArrayList indicesToRemove = Lists.newArrayList();
        for (TrafficTreatment bkt : nextObjective.next()) {
            PortNumber portNumber = OfdpaGroupHandlerUtility.readOutPortFromTreatment(bkt);
            int label = OfdpaGroupHandlerUtility.readLabelFromTreatment(bkt);
            if (portNumber == null) {
                this.log.warn("treatment {} of next objective {} has no outport.. cannot remove bucket from group in dev: {}", new Object[]{bkt, nextObjective.id(), this.deviceId});
                Ofdpa2Pipeline.fail((Objective)nextObjective, ObjectiveError.BADPARAMS);
                return;
            }
            List<Integer> existing = OfdpaGroupHandlerUtility.existingPortAndLabel(allActiveKeys, this.groupService, this.deviceId, portNumber, label);
            if (existing.isEmpty()) {
                bucketsToCreate.add(bkt);
            }
            if (existing.size() <= 1) continue;
            existing.remove(0);
            indicesToRemove.addAll(existing);
        }
        if (allActiveKeys.size() > nextObjective.next().size() && (nextObjective.next().size() != 0 || allActiveKeys.size() != 1 || ((Deque)allActiveKeys.get(0)).size() != 1)) {
            this.log.warn("Mismatch detected between next and flowobjstore for device {}: nextId:{}, nextObjective-size:{} next-size:{} .. correcting", new Object[]{this.deviceId, nextObjective.id(), nextObjective.next().size(), allActiveKeys.size()});
            List<Integer> otherIndices = OfdpaGroupHandlerUtility.indicesToRemoveFromNextGroup(allActiveKeys, nextObjective, this.groupService, this.deviceId);
            otherIndices = otherIndices.stream().filter(index -> !indicesToRemove.contains(index)).collect(Collectors.toList());
            indicesToRemove.addAll(otherIndices);
        }
        this.log.trace("Buckets to create {}", (Object)bucketsToCreate);
        this.log.trace("Indices to remove {}", (Object)indicesToRemove);
        if (!bucketsToCreate.isEmpty()) {
            this.log.info("creating {} buckets as part of nextId: {} verification", (Object)bucketsToCreate.size(), (Object)nextObjective.id());
            DefaultNextObjective.Builder nextObjBuilder = DefaultNextObjective.builder().withId(nextObjective.id()).withType(nextObjective.type()).withMeta(nextObjective.meta()).fromApp(nextObjective.appId());
            bucketsToCreate.forEach(arg_0 -> ((NextObjective.Builder)nextObjBuilder).addTreatment(arg_0));
            if (nextObjective.type() == NextObjective.Type.HASHED) {
                if (OfdpaGroupHandlerUtility.isL2Hash(nextObjective)) {
                    this.addBucketToL2HashGroup(nextObjBuilder.addToExisting(), allActiveKeys);
                } else {
                    this.addBucketToEcmpHashGroup(nextObjBuilder.addToExisting(), allActiveKeys);
                }
            } else {
                this.addBucketToBroadcastGroup(nextObjBuilder.addToExisting(), allActiveKeys);
            }
        }
        if (!indicesToRemove.isEmpty()) {
            this.log.info("removing {} buckets as part of nextId: {} verification", (Object)indicesToRemove.size(), (Object)nextObjective.id());
            ArrayList chainsToRemove = Lists.newArrayList();
            indicesToRemove.forEach(index -> chainsToRemove.add((Deque)allActiveKeys.get((int)index)));
            this.removeBucket(chainsToRemove, nextObjective);
        }
        if (bucketsToCreate.isEmpty() && indicesToRemove.isEmpty()) {
            int objGroupSize;
            GroupKey topGroupKey = (GroupKey)((Deque)allActiveKeys.get(0)).peekFirst();
            Group topGroup = this.groupService.getGroup(this.deviceId, topGroupKey);
            int actualGroupSize = topGroup.buckets().buckets().size();
            if (actualGroupSize != (objGroupSize = nextObjective.next().size())) {
                this.log.warn("Mismatch detected in device:{}, nextId:{}, nextObjective-size:{} group-size:{} .. correcting", new Object[]{this.deviceId, nextObjective.id(), objGroupSize, actualGroupSize});
            }
            if (actualGroupSize > objGroupSize) {
                ArrayList bucketsToRemove = Lists.newArrayList();
                for (GroupBucket bucket : topGroup.buckets().buckets()) {
                    Instructions.GroupInstruction g = (Instructions.GroupInstruction)bucket.treatment().allInstructions().iterator().next();
                    GroupId gidToCheck = g.groupId();
                    boolean matches = false;
                    for (Deque validChain : allActiveKeys) {
                        GroupKey pointedGroupKey;
                        Group pointedGroup;
                        if (validChain.size() < 2 || (pointedGroup = this.groupService.getGroup(this.deviceId, pointedGroupKey = (GroupKey)validChain.stream().collect(Collectors.toList()).get(1))) == null || !gidToCheck.equals((Object)pointedGroup.id())) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    this.log.warn("Removing bucket pointing to groupId:{}", (Object)gidToCheck);
                    bucketsToRemove.add(bucket);
                }
                if (bucketsToRemove.isEmpty()) {
                    this.log.warn("Mismatch detected but could not determine whichbuckets to remove");
                } else {
                    GroupBuckets removeBuckets = new GroupBuckets((List)bucketsToRemove);
                    this.groupService.removeBucketsFromGroup(this.deviceId, topGroupKey, removeBuckets, topGroupKey, nextObjective.appId());
                }
            } else if (actualGroupSize < objGroupSize) {
                ArrayList bucketsToAdd = Lists.newArrayList();
                for (Deque validChain : allActiveKeys) {
                    GroupKey pointedGroupKey;
                    Group pointedGroup;
                    if (validChain.size() < 2 || (pointedGroup = this.groupService.getGroup(this.deviceId, pointedGroupKey = (GroupKey)validChain.stream().collect(Collectors.toList()).get(1))) == null) continue;
                    boolean matches = false;
                    for (GroupBucket bucket : topGroup.buckets().buckets()) {
                        Instructions.GroupInstruction g = (Instructions.GroupInstruction)bucket.treatment().allInstructions().iterator().next();
                        GroupId gidToCheck = g.groupId();
                        if (!pointedGroup.id().equals((Object)gidToCheck)) continue;
                        matches = true;
                        break;
                    }
                    if (matches) continue;
                    this.log.warn("Adding bucket pointing to groupId:{}", (Object)pointedGroup);
                    TrafficTreatment t = DefaultTrafficTreatment.builder().group(pointedGroup.id()).build();
                    if (nextObjective.type() == NextObjective.Type.HASHED) {
                        bucketsToAdd.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)t));
                        continue;
                    }
                    bucketsToAdd.add(DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)t));
                }
                if (bucketsToAdd.isEmpty()) {
                    this.log.warn("Mismatch detected but could not determine which buckets to add");
                } else {
                    GroupBuckets addBuckets = new GroupBuckets((List)bucketsToAdd);
                    this.groupService.addBucketsToGroup(this.deviceId, topGroupKey, addBuckets, topGroupKey, nextObjective.appId());
                }
            }
        }
        Ofdpa2Pipeline.pass((Objective)nextObjective);
    }

    protected void updatePendingNextObjective(GroupKey groupKey, OfdpaGroupHandlerUtility.OfdpaNextGroup nextGrp) {
        this.pendingAddNextObjectives.asMap().compute(groupKey, (k, val) -> {
            if (val == null) {
                val = new CopyOnWriteArrayList<OfdpaGroupHandlerUtility.OfdpaNextGroup>();
            }
            val.add(nextGrp);
            return val;
        });
    }

    protected void updatePendingGroups(GroupKey groupKey, OfdpaGroupHandlerUtility.GroupChainElem gce) {
        this.pendingGroups.asMap().compute(groupKey, (k, val) -> {
            if (val == null) {
                val = Sets.newConcurrentHashSet();
            }
            val.add(gce);
            return val;
        });
    }

    protected void addPendingUpdateNextObjective(GroupKey groupKey, NextObjective nextObjective) {
        this.pendingUpdateNextObjectives.compute(groupKey, (gKey, nextObjs) -> {
            if (nextObjs != null) {
                nextObjs.add(nextObjective);
            } else {
                nextObjs = Sets.newHashSet((Object[])new NextObjective[]{nextObjective});
            }
            return nextObjs;
        });
    }

    protected void addPendingRemoveNextObjective(NextObjective nextObjective, List<GroupKey> groupKeys) {
        this.pendingRemoveNextObjectives.put((Object)nextObjective, groupKeys);
    }

    protected int getNextAvailableIndex() {
        return (int)this.nextIndex.incrementAndGet();
    }

    protected void processPendingUpdateNextObjs(GroupKey groupKey) {
        Set<NextObjective> nextObjs = this.pendingUpdateNextObjectives.remove(groupKey);
        if (nextObjs != null) {
            nextObjs.forEach(nextObj -> {
                this.log.debug("Group {} updated, update pending next objective {}.", (Object)groupKey, nextObj);
                Ofdpa2Pipeline.pass((Objective)nextObj);
            });
        }
    }

    protected void processPendingRemoveNextObjs(GroupKey key) {
        this.pendingRemoveNextObjectives.asMap().forEach((nextObjective, groupKeys) -> {
            groupKeys.remove(key);
            if (groupKeys.isEmpty()) {
                this.pendingRemoveNextObjectives.invalidate(nextObjective);
                Ofdpa2Pipeline.pass((Objective)nextObjective);
            }
        });
    }

    protected void processPendingAddGroupsOrNextObjs(GroupKey key, boolean added) {
        Set gceSet = (Set)this.pendingGroups.asMap().remove(key);
        if (gceSet != null) {
            for (OfdpaGroupHandlerUtility.GroupChainElem gce : gceSet) {
                this.log.debug("Group service {} group key {} in device {}. Processing next group in group chain with group id 0x{}", new Object[]{added ? "ADDED" : "processed", key, this.deviceId, Integer.toHexString(gce.groupDescription().givenGroupId())});
                this.processGroupChain(gce);
            }
        } else {
            List nextGrpList = (List)this.pendingAddNextObjectives.getIfPresent((Object)key);
            if (nextGrpList != null) {
                this.pendingAddNextObjectives.invalidate((Object)key);
                nextGrpList.forEach(nextGrp -> {
                    this.log.debug("Group service {} group key {} in device:{}. Done implementing next objective: {} <<-->> gid:0x{}", new Object[]{added ? "ADDED" : "processed", key, this.deviceId, nextGrp.nextObjective().id(), Integer.toHexString(this.groupService.getGroup(this.deviceId, key).givenGroupId())});
                    Ofdpa2Pipeline.pass((Objective)nextGrp.nextObjective());
                    this.updateFlowObjectiveStore(nextGrp.nextObjective().id(), (OfdpaGroupHandlerUtility.OfdpaNextGroup)nextGrp);
                    this.pendingBuckets.compute(nextGrp.nextObjective().id(), (nextId, pendBkts) -> {
                        if (pendBkts != null) {
                            pendBkts.forEach(pendBkt -> this.addBucketToGroup((NextObjective)pendBkt, (NextGroup)nextGrp));
                        }
                        return null;
                    });
                });
            }
        }
    }

    private void processGroupChain(OfdpaGroupHandlerUtility.GroupChainElem gce) {
        int waitOnGroups = gce.decrementAndGetGroupsWaitedOn();
        if (waitOnGroups != 0) {
            this.log.debug("GCE: {} not ready to be processed", (Object)gce);
            return;
        }
        this.log.debug("GCE: {} ready to be processed", (Object)gce);
        if (gce.addBucketToGroup()) {
            this.groupService.addBucketsToGroup(gce.groupDescription().deviceId(), gce.groupDescription().appCookie(), gce.groupDescription().buckets(), gce.groupDescription().appCookie(), gce.groupDescription().appId());
        } else {
            this.groupService.addGroup(gce.groupDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlowObjectiveStore(Integer nextId, OfdpaGroupHandlerUtility.OfdpaNextGroup nextGrp) {
        FlowObjectiveStore flowObjectiveStore = this.flowObjectiveStore;
        synchronized (flowObjectiveStore) {
            NextGroup next = this.flowObjectiveStore.getNextGroup(nextId);
            if (next == null || nextGrp.nextObjective().op() == Objective.Operation.ADD) {
                this.flowObjectiveStore.putNextGroup(nextId, (NextGroup)nextGrp);
                return;
            }
            if (nextGrp.nextObjective().op() == Objective.Operation.ADD_TO_EXISTING) {
                List allActiveKeys = (List)Ofdpa2Pipeline.appKryo.deserialize(next.data());
                if ((allActiveKeys = Lists.newArrayList((Iterable)allActiveKeys)).size() == 1 && ((Deque)allActiveKeys.get(0)).size() == 1) {
                    allActiveKeys.clear();
                }
                allActiveKeys.addAll(nextGrp.allKeys());
                this.flowObjectiveStore.putNextGroup(nextId, (NextGroup)new OfdpaGroupHandlerUtility.OfdpaNextGroup(allActiveKeys, nextGrp.nextObjective()));
            }
        }
    }

    private static /* synthetic */ void lambda$processL2HashedNextObjective$24(GroupKey l2LbGroupKey, Deque gKeyChain) {
        gKeyChain.addFirst(l2LbGroupKey);
    }

    private static /* synthetic */ void lambda$processEcmpHashedNextObjective$22(GroupKey l3ecmpGroupKey, Deque gKeyChain) {
        gKeyChain.addFirst(l3ecmpGroupKey);
    }

    private static /* synthetic */ void lambda$createL3MulticastGroup$20(GroupKey l3MulticastGroupKey, List allGroupKeys, OfdpaGroupHandlerUtility.GroupInfo groupInfo) {
        ArrayDeque<GroupKey> gkeyChain = new ArrayDeque<GroupKey>();
        gkeyChain.addFirst(groupInfo.innerMostGroupDesc().appCookie());
        if (!groupInfo.nextGroupDesc().equals(groupInfo.innerMostGroupDesc())) {
            gkeyChain.addFirst(groupInfo.nextGroupDesc().appCookie());
        }
        gkeyChain.addFirst(l3MulticastGroupKey);
        allGroupKeys.add(gkeyChain);
    }

    private class InnerGroupListener
    implements GroupListener {
        private InnerGroupListener() {
        }

        public void event(GroupEvent event) {
            switch ((GroupEvent.Type)event.type()) {
                case GROUP_ADDED: {
                    Ofdpa2GroupHandler.this.processPendingAddGroupsOrNextObjs(((Group)event.subject()).appCookie(), true);
                    break;
                }
                case GROUP_REMOVED: {
                    Ofdpa2GroupHandler.this.processPendingRemoveNextObjs(((Group)event.subject()).appCookie());
                    break;
                }
                case GROUP_UPDATED: {
                    Ofdpa2GroupHandler.this.processPendingUpdateNextObjs(((Group)event.subject()).appCookie());
                    break;
                }
            }
        }
    }
}

